/*
 * Decompiled with CFR 0.152.
 */
package zephyr.obunsha.petitroyal;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import zephyr.util.AppendLatinKeys;
import zephyr.util.ZephyrUtil;

public class SedBodyHtml {
    private static final String DT_ID_REGEXP = "<dt[^>]+>(<b>\\** *)?(.+?)(</b>)?</dt>";
    private static final Pattern DT_ID = Pattern.compile("<dt[^>]+>(<b>\\** *)?(.+?)(</b>)?</dt>");
    private static final String YKG_REGEXP = "<ykg>(.*?)</ykg>";
    private static final Pattern YKG = Pattern.compile("<ykg>(.*?)</ykg>");
    private static final String YKG_BOLD_REGEXP = "<b>\uff65*(.*?)</b>";
    private static final Pattern YKG_BOLD = Pattern.compile("<b>\uff65*(.*?)</b>");
    private static final AppendLatinKeys LATKEY = new AppendLatinKeys();
    private static int nJPKey = 0;
    private static final String[][] REPLACES = new String[][]{{"&lt;", "<"}, {"&gt;", ">"}, {"&amp;amp;", "&"}, {"&amp;", "&"}, {"&hellip;", "\uff65\uff65\uff65"}, {"&rarr;", "\u2192"}, {"&larr;", "\u2190"}, {"&hArr;", "\u21d4"}, {"&rArr;", "\u21d2"}, {"&dagger;", "\u2020"}, {"&minus;", "-"}, {"&mdash;", "\u2015"}, {"\u2103&deg;C", "\u2103"}, {"</p><p><indent val=\"2\"><p>&nbsp;</p><p>", "</p><indent val=\"2\"><p><p>"}, {"<b>\uff3b\u7528\u4f8b\uff3d</b>", "\uff3b\u7528\u4f8b\uff3d"}};
    private static final String[][] REG_REPLACES = new String[][]{{"<p> +", "<p>"}};

    private static String getJPKey(String string) {
        Matcher matcher = YKG_BOLD.matcher(string);
        String string2 = "";
        while (matcher.find()) {
            string2 = string2 + matcher.group(1);
        }
        if (string2.isEmpty()) {
            return string;
        }
        return "* " + string2;
    }

    private static String fixJPKey(String string, String string2) {
        String string3;
        Matcher matcher = DT_ID.matcher(string);
        String string4 = matcher.find() ? matcher.group(2) : null;
        StringBuffer stringBuffer = new StringBuffer();
        matcher = YKG.matcher(string);
        int n = 0;
        TreeSet<String> treeSet = new TreeSet<String>();
        while (matcher.find()) {
            if (n < matcher.start()) {
                stringBuffer.append(string.substring(n, matcher.start()));
            }
            string3 = matcher.group(1);
            stringBuffer.append(string3);
            String string5 = SedBodyHtml.getJPKey(string3);
            if (!(string5.isEmpty() || treeSet.contains(string5) || string5.contains("<a "))) {
                treeSet.add(string5);
            }
            n = matcher.end();
        }
        if (n < string.length()) {
            stringBuffer.append(string.substring(n));
        }
        string3 = stringBuffer.toString();
        if (treeSet.isEmpty() || string4 == null) {
            return string3;
        }
        n = string3.indexOf("<dd>");
        stringBuffer = new StringBuffer();
        if (n >= 0) {
            stringBuffer.append(string3.substring(0, n));
        }
        stringBuffer.append(LATKEY.makeKeys(string4, ZephyrUtil.makeKey(string4), string2, treeSet));
        nJPKey += treeSet.size();
        if (n >= 0) {
            stringBuffer.append(string3.substring(n));
        } else {
            stringBuffer.append(string3);
        }
        return stringBuffer.toString();
    }

    private static String sed(String string, String string2) {
        string = ZephyrUtil.sed(string, REPLACES, REG_REPLACES);
        string = SedBodyHtml.fixJPKey(string, string2);
        return string;
    }

    private static void sed(String[] stringArray) throws Exception {
        String string;
        InputStream inputStream = System.in;
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));
        String string2 = stringArray.length > 0 ? AppendLatinKeys.getKeyType(stringArray[0]) : "\u8868\u8a18";
        while ((string = bufferedReader.readLine()) != null) {
            if ((string = SedBodyHtml.sed(string, string2)) == null) continue;
            System.out.println(string);
        }
        if (nJPKey > 0) {
            System.err.println("append " + nJPKey + " extra Japanese " + string2 + " keys");
        }
    }

    public static void main(String[] stringArray) {
        ZephyrUtil.setUTF8Ouput();
        try {
            SedBodyHtml.sed(stringArray);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

