/*
 * Decompiled with CFR 0.152.
 */
package zephyr.taishukan.kangorin;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.LinkedList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import zephyr.util.MultiHashMap;

public class IndexManager {
    private final MultiHashMap<String, String> idx2hyokiMap = new MultiHashMap();
    private final MultiHashMap<String, String> idx2kanaMap = new MultiHashMap();
    private static final Pattern HYOKI_LINE = Pattern.compile("^(.+?)\\[[0-9]+\\]\t\\[0*([0-9A-F]+):0*([0-9A-F]+)\\]");
    private static final Pattern KANA_LINE = Pattern.compile("^C0:([^\\[]+)\\[[0-9]+\\]\t\\[0*([0-9A-F]+):(0*[0-9A-F]+)\\]");

    public IndexManager(String string, String string2) throws Exception {
        this.loadHyoki(string);
        this.loadKana(string2);
    }

    private String makeIndex(String string, String string2) {
        switch (string2.length()) {
            case 1: {
                return string + "00" + string2;
            }
            case 2: {
                return string + "0" + string2;
            }
            case 3: {
                return string + string2;
            }
        }
        System.err.println("invalid high:low " + string + ":" + string2);
        return "";
    }

    private void loadHyoki(String string) throws Exception {
        String string2;
        FileInputStream fileInputStream = new FileInputStream(new File(string));
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)fileInputStream, "Windows-31J"));
        while ((string2 = bufferedReader.readLine()) != null) {
            String string3;
            Matcher matcher = HYOKI_LINE.matcher(string2);
            if (!matcher.find() || (string3 = matcher.group(1)).matches("[\uff10-\uff19]+")) continue;
            String string4 = this.makeIndex(matcher.group(2), matcher.group(3));
            if (string4.startsWith("0")) {
                System.err.println("invalid idx: " + matcher.group());
                System.exit(1);
            }
            this.idx2hyokiMap.put(string4, string3);
        }
        bufferedReader.close();
        System.err.println("load " + this.idx2hyokiMap.size() + " from " + string);
    }

    private void loadKana(String string) throws Exception {
        String string2;
        FileInputStream fileInputStream = new FileInputStream(new File(string));
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)fileInputStream, "Windows-31J"));
        while ((string2 = bufferedReader.readLine()) != null) {
            Matcher matcher = KANA_LINE.matcher(string2);
            if (!matcher.find()) continue;
            String string3 = matcher.group(1);
            String string4 = this.makeIndex(matcher.group(2), matcher.group(3));
            this.idx2kanaMap.put(string4, string3);
        }
        bufferedReader.close();
        System.err.println("load " + this.idx2kanaMap.size() + " from " + string);
    }

    public String getKey(String string) {
        LinkedList linkedList = this.idx2hyokiMap.getWithoutNull(string);
        LinkedList linkedList2 = this.idx2kanaMap.getWithoutNull(string);
        if (linkedList.isEmpty() && linkedList2.isEmpty()) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (String string2 : linkedList) {
            stringBuilder.append("<key type=\"\u8868\u8a18\">");
            stringBuilder.append(string2);
            stringBuilder.append("</key>");
        }
        for (String string2 : linkedList2) {
            stringBuilder.append("<key type=\"\u304b\u306a\">");
            stringBuilder.append(string2);
            stringBuilder.append("</key>");
        }
        return stringBuilder.toString();
    }
}

