/*
 * Decompiled with CFR 0.152.
 */
package zephyr.util;

import java.awt.image.BufferedImage;
import java.util.LinkedList;
import zephyr.util.BIMUtil;
import zephyr.util.BitType;

public class BMPCleaner {
    private final int ignoreDot;
    private final int checkRange;
    private final int halfRange;
    private final int forceEraseDot;

    public BMPCleaner(int n, int n2, int n3, int n4) {
        this.ignoreDot = Integer.max(n2, 1);
        this.checkRange = n3;
        this.halfRange = n3 / 2;
        this.forceEraseDot = n4;
    }

    public BMPCleaner(int n, int n2, int n3) {
        this(n, n2, n3, Integer.max(1, n / 100));
    }

    private static BMPCleaner getInstance(int n, double d, int n2) {
        int n3 = n / n2;
        int n4 = BIMUtil.mm2dot(d, n);
        double d2 = BIMUtil.dot2mm((int)Math.sqrt(n3), n);
        int n5 = Integer.max(1, n / 100);
        System.err.printf("cleanup: ignore %d dots(%.2f[mm] square) in %.1fx%.1f[mm](%dx%d dot) square, force erase %d dots", n3, d2, d, d, n4, n4, n5);
        System.err.println();
        return new BMPCleaner(n, n3, n4, n5);
    }

    public static BMPCleaner getInstance(int n) {
        return BMPCleaner.getInstance(n, 1.0, 10);
    }

    public static BMPCleaner getHardInstance(int n) {
        return BMPCleaner.getInstance(n, 0.5, 10);
    }

    private BufferedImage array2bim(BitType[][] bitTypeArray) {
        int n = bitTypeArray.length;
        int n2 = bitTypeArray[0].length;
        BufferedImage bufferedImage = new BufferedImage(n, n2, 12);
        for (int i = 0; i < n; ++i) {
            block4: for (int j = 0; j < n2; ++j) {
                switch (bitTypeArray[i][j]) {
                    case BLACK: 
                    case OK: {
                        bufferedImage.setRGB(i, j, -16777216);
                        continue block4;
                    }
                    default: {
                        bufferedImage.setRGB(i, j, -1);
                    }
                }
            }
        }
        return bufferedImage;
    }

    public BufferedImage cleanup(BufferedImage bufferedImage) {
        int n = bufferedImage.getWidth();
        int n2 = bufferedImage.getHeight();
        BitType[][] bitTypeArray = BitType.makeArray(bufferedImage);
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                if (bitTypeArray[i][j] != BitType.BLACK) continue;
                this.cleanup(bitTypeArray, i, j);
            }
        }
        return this.array2bim(bitTypeArray);
    }

    private void addBlacks(BitType[][] bitTypeArray, int n, int n2, LinkedList<int[]> linkedList) {
        int n3 = bitTypeArray.length;
        int n4 = bitTypeArray[0].length;
        if (0 <= n && n < n3 && 0 <= n2 && n2 < n4 && bitTypeArray[n][n2] == BitType.BLACK) {
            linkedList.add(new int[]{n, n2});
            bitTypeArray[n][n2] = BitType.CHECKING;
        }
    }

    private int[] checkRange(LinkedList<int[]> linkedList) {
        int n = Integer.MAX_VALUE;
        int n2 = -1;
        int n3 = Integer.MAX_VALUE;
        int n4 = -1;
        for (int[] nArray : linkedList) {
            if (nArray[0] < n) {
                n = nArray[0];
            }
            if (nArray[0] > n2) {
                n2 = nArray[0];
            }
            if (nArray[1] < n3) {
                n3 = nArray[1];
            }
            if (nArray[1] <= n4) continue;
            n4 = nArray[1];
        }
        return new int[]{n, n2, n3, n4};
    }

    private boolean isBlackEnough(BitType[][] bitTypeArray, int n, int n2) {
        if (this.checkRange == 0) {
            switch (bitTypeArray[n][n2]) {
                case BLACK: 
                case OK: 
                case CHECKING: {
                    return true;
                }
            }
            return false;
        }
        int n3 = bitTypeArray.length;
        int n4 = bitTypeArray[0].length;
        int n5 = Integer.max(0, n - this.halfRange);
        int n6 = Integer.min(n3, n5 + this.checkRange);
        int n7 = Integer.max(0, n2 - this.halfRange);
        int n8 = Integer.min(n4, n7 + this.checkRange);
        int n9 = 0;
        for (int i = n5; i < n6; ++i) {
            block7: for (int j = n7; j < n8; ++j) {
                switch (bitTypeArray[i][j]) {
                    case BLACK: 
                    case OK: 
                    case CHECKING: {
                        ++n9;
                        continue block7;
                    }
                }
            }
        }
        return n9 >= this.ignoreDot;
    }

    private void changeArray(BitType[][] bitTypeArray, LinkedList<int[]> linkedList, BitType bitType) {
        for (int[] nArray : linkedList) {
            bitTypeArray[nArray[0]][nArray[1]] = bitType;
        }
    }

    private void cleanup(BitType[][] bitTypeArray, int n, int n2) {
        int n3;
        int[] nArray;
        LinkedList<int[]> linkedList = new LinkedList<int[]>();
        LinkedList<int[]> linkedList2 = new LinkedList<int[]>();
        this.addBlacks(bitTypeArray, n, n2, linkedList);
        while (linkedList.size() > 0) {
            nArray = linkedList.removeFirst();
            linkedList2.add(nArray);
            n = nArray[0];
            n2 = nArray[1];
            this.addBlacks(bitTypeArray, n - 1, n2 - 1, linkedList);
            this.addBlacks(bitTypeArray, n - 1, n2, linkedList);
            this.addBlacks(bitTypeArray, n - 1, n2 + 1, linkedList);
            this.addBlacks(bitTypeArray, n, n2 - 1, linkedList);
            this.addBlacks(bitTypeArray, n, n2 + 1, linkedList);
            this.addBlacks(bitTypeArray, n + 1, n2 - 1, linkedList);
            this.addBlacks(bitTypeArray, n + 1, n2, linkedList);
            this.addBlacks(bitTypeArray, n + 1, n2 + 1, linkedList);
        }
        if (linkedList2.size() >= this.ignoreDot) {
            this.changeArray(bitTypeArray, linkedList2, BitType.OK);
            return;
        }
        if (linkedList2.size() <= this.forceEraseDot) {
            this.changeArray(bitTypeArray, linkedList2, BitType.NG);
            return;
        }
        nArray = this.checkRange(linkedList2);
        int n4 = (nArray[0] + nArray[1]) / 2;
        if (this.isBlackEnough(bitTypeArray, n4, n3 = (nArray[2] + nArray[3]) / 2)) {
            this.changeArray(bitTypeArray, linkedList2, BitType.OK);
        } else {
            this.changeArray(bitTypeArray, linkedList2, BitType.NG);
        }
    }
}

