/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.ussiy.io;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;

public class LockableFileOutputStream
extends OutputStream {
    private final int LOCK_FLG = 1;
    private final int TRY_LOCK_FLG = 0;
    private FileOutputStream fOut;
    private FileChannel fc;
    private FileLock fl;

    public LockableFileOutputStream(FileOutputStream out) {
        this.fOut = out;
        this.fc = out.getChannel();
    }

    public void close() throws IOException {
        this.fOut.close();
    }

    protected void finalize() throws IOException {
        this.unlock();
    }

    public void flush() throws IOException {
        this.fOut.flush();
    }

    public FileChannel getChannel() {
        return this.fc;
    }

    public boolean lock() {
        return this.lock(1);
    }

    private boolean lock(int flg) {
        try {
            if (this.fc != null) {
                if (flg == 0) {
                    this.fl = this.fc.tryLock();
                } else if (flg == 1) {
                    this.fl = this.fc.lock();
                }
                return this.fl != null;
            }
            return false;
        }
        catch (IOException e) {
            e.printStackTrace();
            try {
                this.fl.release();
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
            return false;
        }
    }

    public boolean tryLock() {
        return this.lock(0);
    }

    public boolean unlock() throws IOException {
        try {
            if (this.fl != null) {
                this.fl.release();
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            try {
                if (this.fl != null) {
                    this.fl.release();
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
    }

    public void write(byte[] parm1, int parm2, int parm3) throws IOException {
        this.fOut.write(parm1, parm2, parm3);
    }

    public void write(int b) throws IOException {
        this.fOut.write(b);
    }

    public void write(byte[] parm1) throws IOException {
        this.fOut.write(parm1);
    }
}

