/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.ussiy.app.propedit.util;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import jp.gr.java_conf.ussiy.app.propedit.util.AlreadyFileLockException;
import jp.gr.java_conf.ussiy.io.LockableFileOutputStream;
import jp.gr.java_conf.ussiy.util.StringUtil;

public class FileOpener
extends File {
    private ByteArrayOutputStream bin = null;
    private int encode;
    private StringBuffer txt = null;

    public FileOpener(File file) {
        super(file.getPath());
    }

    public FileOpener(String filepath) {
        super(filepath);
    }

    public String getText() {
        if (this.txt == null) {
            return null;
        }
        return this.txt.toString();
    }

    public void read(String code) throws IOException {
        byte[] buffer = null;
        FileInputStream fis = null;
        int getLength = 0;
        InputStreamReader fr = null;
        BufferedReader br = null;
        if (this.isFile()) {
            try {
                fis = new FileInputStream(this);
                this.bin = new ByteArrayOutputStream();
                buffer = new byte[1024];
                while ((getLength = fis.read(buffer)) != -1) {
                    this.bin.write(buffer, 0, getLength);
                }
                this.txt = new StringBuffer(StringUtil.removeCarriageReturn(new String(this.bin.toByteArray(), code)));
                return;
            }
            catch (IOException e) {
                throw e;
            }
            finally {
                try {
                    if (br != null) {
                        br.close();
                    }
                    if (fr != null) {
                        fr.close();
                    }
                }
                catch (IOException e) {
                }
            }
        }
    }

    public void setText(String buffer) {
        this.txt = new StringBuffer();
        if (buffer != null) {
            this.txt.append(buffer);
        }
    }

    public void write(String code) throws AlreadyFileLockException, IOException {
        LockableFileOutputStream out = null;
        try {
            out = new LockableFileOutputStream(new FileOutputStream(this));
            if (!out.tryLock()) {
                throw new AlreadyFileLockException("The file has been already locked by other program.");
            }
            out.write(this.getText().getBytes(code));
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            if (out != null) {
                out.unlock();
                out.flush();
                out.close();
                out = null;
            }
        }
    }
}

