/*
 * Decompiled with CFR 0.152.
 */
package jp.eclipse.plugin.proptranslator.util;

import java.util.ArrayList;
import java.util.List;
import jp.eclipse.plugin.proptranslator.PropTranslatorPlugin;
import jp.eclipse.plugin.proptranslator.preferencePage.WordRegistModel;
import jp.eclipse.plugin.proptranslator.util.Constants;
import jp.eclipse.plugin.proptranslator.util.StringUtils;
import jp.eclipse.plugin.proptranslator.xstream.XStreamSerializer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PreferenceUtils {
    public static void setSiteNameCombo(Composite composite, Combo combo) {
        int i = 0;
        while (i < Constants.SITE_NAMES.length) {
            String site = Constants.SITE_NAMES[i];
            combo.add(site);
            ++i;
        }
    }

    public static List<IFile> getPropertyFiles(IProject project) throws CoreException {
        if (!project.isOpen()) {
            MessageDialog.openError((Shell)new Shell(), (String)"\u30a8\u30e9\u30fc", (String)"\u9078\u629e\u3055\u308c\u305f\u30d7\u30ed\u30b8\u30a7\u30af\u30c8\u306f\u30af\u30ed\u30fc\u30ba\u72b6\u614b\u3067\u3059\u3002");
            return null;
        }
        final ArrayList<IFile> list = new ArrayList<IFile>();
        project.accept(new IResourceVisitor(){

            public boolean visit(IResource resource) throws CoreException {
                IFile file;
                String[] fileNames;
                if (resource.getType() == 1 && !(fileNames = StringUtils.getSplitFileName(file = (IFile)resource))[0].endsWith("_en") && fileNames[1].equals("properties")) {
                    list.add(file);
                }
                return true;
            }
        });
        return list;
    }

    public static List<WordRegistModel> getRegistWordModels(IPreferenceStore store) {
        String xml = store.getString(PropTranslatorPlugin.PREF_WORD_REGIST);
        List<WordRegistModel> registWordModels = new ArrayList<WordRegistModel>();
        if (xml != null && xml.length() > 0) {
            registWordModels = (List)XStreamSerializer.deserialize(xml, PreferenceUtils.class.getClassLoader());
        }
        return registWordModels;
    }
}

