//*****************************************************************************
//*****************************************************************************
//  FILENAME: BUF.h
//  Version: 1.3, Updated on 2010/4/6 at 11:27:6
//  Generated by PSoC Designer 
//
//  DESCRIPTION: DigitalBuffers User Module C Language interface file
//-----------------------------------------------------------------------------
//  Copyright (c) Cypress Semiconductor 2010. All Rights Reserved.
//*****************************************************************************
//*****************************************************************************
#ifndef BUF_INCLUDE
#define BUF_INCLUDE

#include <m8c.h>

#pragma fastcall16 BUF_EnableInt
#pragma fastcall16 BUF_DisableInt
#pragma fastcall16 BUF_Start
#pragma fastcall16 BUF_Stop

//-------------------------------------------------
// Prototypes of the BUF API.
//-------------------------------------------------

extern void BUF_EnableInt(void);
extern void BUF_DisableInt(void);
extern void BUF_Start(void);
extern void BUF_Stop(void);


//--------------------------------------------------
// Constants for BUF API's.
//--------------------------------------------------
#define BUF_CONTROL_REG_START_BIT              ( 0x01 )
#define BUF_INT_REG_ADDR                       ( 0x0e1 )
#define BUF_INT_MASK                           ( 0x40 )


//--------------------------------------------------
// Constants for BUF user defined values
//--------------------------------------------------
#pragma ioport  BUF_DATA_0_REG: 0x038                      //DR0 Count register
BYTE            BUF_DATA_0_REG;
#pragma ioport  BUF_DATA_1_REG: 0x039                      //DR1 Period register
BYTE            BUF_DATA_1_REG;
#pragma ioport  BUF_DATA_2_REG: 0x03a                      //DR2 Compare register
BYTE            BUF_DATA_2_REG;
#pragma ioport  BUF_CONTROL_REG:    0x03b                  //Control register
BYTE            BUF_CONTROL_REG;
#pragma ioport  BUF_FUNC_REG:   0x138                      //Function register
BYTE            BUF_FUNC_REG;
#pragma ioport  BUF_INPUT_REG:  0x139                      //Input register
BYTE            BUF_INPUT_REG;
#pragma ioport  BUF_OUTPUT_REG: 0x13a                      //Output register
BYTE            BUF_OUTPUT_REG;
#pragma ioport  BUF_INT_REG:       0x0e1                   //Interrupt Mask Register
BYTE            BUF_INT_REG;


//-------------------------------------------------
// Register Addresses for BUF
//-------------------------------------------------


//-------------------------------------------------
// BUF Macro 'Functions'
//-------------------------------------------------

#define BUF_Start_M \
   BUF_CONTROL_REG |=  BUF_CONTROL_REG_START_BIT

#define BUF_Stop_M  \
   BUF_CONTROL_REG &= ~BUF_CONTROL_REG_START_BIT

#define BUF_EnableInt_M   \
   M8C_EnableIntMask(BUF_INT_REG, BUF_INT_MASK)

#define BUF_DisableInt_M  \
   M8C_DisableIntMask(BUF_INT_REG, BUF_INT_MASK)

#endif
// end of file BUF.h
