//*****************************************************************************
//*****************************************************************************
//  FILENAME: PWM8_A.h
//   Version: 2.5, Updated on 2010/4/6 at 11:27:32
//  Generated by PSoC Designer 
//
//  DESCRIPTION: PWM8 User Module C Language interface file
//-----------------------------------------------------------------------------
//  Copyright (c) Cypress Semiconductor 2010. All Rights Reserved.
//*****************************************************************************
//*****************************************************************************
#ifndef PWM8_A_INCLUDE
#define PWM8_A_INCLUDE

#include <m8c.h>

#pragma fastcall16 PWM8_A_EnableInt
#pragma fastcall16 PWM8_A_DisableInt
#pragma fastcall16 PWM8_A_Start
#pragma fastcall16 PWM8_A_Stop
#pragma fastcall16 PWM8_A_bReadCounter              // Read  DR0
#pragma fastcall16 PWM8_A_WritePeriod               // Write DR1
#pragma fastcall16 PWM8_A_bReadPulseWidth           // Read  DR2
#pragma fastcall16 PWM8_A_WritePulseWidth           // Write DR2

// The following symbols are deprecated.
// They may be omitted in future releases
//
#pragma fastcall16 bPWM8_A_ReadCounter              // Read  DR0 (Deprecated)
#pragma fastcall16 bPWM8_A_ReadPulseWidth           // Read  DR2 (Deprecated)


//-------------------------------------------------
// Prototypes of the PWM8_A API.
//-------------------------------------------------

extern void PWM8_A_EnableInt(void);                        // Proxy Class 1
extern void PWM8_A_DisableInt(void);                       // Proxy Class 1
extern void PWM8_A_Start(void);                            // Proxy Class 1
extern void PWM8_A_Stop(void);                             // Proxy Class 1
extern BYTE PWM8_A_bReadCounter(void);                     // Proxy Class 2
extern void PWM8_A_WritePeriod(BYTE bPeriod);              // Proxy Class 1
extern BYTE PWM8_A_bReadPulseWidth(void);                  // Proxy Class 1
extern void PWM8_A_WritePulseWidth(BYTE bPulseWidth);      // Proxy Class 1

// The following functions are deprecated.
// They may be omitted in future releases
//
extern BYTE bPWM8_A_ReadCounter(void);            // Deprecated
extern BYTE bPWM8_A_ReadPulseWidth(void);         // Deprecated


//--------------------------------------------------
// Constants for PWM8_A API's.
//--------------------------------------------------

#define PWM8_A_CONTROL_REG_START_BIT           ( 0x01 )
#define PWM8_A_INT_REG_ADDR                    ( 0x0e1 )
#define PWM8_A_INT_MASK                        ( 0x02 )


//--------------------------------------------------
// Constants for PWM8_A user defined values
//--------------------------------------------------

#define PWM8_A_PERIOD                          ( 0x00 )
#define PWM8_A_PULSE_WIDTH                     ( 0x00 )


//-------------------------------------------------
// Register Addresses for PWM8_A
//-------------------------------------------------

#pragma ioport  PWM8_A_COUNTER_REG: 0x024                  //DR0 Count register
BYTE            PWM8_A_COUNTER_REG;
#pragma ioport  PWM8_A_PERIOD_REG:  0x025                  //DR1 Period register
BYTE            PWM8_A_PERIOD_REG;
#pragma ioport  PWM8_A_COMPARE_REG: 0x026                  //DR2 Compare register
BYTE            PWM8_A_COMPARE_REG;
#pragma ioport  PWM8_A_CONTROL_REG: 0x027                  //Control register
BYTE            PWM8_A_CONTROL_REG;
#pragma ioport  PWM8_A_FUNC_REG:    0x124                  //Function register
BYTE            PWM8_A_FUNC_REG;
#pragma ioport  PWM8_A_INPUT_REG:   0x125                  //Input register
BYTE            PWM8_A_INPUT_REG;
#pragma ioport  PWM8_A_OUTPUT_REG:  0x126                  //Output register
BYTE            PWM8_A_OUTPUT_REG;
#pragma ioport  PWM8_A_INT_REG:       0x0e1                //Interrupt Mask Register
BYTE            PWM8_A_INT_REG;


//-------------------------------------------------
// PWM8_A Macro 'Functions'
//-------------------------------------------------

#define PWM8_A_Start_M \
   PWM8_A_CONTROL_REG |=  PWM8_A_CONTROL_REG_START_BIT

#define PWM8_A_Stop_M  \
   PWM8_A_CONTROL_REG &= ~PWM8_A_CONTROL_REG_START_BIT

#define PWM8_A_EnableInt_M   \
   M8C_EnableIntMask(PWM8_A_INT_REG, PWM8_A_INT_MASK)

#define PWM8_A_DisableInt_M  \
   M8C_DisableIntMask(PWM8_A_INT_REG, PWM8_A_INT_MASK)

#endif
// end of file PWM8_A.h
