;;*****************************************************************************
;;*****************************************************************************
;;  FILENAME: PWM8_A.inc
;;   Version: 2.5, Updated on 2010/4/6 at 11:27:32
;;  Generated by PSoC Designer 
;;
;;  DESCRIPTION: Assembler declarations for the PWM8 user module interface
;;-----------------------------------------------------------------------------
;;  Copyright (c) Cypress Semiconductor 2010. All Rights Reserved.
;;*****************************************************************************
;;*****************************************************************************

include "m8c.inc"


;--------------------------------------------------
; Constants for PWM8_A API's.
;--------------------------------------------------

PWM8_A_CONTROL_REG_START_BIT:              equ 0x01    ; Control register start bit
PWM8_A_INT_REG:                            equ 0x0e1
PWM8_A_INT_MASK:                           equ 0x02


;--------------------------------------------------
; Constants for PWM8_A user defined values
;--------------------------------------------------

PWM8_A_PERIOD:                             equ 0x00
PWM8_A_PULSE_WIDTH:                        equ 0x00


;--------------------------------------------------
; Register Address Constants for PWM8_A
;--------------------------------------------------

PWM8_A_COUNTER_REG:                    equ 0x24   ; DR0 Count register
PWM8_A_PERIOD_REG:                     equ 0x25   ; DR1 Period register
PWM8_A_COMPARE_REG:                    equ 0x26   ; DR2 Compare register
PWM8_A_CONTROL_REG:                    equ 0x27   ; Control register
PWM8_A_FUNC_REG:                       equ 0x24   ; Function register
PWM8_A_INPUT_REG:                      equ 0x25   ; Input register
PWM8_A_OUTPUT_REG:                     equ 0x26   ; Output register


;--------------------------------------------------
; PWM8_A Macro 'Functions'
;--------------------------------------------------

   macro PWM8_A_Start_M
   or    reg[PWM8_A_CONTROL_REG],  PWM8_A_CONTROL_REG_START_BIT
   endm

   macro PWM8_A_Stop_M
   and   reg[PWM8_A_CONTROL_REG], ~PWM8_A_CONTROL_REG_START_BIT
   endm

   macro PWM8_A_EnableInt_M
   M8C_EnableIntMask PWM8_A_INT_REG, PWM8_A_INT_MASK
   endm

   macro PWM8_A_DisableInt_M
   M8C_DisableIntMask PWM8_A_INT_REG, PWM8_A_INT_MASK
   endm


; end of file PWM8_A.inc
