;;*****************************************************************************
;;*****************************************************************************
;;  FILENAME: PWM8_C.inc
;;   Version: 2.5, Updated on 2010/4/6 at 11:27:32
;;  Generated by PSoC Designer 
;;
;;  DESCRIPTION: Assembler declarations for the PWM8 user module interface
;;-----------------------------------------------------------------------------
;;  Copyright (c) Cypress Semiconductor 2010. All Rights Reserved.
;;*****************************************************************************
;;*****************************************************************************

include "m8c.inc"


;--------------------------------------------------
; Constants for PWM8_C API's.
;--------------------------------------------------

PWM8_C_CONTROL_REG_START_BIT:              equ 0x01    ; Control register start bit
PWM8_C_INT_REG:                            equ 0x0df
PWM8_C_INT_MASK:                           equ 0x02


;--------------------------------------------------
; Constants for PWM8_C user defined values
;--------------------------------------------------

PWM8_C_PERIOD:                             equ 0x00
PWM8_C_PULSE_WIDTH:                        equ 0x00


;--------------------------------------------------
; Register Address Constants for PWM8_C
;--------------------------------------------------

PWM8_C_COUNTER_REG:                    equ 0x44   ; DR0 Count register
PWM8_C_PERIOD_REG:                     equ 0x45   ; DR1 Period register
PWM8_C_COMPARE_REG:                    equ 0x46   ; DR2 Compare register
PWM8_C_CONTROL_REG:                    equ 0x47   ; Control register
PWM8_C_FUNC_REG:                       equ 0x44   ; Function register
PWM8_C_INPUT_REG:                      equ 0x45   ; Input register
PWM8_C_OUTPUT_REG:                     equ 0x46   ; Output register


;--------------------------------------------------
; PWM8_C Macro 'Functions'
;--------------------------------------------------

   macro PWM8_C_Start_M
   or    reg[PWM8_C_CONTROL_REG],  PWM8_C_CONTROL_REG_START_BIT
   endm

   macro PWM8_C_Stop_M
   and   reg[PWM8_C_CONTROL_REG], ~PWM8_C_CONTROL_REG_START_BIT
   endm

   macro PWM8_C_EnableInt_M
   M8C_EnableIntMask PWM8_C_INT_REG, PWM8_C_INT_MASK
   endm

   macro PWM8_C_DisableInt_M
   M8C_DisableIntMask PWM8_C_INT_REG, PWM8_C_INT_MASK
   endm


; end of file PWM8_C.inc
