//----------------------------------------------------------------------------
// C main line
//----------------------------------------------------------------------------

#include <m8c.h>        // part specific constants and macros
#include "PSoCAPI.h"    // PSoC API definitions for all User Modules
#include "psocdynamic.h"
#include "mmc_driver.h"
#include "fatfs_mmc.h"
#include "main.h"

unsigned char PWM_End_Flag;	//1:Wait 0:Go

void PRSPWM_Start(void)
{   
	LoadConfig_PRSPWM();

	//L ch HSPWM	
	BUF_Start();	
	PRS8_WriteSeed(0x01);
	PRS8_WritePolynomial(0xB8);
	PRS8_Start();
	PRS8_SEED_REG = 0x00;
	
	PWM8_A_WritePeriod(MAIN_PWM_PERIOD);
	PWM8_A_WritePulseWidth(0);
	PWM8_A_Start(); 
	
	PWM8_B_WritePeriod(MAIN_PWM_PERIOD); 
	PWM8_B_WritePulseWidth(0);
	PWM8_B_Start();        
	RDI0LT1 |= 0xF0;

	//R ch HSPWM 
	BUF2_Start();	
	PRS8_B_WriteSeed(0x01);
	PRS8_B_WritePolynomial(0xB8);
	PRS8_B_Start();
	PRS8_B_SEED_REG = 0x00;
	
	PWM8_C_WritePeriod(MAIN_PWM_PERIOD);
	PWM8_C_WritePulseWidth(0);
	PWM8_C_Start(); 
	
	PWM8_D_WritePeriod(MAIN_PWM_PERIOD); 
	PWM8_D_WritePulseWidth(0);
	PWM8_D_Start();        

	RDI2LT1 |= 0xF0;
	
	//LPF Start
	PGA_1_Start(PGA_1_HIGHPOWER);
	PGA_2_Start(PGA_2_HIGHPOWER);
//	DAC_Modulator_1_Start(DAC_Modulator_1_MEDPOWER);
//	DAC_Modulator_2_Start(DAC_Modulator_2_MEDPOWER);
//	AMD_CR0 = 0x21;		//GOE0 & GOE1 are busses as modulator
}

void main(void)
{

	unsigned char TrackNum;
	unsigned char LP1;
	unsigned long FileLength;
	WORD i = 0;

	PRSPWM_Start();		//high Speed PWM Start
	MMC_INIT();			//SPI & MMC initialize
	FATFS_INIT();		//FAT16 drive
	
	
	// interrupt enable 
	PWM8_Timer_Start();
	PWM8_Timer_EnableInt(); 
	M8C_EnableGInt;


	TrackNum = 1;
	FileLength = Get_File_Num(TrackNum);	


	while(1){
		do{
			for(LP1=100;LP1!=0;LP1--)SPI_SEND(0xff);					
		}while(MMC_CMD(18,((((Now_Cluster - 2) * Sector_Per_Cluster)+Beginning_Of_Data_Sector + SectorZero)<<9),0x01)!= 0x00);	//end do
		//CMD18=52_(4-byte data address)_01h	
		//-----------------------------
		// read start
		//-----------------------------	
		DPCM_INIT();

		
		while(--FileLength){
			while(SPI_SEND(0xff) != 0xfe);	//get start token?
			LP1=128;
			while(LP1--){
				DPCMDecoder1(SPI_SEND(0xff));
				DPCMDecoder2(SPI_SEND(0xff));		
				while(PWM_End_Flag);
				PWM_End_Flag=1;
				
				DPCMDecoder1(SPI_SEND(0xff));
				DPCMDecoder2(SPI_SEND(0xff));
				while(PWM_End_Flag);
				PWM_End_Flag=1;
			}	//end while(LP1--)
			SPI_SEND(0xff);		//16-bit CRC
			SPI_SEND(0xff);		//16-bit CRC
			//if(PRT1DR & SW1)break;
	
		}	//end while(1)
		

////////////////////////////////////////
/////////		STOP Tran 
////////////////////////////////////////
	//while(PRT1DR & SW1);

	MMC_SEND_STOP();
	DPCM_INIT();
	TrackNum++;
	if(!Get_File_Num(TrackNum))TrackNum = 1;
	FileLength = Get_File_Num(TrackNum);
	}//end while(1)	
	
	
}

