#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "_bitio.h"

#define OVERRUN 0xffff
/*
#define TRUE     1
#define FALSE    0
*/
#define rightbits(n, x) ((x) & ((1U << (n)) - 1U))  
/*
typedef unsigned int  Uint;
typedef unsigned char Uchar;
*/
FILE *infp, *outfp;
int  getcount, putcount;
Uint bitbuf;


void error(char *message)
{
	fprintf(stderr, "%s¥n", message);
	exit(1);
}


void init_bit_o(void)
{
	putcount = 8; bitbuf = 0;
}

void init_bit_i(void)
{
	getcount = 0; bitbuf = 0;
}


Uint getbit(void)
{
    int flag;
    if (--getcount >= 0)  return (bitbuf >> getcount) & 1U;
    getcount = 7; 
    if((flag = fgetc(infp))==EOF){
		//printf("\t %d \r\n",flag);
		return OVERRUN;
	}
    else bitbuf = flag;
    return (bitbuf >> 7) & 1U;
}

Uint getbits(int n)
{
	Uint x = 0;
	if (n < 1 || 25 < n)  return 0;
	while (n > getcount) {
		n -= getcount;
		x |= rightbits(getcount, bitbuf) << n;
		bitbuf = fgetc(infp); getcount = 8;
	}
	getcount -= n;
	return x | rightbits(n, bitbuf >> getcount);
}


void putbit(Uint bit)
{
	putcount--;
	if (bit != 0)  bitbuf |= (1 << putcount);
	if (putcount == 0) {
		if (fputc(bitbuf, outfp) == EOF)  error("can't write\r\n");
		bitbuf = 0; putcount = 8;
	}
}


void putbits(int n, Uint x)
{
	if (n < 1 || 25 < n)  return;
	while (n >= putcount) {
		n -= putcount;
		bitbuf |= rightbits(putcount, x >> n);
		if (fputc(bitbuf, outfp) == EOF)  error("cant write\r\n");
		bitbuf = 0U; putcount = 8;
	}
	putcount -= n;
	bitbuf |= rightbits(n, x) << putcount;
}

