#include <iostream>
#include <windows.h>
#include <math.h>

using namespace std;

enum { RAMP_STEPS_ = 256 };
struct GAMMA_RAMP_TABLE {
	WORD r[RAMP_STEPS_];
	WORD g[RAMP_STEPS_];
	WORD b[RAMP_STEPS_];
};

double limit(double v) {
	double r = v;
	r = ( r<0     ? 0 : r );
	r = ( r>65535 ? 0 : r );
	return r;
}

int main()
{
	double gamma_r = 1.0, gamma_g = 1.0, gamma_b = 1.0;
	const WORD MAX = 65535;
	GAMMA_RAMP_TABLE table;
	for(int j=0; j<RAMP_STEPS_; j++) {
		table.r[j] = (WORD)limit(MAX*pow(j/255.0, 1.0/gamma_r));
		table.g[j] = (WORD)limit(MAX*pow(j/255.0, 1.0/gamma_g));
		table.b[j] = (WORD)limit(MAX*pow(j/255.0, 1.0/gamma_b));
	}
	LPVOID ptr = &table;
	HDC the_display_ = GetDC(0);
	int err = SetDeviceGammaRamp(the_display_, ptr);
    return 0;
}
