<?php
// $Id: showrss.inc.php,v 1.1.2.1 2003/03/12 03:32:30 panda Exp $
/**
 *
 * showrss ץ饰
 * 
 * 饤󥹤 PukiWiki ΤƱ GNU General Public License (GPL) Ǥ
 * http://www.gnu.org/licenses/gpl.txt
 *
 * pukiwikiѤΥץ饰Ǥ
 * pukiwiki1.3.2ʾưȻפޤ
 * 
 * ΤȤư뤿ˤPHP  xml extension ɬܤǤPHPȤ߹ޤƤʤϤäʤ顼ФȻפޤ
 * ɽ or ʸؿǤʤȤʤʤʤʤǤפäƤɤ줯餤Τ狼餤ΤαǤ
 * mbstring ⤢ۤǤ
 * 
 * ʤϡ jcode.phps 礳äȤä mb_convert_encoding ȤؿƤФȤꤢäݤѴǤ뤫Ǥ
 * http://www.spencernetwork.org/
 * 
 * Ϣ:
 * do3ob wiki   ->   http://do3ob.com/
 * email        ->   hiro_do3ob@yahoo.co.jp
 * 
 *        ->   http://do3ob.s20.xrea.com/
 *
 * version: $Id: showrss.inc.php,v 1.1.2.1 2003/03/12 03:32:30 panda Exp $
 * 
 */

// å嵡ǽȤϰʲǻꤹǥ쥯ȥ֤Ƥ
if (!defined("CACHE_DIR")) {
	define("CACHE_DIR", "./cache/");
}

// RSS "&lt; &gt; &amp;" ʤɤ ö "< > &" ᤹       "&amp;"  "&amp;amp;" ˤʤä㤦к
if (!defined("SHOWRSS_VALUE_UNESCAPE")) {
	define("SHOWRSS_USE_UNESCAPE", true);
}

// θä"< > &"ʤɤ"&lt; &gt; &amp;"ˤ뤫         XSSк
if (!defined("SHOWRSS_VALUE_ESCAPE")) {
	define("SHOWRSS_USE_ESCAPE"  , true);
}


function plugin_showrss_init() {

	global $_plugin_showrss_tmpl;

	$_plugin_showrss_tmpl = array();
	$_plugin_showrss_tmpl["default"] = array ( "main" => "{list}",
						   "list" => "<a href=\"{link}\" title=\"{description}\">{title}</a><br>",
						   "lastmodified" => "<span style=\"font-size:10px\"><strong>Last-Modified:{timestamp}</strong></span>");

	$_plugin_showrss_tmpl["menubar"] = array ( "main" => "<span class=\"small\"><ul class=\"recent_list\">{list}</ul></span>",
						   "list" => "<li><a href=\"{link}\" title=\"{title} ({description})\">{title}</a></li><br>",
						   "lastmodified" => "<span style=\"font-size:10px\"><strong>Last-Modified:{timestamp}</strong></span>");

	$_plugin_showrss_tmpl["recent"] = array ( "main"         => "<span class=\"small\"><ul class=\"recent_list\">{list}</ul></span>",
						  "list"         => "<li><a href=\"{link}\" title=\"{title} ({description})\">{title}</a></li><br>",
						  "lastmodified" => "<span style=\"font-size:10px\"><strong>Last-Modified:{timestamp}</strong></span>");
}

function plugin_showrss_convert() {

	global $_plugin_showrss_tmpl;

	$local_tmpl = $_plugin_showrss_tmpl; // timestampղ

	if (!extension_loaded("xml")) {
		// xml ĥǽͭǤʤ硣
		// http://www18.tok2.com/home/koumori27/xml/phpsax/phpsax_menu.html ѤƱȤǤɥˡ뤫ʡ
		return plugin_showrss_private_error_message("xml extension is not loaded");
	}

	if (func_num_args() == 0) {
		// ʤϥ顼
		return plugin_showrss_private_error_message("wrong parameter");
	}

	list($rssurl, $tmplname, $usecache, $usetimestamp) = func_get_args();

	// ӽ
	$rssurl       = trim($rssurl);
	$tmplname     = trim($tmplname);
	$usetimestamp = trim($usetimestamp);

	if (is_array($local_tmpl[$tmplname]) === false) {
		$tmplname = "default";
	}

	// RSS ѥͥå
	if (plugin_showrss_private_check_url($rssurl) == false) {
		// url(եѥ)ʾ
		return plugin_showrss_private_error_message("syntax error \"$rssurl\"");
	}

	if ($usecache > 0) {
		if (file_exists(CACHE_DIR) === false) {
			// åȤȻפäɥåǥ쥯ȥ꤬¸ߤʤ
			return plugin_showrss_private_error_message("don't exist:" . CACHE_DIR);
		}

		if (is_writable(CACHE_DIR) === false) {
			// åǥ쥯ȥϽ񤭹߲ǽ
			return plugin_showrss_private_error_message("don't have permission to access :" . CACHE_DIR);
		}

		$expire = 60 * 60 * $usecache;
		if (($filename = plugin_showrss_private_cache_rss($rssurl, $expire)) !== false && filesize($filename) !== 0) {
			// åнǤ url 򥭥å˽񤭴롣
			$rssurl = $filename;
		}
		else {
			// å˼ԤϲʤäΤȤ񤦡 㥨顼٤
			$usecache = 0;
		}
	}

	// ॹפĤɡ⡼礤ޡȤ˽񤭤ʡ
	if ($usetimestamp > 0) {
		if ($usecache > 0) {
			$timestamp = filemtime($rssurl);
		}
		else {
			$timestamp = time();
		}
		$timestamp = date("Y/m/d H:i:s", $timestamp);
		$local_tmpl[$tmplname]["main"] .= str_replace("{timestamp}", $timestamp, $local_tmpl[$tmplname]["lastmodified"]);
	}

	$parsed_rss_array = plugin_showrss_private_get_rss_array($rssurl);

	if (is_string($parsed_rss_array)) {
		// ͤʸȥ顼å
		return plugin_showrss_private_error_message("$parsed_rss_array");
	}

	if (function_exists("mb_convert_encoding")) {
		// 󥳡ɤǤeucˡ
		foreach ($parsed_rss_array as $index => $parsed_rss) {
			foreach ($parsed_rss as $parsed_rss_key => $parsed_rss_value) {
				$parsed_rss_array[$index][$parsed_rss_key] = mb_convert_encoding($parsed_rss_value, "EUC-JP", "auto");
			}
		}
	}
	return plugin_showrss_private_make_html($tmplname, $local_tmpl, $parsed_rss_array);
}

// ʲshowrss ץ饤١ȤʴؿȤ

// 顼åʴʰס
function plugin_showrss_private_error_message($msg) {
	return '<strong>showrss:</strong>' . htmlspecialchars($msg);
}

// urlå
// եξ showrss??????.tmp ߤʥե̾ʤȥ顼ˤʤޤ
// ereg("showrss[a-z0-9_-]+\\.tmp") ˥ޥåOK!
function plugin_showrss_private_check_url($rssurl) {
	// parse_url򤫤ޤ
	$parsed = parse_url(strtolower(trim($rssurl)));

	// schemehttp,https,ftpʤ̵OK
	$scheme = array('http', 'https', 'ftp');
	if (in_array($parsed["scheme"], $scheme)) {
		return true;
	}
	elseif (isset($parsed["scheme"]) == true) {
		// ʳschemeϤȤꤢ顼ˤƤߤ롣
		return false;
	}

	$filename = basename($parsed["path"]);
	if (ereg("showrss[a-z0-9_\\.-]+\\.tmp", $filename)) {
		return true;
	}

	// ٤Ƥξ˰óݤʤ false
	return false;
}
// ƥץ졼ȤĤärss󤫤html
function plugin_showrss_private_make_html($tmplname, $showrss_tmpl, $parsed_rss_array) {

	// ƥץ졼ͭδؿ硢ĤȤ
	if (function_exists("plugin_showrss_private_make_html_" . $tmplname) === true) {
		$makehtml = "plugin_showrss_private_make_html_" . $tmplname;
	}
	else {
		$makehtml = "plugin_showrss_private_make_html_default";
	}
	return $makehtml($tmplname, $showrss_tmpl, $parsed_rss_array);
}

// ǥեȤΥƥץ졼֤ؿ
function plugin_showrss_private_make_html_default($tmplname, $showrss_tmpl, $parsed_rss_array) {
	// ִ
	foreach ($parsed_rss_array as $index => $parsed_rss) {
		$linkhtml = $showrss_tmpl[$tmplname]["list"];
		foreach ($parsed_rss as $parsed_rss_key => $parsed_rss_value) {

			switch ($parsed_rss_key) {
			case "link":
				// 󥯤ξ
				// XSS к "  > ȤѴ
				break;
			case "description":
				if ($unixtime = strtotime(trim($parsed_rss_value))) {
					$parsed_rss_value = plugin_showrss_private_make_update_label($unixtime);
				}
				break;
			default:
				// ʤ
			}
			$parsed_rss_value = plugin_showrss_private_escape($parsed_rss_value);

			$linkhtml = str_replace("{" . $parsed_rss_key . "}", trim($parsed_rss_value), $linkhtml);
		}
		$linklist .= $linkhtml;
	}
	$linklist = str_replace("{list}", $linklist, $showrss_tmpl[$tmplname]["main"]);
	return $linklist;
}

// recent֤ؿ
function plugin_showrss_private_make_html_recent($tmplname, $showrss_tmpl, $parsed_rss_array) {

	$last = "";
	// ִ
	foreach ($parsed_rss_array as $index => $parsed_rss) {

		if (strtotime($parsed_rss["description"]) !== false ) {
			if (date("Y-m-d", strtotime($parsed_rss["description"])) !== $last) {
				$last = date("Y-m-d", strtotime($parsed_rss["description"]));
				$linklist .= "<strong>$last</strong>";
			}
		}

		$linkhtml = $showrss_tmpl[$tmplname]["list"];
		foreach ($parsed_rss as $parsed_rss_key => $parsed_rss_value) {

			switch ($parsed_rss_key) {
			case "link":
				// 󥯤ξ
				// XSS к "  > ȤѴ
				break;
			case "description":
				if ($unixtime = strtotime(trim($parsed_rss_value))) {
					$parsed_rss_value = plugin_showrss_private_make_update_label($unixtime);
				}
				break;
			default:
				// ʤ
			}
			$parsed_rss_value = plugin_showrss_private_escape($parsed_rss_value);

			$linkhtml = str_replace("{" . $parsed_rss_key . "}", trim($parsed_rss_value), $linkhtml);
		}
		$linklist .= $linkhtml;
	}
	$linklist = str_replace("{list}", $linklist, $showrss_tmpl[$tmplname]["main"]);
	return $linklist;
}

// xssкäݤ褦
function plugin_showrss_private_escape($target) {

	if (SHOWRSS_VALUE_UNESCAPE) {
		$target = strtr($target, array_flip(get_html_translation_table(ENT_COMPAT)));
	}

	if (SHOWRSS_VALUE_ESCAPE) {
		$target = htmlspecialchars($target);
	}
	return $target;
}

// rss
function plugin_showrss_private_get_rss_array($rss) {
	global $_plugin_showrss_insideitem,$_plugin_showrss_tag,$_plugin_showrss_title,
	$_plugin_showrss_description,$_plugin_showrss_link,$_plugin_showrss_parsed;

	// 
	$_plugin_showrss_insideitem = false;
	$_plugin_showrss_tag = $_plugin_showrss_title = $_plugin_showrss_description = $_plugin_showrss_link = "";
	$_plugin_showrss_parsed = array();

	$xml_parser = xml_parser_create();
	xml_set_element_handler($xml_parser, "plugin_showrss_private_start_element", "plugin_showrss_private_end_element");
	xml_set_character_data_handler($xml_parser, "plugin_showrss_private_character_data");
	if (!($fp = @fopen($rss,"r"))) return("can't open $rss");
	while ($data = fread($fp, 4096))
		if (!xml_parse($xml_parser, $data, feof($fp))) {
			return(sprintf("XML error: %s at line %d in %s",
				       xml_error_string(xml_get_error_code($xml_parser)),
				       xml_get_current_line_number($xml_parser), $rss));
		}
	fclose($fp);
	xml_parser_free($xml_parser);
	return $_plugin_showrss_parsed;
}


// ֤pukiwikiѴ
function plugin_showrss_private_make_update_label($time, $utime = UTIME) {
	$time = $utime - $time;

	if(ceil($time / 60) < 60)
		$result = ceil($time / 60)."m";
	else if(ceil($time / 60 / 60) < 24)
		$result = ceil($time / 60 / 60)."h";
	else
		$result = ceil($time / 60 / 60 / 24)."d";

	return $result;
}

// xml parserΥϥɥؿ
function plugin_showrss_private_start_element($parser, $name, $attrs) {
	global $_plugin_showrss_insideitem, $_plugin_showrss_tag, $_plugin_showrss_title, $_plugin_showrss_description, $_plugin_showrss_link;
	if ($_plugin_showrss_insideitem) {
		$_plugin_showrss_tag = $name;
	} elseif ($name == "ITEM") {
		$_plugin_showrss_insideitem = true;
	}
}
// xml parserΥϥɥؿ
function plugin_showrss_private_end_element($parser, $name) {
	global $_plugin_showrss_insideitem, $_plugin_showrss_tag, $_plugin_showrss_title, $_plugin_showrss_description, $_plugin_showrss_link, $_plugin_showrss_parsed;
	if ($name == "ITEM") {

		$_plugin_showrss_parsed[] = array(
			"link"  =>  $_plugin_showrss_link,
			"title" =>  $_plugin_showrss_title,
			"description" => $_plugin_showrss_description
			);


		$_plugin_showrss_title = "";
		$_plugin_showrss_description = "";
		$_plugin_showrss_link = "";
		$_plugin_showrss_insideitem = false;
	}
}

// xml parser Υϥɥؿ
function plugin_showrss_private_character_data($parser, $data) {
	global $_plugin_showrss_insideitem, $_plugin_showrss_tag, $_plugin_showrss_title, $_plugin_showrss_description, $_plugin_showrss_link;
	if ($_plugin_showrss_insideitem) {
		switch ($_plugin_showrss_tag) {
		case "TITLE":
			$_plugin_showrss_title .= $data;
			break;
		case "DESCRIPTION":
			$_plugin_showrss_description .= $data;
			break;
		case "LINK":
			$_plugin_showrss_link .= $data;
			break;
		}
	}
}

// -- å -- //

// å򥳥ȥ
function plugin_showrss_private_cache_rss($target, $expire) {
	// ڤΥå򥯥ꥢ
	plugin_showrss_private_cache_garbage_collection(CACHE_DIR, $expire);
	// å夬м
	if (($result = plugin_showrss_private_cache_fetch($target, CACHE_DIR, $expire)) !== false) {
		return $result;
	}

	$data = implode('', file($target));

	if (($filename = plugin_showrss_private_cache_save($data, $target, CACHE_DIR)) === false) {
		return false;
	}

	return $filename;

}

// å夬뤫Ĵ٤롣¸ߤե̾
function plugin_showrss_private_cache_fetch($target, $dir) {

	$filename = $dir . encode($target) . ".tmp";

	if (!is_readable($filename)) {
		return false;
	}

	return $filename;
}

// å¸
function plugin_showrss_private_cache_save($data, $target, $dir) {
	$filename = $dir . encode($target) . ".tmp";
	// lockʤʡ
	$fp = fopen($filename, "w");
	fwrite($fp, $data);
	fclose($fp);
	return $filename;
}

// ڤΥե
function plugin_showrss_private_cache_garbage_collection($dir, $expire) {

	$dh = dir($dir);
	while (($filename = $dh->read()) !== false) {
		if ($filename === '.' || $filename === '..') {
			continue;
		}

		$last = time() - filemtime($dir . $filename);

		if ($last > $expire) {
			unlink($dir . $filename);
		}
	}

	$dh->close();

}

?>
