#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <string.h>
#include "./swapfloat.c"
#include "./gethead.c"
#include "./qcksort.c"
#include "./getmedf.c"

/*
slopecorr2.c
gcc -O2 -lm -o slopecorr2  slopecorr2.c
*/


void ksmooth(float sdata1[], float sdata2[]);

int main (int argc, char**argv)
{
    FILE    *fp;
    float   *data,*data2,*mbox;
    float   *ldata,*ldata2,*datas;
    int     *iclip;
    int     i,j,jj,k,cnum,xynum=1048576;
    int     datanum=((int)(xynum*sizeof(float)/2880)+1)*2880/sizeof(float);
    int     headsize,hfact;
    char    *header;
    float   midpt;
    int     mnum;
  
    if (argc < 2){
      fprintf(stderr, "usage : slopecorr2 name.fits\n");
      return 0;
    }

/*
  get fits header size
*/
    hfact = gethead(argv[1]);
    if (hfact==0){
      fprintf(stderr, "The header size was not obtained.\n");
      return 0;
    }
    headsize = hfact*2880;


/*
  read the FITS data
*/
    data=(float*)malloc(datanum*sizeof(float));
    iclip=(int*)malloc(xynum*sizeof(int));
    data2=(float*)malloc(xynum*sizeof(float));
    header=(char*)malloc(headsize*sizeof(char)+1);
    fp=fopen(argv[1],"rb");
    fread(header,sizeof(char),headsize,fp);
    fread(data,sizeof(float),xynum,fp);
    fclose(fp);

    /* 
    mnum=0;
    midpt=0;
    for (i=0; i<xynum; i++){
      swapfloat(&data[i]);
      if(data[i]>-500 && data[i]<20000){
        iclip[i]=1;
	midpt=midpt+data[i];
	mnum++;
      } else {
	iclip[i]=0;
      }
    }
    midpt=midpt/mnum;

    datas=(float*)malloc(mnum*sizeof(float));
    j=0;
    for (i=0; i<xynum; i++){
      if(iclip[i]==1){
	datas[j]=data[i];
	j++;
      } 
    }

    */

    /*
      get median
    */

    /* fastmedf2(datas,mnum,1,&midpt); */


    for (i=0; i<xynum; i++){
      swapfloat(&data[i]);
    }
    midpt=getmedf(data,xynum,-1000,15000);


    /* free(datas);  */

    for (i=0; i<xynum; i++){
      data2[i]=data[i]-midpt;
      if(data2[i]>1000 || data2[i]<-1000){
        data2[i]=-9999;
      }
    }

    ldata=(float*)malloc(1024*sizeof(float));
    ldata2=(float*)malloc(1024*sizeof(float));
    for (j=1; j<1023; j++){

       cnum=0;
       for(i=0; i<1024; i++){
         if(data2[j+1024*i]>-1000){  
           cnum++;
         }
       } 
      
       if(cnum>10){
         mbox=(float*)malloc(cnum*sizeof(float));
         k=0;
         midpt=0;
         for(i=0; i<1024; i++){
           if(data2[j+1024*i]>-1000){  
	     mbox[k]=data2[j+1024*i];
	     midpt=midpt+mbox[k];
             k++;
           }
         }
	 midpt=midpt/cnum;
         /* fastmedf2(mbox,cnum,1,&midpt); */
	 /* ldata[j]=midpt;  */
	 ldata[j]=getmedf(mbox,cnum,-1000,1000);
         free(mbox);
       } else {
         ldata[j]=0;
       }

    }
    ldata[0]=ldata[1];
    ldata[1023]=ldata[1022];

    free(data2);

    ksmooth(ldata,ldata2);

    for (i=0; i<xynum; i++){
      jj=i%1024;
      data[i]=data[i]-ldata2[jj];
    }

    for (i=0; i<xynum; i++){
      swapfloat(&data[i]);
    }

    if(NULL==(fp=fopen(argv[1],"wb"))){
	printf("%s can not be opened.\n",argv[1]);
	exit(1);
    }
    fwrite(header,sizeof(char),headsize,fp);
    fwrite(data,sizeof(float),datanum,fp);
    fclose(fp);

    free(data);
    free(header);
    free(ldata);
    free(ldata2);

    return 0;

}


void ksmooth(float sdata1[], float sdata2[])
{
  int i,j;
  float hh,wi,wsum,wysum;

  hh=5;

  for(i=0; i<512; i++){

    wsum=0;
    wysum=0;
    for(j=i-7; j<=i+7; j++){
      if(j>=0 && j<512){
         wi=exp(-0.5*(i-j)*(i-j)/hh);
         wsum=wsum+wi;
         wysum=wysum+wi*sdata1[j];
      }
    }
    sdata2[i]=wysum/wsum;

  }

  for(i=512; i<1024; i++){

    wsum=0;
    wysum=0;
    for(j=i-7; j<=i+7; j++){
      if(j>=512 && j<1024){
         wi=exp(-0.5*(i-j)*(i-j)/hh);
         wsum=wsum+wi;
         wysum=wysum+wi*sdata1[j];
      }
    }
    sdata2[i]=wysum/wsum;

  }


}


