#include <stdio.h>
#include <stdlib.h>
#include "matched.h"

void usage(void);

int main(int argc, char *argv[]){
   int ndata;
   double *refmag, *delta, mean;
   matched *data;
   if(argc!=2) usage();
   if((data=load_matched(argv[1],&ndata))==NULL){
      fprintf(stderr,"Failed to load matched from %s\n",argv[1]); exit(1);
   }
   refmag=malloc(ndata*sizeof(double));
   delta=malloc(ndata*sizeof(double));
   get_refmag_delta(ndata,data,refmag,delta);
   mean=get_matched_magdelta(ndata,data);
   fprintf(stdout,"%.3f\n",mean);
   free(refmag); free(delta);
   return 0;
}

void usage(void){
   fprintf(stderr,"Usage -> calc_magdel  matched_file\n"); exit(1);
}
