#include "verbose.h"

void print_start(FILE *fp){
   fprintf(fp,"\n### opm started ###\n\n");
}

void print_load_xym(FILE *fp, int ndata, char *file){
   fprintf(fp,"# %d %s\n",ndata,file);
}

void print_mag_cut(FILE *fp, char *file, double cut, int start){
   fprintf(fp,"#\tmag_cut for %s : %d objects (m<%g) were excluded\n",file,start,cut);
}

void print_nset(FILE *fp, int nset, int start1, int start2){
   fprintf(fp,"# nset=%d (start1=%d start2=%d)\n",nset,start1,start2);
}

void print_make_tri_array(FILE *fp, int nset, int narray){
   fprintf(fp,"# %d triangles were created with %d objects\n",narray,nset);
}

void print_nobject_output(FILE *fp, int num, char *file){
   fprintf(fp,"# %d objects were put into %s\n",num,file);
}

void print_end(FILE *fp){
   fprintf(fp,"\n### opm finished ###\n\n");
}

void print_opm_success(FILE *fp, double *coef){
   fprintf(fp,"# Congratulations! Matching was successfully done!\n");
   fprintf(fp,"#\txref = %12.5f xobj + %12.5f yobj + %12.5f\n",coef[0],coef[1],coef[2]);
   fprintf(fp,"#\tyref = %12.5f xobj + %12.5f yobj + %12.5f\n",coef[3],coef[4],coef[5]);
}

