#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <string.h>
#include "./gethead.c"
#include "./gethead2.c"
#include "./swapfloat.c"
#include "./swapshort.c"

/*
darkflatfzncf.c
(rawdata[short] - dark[float]) / flat[float] = newframe[float]
without cfitsio 
*/


int main (int argc, char**argv)
{

  short     *data1;
  float     *data2, *data3;
  float     *data4={0};
  char      fname1[50], fname4[30];
  char      line[100];
  FILE      *fp, *fp4;
  int       i, j, xynum = 1048576;
  int       datanum = ((int)(xynum*sizeof(float)/2880)+1)*2880/sizeof(float);
  int       lnum, fnum;
  int       hfact;
  int       headsize1, headsize2, headsize3;
  char      *header1;
  char      **fits1arr, **fits4arr;

  if (argc < 4){
    fprintf(stderr, "usage : darkflatfz rawdata-list dark(float) flat(float)\n");
    return 0;
  }

  hfact = gethead(argv[2]);
  if (hfact == 0){
    fprintf(stderr, "The header size was not obtained.\n");
    return 0;
  }
  headsize2 = hfact * 2880;

  hfact = gethead(argv[3]);
  if (hfact == 0){
    fprintf(stderr, "The header size was not obtained.\n");
    return 0;
  }
  headsize3 = hfact * 2880;


/*
read the data2, dark
*/
  data2 = (float*)malloc(xynum*sizeof(float));
  if(NULL == (fp = fopen(argv[2], "rb"))){
      printf("%s can not be opened.\n",argv[2]);
      exit(1);
  }
  fseek(fp, headsize2, SEEK_SET);
  fread(data2, sizeof(float), xynum, fp);
  fclose(fp);

  for (i=0; i<xynum; i++){
    swapfloat(&data2[i]);
  }


/*
read the data3, flat
*/
  data3 = (float*)malloc(xynum*sizeof(float));
  if(NULL == (fp = fopen(argv[3], "rb"))){
      printf("%s can not be opened.\n", argv[3]);
      exit(1);
  }
  fseek(fp, headsize3, SEEK_SET);
  fread(data3, sizeof(float), xynum, fp);
  fclose(fp);

  for (i=0; i<xynum; i++){
    swapfloat(&data3[i]);
  }


/*
read the list
*/

  if(NULL == (fp = fopen(argv[1], "r"))){
    printf("%s can not be opened.\n", argv[1]);
    exit(1);
  }
  lnum = 0;
  while(fgets(line, sizeof(line), fp) != NULL){
    lnum ++;
  }
  fclose(fp);

  fits1arr = (char**)malloc(lnum*sizeof(char)*50);
  fits4arr = (char**)malloc(lnum*sizeof(char)*30);
  fp = fopen(argv[1], "r");
  fnum = 0;
  while(fgets(line, sizeof(line), fp) !=NULL){
    sscanf(line, "%s %s", fname1, fname4);
    fits1arr[fnum] = (char*)malloc(50);
    fits4arr[fnum] = (char*)malloc(30);
    strcpy(fits1arr[fnum], fname1);
    strcpy(fits4arr[fnum], fname4);
    fnum++;
  }
  fclose(fp);


  for(j=0; j<lnum; j++){

    hfact = gethead(fits1arr[j]);
    if (hfact == 0){
      fprintf(stderr, "The header size was not obtained.\n");
      return 0;
    }
    headsize1 = hfact * 2880;

    data1 = (short*)malloc(xynum*sizeof(short));
    header1 = (char*)malloc(headsize1*sizeof(char));
    fp = fopen(fits1arr[j], "rb");
    fread(header1, sizeof(char), headsize1, fp);
    fread(data1, sizeof(short), xynum, fp);
    fclose(fp);

    for (i=0; i<xynum; i++){
      swapshort(&data1[i]);
    }


    /*
     dark subtraction and flat division
    */
    data4 = (float*)malloc(datanum*sizeof(float));
    for (i=0; i<xynum; i++){
      if (data3[i] != 0.0){
        data4[i] = (data1[i] - data2[i]) / data3[i];
      } else {
        data4[i] = -1000.0;
      }
    }
  
    for (i=0; i<datanum; i++){
      swapfloat(&data4[i]);
    }

    header1[107]='-';
    header1[108]='3';
    header1[109]='2';

    fp4=fopen(fits4arr[j], "wb");
    fwrite(header1, sizeof(char), headsize1, fp4);
    fwrite(data4, sizeof(float), datanum, fp4);
    fclose(fp4);

    free(fits1arr[j]);
    free(fits4arr[j]);
    free(data4);
    free(data1);
    free(header1);
  }

  free(data2);
  free(data3);
  free(fits1arr);
  free(fits4arr);

  return 0;

}


