#ifndef _INCLUDE_VERIFICATION_H_
#define _INCLUDE_VERIFICATION_H_

#include "boolean.h"
#include "xym.h"
#include "triangle.h"
#include "treematch.h"
#include "opm_param.h"

#define ANGLE_LIMIT 5

Boolean pre_verif(triangle p, triangle q, double *coef, double limit);
Boolean verification(FILE *flog, int nobj, xym *data_obj, int nref, xym *data_ref, double *coef, opm_param *setting);
Leaf *make_leaf(int ndata, xym *data);
Leaf *make_leaf_tran(int ndata, xym *data, double *coef);
void calc_coef_param(Boolean mirror, double *coef, double *magnify, double *angle);

#endif
