#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "./gethead.c"
#include "./swapfloat.c"

/*
  mkcorrflat.c 
  as of 2011.8
*/

void mkheader(char *header, int sorf);

int main (int argc, char**argv)
{
  float *datac,*datam,*datan,*corrflat;
  FILE  *fp;
  int   i,xynum=1024*1024;
  int   datanum=((int)(xynum*sizeof(float)/2880)+1)*2880/sizeof(float);
  int   headsize1,headsize2,headsize3,hfact;
  char  *header;
  char  band[2];
  char  cflat[12],mflat[12];

  if (argc<3){
    fprintf(stderr, "usage : mkcorrflat newflat.fits outflat.fits \n");
    return 0;
  }

  memcpy(band,argv[1],1); band[1]='\0';
  strcpy(cflat,band);
  strcat(cflat,"cflat.fits");
  strcpy(mflat,band);
  strcat(mflat,"mflat.fits");


/*
header size
*/

  hfact = gethead(cflat);
  headsize1 = hfact*2880;

  hfact = gethead(mflat);
  headsize2 = hfact*2880;

  hfact = gethead(argv[1]);
  headsize3 = hfact*2880;

/*
read the data
*/

  datac=(float*)malloc(xynum*sizeof(float));
  fp=fopen(cflat,"rb");
  fseek(fp,headsize1,SEEK_SET);
  fread(datac,sizeof(float),xynum,fp);
  fclose(fp);

  for (i=0; i<xynum; i++){
    swapfloat(&datac[i]);
  }


  datam=(float*)malloc(xynum*sizeof(float));
  fp=fopen(mflat,"rb");
  fseek(fp,headsize2,SEEK_SET);
  fread(datam,sizeof(float),xynum,fp);
  fclose(fp);

  for (i=0; i<xynum; i++){
    swapfloat(&datam[i]);
  }


  datan=(float*)malloc(xynum*sizeof(float));
  fp=fopen(argv[1],"rb");
  fseek(fp,headsize3,SEEK_SET);
  fread(datan,sizeof(float),xynum,fp);
  fclose(fp);

  for (i=0; i<xynum; i++){
    swapfloat(&datan[i]);
  }

  corrflat=(float*)malloc(datanum*sizeof(float));

  for (i=0; i<xynum; i++){
    if (datan[i] < 0.7 || datan[i] > 1.3 || datam[i] < 0.7 || datam[i] > 1.3 || datac[i] < 0.7 || datac[i] > 1.3){
      corrflat[i]=-100000;
    } else {
      corrflat[i]=datan[i]/datac[i]*datam[i];
    }
  }

  free(datac);
  free(datan);
  free(datam);

  for (i=0; i<datanum; i++){
     swapfloat(&corrflat[i]);
  }

  header=(char*)malloc(2880*sizeof(char)+1);
  mkheader(header,1);  /* 1 for float */
  fp=fopen(argv[2],"wb");
  fwrite(header,sizeof(char),2880,fp);
  fwrite(corrflat,sizeof(float),datanum,fp);
  fclose(fp);
  free(header);

  free(corrflat);


  return 0;

}


void mkheader(char *header, int sorf)
{

  int       ih;
  char      fheader[2881]="SIMPLE  =                    T / Fits standard                                  BITPIX  =                  -32 / Bits per pixel                                 NAXIS   =                    2 / Number of axes                                 NAXIS1  =                 1024 / Axis length                                    NAXIS2  =                 1024 / Axis length                                    EXTEND  =                    F / File may contain extensions                    END                                                                             ";
  char      sheader[2881]="SIMPLE  =                    T / Fits standard                                  BITPIX  =                   16 / Bits per pixel                                 NAXIS   =                    2 / Number of axes                                 NAXIS1  =                 1024 / Axis length                                    NAXIS2  =                 1024 / Axis length                                    EXTEND  =                    F / File may contain extensions                    END                                                                             ";
  char      nn[2]=" ";

  if(sorf==1){
    for(ih=0; ih<560; ih++){
      header[ih]=fheader[ih];
    }
    for(ih=560; ih<2880; ih++){
      header[ih]=nn[0];
    }
  } else if (sorf==2){
    for(ih=0; ih<560; ih++){
      header[ih]=sheader[ih];
    }
    for(ih=560; ih<2880; ih++){
      header[ih]=nn[0];
    }
  } else {
    printf("wrong type for sorf.\n");
    exit(1);
  }



}



