# coding: utf-8

# print "".join(['a','b'])

from pylaf.utils.core.weakvaluelist import WeakValueList

class Node:
    '''監視対象。いずれからも監視されなくなったら自動的に削除される。メンバ変数による参照禁止'''
    def __init__(self,value):
        self.value = value
        self.observers = WeakValueList() # オブザーバへの逆参照を格納する弱参照リスト（循環参照を防止するために逆参照を用いた）
    def register(self,observer):
        if not self.observers.count(observer): # もし、observerに対する弱参照を保持していなければ
            self.observers.append(observer) # オブザーバの弱参照をリストに保持
    def unregister(self,observer):
        self.observers.cleanup() # 削除したオブジェクトをコールしないよう空になった弱参照をクリア
        self.observers.remove(observer) # 与えられたobserverに対する弱参照をリストから削除
    def notify(self,event):
        '''監視者へ変更を通知する。observer.update(event)を起動する。起動の順番は登録順。'''
        self.observers.cleanup() # 削除したオブジェクトをコールしないよう空になった弱参照をクリア
        for o in self.observers.tolist(): o.notify(event) # オブザーバひとつひとつのupdate()をobserversの順番に起動
        
class PortAttributes(object):
    def __init__(self,owner,port,value):
        self.owner = weakref.ref(owner)
        self.port  = weakref.ref(port)
        self.node  = None
        self.register(Node(value))
    def register(self,node):
        self.unregister() # 監視を解除
        node.register(self) # 監視していることを通知
        self.node = node # 監視対象を保持するために参照する
    def unregister(self):
        if not self.node == None: # すでになにかを監視しているならば
            self.node.unregister(self) # 監視をやめることを通知
            self.node = None # 監視対象保持のための参照を削除
    def notify(self,event):
        self.port().notify(self,event)
        
class Port(object):
    def __init__(self,init_value=None):
        self.init_value = init_value
        self.name       = None # 最初にset/get/linkが呼び出されたときにオーナーを検索して取得（未実装）
    def __get__(self, owner, ownertype):
        node = self.get_attributes(owner,self.get_name(owner)).node
        node.notify('get')
        return node.value
    def __set__(self, owner, value):
        node = self.get_attributes(owner,self.get_name(owner)).node
        node.value = value
        node.notify('set')
    #def __delete__(self, owner):
    #    self.get_attributes(owner,self.get_name(owner)).unregister()
    def notify(self, attr, event): pass
    def get_name(self, owner): # オーナーインスタンスからの参照名を取得する
        if self.name == None: # オーナーインスタンスが生成されてから最初に参照されたときには名称探索をする
            # 呼び出しのコンテキストから、オーナーインスタンスにオブジェクトが存在することが保証されている（はず）
            for name, v in owner.__class__.__dict__.iteritems(): # オーナークラスのメンバ全体について
                if v == self:
                    self.name = name
                    return name # 自身と一致するインスタンスの名称を返す
        else:
            return self.name
    def get_attributes(self, owner, name): # オーナーインスタンスから属性を取得する
        if not name in owner.__dict__: # まだオーナーに属性が生成されていなければ
            owner.__dict__[name] = PortAttributes(owner,self,self.init_value) # 新しく生成する
        return owner.__dict__[name] # 属性を返す
        
class RulePort(Port):
    def __init__(self,value=None,rule=None):
        Port.__init__(self,value)
        if rule: self.rule = rule
    def __set__(self, owner, value):
        raise RulePortSetError("cannot set() a rule cell")
    def notify(self,attr,event):
        if not event == 'get': return
        try: self.rule
        except: return # undefined rule error!!
        attr.node.value = self.rule(attr.owner())
        
class EventPort(Port):
    def __init__(self,value=None,rule=None):
        Port.__init__(self,value)
        if rule: self.rule = rule
    def notify(self,attr,event):
        if not event == 'set': return
        try: self.rule
        except: return # undefined rule error!!
        self.rule(attr.owner())
        
class _PortException(Exception):
    def __init__(self, value):
        self.value = value
    def __str__(self):
        return repr(self.value)

class RulePortSetError(_PortException): pass

def rule(*args,**kw):
    def _(func): return RulePort(rule=func,*args,**kw)
    return _
    
def event(*args,**kw):
    def _(func): return EventPort(rule=func,*args,**kw)
    return _
    
class MyClass(object):
    x = Port(10)
    y = Port(20)
    @rule()
    def z(self): return self.x + self.y
    @event(10)
    def a(self): print self.a
    
def port(owner,name):
    return owner.__class__.__dict__[name]
    
p = port

# ポートの種類
# 同期
# 同期のみ。コールバックやルールの駆動には関係しない。
# イベント
# 特定の入力に対してsetされたら、直ちに結びつけられたコールバックを起動する。
# ルール
# getされたらば無条件で（入力のうちひとつでも更新されていた場合にしてもいいかも）
# すべての可能な入力が更新された場合
# タイマー
# afterが使えるオブジェクトに対してはタイマーを使える
#
# 行列変換コンポーネントの場合
# class MatrixConvert:
#     input = Port(array([]))
#     type  = Port(["s2y","s2z"])
#     @rule()
#     def output(self, prev): return


# ポートが更新されたかを判定する方法を２種類から選べる。
# A) コンテンツの内容が等しいかどうか調べる。
# B) setされたら無条件に更新されたと見なす。比較のコストが大きい場合にはこちらを使う。

import numpy
a = numpy.random.rand(1000)
print repr(id(a))
print repr(id(a))
b = a.copy()
a[0] = 0
print repr(a) == repr(b)
print a == b

print repr(10.)

import weakref
m, n = MyClass(), MyClass()
print 'm.x:', m.x
print 'm.y:', m.y
print 'm.z:', m.z
print 'n.x:', n.x
m.x = 20
print 'm.x:', m.x
print 'm.y:', m.y
print 'm.z:', m.z
print m.__class__.__dict__['x']
print port(m,'x')
print p(m,'x')
print 'n.x:', n.x
m.a = 100
#try: m.z = 10
#except RulePortSetError: print 'RulePortSetError'
# 上のエラー処理が入っていると、下の解放確認が正しく働かない
m = weakref.ref(m); print m
