#------------------------------------------------------------------------------
# File:         TagLookup.pm
#
# Description:  Fast lookup for ExifTool tags
#
# Notes:        This lookup is used to look up tag names for writing
#
# Revisions:    12/31/2004  - P. Harvey Created
#------------------------------------------------------------------------------

package Image::ExifTool::TagLookup;

use strict;
require Exporter;

use vars qw($VERSION @ISA @EXPORT_OK);
use Image::ExifTool qw(:Utils);

$VERSION = '1.06';
@ISA = qw(Exporter);
@EXPORT_OK = qw(FindTagInfo TagExists);

sub AddTags($$);

#
# Note: the lists below were generated by Image::ExifTool::BuildTagLookup
#

#++++ Begin automatically generated code ++++

# list of tables containing writable tags
my @tableList = (
	'Image::ExifTool::APP12::Ducky',
	'Image::ExifTool::Canon::AFMicroAdj',
	'Image::ExifTool::Canon::CameraInfo1000D',
	'Image::ExifTool::Canon::CameraInfo1D',
	'Image::ExifTool::Canon::CameraInfo1DmkII',
	'Image::ExifTool::Canon::CameraInfo1DmkIII',
	'Image::ExifTool::Canon::CameraInfo1DmkIIN',
	'Image::ExifTool::Canon::CameraInfo1DmkIV',
	'Image::ExifTool::Canon::CameraInfo40D',
	'Image::ExifTool::Canon::CameraInfo450D',
	'Image::ExifTool::Canon::CameraInfo500D',
	'Image::ExifTool::Canon::CameraInfo50D',
	'Image::ExifTool::Canon::CameraInfo550D',
	'Image::ExifTool::Canon::CameraInfo5D',
	'Image::ExifTool::Canon::CameraInfo5DmkII',
	'Image::ExifTool::Canon::CameraInfo7D',
	'Image::ExifTool::Canon::CameraInfo7D_2',
	'Image::ExifTool::Canon::CameraInfoPowerShot',
	'Image::ExifTool::Canon::CameraInfoPowerShot2',
	'Image::ExifTool::Canon::CameraInfoUnknown32',
	'Image::ExifTool::Canon::CameraSettings',
	'Image::ExifTool::Canon::ColorBalance',
	'Image::ExifTool::Canon::ColorData1',
	'Image::ExifTool::Canon::ColorData2',
	'Image::ExifTool::Canon::ColorData3',
	'Image::ExifTool::Canon::ColorData4',
	'Image::ExifTool::Canon::ColorData5',
	'Image::ExifTool::Canon::ColorInfo',
	'Image::ExifTool::Canon::FaceDetect1',
	'Image::ExifTool::Canon::FaceDetect2',
	'Image::ExifTool::Canon::FileInfo',
	'Image::ExifTool::Canon::Flags',
	'Image::ExifTool::Canon::FocalLength',
	'Image::ExifTool::Canon::LightingOpt',
	'Image::ExifTool::Canon::Main',
	'Image::ExifTool::Canon::MeasuredColor',
	'Image::ExifTool::Canon::ModifiedInfo',
	'Image::ExifTool::Canon::MyColors',
	'Image::ExifTool::Canon::Panorama',
	'Image::ExifTool::Canon::PreviewImageInfo',
	'Image::ExifTool::Canon::Processing',
	'Image::ExifTool::Canon::SerialInfo',
	'Image::ExifTool::Canon::ShotInfo',
	'Image::ExifTool::Canon::VignettingCorr',
	'Image::ExifTool::Canon::VignettingCorr2',
	'Image::ExifTool::CanonCustom::Functions10D',
	'Image::ExifTool::CanonCustom::Functions1D',
	'Image::ExifTool::CanonCustom::Functions2',
	'Image::ExifTool::CanonCustom::Functions20D',
	'Image::ExifTool::CanonCustom::Functions30D',
	'Image::ExifTool::CanonCustom::Functions350D',
	'Image::ExifTool::CanonCustom::Functions400D',
	'Image::ExifTool::CanonCustom::Functions5D',
	'Image::ExifTool::CanonCustom::FunctionsD30',
	'Image::ExifTool::CanonCustom::PersonalFuncValues',
	'Image::ExifTool::CanonCustom::PersonalFuncs',
	'Image::ExifTool::CanonRaw::ExposureInfo',
	'Image::ExifTool::CanonRaw::FlashInfo',
	'Image::ExifTool::CanonRaw::ImageFormat',
	'Image::ExifTool::CanonRaw::ImageInfo',
	'Image::ExifTool::CanonRaw::Main',
	'Image::ExifTool::CanonRaw::MakeModel',
	'Image::ExifTool::CanonRaw::RawJpgInfo',
	'Image::ExifTool::CanonRaw::TimeStamp',
	'Image::ExifTool::CanonVRD::Ver1',
	'Image::ExifTool::CanonVRD::Ver2',
	'Image::ExifTool::Casio::Main',
	'Image::ExifTool::Casio::Type2',
	'Image::ExifTool::Composite',
	'Image::ExifTool::DNG::AdobeData',
	'Image::ExifTool::Exif::Main',
	'Image::ExifTool::Extra',
	'Image::ExifTool::FotoStation::Main',
	'Image::ExifTool::FotoStation::SoftEdit',
	'Image::ExifTool::FujiFilm::Main',
	'Image::ExifTool::GPS::Main',
	'Image::ExifTool::IPTC::ApplicationRecord',
	'Image::ExifTool::IPTC::EnvelopeRecord',
	'Image::ExifTool::IPTC::NewsPhoto',
	'Image::ExifTool::JFIF::Main',
	'Image::ExifTool::Kodak::CameraInfo',
	'Image::ExifTool::Kodak::IFD',
	'Image::ExifTool::Kodak::KDC_IFD',
	'Image::ExifTool::Kodak::Main',
	'Image::ExifTool::Kodak::Meta',
	'Image::ExifTool::Kodak::SubIFD0',
	'Image::ExifTool::Kodak::SubIFD1',
	'Image::ExifTool::Kodak::SubIFD2',
	'Image::ExifTool::Kodak::SubIFD3',
	'Image::ExifTool::Kodak::SubIFD5',
	'Image::ExifTool::Kodak::Type10',
	'Image::ExifTool::Kodak::Type2',
	'Image::ExifTool::Kodak::Type3',
	'Image::ExifTool::Kodak::Type4',
	'Image::ExifTool::Kodak::Type7',
	'Image::ExifTool::Kodak::Type9',
	'Image::ExifTool::MIE::Audio',
	'Image::ExifTool::MIE::Camera',
	'Image::ExifTool::MIE::Doc',
	'Image::ExifTool::MIE::Extender',
	'Image::ExifTool::MIE::Flash',
	'Image::ExifTool::MIE::GPS',
	'Image::ExifTool::MIE::Geo',
	'Image::ExifTool::MIE::Image',
	'Image::ExifTool::MIE::Lens',
	'Image::ExifTool::MIE::Main',
	'Image::ExifTool::MIE::Orient',
	'Image::ExifTool::MIE::Preview',
	'Image::ExifTool::MIE::Thumbnail',
	'Image::ExifTool::MIE::UTM',
	'Image::ExifTool::MIE::Video',
	'Image::ExifTool::Minolta::CameraSettings',
	'Image::ExifTool::Minolta::CameraSettings5D',
	'Image::ExifTool::Minolta::CameraSettings7D',
	'Image::ExifTool::Minolta::CameraSettingsA100',
	'Image::ExifTool::Minolta::Main',
	'Image::ExifTool::Minolta::WBInfoA100',
	'Image::ExifTool::MinoltaRaw::PRD',
	'Image::ExifTool::MinoltaRaw::RIF',
	'Image::ExifTool::MinoltaRaw::WBG',
	'Image::ExifTool::Nikon::AFInfo',
	'Image::ExifTool::Nikon::AFInfo2',
	'Image::ExifTool::Nikon::AFTune',
	'Image::ExifTool::Nikon::CaptureOutput',
	'Image::ExifTool::Nikon::ColorBalance1',
	'Image::ExifTool::Nikon::ColorBalance2',
	'Image::ExifTool::Nikon::ColorBalance3',
	'Image::ExifTool::Nikon::ColorBalance4',
	'Image::ExifTool::Nikon::ColorBalanceA',
	'Image::ExifTool::Nikon::DistortInfo',
	'Image::ExifTool::Nikon::FileInfo',
	'Image::ExifTool::Nikon::FlashInfo0100',
	'Image::ExifTool::Nikon::FlashInfo0102',
	'Image::ExifTool::Nikon::FlashInfo0103',
	'Image::ExifTool::Nikon::GEM',
	'Image::ExifTool::Nikon::ISOInfo',
	'Image::ExifTool::Nikon::LensData00',
	'Image::ExifTool::Nikon::LensData01',
	'Image::ExifTool::Nikon::LensData0204',
	'Image::ExifTool::Nikon::Main',
	'Image::ExifTool::Nikon::MultiExposure',
	'Image::ExifTool::Nikon::PictureControl',
	'Image::ExifTool::Nikon::PreviewIFD',
	'Image::ExifTool::Nikon::ROC',
	'Image::ExifTool::Nikon::Scan',
	'Image::ExifTool::Nikon::ShotInfo',
	'Image::ExifTool::Nikon::ShotInfoD300S',
	'Image::ExifTool::Nikon::ShotInfoD300a',
	'Image::ExifTool::Nikon::ShotInfoD300b',
	'Image::ExifTool::Nikon::ShotInfoD3S',
	'Image::ExifTool::Nikon::ShotInfoD3X',
	'Image::ExifTool::Nikon::ShotInfoD3a',
	'Image::ExifTool::Nikon::ShotInfoD3b',
	'Image::ExifTool::Nikon::ShotInfoD40',
	'Image::ExifTool::Nikon::ShotInfoD5000',
	'Image::ExifTool::Nikon::ShotInfoD80',
	'Image::ExifTool::Nikon::ShotInfoD90',
	'Image::ExifTool::Nikon::Type2',
	'Image::ExifTool::Nikon::VRInfo',
	'Image::ExifTool::Nikon::WorldTime',
	'Image::ExifTool::NikonCapture::Brightness',
	'Image::ExifTool::NikonCapture::ColorBoost',
	'Image::ExifTool::NikonCapture::CropData',
	'Image::ExifTool::NikonCapture::DLightingHQ',
	'Image::ExifTool::NikonCapture::DLightingHS',
	'Image::ExifTool::NikonCapture::Exposure',
	'Image::ExifTool::NikonCapture::HighlightData',
	'Image::ExifTool::NikonCapture::Main',
	'Image::ExifTool::NikonCapture::NoiseReduction',
	'Image::ExifTool::NikonCapture::PhotoEffects',
	'Image::ExifTool::NikonCapture::PictureCtrl',
	'Image::ExifTool::NikonCapture::RedEyeData',
	'Image::ExifTool::NikonCapture::UnsharpData',
	'Image::ExifTool::NikonCapture::WBAdjData',
	'Image::ExifTool::NikonCustom::SettingsD3',
	'Image::ExifTool::NikonCustom::SettingsD40',
	'Image::ExifTool::NikonCustom::SettingsD5000',
	'Image::ExifTool::NikonCustom::SettingsD80',
	'Image::ExifTool::NikonCustom::SettingsD90',
	'Image::ExifTool::Olympus::CameraSettings',
	'Image::ExifTool::Olympus::Equipment',
	'Image::ExifTool::Olympus::FETags',
	'Image::ExifTool::Olympus::FocusInfo',
	'Image::ExifTool::Olympus::ImageProcessing',
	'Image::ExifTool::Olympus::Main',
	'Image::ExifTool::Olympus::RawDevelopment',
	'Image::ExifTool::Olympus::RawDevelopment2',
	'Image::ExifTool::Olympus::RawInfo',
	'Image::ExifTool::PDF::Info',
	'Image::ExifTool::PNG::Main',
	'Image::ExifTool::PNG::TextualData',
	'Image::ExifTool::Panasonic::Data1',
	'Image::ExifTool::Panasonic::FaceDetInfo',
	'Image::ExifTool::Panasonic::FaceRecInfo',
	'Image::ExifTool::Panasonic::Leica2',
	'Image::ExifTool::Panasonic::Leica3',
	'Image::ExifTool::Panasonic::Leica5',
	'Image::ExifTool::Panasonic::Leica6',
	'Image::ExifTool::Panasonic::LensInfo',
	'Image::ExifTool::Panasonic::Main',
	'Image::ExifTool::Panasonic::Subdir',
	'Image::ExifTool::PanasonicRaw::Main',
	'Image::ExifTool::Pentax::AEInfo',
	'Image::ExifTool::Pentax::AFInfo',
	'Image::ExifTool::Pentax::BatteryInfo',
	'Image::ExifTool::Pentax::CameraInfo',
	'Image::ExifTool::Pentax::CameraSettings',
	'Image::ExifTool::Pentax::ColorInfo',
	'Image::ExifTool::Pentax::EVStepInfo',
	'Image::ExifTool::Pentax::FlashInfo',
	'Image::ExifTool::Pentax::LensData',
	'Image::ExifTool::Pentax::LensInfo',
	'Image::ExifTool::Pentax::LensInfo2',
	'Image::ExifTool::Pentax::Main',
	'Image::ExifTool::Pentax::SRInfo',
	'Image::ExifTool::Pentax::Type2',
	'Image::ExifTool::PhotoMechanic::SoftEdit',
	'Image::ExifTool::PhotoMechanic::XMP',
	'Image::ExifTool::Photoshop::JPEG_Quality',
	'Image::ExifTool::Photoshop::Main',
	'Image::ExifTool::Photoshop::Resolution',
	'Image::ExifTool::PostScript::Main',
	'Image::ExifTool::Ricoh::ImageInfo',
	'Image::ExifTool::Ricoh::Main',
	'Image::ExifTool::Ricoh::SerialInfo',
	'Image::ExifTool::Ricoh::Subdir',
	'Image::ExifTool::Samsung::Type1',
	'Image::ExifTool::Samsung::Type2',
	'Image::ExifTool::Sanyo::Main',
	'Image::ExifTool::Sigma::Main',
	'Image::ExifTool::Sony::CameraSettings',
	'Image::ExifTool::Sony::CameraSettings2',
	'Image::ExifTool::Sony::Main',
	'Image::ExifTool::Sony::Panorama',
	'Image::ExifTool::Sony::ShotInfo',
	'Image::ExifTool::SonyIDC::Main',
	'Image::ExifTool::XMP::Album',
	'Image::ExifTool::XMP::DICOM',
	'Image::ExifTool::XMP::Lightroom',
	'Image::ExifTool::XMP::MP',
	'Image::ExifTool::XMP::MediaPro',
	'Image::ExifTool::XMP::Microsoft',
	'Image::ExifTool::XMP::acdsee',
	'Image::ExifTool::XMP::aux',
	'Image::ExifTool::XMP::cc',
	'Image::ExifTool::XMP::crs',
	'Image::ExifTool::XMP::dc',
	'Image::ExifTool::XMP::dex',
	'Image::ExifTool::XMP::digiKam',
	'Image::ExifTool::XMP::exif',
	'Image::ExifTool::XMP::iptcCore',
	'Image::ExifTool::XMP::iptcExt',
	'Image::ExifTool::XMP::pdf',
	'Image::ExifTool::XMP::photoshop',
	'Image::ExifTool::XMP::plus',
	'Image::ExifTool::XMP::prism',
	'Image::ExifTool::XMP::prl',
	'Image::ExifTool::XMP::pur',
	'Image::ExifTool::XMP::rdf',
	'Image::ExifTool::XMP::swf',
	'Image::ExifTool::XMP::tiff',
	'Image::ExifTool::XMP::x',
	'Image::ExifTool::XMP::xmp',
	'Image::ExifTool::XMP::xmpBJ',
	'Image::ExifTool::XMP::xmpDM',
	'Image::ExifTool::XMP::xmpMM',
	'Image::ExifTool::XMP::xmpNote',
	'Image::ExifTool::XMP::xmpPLUS',
	'Image::ExifTool::XMP::xmpRights',
	'Image::ExifTool::XMP::xmpTPg',
);

# lookup for all writable tags
my %tagLookup = (
	'aberrationcorrectiondistance' => { 65 => 0x69 },
	'about' => { 258 => 'about' },
	'abspeakaudiofilepath' => { 264 => 'absPeakAudioFilePath' },
	'accessorytype' => { 199 => 0x53 },
	'actionadvised' => { 76 => 0x2a },
	'activearea' => { 70 => 0xc68d },
	'actived-lighting' => { 139 => 0x22, 165 => 0x24 },
	'actived-lightingmode' => { 165 => 0x25 },
	'addaspectratioinfo' => { 47 => 0x80e },
	'additionalmodelinformation' => { 251 => 'AdditionalModelInformation' },
	'addoriginaldecisiondata' => { 47 => 0x80f, 48 => 0x11, 49 => 0x13, 52 => 0x14 },
	'address' => { 102 => 'Address' },
	'adjustmentmode' => { 229 => 0x15 },
	'adultcontentwarning' => { 254 => 'AdultContentWarning', 257 => 'adultContentWarning' },
	'advancedraw' => { 167 => 0x76a43203 },
	'advancedscenemode' => { 199 => 0x3d },
	'advisory' => { 262 => 'Advisory' },
	'ae_iso' => { 202 => 0x2 },
	'aeaperture' => { 202 => 0x1 },
	'aebautocancel' => { 47 => 0x104 },
	'aebbracketvalue' => { 42 => 0x11 },
	'aebsequence' => { 47 => 0x105 },
	'aebsequenceautocancel' => { 45 => 0x9, 46 => 0x9, 48 => 0x8, 49 => 0x9, 52 => 0x9, 53 => 0x7 },
	'aebshotcount' => { 47 => 0x106 },
	'aebxv' => { 202 => 0x4 },
	'aeexposuretime' => { 202 => 0x0 },
	'aeextra' => { 202 => 0x7 },
	'aelbutton' => { 114 => 0x45 },
	'aelexposureindicator' => { 114 => 0x51 },
	'aelock' => { 114 => 0x5b, 175 => '4.2', 177 => '4.2', 179 => 0x201, 213 => 0x48 },
	'aelockbutton' => { 174 => '16.1', 175 => '4.1', 176 => '15.1', 177 => '4.1', 178 => '17.1' },
	'aelockbuttonplusdials' => { 174 => '16.2' },
	'aelockformb-d80' => { 178 => '3.1' },
	'aemaxaperture' => { 202 => 0x9 },
	'aemaxaperture2' => { 202 => 0xa },
	'aemeteringmode' => { 202 => 0xc },
	'aemeteringsegments' => { 213 => 0x209 },
	'aemicroadjustment' => { 47 => 0x111 },
	'aeminaperture' => { 202 => 0xb },
	'aeminexposuretime' => { 202 => 0x5 },
	'aeprogrammode' => { 202 => 0x6 },
	'aesetting' => { 20 => 0x21 },
	'aexv' => { 202 => 0x3 },
	'af-cpriorityselection' => { 174 => '1.1' },
	'af-onformb-d10' => { 174 => '3.3' },
	'af-spriorityselection' => { 174 => '1.2' },
	'afactivation' => { 174 => '2.1' },
	'afadjustment' => { 213 => 0x72 },
	'afaperture' => { 137 => 0x5, 138 => 0x5 },
	'afareaheight' => { 121 => 0x1a },
	'afareaillumination' => { 114 => 0x4b, 177 => '15.3' },
	'afareamode' => { 114 => 0xe, 120 => 0x0, 121 => 0x5, 199 => 0xf, 230 => 0x11, 231 => 0x11 },
	'afareamodesetting' => { 175 => '11.1', 176 => '0.1', 177 => '16.1', 178 => '2.1' },
	'afareas' => { 179 => 0x304 },
	'afareawidth' => { 121 => 0x18 },
	'afareaxposition' => { 121 => 0x14 },
	'afareayposition' => { 121 => 0x16 },
	'afassist' => { 45 => 0x5, 53 => 0x5, 114 => 0x48, 174 => '2.5', 175 => '0.2', 176 => '0.2', 177 => '0.2', 178 => '2.3' },
	'afassistbeam' => { 47 => 0x50e, 48 => 0x4, 49 => 0x5, 50 => 0x4, 51 => 0x4, 52 => 0x5 },
	'afassistlamp' => { 199 => 0x31 },
	'afdefocus' => { 203 => 0x6 },
	'afduringliveview' => { 47 => 0x511 },
	'affinetune' => { 122 => 0x0 },
	'affinetuneadj' => { 122 => 0x2, 147 => 0x2d1, 148 => 0x2dc, 179 => 0x307 },
	'affinetuneindex' => { 122 => 0x1 },
	'afilluminator' => { 230 => 0x29, 232 => 0xb044 },
	'afimageheight' => { 121 => 0x12 },
	'afimagewidth' => { 121 => 0x10 },
	'afintegrationtime' => { 203 => 0x7 },
	'afmicroadjactive' => { 1 => 0x1 },
	'afmicroadjustment' => { 47 => 0x507 },
	'afmicroadjvalue' => { 1 => 0x2 },
	'afmode' => { 67 => 0x3009, 229 => 0x5, 232 => 0xb043 },
	'afonaelockbuttonswitch' => { 47 => 0x702 },
	'afonbutton' => { 174 => '3.1' },
	'afpoint' => { 20 => 0x13, 66 => 0x18, 120 => 0x1, 182 => 0x308, 229 => 0x1f },
	'afpointactivationarea' => { 46 => 0x11, 52 => 0x11 },
	'afpointareaexpansion' => { 47 => 0x508 },
	'afpointautoselection' => { 47 => 0x50b },
	'afpointbrightness' => { 47 => 0x50d, 174 => '2.4' },
	'afpointdisplayduringfocus' => { 47 => 0x50c },
	'afpointillumination' => { 46 => 0xa, 174 => '2.3', 178 => '2.4' },
	'afpointmode' => { 206 => 0x3 },
	'afpointposition' => { 67 => 0x2021, 199 => 0x4d },
	'afpointregistration' => { 45 => 0x7 },
	'afpoints' => { 113 => 0x10 },
	'afpointselected' => { 179 => 0x305, 213 => 0xe },
	'afpointselected2' => { 206 => 0x4 },
	'afpointselection' => { 46 => 0xb, 174 => '1.3' },
	'afpointselectionmethod' => { 47 => 0x50f, 48 => 0xc, 49 => 0xd, 52 => 0xd },
	'afpointsinfocus' => { 42 => 0xe, 120 => 0x2, 203 => 0xb, 213 => [0xf,0x3c] },
	'afpointsinfocus5d' => { 13 => 0x38 },
	'afpointspotmetering' => { 46 => 0xd },
	'afpointsunknown1' => { 203 => 0x0 },
	'afpointsunknown2' => { 203 => 0x2 },
	'afpointsused' => { 121 => 0x8 },
	'afpredictor' => { 203 => 0x4 },
	'afresponse' => { 139 => 0xad },
	'afresult' => { 184 => 0x1038 },
	'afsearch' => { 179 => 0x303 },
	'afwithshutter' => { 230 => 0x2a },
	'aggregationtype' => { 255 => 'aggregationType' },
	'agreement' => { 257 => 'agreement' },
	'aiservocontinuousshooting' => { 46 => 0x15 },
	'aiservoimagepriority' => { 47 => 0x503 },
	'aiservotrackingmethod' => { 47 => 0x504 },
	'aiservotrackingsensitivity' => { 46 => 0x14, 47 => 0x502 },
	'album' => { 264 => 'album' },
	'alreadyapplied' => { 245 => 'AlreadyApplied' },
	'alternatetitle' => { 255 => 'alternateTitle' },
	'alttapename' => { 264 => 'altTapeName' },
	'alttimecodetimeformat' => { 264 => 'altTimecodeTimeFormat' },
	'alttimecodetimevalue' => { 264 => 'altTimecodeTimeValue' },
	'alttimecodevalue' => { 264 => 'altTimecodeValue' },
	'analogbalance' => { 70 => 0xc627 },
	'angleadj' => { 65 => 0x8b },
	'anti-blur' => { 232 => 0xb04b },
	'antialiasstrength' => { 70 => 0xc632 },
	'aperturerange' => { 47 => 0x10d },
	'apertureringuse' => { 206 => '1.4' },
	'aperturevalue' => { 56 => 0x2, 70 => 0x9202, 184 => 0x1002, 249 => 'ApertureValue' },
	'applekeywords' => { 188 => 'AAPL:Keywords' },
	'applicationnotes' => { 70 => 0x2bc, 201 => 0x2bc },
	'applicationrecordversion' => { 76 => 0x0 },
	'applyshootingmeteringmode' => { 47 => 0x10e },
	'approximatefnumber' => { 194 => 0x313, 200 => 0x3406 },
	'armidentifier' => { 77 => 0x78 },
	'armversion' => { 77 => 0x7a },
	'artfilter' => { 179 => 0x529 },
	'artist' => { 70 => 0x13b, 190 => 'Artist', 260 => 'Artist', 264 => 'artist' },
	'artworkcopyrightnotice' => { 251 => 'ArtworkOrObjectAOCopyrightNotice' },
	'artworkcreator' => { 251 => 'ArtworkOrObjectAOCreator' },
	'artworkdatecreated' => { 251 => 'ArtworkOrObjectAODateCreated' },
	'artworksource' => { 251 => 'ArtworkOrObjectAOSource' },
	'artworksourceinventoryno' => { 251 => 'ArtworkOrObjectAOSourceInvNo' },
	'artworktitle' => { 251 => 'ArtworkOrObjectAOTitle' },
	'aspectframe' => { 183 => 0x1113 },
	'aspectratio' => { 183 => 0x1112, 230 => 0x55 },
	'asshoticcprofile' => { 70 => 0xc68f },
	'asshotneutral' => { 70 => 0xc628 },
	'asshotpreprofilematrix' => { 70 => 0xc690 },
	'asshotprofilename' => { 70 => 0xc6f6 },
	'asshotwhitexy' => { 70 => 0xc629 },
	'assignfuncbutton' => { 47 => 0x70b },
	'assistbuttonfunction' => { 45 => 0xd },
	'attributionname' => { 244 => 'attributionName' },
	'attributionurl' => { 244 => 'attributionURL' },
	'audio' => { 199 => 0x20 },
	'audiochanneltype' => { 264 => 'audioChannelType' },
	'audiocompression' => { 96 => 'Compression' },
	'audiocompressor' => { 264 => 'audioCompressor' },
	'audioduration' => { 76 => 0x99 },
	'audiomoddate' => { 264 => 'audioModDate' },
	'audiooutcue' => { 76 => 0x9a },
	'audiosamplerate' => { 264 => 'audioSampleRate' },
	'audiosampletype' => { 264 => 'audioSampleType' },
	'audiosamplingrate' => { 76 => 0x97 },
	'audiosamplingresolution' => { 76 => 0x98 },
	'audiotype' => { 76 => 0x96 },
	'author' => { 98 => 'Author', 188 => 'Author', 190 => 'Author', 221 => 'Author', 242 => 'author', 252 => 'Author' },
	'authorsposition' => { 253 => 'AuthorsPosition' },
	'autoaperture' => { 210 => '0.1' },
	'autobracket' => { 229 => 0x19 },
	'autobracketing' => { 74 => 0x1100, 213 => 0x18 },
	'autobracketmodem' => { 174 => '21.2' },
	'autobracketorder' => { 114 => 0x43, 174 => '21.3', 177 => '2.2', 178 => '13.2' },
	'autobracketset' => { 174 => '21.1', 176 => '11.1', 177 => '2.1', 178 => '13.1' },
	'autobrightness' => { 245 => 'AutoBrightness' },
	'autocontrast' => { 245 => 'AutoContrast' },
	'autodistortioncontrol' => { 129 => 0x4 },
	'autodynamicrange' => { 74 => 0x140b },
	'autoexposure' => { 245 => 'AutoExposure' },
	'autoexposurebracketing' => { 42 => 0x10 },
	'autofocus' => { 182 => 0x209 },
	'autofp' => { 177 => '7.3', 178 => '31.4' },
	'autoiso' => { 42 => 0x1, 67 => 0x3008, 175 => '1.1', 177 => '1.1' },
	'autoisomax' => { 175 => '1.2', 177 => '1.2' },
	'autoisominshutterspeed' => { 175 => '1.3', 177 => '1.3' },
	'autolightingoptimizer' => { 10 => 0xbe, 11 => 0xbf, 14 => 0xbf, 33 => 0x2, 47 => 0x204, 65 => 0x6f },
	'autolightingoptimizeron' => { 65 => 0x6e },
	'autoredeye' => { 167 => 0xfe28a44f },
	'autorotate' => { 42 => 0x1b },
	'autoshadows' => { 245 => 'AutoShadows' },
	'auxiliarylens' => { 139 => 0x82 },
	'avaperturesetting' => { 206 => 0x13 },
	'avsettingwithoutlens' => { 47 => 0x707 },
	'azimuth' => { 106 => 'Azimuth' },
	'babyage' => { 199 => [0x8010,0x33] },
	'backgroundalpha' => { 259 => 'bgalpha' },
	'baseexposurecompensation' => { 206 => 0x15 },
	'baseiso' => { 42 => 0x2, 60 => 0x101c, 200 => 0x312a },
	'baselineexposure' => { 70 => 0xc62a },
	'baselinenoise' => { 70 => 0xc62b },
	'baselinesharpness' => { 70 => 0xc62c },
	'baseurl' => { 262 => 'BaseURL' },
	'batteryadbodyload' => { 204 => 0x3 },
	'batteryadbodynoload' => { 204 => 0x2 },
	'batteryadgripload' => { 204 => 0x5 },
	'batteryadgripnoload' => { 204 => 0x4 },
	'batterylevel' => { 114 => 0x60 },
	'batteryorder' => { 174 => '12.5' },
	'batterystates' => { 204 => 0x1 },
	'bayergreensplit' => { 70 => 0xc62d },
	'bayerpattern' => { 80 => 0xf902, 117 => 0x17 },
	'beatspliceparamsriseindecibel' => { 264 => 'beatSpliceParamsRiseInDecibel' },
	'beatspliceparamsriseintimedurationscale' => { 264 => 'beatSpliceParamsRiseInTimeDurationScale' },
	'beatspliceparamsriseintimedurationvalue' => { 264 => 'beatSpliceParamsRiseInTimeDurationValue' },
	'beatspliceparamsusefilebeatsmarker' => { 264 => 'beatSpliceParamsUseFileBeatsMarker' },
	'beep' => { 174 => '13.1', 175 => '0.1', 176 => '2.1', 177 => '0.1', 178 => '4.1' },
	'bestqualityscale' => { 70 => 0xc65c },
	'bestshotmode' => { 67 => 0x3007 },
	'bitdepth' => { 103 => 'BitDepth', 117 => 0x11, 144 => 0x41 },
	'bitspercomponent' => { 78 => 0x87 },
	'bitspersample' => { 70 => 0x102, 260 => 'BitsPerSample' },
	'blacklevel' => { 70 => 0xc61a, 184 => 0x1012 },
	'blacklevel2' => { 183 => 0x600, 187 => 0x600 },
	'blacklevelrepeatdim' => { 70 => 0xc619 },
	'blackpoint' => { 213 => 0x200 },
	'bluebalance' => { 128 => 0x271, 184 => 0x1018, 201 => 0x12, 213 => 0x1b },
	'bluecurvelimits' => { 64 => 0x1fe },
	'bluecurvepoints' => { 64 => 0x1d4 },
	'bluehue' => { 245 => 'BlueHue' },
	'bluesaturation' => { 245 => 'BlueSaturation' },
	'blurwarning' => { 74 => 0x1300 },
	'bodyfirmware' => { 224 => 0x0 },
	'bodyfirmwareversion' => { 180 => 0x104, 181 => 0x100, 184 => 0x104 },
	'bodyserialnumber' => { 224 => 0x10 },
	'bracketmode' => { 30 => 0x3 },
	'bracketsequence' => { 67 => 0x301d },
	'bracketshotnumber' => { 30 => 0x5, 206 => 0x9 },
	'bracketstep' => { 111 => 0xe },
	'bracketvalue' => { 30 => 0x4 },
	'brightness' => { 70 => 0xfe53, 97 => 'Brightness', 111 => 0x2c, 141 => 0x34, 230 => 0x22, 245 => 'Brightness' },
	'brightnessadj' => { 64 => 0x114, 160 => 0x0, 170 => 0x2d, 235 => 0x8018 },
	'brightnessvalue' => { 70 => 0x9203, 184 => 0x1003, 249 => 'BrightnessValue' },
	'bulbduration' => { 42 => 0x18 },
	'burstmode' => { 83 => 0xa, 199 => 0x2a },
	'burstmode2' => { 83 => 0x18 },
	'burstshot' => { 229 => 0x34 },
	'buttonfunctioncontroloff' => { 47 => 0x70a },
	'bwfilter' => { 111 => 0x2a, 118 => 0x39 },
	'bwmode' => { 184 => 0x203 },
	'by-line' => { 76 => 0x50 },
	'by-linetitle' => { 76 => 0x55 },
	'bytecount' => { 255 => 'byteCount' },
	'calibration' => { 229 => 0x24 },
	'calibrationilluminant1' => { 70 => 0xc65a },
	'calibrationilluminant2' => { 70 => 0xc65b },
	'cameraangle' => { 264 => 'cameraAngle' },
	'cameracalibration1' => { 70 => 0xc623 },
	'cameracalibration2' => { 70 => 0xc624 },
	'cameracalibrationsig' => { 70 => 0xc6f3 },
	'cameracolorcalibration01' => { 22 => 0x4b, 23 => 0xa4, 24 => 0x85, 25 => 0xa8, 26 => 0xba },
	'cameracolorcalibration02' => { 22 => 0x4f, 23 => 0xa8, 24 => 0x89, 25 => 0xac, 26 => 0xbf },
	'cameracolorcalibration03' => { 22 => 0x53, 23 => 0xac, 24 => 0x8d, 25 => 0xb0, 26 => 0xc4 },
	'cameracolorcalibration04' => { 22 => 0x57, 23 => 0xb0, 24 => 0x91, 25 => 0xb4, 26 => 0xc9 },
	'cameracolorcalibration05' => { 22 => 0x5b, 23 => 0xb4, 24 => 0x95, 25 => 0xb8, 26 => 0xce },
	'cameracolorcalibration06' => { 22 => 0x5f, 23 => 0xb8, 24 => 0x99, 25 => 0xbc, 26 => 0xd3 },
	'cameracolorcalibration07' => { 22 => 0x63, 23 => 0xbc, 24 => 0x9d, 25 => 0xc0, 26 => 0xd8 },
	'cameracolorcalibration08' => { 22 => 0x67, 23 => 0xc0, 24 => 0xa1, 25 => 0xc4, 26 => 0xdd },
	'cameracolorcalibration09' => { 22 => 0x6b, 23 => 0xc4, 24 => 0xa5, 25 => 0xc8, 26 => 0xe2 },
	'cameracolorcalibration10' => { 22 => 0x6f, 23 => 0xc8, 24 => 0xa9, 25 => 0xcc, 26 => 0xe7 },
	'cameracolorcalibration11' => { 22 => 0x73, 23 => 0xcc, 24 => 0xad, 25 => 0xd0, 26 => 0xec },
	'cameracolorcalibration12' => { 22 => 0x77, 23 => 0xd0, 24 => 0xb1, 25 => 0xd4, 26 => 0xf1 },
	'cameracolorcalibration13' => { 22 => 0x7b, 23 => 0xd4, 24 => 0xb5, 25 => 0xd8, 26 => 0xf6 },
	'cameracolorcalibration14' => { 22 => 0x7f, 23 => 0xd8, 24 => 0xb9, 25 => 0xdc, 26 => 0xfb },
	'cameracolorcalibration15' => { 22 => 0x83, 23 => 0xdc, 24 => 0xbd, 25 => 0xe0, 26 => 0x100 },
	'cameraid' => { 184 => 0x209, 228 => 0x209 },
	'cameraiso' => { 20 => 0x10 },
	'cameralabel' => { 264 => 'cameraLabel' },
	'cameramodel' => { 264 => 'cameraModel' },
	'cameramove' => { 264 => 'cameraMove' },
	'cameraorientation' => { 2 => 0x30, 5 => 0x30, 7 => 0x35, 8 => 0x30, 9 => 0x30, 10 => 0x31, 11 => 0x31, 12 => 0x35, 13 => 0x27, 14 => 0x31, 16 => 0x11 },
	'cameraowner' => { 84 => 0xc353 },
	'cameraparameters' => { 184 => 0x2050 },
	'cameraprofile' => { 245 => 'CameraProfile' },
	'cameraprofiledigest' => { 245 => 'CameraProfileDigest' },
	'cameraserialnumber' => { 70 => 0xc62f, 241 => 'CameraSerialNumber' },
	'camerasettingsversion' => { 179 => 0x0 },
	'cameratemperature' => { 2 => 0x18, 5 => 0x18, 7 => 0x19, 8 => 0x18, 9 => 0x18, 10 => 0x19, 11 => 0x19, 12 => 0x19, 13 => 0x17, 14 => 0x19, 15 => 0x19, 17 => [0x87,0x91], 18 => [0x99,0x9f,0xa4,0xa8], 19 => [0x64,0x47,0x53,0x5b,0x5c], 42 => 0xc, 194 => 0x320, 200 => 0x3402, 213 => 0x47, 227 => 0x43 },
	'cameratype' => { 42 => 0x1a, 184 => 0x207 },
	'cameratype2' => { 180 => 0x100 },
	'canonexposuremode' => { 20 => 0x14 },
	'canonfiledescription' => { 60 => 0x805 },
	'canonfilelength' => { 34 => 0xe },
	'canonfirmwareversion' => { 34 => 0x7, 60 => 0x80b },
	'canonflashinfo' => { 60 => 0x1028 },
	'canonflashmode' => { 20 => 0x4 },
	'canonimagesize' => { 4 => 0x39, 20 => 0xa },
	'canonimagetype' => { 34 => 0x6, 60 => 0x815 },
	'canonmodelid' => { 34 => 0x10, 60 => 0x1834 },
	'canonvrd' => { 71 => 'CanonVRD' },
	'caption' => { 242 => 'caption' },
	'caption-abstract' => { 76 => 0x78 },
	'captionsauthornames' => { 248 => 'CaptionsAuthorNames' },
	'captionsdatetimestamps' => { 248 => 'CaptionsDateTimeStamps' },
	'captionwriter' => { 253 => 'CaptionWriter' },
	'captureframerate' => { 67 => 0x4001 },
	'cardshutterlock' => { 114 => 0x49 },
	'casioimagesize' => { 67 => 0x9 },
	'catalogsets' => { 76 => 0xff, 240 => 'CatalogSets' },
	'categories' => { 34 => 0x23, 242 => 'categories' },
	'category' => { 76 => 0xf, 253 => 'Category' },
	'ccdboardversion' => { 194 => 0x331 },
	'ccdscanmode' => { 184 => 0x1039 },
	'ccdsensitivity' => { 157 => 0x6 },
	'ccdversion' => { 194 => 0x330 },
	'celllength' => { 70 => 0x109 },
	'cellwidth' => { 70 => 0x108 },
	'centerafarea' => { 177 => '15.1' },
	'centerfocuspoint' => { 178 => '2.2' },
	'centerweightedareasize' => { 174 => '7.1', 177 => '6.3', 178 => '8.1' },
	'certificate' => { 268 => 'Certificate' },
	'cfapattern' => { 70 => 0xa302 },
	'cfapatterncolumns' => { 249 => 'CFAPatternColumns' },
	'cfapatternrows' => { 249 => 'CFAPatternRows' },
	'cfapatternvalues' => { 249 => 'CFAPatternValues' },
	'channel' => { 255 => 'channel' },
	'channels' => { 96 => 'Channels' },
	'checkmark' => { 64 => 0x26a },
	'childfontfiles' => { 269 => 'FontsChildFontFiles' },
	'chmodeshootingspeed' => { 174 => '10.3' },
	'chromablurradius' => { 70 => 0xc631 },
	'chromaticaberration' => { 65 => 0x66 },
	'chromaticaberrationb' => { 245 => 'ChromaticAberrationB' },
	'chromaticaberrationblue' => { 65 => 0x6b },
	'chromaticaberrationon' => { 65 => 0x62 },
	'chromaticaberrationr' => { 245 => 'ChromaticAberrationR' },
	'chromaticaberrationred' => { 65 => 0x6a },
	'chrominancenoisereduction' => { 65 => 0x5e },
	'chrominancenr_tiff_jpeg' => { 65 => 0x60 },
	'city' => { 76 => 0x5a, 102 => 'City', 199 => 0x6d, 253 => 'City' },
	'clarity' => { 245 => 'Clarity' },
	'classifystate' => { 76 => 0xe1 },
	'client' => { 264 => 'client' },
	'clmodeshootingspeed' => { 174 => '10.2', 178 => '11.1' },
	'cmcontrast' => { 187 => 0x2022 },
	'cmexposurecompensation' => { 187 => 0x2000 },
	'cmhue' => { 187 => 0x2021 },
	'cmsaturation' => { 187 => 0x2020 },
	'cmsharpness' => { 187 => 0x2023 },
	'cmwhitebalance' => { 187 => 0x2001 },
	'cmwhitebalancecomp' => { 187 => 0x2002 },
	'cmwhitebalancegraypoint' => { 187 => 0x2010 },
	'codec' => { 110 => 'Codec' },
	'codedcharacterset' => { 77 => 0x5a },
	'coloraberrationcontrol' => { 167 => 0xc89224b },
	'coloradjustment' => { 229 => 0x14 },
	'coloradjustmentmode' => { 228 => 0x210 },
	'coloranta' => { 269 => 'ColorantsA' },
	'colorantb' => { 269 => 'ColorantsB' },
	'colorantblack' => { 269 => 'ColorantsBlack' },
	'colorantblue' => { 269 => 'ColorantsBlue' },
	'colorantcyan' => { 269 => 'ColorantsCyan' },
	'colorantgreen' => { 269 => 'ColorantsGreen' },
	'colorantl' => { 269 => 'ColorantsL' },
	'colorantmagenta' => { 269 => 'ColorantsMagenta' },
	'colorantmode' => { 269 => 'ColorantsMode' },
	'colorantred' => { 269 => 'ColorantsRed' },
	'colorantswatchname' => { 269 => 'ColorantsSwatchName' },
	'coloranttype' => { 269 => 'ColorantsType' },
	'colorantyellow' => { 269 => 'ColorantsYellow' },
	'colorbalance' => { 97 => 'ColorBalance' },
	'colorbalanceadj' => { 167 => 0x76a43202 },
	'colorbalanceblue' => { 111 => 0x1e },
	'colorbalancegreen' => { 111 => 0x1d },
	'colorbalancered' => { 111 => 0x1c },
	'colorblur' => { 65 => 0x65 },
	'colorbooster' => { 167 => 0x5f0e7d23 },
	'colorboostlevel' => { 161 => 0x1 },
	'colorboosttype' => { 161 => 0x0 },
	'colorclass' => { 216 => 0xde },
	'colorcompensationfilter' => { 114 => [0x3a,0x5f], 115 => 0x111, 232 => 0xb022 },
	'colorcontrol' => { 184 => 0x102b },
	'colorcorrection' => { 235 => 0x8015 },
	'colordataversion' => { 24 => 0x0, 25 => 0x0 },
	'coloreffect' => { 199 => 0x28 },
	'colorfilter' => { 66 => 0x17, 67 => 0x3017, 111 => 0x29, 118 => [0x38,0x4d,0x4f], 215 => 0x17 },
	'colorgain' => { 144 => 0x51 },
	'colorhue' => { 139 => 0x8d },
	'colorimetricreference' => { 70 => 0xc6bf },
	'colormatrix' => { 183 => 0x200, 184 => 0x1011 },
	'colormatrix1' => { 70 => 0xc621 },
	'colormatrix2' => { 70 => 0xc622, 187 => 0x200 },
	'colormatrixa' => { 213 => 0x203 },
	'colormatrixb' => { 213 => 0x204 },
	'colormatrixnumber' => { 184 => 0x1019 },
	'colormode' => { 67 => 0x3015, 74 => 0x1210, 83 => 0x66, 111 => 0x28, 114 => 0x16, 115 => 0x101, 118 => 0x7, 139 => 0x3, 157 => 0x4, 199 => 0x32, 229 => 0x2c, 232 => 0xb029, 253 => 'ColorMode' },
	'colormoirereduction' => { 168 => 0x15 },
	'colormoirereductionmode' => { 168 => 0x5 },
	'colornoisereduction' => { 235 => 0x8029, 245 => 'ColorNoiseReduction' },
	'colornoisereductionintensity' => { 168 => 0x18 },
	'colornoisereductionsharpness' => { 168 => 0x1c },
	'colorplanes' => { 73 => 0x2 },
	'colorprofile' => { 111 => 0x33 },
	'colorrepresentation' => { 78 => 0x3c },
	'colorreproduction' => { 232 => 0xb020 },
	'colorsequence' => { 78 => 0x41 },
	'colorspace' => { 27 => 0x3, 34 => 0xb4, 60 => 0x10b4, 70 => 0xa001, 103 => 'ColorSpace', 112 => 0x2f, 113 => 0x25, 114 => 0x17, 139 => 0x1e, 179 => 0x507, 213 => 0x37, 229 => 0xb, 249 => 'ColorSpace' },
	'colortempasshot' => { 22 => 0x1d, 23 => 0x26, 24 => 0x43, 25 => 0x43, 26 => 0x4b },
	'colortempauto' => { 22 => 0x22, 23 => 0x1c, 24 => 0x48, 25 => 0x48, 26 => 0x50 },
	'colortempcloudy' => { 22 => 0x31, 23 => 0x35, 24 => 0x5c, 25 => 0x61, 26 => 0x69 },
	'colortempcustom' => { 24 => 0x84 },
	'colortempcustom1' => { 22 => 0x45 },
	'colortempcustom2' => { 22 => 0x4a },
	'colortempdaylight' => { 22 => 0x27, 23 => 0x2b, 24 => 0x52, 25 => 0x57, 26 => 0x5f },
	'colortemperature' => { 2 => 0x73, 3 => [0x48,0x4e], 4 => 0x37, 5 => 0x62, 6 => 0x37, 8 => 0x73, 9 => 0x73, 10 => 0x77, 11 => 0x73, 12 => 0x7c, 13 => 0x58, 14 => 0x73, 16 => 0x57, 34 => 0xae, 40 => 0x9, 60 => 0x10ae, 74 => 0x1005, 81 => 0x846, 97 => 'ColorTemperature', 112 => [0x6e,0x49], 113 => 0x3f, 114 => [0x39,0x5e], 115 => 0x10b, 118 => [0x3c,0x4c,0x4e], 194 => 0x321, 213 => 0x50, 232 => 0xb021 },
	'colortemperatureadj' => { 235 => 0x8013 },
	'colortemperaturebg' => { 184 => 0x1013 },
	'colortemperaturerg' => { 184 => 0x1014 },
	'colortemperaturesetting' => { 114 => 0x25 },
	'colortempflash' => { 22 => 0x40, 23 => 0x49, 24 => 0x70, 25 => 0x75, 26 => 0x7d },
	'colortempflashdata' => { 24 => 0x24a },
	'colortempfluorescent' => { 22 => 0x3b, 23 => 0x3f, 24 => 0x66, 25 => 0x6b, 26 => 0x73 },
	'colortempkelvin' => { 23 => 0x44, 24 => 0x6b, 25 => 0x70, 26 => 0x78 },
	'colortempmeasured' => { 24 => 0x4d, 25 => 0x4d, 26 => 0x55 },
	'colortemppc1' => { 23 => 0x94, 24 => 0x75 },
	'colortemppc2' => { 23 => 0x99, 24 => 0x7a },
	'colortemppc3' => { 23 => 0x9e, 24 => 0x7f },
	'colortempshade' => { 22 => 0x2c, 23 => 0x30, 24 => 0x57, 25 => 0x5c, 26 => 0x64 },
	'colortemptungsten' => { 22 => 0x36, 23 => 0x3a, 24 => 0x61, 25 => 0x66, 26 => 0x6e },
	'colortempunknown' => { 23 => 0x21, 25 => 0x52, 26 => 0x5a },
	'colortempunknown10' => { 23 => 0x76, 25 => 0xa2, 26 => 0xaa },
	'colortempunknown11' => { 23 => 0x7b, 25 => 0xa7, 26 => 0xaf },
	'colortempunknown12' => { 23 => 0x80, 26 => 0xb4 },
	'colortempunknown13' => { 23 => 0x85, 26 => 0xb9 },
	'colortempunknown14' => { 23 => 0x8a },
	'colortempunknown15' => { 23 => 0x8f },
	'colortempunknown16' => { 23 => 0xa3 },
	'colortempunknown2' => { 23 => 0x4e, 25 => 0x7a, 26 => 0x82 },
	'colortempunknown3' => { 23 => 0x53, 25 => 0x7f, 26 => 0x87 },
	'colortempunknown4' => { 23 => 0x58, 25 => 0x84, 26 => 0x8c },
	'colortempunknown5' => { 23 => 0x5d, 25 => 0x89, 26 => 0x91 },
	'colortempunknown6' => { 23 => 0x62, 25 => 0x8e, 26 => 0x96 },
	'colortempunknown7' => { 23 => 0x67, 25 => 0x93, 26 => 0x9b },
	'colortempunknown8' => { 23 => 0x6c, 25 => 0x98, 26 => 0xa0 },
	'colortempunknown9' => { 23 => 0x71, 25 => 0x9d, 26 => 0xa5 },
	'colortone' => { 4 => 0x6f, 6 => 0x77, 20 => 0x2a, 27 => 0x2 },
	'colortoneadj' => { 64 => 0x11e },
	'colortonefaithful' => { 13 => 0x107 },
	'colortonelandscape' => { 13 => 0x105 },
	'colortoneneutral' => { 13 => 0x106 },
	'colortoneportrait' => { 13 => 0x104 },
	'colortonestandard' => { 13 => 0x103 },
	'colortoneuserdef1' => { 13 => 0x109 },
	'colortoneuserdef2' => { 13 => 0x10a },
	'colortoneuserdef3' => { 13 => 0x10b },
	'commanddials' => { 177 => '5.1' },
	'commanddialsaperturesetting' => { 174 => '17.3' },
	'commanddialschangemainsub' => { 174 => '17.2' },
	'commanddialsmenuandplayback' => { 174 => '17.4' },
	'commanddialsreverserotation' => { 174 => '17.1', 176 => '16.2', 178 => '18.1' },
	'commanderchannel' => { 177 => '10.2' },
	'commandergroupa_manualoutput' => { 177 => '13.2' },
	'commandergroupa_ttl-aacomp' => { 177 => '13.1' },
	'commandergroupa_ttlcomp' => { 178 => '32.1' },
	'commandergroupamode' => { 177 => '11.2' },
	'commandergroupb_manualoutput' => { 177 => '14.2' },
	'commandergroupb_ttl-aacomp' => { 177 => '14.1' },
	'commandergroupb_ttlcomp' => { 178 => '33.1' },
	'commandergroupbmode' => { 177 => '11.3' },
	'commanderinternalflash' => { 177 => '11.1' },
	'commanderinternalmanualoutput' => { 177 => '12.2' },
	'commanderinternalttlcomp' => { 177 => '12.1', 178 => '31.2' },
	'comment' => { 0 => 0x2, 71 => 'Comment', 98 => 'Comment', 190 => 'Comment' },
	'complianceprofile' => { 255 => 'complianceProfile' },
	'componentsconfiguration' => { 70 => 0x9101, 103 => 'Components', 249 => 'ComponentsConfiguration' },
	'componentversion' => { 60 => 0x80c },
	'composer' => { 264 => 'composer' },
	'compressedbitsperpixel' => { 70 => 0x9102, 249 => 'CompressedBitsPerPixel' },
	'compressedimagesize' => { 115 => 0x40, 184 => 0x40 },
	'compression' => { 70 => 0x103, 260 => 'Compression' },
	'compressionfactor' => { 179 => 0x50d },
	'compressionratio' => { 103 => 'Compression', 184 => 0x1034 },
	'constrainedcropheight' => { 64 => 0x266, 216 => 0xd6 },
	'constrainedcropwidth' => { 64 => 0x262, 216 => 0xd5 },
	'contact' => { 76 => 0x76 },
	'contentlocationcode' => { 76 => 0x1a },
	'contentlocationname' => { 76 => 0x1b },
	'continuousbracketing' => { 114 => 0x20 },
	'continuousdrive' => { 20 => 0x5 },
	'continuousshootingspeed' => { 47 => 0x610 },
	'continuousshotlimit' => { 47 => 0x611 },
	'contrast' => { 4 => 0x73, 6 => 0x75, 20 => 0xd, 66 => 0xc, 67 => [0x3012,0x20], 70 => [0xa408,0xfe54], 74 => [0x1004,0x1006], 97 => 'Contrast', 111 => 0x20, 112 => 0x31, 113 => 0x27, 114 => 0x19, 118 => 0x2, 141 => 0x33, 184 => 0x1029, 199 => 0x39, 200 => 0x300a, 213 => 0x20, 215 => 0xc, 229 => 0xd, 230 => 0x1d, 231 => 0x1a, 232 => 0x2004, 245 => 'Contrast', 249 => 'Contrast' },
	'contrastadj' => { 64 => 0x115, 170 => 0x2c, 235 => 0x8017 },
	'contrastdetectaf' => { 121 => 0x4 },
	'contrastdetectafinfocus' => { 121 => 0x1c },
	'contrastfaithful' => { 13 => 0xec },
	'contrastlandscape' => { 13 => 0xea },
	'contrastmode' => { 199 => 0x2c },
	'contrastmonochrome' => { 13 => 0xed },
	'contrastneutral' => { 13 => 0xeb },
	'contrastportrait' => { 13 => 0xe9 },
	'contrastsetting' => { 179 => 0x505, 187 => 0x1012 },
	'contraststandard' => { 13 => 0xe8 },
	'contrastuserdef1' => { 13 => 0xee },
	'contrastuserdef2' => { 13 => 0xef },
	'contrastuserdef3' => { 13 => 0xf0 },
	'contributedmediadurationscale' => { 264 => 'contributedMediaDurationScale' },
	'contributedmediadurationvalue' => { 264 => 'contributedMediaDurationValue' },
	'contributedmediamanaged' => { 264 => 'contributedMediaManaged' },
	'contributedmediapath' => { 264 => 'contributedMediaPath' },
	'contributedmediastarttimescale' => { 264 => 'contributedMediaStartTimeScale' },
	'contributedmediastarttimevalue' => { 264 => 'contributedMediaStartTimeValue' },
	'contributedmediatrack' => { 264 => 'contributedMediaTrack' },
	'contributedmediawebstatement' => { 264 => 'contributedMediaWebStatement' },
	'contributor' => { 246 => 'contributor' },
	'contributors' => { 98 => 'Contributors' },
	'controldialset' => { 114 => 0x46 },
	'controlledvocabularyterm' => { 251 => 'CVterm' },
	'controllerboardversion' => { 194 => 0x332 },
	'controlmode' => { 42 => 0x12 },
	'conversionlens' => { 199 => 0x35 },
	'converter' => { 70 => 0xfe4d, 157 => 0xb, 245 => 'Converter' },
	'converttograyscale' => { 245 => 'ConvertToGrayscale' },
	'copyright' => { 0 => 0x3, 70 => 0x8298, 98 => 'Copyright', 190 => 'Copyright', 221 => 'Copyright', 252 => 'Copyright', 255 => 'copyright', 257 => 'copyright', 260 => 'Copyright', 264 => 'copyright' },
	'copyrightflag' => { 219 => 0x40a },
	'copyrightnotice' => { 76 => 0x74 },
	'copyrightownerid' => { 254 => 'CopyrightOwnerCopyrightOwnerID' },
	'copyrightownerimageid' => { 254 => 'CopyrightOwnerImageID' },
	'copyrightownername' => { 254 => 'CopyrightOwnerCopyrightOwnerName' },
	'copyrightregistrationnumber' => { 254 => 'CopyrightRegistrationNumber' },
	'copyrightstatus' => { 254 => 'CopyrightStatus' },
	'coringfilter' => { 183 => 0x310, 184 => 0x102d, 187 => 0x310 },
	'coringvalues' => { 183 => 0x311, 187 => 0x311 },
	'corporateentity' => { 255 => 'corporateEntity' },
	'country' => { 102 => 'Country', 199 => 0x69, 253 => 'Country' },
	'country-primarylocationcode' => { 76 => 0x64 },
	'country-primarylocationname' => { 76 => 0x65 },
	'countrycode' => { 217 => 'CountryCode', 250 => 'CountryCode' },
	'coverage' => { 246 => 'coverage' },
	'coverdate' => { 255 => 'coverDate' },
	'coverdisplaydate' => { 255 => 'coverDisplayDate' },
	'cpufirmwareversion' => { 213 => 0x28 },
	'crc32' => { 247 => 'crc32' },
	'createdate' => { 70 => 0x9004, 98 => 'CreateDate', 188 => 'CreationDate', 190 => 'create-date', 221 => 'CreationDate', 262 => 'CreateDate' },
	'creationdate' => { 252 => 'CreationDate', 255 => 'creationDate' },
	'creationtime' => { 190 => 'Creation Time' },
	'creativestyle' => { 230 => 0x1a, 231 => 0x18 },
	'creativestylewaschanged' => { 235 => 0x8001 },
	'creator' => { 188 => 'Creator', 221 => 'Creator', 246 => 'creator', 252 => 'Creator' },
	'creatoraddress' => { 250 => 'CreatorContactInfoCiAdrExtadr' },
	'creatorcity' => { 250 => 'CreatorContactInfoCiAdrCity' },
	'creatorcountry' => { 250 => 'CreatorContactInfoCiAdrCtry' },
	'creatorpostalcode' => { 250 => 'CreatorContactInfoCiAdrPcode' },
	'creatorregion' => { 250 => 'CreatorContactInfoCiAdrRegion' },
	'creatortool' => { 262 => 'CreatorTool' },
	'creatorworkemail' => { 250 => 'CreatorContactInfoCiEmailWork' },
	'creatorworktelephone' => { 250 => 'CreatorContactInfoCiTelWork' },
	'creatorworkurl' => { 250 => 'CreatorContactInfoCiUrlWork' },
	'credit' => { 76 => 0x6e, 253 => 'Credit' },
	'creditline' => { 257 => 'creditLine' },
	'creditlinereq' => { 267 => 'CreditLineReq' },
	'creditlinerequired' => { 254 => 'CreditLineRequired' },
	'cropactive' => { 64 => 0x244 },
	'cropangle' => { 245 => 'CropAngle' },
	'cropaspectratio' => { 64 => 0x260 },
	'cropbottom' => { 73 => 0x9, 162 => 0x36, 216 => 0xdc, 245 => 'CropBottom' },
	'cropheight' => { 64 => 0x24c, 183 => 0x615, 187 => 0x615, 245 => 'CropHeight' },
	'crophispeed' => { 139 => 0x1b },
	'cropleft' => { 64 => 0x246, 73 => 0x6, 162 => 0x1e, 183 => 0x612, 187 => 0x612, 216 => 0xd9, 245 => 'CropLeft' },
	'cropoutputheight' => { 162 => 0xce },
	'cropoutputheightinches' => { 162 => 0x96 },
	'cropoutputpixels' => { 162 => 0xd6 },
	'cropoutputresolution' => { 162 => 0xb6 },
	'cropoutputscale' => { 162 => 0xbe },
	'cropoutputwidth' => { 162 => 0xc6 },
	'cropoutputwidthinches' => { 162 => 0x8e },
	'cropright' => { 73 => 0x8, 162 => 0x2e, 216 => 0xdb, 245 => 'CropRight' },
	'croprotation' => { 73 => 0xb },
	'cropscaledresolution' => { 162 => 0x9e },
	'cropsourceresolution' => { 162 => 0xae },
	'croptop' => { 64 => 0x248, 73 => 0x7, 162 => 0x26, 183 => 0x613, 187 => 0x613, 216 => 0xda, 245 => 'CropTop' },
	'cropunit' => { 245 => 'CropUnit' },
	'cropunits' => { 245 => 'CropUnits' },
	'cropwidth' => { 64 => 0x24a, 183 => 0x614, 187 => 0x614, 245 => 'CropWidth' },
	'currenticcprofile' => { 70 => 0xc691 },
	'currentpreprofilematrix' => { 70 => 0xc692 },
	'currentversion' => { 235 => 0xd000 },
	'curves' => { 167 => 0x76a43201 },
	'custom1' => { 254 => 'Custom1' },
	'custom10' => { 254 => 'Custom10' },
	'custom2' => { 254 => 'Custom2' },
	'custom3' => { 254 => 'Custom3' },
	'custom4' => { 254 => 'Custom4' },
	'custom5' => { 254 => 'Custom5' },
	'custom6' => { 254 => 'Custom6' },
	'custom7' => { 254 => 'Custom7' },
	'custom8' => { 254 => 'Custom8' },
	'custom9' => { 254 => 'Custom9' },
	'customcontrast' => { 65 => 0x4e },
	'customcontrols' => { 47 => 0x70c },
	'customlinear' => { 65 => 0x4f },
	'customoutputhighlightpoint' => { 65 => 0x53 },
	'customoutputshadowpoint' => { 65 => 0x54 },
	'customrawhighlight' => { 65 => 0x7c },
	'customrawhighlightpoint' => { 65 => 0x51 },
	'customrawshadow' => { 65 => 0x85 },
	'customrawshadowpoint' => { 65 => 0x52 },
	'customrendered' => { 70 => 0xa401, 249 => 'CustomRendered' },
	'customsaturation' => { 179 => 0x503 },
	'customsettingsalldefault' => { 174 => '0.2' },
	'customsettingsbank' => { 174 => '0.1' },
	'customsharpness' => { 65 => 0x50 },
	'customwbbluelevel' => { 114 => 0x36 },
	'customwberror' => { 114 => 0x37 },
	'customwbgreenlevel' => { 114 => 0x35 },
	'customwbredlevel' => { 114 => 0x34 },
	'customwbsetting' => { 114 => 0x26 },
	'd-lightinghq' => { 167 => 0x2175eb78 },
	'd-lightinghqcolorboost' => { 163 => 0x2 },
	'd-lightinghqhighlight' => { 163 => 0x1 },
	'd-lightinghqselected' => { 167 => 0x6a6e36b6 },
	'd-lightinghqshadow' => { 163 => 0x0 },
	'd-lightinghs' => { 167 => 0xce5554aa },
	'd-lightinghsadjustment' => { 164 => 0x0 },
	'd-lightinghscolorboost' => { 164 => 0x1 },
	'd-rangeoptimizerhighlight' => { 235 => 0x8024 },
	'd-rangeoptimizermode' => { 235 => 0x8022 },
	'd-rangeoptimizershadow' => { 235 => 0x802d },
	'd-rangeoptimizervalue' => { 235 => 0x8023 },
	'datacompressionmethod' => { 78 => 0x6e },
	'dataimprint' => { 111 => 0x34 },
	'date' => { 213 => 0x6, 246 => 'date' },
	'dateacquired' => { 241 => 'DateAcquired' },
	'datecreated' => { 76 => 0x37, 253 => 'DateCreated' },
	'datedisplayformat' => { 159 => 0x3 },
	'dateimprint' => { 176 => '4.2' },
	'daterecieved' => { 255 => 'dateRecieved' },
	'datesent' => { 77 => 0x46 },
	'datestampmode' => { 34 => 0x1c },
	'datetime' => { 242 => 'datetime', 260 => 'DateTime' },
	'datetimedigitized' => { 249 => 'DateTimeDigitized' },
	'datetimeoriginal' => { 63 => 0x0, 70 => 0x9003, 95 => 0x14, 98 => 'OriginalDate', 249 => 'DateTimeOriginal' },
	'datetimestamp' => { 83 => 0x64 },
	'daylightsavings' => { 159 => 0x2 },
	'declination' => { 106 => 'Declination' },
	'decposition' => { 111 => 0x32 },
	'defaultcroporigin' => { 70 => 0xc61f },
	'defaultcropsize' => { 70 => 0xc620 },
	'defaultscale' => { 70 => 0xc61e },
	'defringe' => { 245 => 'Defringe' },
	'deletedimagecount' => { 139 => 0xa6, 145 => 0x6e },
	'derivedfromalternatepaths' => { 265 => 'DerivedFromAlternatePaths' },
	'derivedfromdocumentid' => { 265 => 'DerivedFromDocumentID' },
	'derivedfromfilepath' => { 265 => 'DerivedFromFilePath' },
	'derivedfromfrompart' => { 265 => 'DerivedFromFromPart' },
	'derivedfrominstanceid' => { 265 => 'DerivedFromInstanceID' },
	'derivedfromlastmodifydate' => { 265 => 'DerivedFromLastModifyDate' },
	'derivedfrommanager' => { 265 => 'DerivedFromManager' },
	'derivedfrommanagervariant' => { 265 => 'DerivedFromManagerVariant' },
	'derivedfrommanageto' => { 265 => 'DerivedFromManageTo' },
	'derivedfrommanageui' => { 265 => 'DerivedFromManageUI' },
	'derivedfrommaskmarkers' => { 265 => 'DerivedFromMaskMarkers' },
	'derivedfromoriginaldocumentid' => { 265 => 'DerivedFromOriginalDocumentID' },
	'derivedfrompartmapping' => { 265 => 'DerivedFromPartMapping' },
	'derivedfromrenditionclass' => { 265 => 'DerivedFromRenditionClass' },
	'derivedfromrenditionparams' => { 265 => 'DerivedFromRenditionParams' },
	'derivedfromtopart' => { 265 => 'DerivedFromToPart' },
	'derivedfromversionid' => { 265 => 'DerivedFromVersionID' },
	'description' => { 190 => 'Description', 246 => 'description' },
	'destination' => { 77 => 0x5 },
	'destinationcity' => { 213 => 0x24 },
	'destinationcitycode' => { 215 => 0x1001 },
	'destinationdst' => { 213 => 0x26 },
	'developmentdynamicrange' => { 74 => 0x1403 },
	'devicesettingdescriptioncolumns' => { 249 => 'DeviceSettingDescriptionColumns' },
	'devicesettingdescriptionrows' => { 249 => 'DeviceSettingDescriptionRows' },
	'devicesettingdescriptionsettings' => { 249 => 'DeviceSettingDescriptionSettings' },
	'dialdirectiontvav' => { 47 => 0x706 },
	'digitalcreationdate' => { 76 => 0x3e },
	'digitalcreationtime' => { 76 => 0x3f },
	'digitaldeehighlightadj' => { 144 => 0x202 },
	'digitaldeeshadowadj' => { 144 => 0x200 },
	'digitaldeethreshold' => { 144 => 0x201 },
	'digitalgain' => { 40 => 0xb },
	'digitalgem' => { 134 => 0x0 },
	'digitalice' => { 144 => 0x100 },
	'digitalimageguid' => { 251 => 'DigImageGUID' },
	'digitalroc' => { 143 => 0x0 },
	'digitalsourcefiletype' => { 251 => 'DigitalSourcefileType' },
	'digitalsourcetype' => { 251 => 'DigitalSourceType' },
	'digitalzoom' => { 20 => 0xc, 66 => 0xa, 83 => 0x68, 97 => 'DigitalZoom', 111 => 0xc, 139 => 0x86, 157 => 0xa, 184 => 0x204, 213 => 0x1e, 215 => 0xa, 228 => 0x204 },
	'digitalzoomon' => { 228 => 0x21b },
	'digitalzoomratio' => { 70 => 0xa404, 249 => 'DigitalZoomRatio' },
	'director' => { 264 => 'director' },
	'directorphotography' => { 264 => 'directorPhotography' },
	'directory' => { 71 => 'Directory' },
	'directoryindex' => { 2 => 0x137, 5 => 0x17e, 8 => 0x13f, 9 => 0x133, 10 => 0x1df, 11 => [0x1a3,0x1a7], 12 => 0x1f0, 14 => [0x1a3,0x1c7], 16 => 0x1d3 },
	'directorynumber' => { 130 => 0x6 },
	'disclaimer' => { 190 => 'Disclaimer' },
	'displayallafpoints' => { 47 => 0x514 },
	'displayaperture' => { 20 => 0x23 },
	'displayedunitsx' => { 220 => 0x2 },
	'displayedunitsy' => { 220 => 0x6 },
	'distance1' => { 83 => 0x28 },
	'distance2' => { 83 => 0x2c },
	'distance3' => { 83 => 0x30 },
	'distance4' => { 83 => 0x34 },
	'distortioncontrol' => { 145 => 0x10 },
	'distortioncorrection' => { 65 => 0x67, 179 => 0x50b },
	'distortioncorrection2' => { 183 => 0x1011 },
	'distortioncorrectionon' => { 65 => 0x63 },
	'distributor' => { 255 => 'distributor' },
	'dmcomment' => { 264 => 'comment' },
	'dngbackwardversion' => { 70 => 0xc613 },
	'dnglensinfo' => { 70 => 0xc630 },
	'dngversion' => { 70 => 0xc612 },
	'document' => { 190 => 'Document' },
	'documentancestorid' => { 253 => 'DocumentAncestorsAncestorID' },
	'documenthistory' => { 76 => 0xe7 },
	'documentid' => { 265 => 'DocumentID' },
	'documentname' => { 70 => 0x10d },
	'documentnotes' => { 76 => 0xe6 },
	'doi' => { 255 => 'doi' },
	'dotrange' => { 70 => 0x150 },
	'drivemode' => { 67 => 0x3103, 111 => 0x6, 114 => 0x1e, 179 => 0x600, 213 => 0x34, 229 => 0x3, 230 => 0x4 },
	'drivemode2' => { 114 => 0xa, 206 => 0x7 },
	'dspfirmwareversion' => { 213 => 0x27 },
	'duration' => { 96 => 'Duration', 110 => 'Duration' },
	'durationscale' => { 264 => 'durationScale' },
	'durationvalue' => { 264 => 'durationValue' },
	'dustremovaldata' => { 34 => 0x97 },
	'dynamicafarea' => { 174 => '1.4' },
	'dynamicrange' => { 74 => 0x1400 },
	'dynamicrangeexpansion' => { 213 => 0x69 },
	'dynamicrangemax' => { 64 => 0x7c },
	'dynamicrangemin' => { 64 => 0x7a },
	'dynamicrangeoptimizer' => { 114 => 0x15, 232 => [0xb025,0xb04f] },
	'dynamicrangeoptimizerlevel' => { 230 => 0x19, 231 => 0x17 },
	'dynamicrangeoptimizermode' => { 230 => 0x18, 231 => 0x16 },
	'dynamicrangeoptimizersetting' => { 114 => 0x27 },
	'dynamicrangesetting' => { 74 => 0x1402 },
	'e-dialinprogram' => { 206 => '1.3' },
	'easyexposurecomp' => { 178 => '6.1' },
	'easyexposurecompensation' => { 174 => '6.4' },
	'easymode' => { 20 => 0xb },
	'edgenoisereduction' => { 168 => 0x4, 235 => 0x8028 },
	'edition' => { 255 => 'edition' },
	'editorialupdate' => { 76 => 0x8 },
	'editstatus' => { 76 => 0x7, 217 => 'EditStatus' },
	'effectivelv' => { 213 => 0x2d },
	'effectivemaxaperture' => { 137 => 0x12, 138 => 0x13 },
	'eissn' => { 255 => 'eIssn' },
	'elevation' => { 106 => 'Elevation' },
	'email' => { 98 => 'EMail' },
	'embargodate' => { 255 => 'embargoDate', 257 => 'embargoDate' },
	'endingpage' => { 255 => 'endingPage' },
	'enduserid' => { 254 => 'EndUserEndUserID' },
	'endusername' => { 254 => 'EndUserEndUserName' },
	'engineer' => { 264 => 'engineer' },
	'enhancedarktones' => { 160 => 0x8 },
	'enhancement' => { 66 => 0x16, 67 => 0x3016 },
	'enhancer' => { 183 => 0x300 },
	'enhancervalues' => { 183 => 0x301 },
	'envelopenumber' => { 77 => 0x28 },
	'envelopepriority' => { 77 => 0x3c },
	'enveloperecordversion' => { 77 => 0x0 },
	'epsonimageheight' => { 184 => 0x20c },
	'epsonimagewidth' => { 184 => 0x20b },
	'epsonsoftware' => { 184 => 0x20d },
	'equipmentinstitution' => { 237 => 'EquipmentInstitution' },
	'equipmentmanufacturer' => { 237 => 'EquipmentManufacturer' },
	'equipmentversion' => { 180 => 0x0 },
	'ettlii' => { 47 => 0x304, 48 => 0xd, 49 => 0xe, 50 => 0x7, 51 => 0x7, 52 => 0xe },
	'event' => { 240 => 'Event', 251 => 'Event', 255 => 'event' },
	'evsteps' => { 206 => '1.2', 208 => 0x0 },
	'evstepsize' => { 176 => '5.1', 177 => '0.7' },
	'exclusivityenddate' => { 257 => 'exclusivityEndDate' },
	'excursiontolerance' => { 78 => 0x82 },
	'exif' => { 71 => 'EXIF' },
	'exifbyteorder' => { 71 => 'ExifByteOrder' },
	'exifcamerainfo' => { 76 => 0xe8 },
	'exifimageheight' => { 70 => 0xa003, 249 => 'PixelYDimension' },
	'exifimagewidth' => { 70 => 0xa002, 249 => 'PixelXDimension' },
	'exifunicodebyteorder' => { 71 => 'ExifUnicodeByteOrder' },
	'exifversion' => { 70 => 0x9000, 249 => 'ExifVersion' },
	'exitpupilposition' => { 137 => 0x4, 138 => 0x4 },
	'expirationdate' => { 76 => 0x25, 255 => 'expirationDate', 257 => 'expirationDate' },
	'expirationtime' => { 76 => 0x26 },
	'exposure' => { 70 => 0xfe51, 245 => 'Exposure' },
	'exposureadj' => { 165 => 0x0 },
	'exposureadj2' => { 165 => 0x12 },
	'exposureadjust' => { 229 => 0xc },
	'exposurebracketingindicatorlast' => { 114 => 0x52 },
	'exposurebracketstepsize' => { 206 => 0x8 },
	'exposurebracketvalue' => { 139 => 0x19 },
	'exposurecompensation' => { 42 => 0x6, 56 => 0x0, 70 => 0x9204, 83 => 0x24, 97 => 'ExposureComp', 111 => 0xd, 112 => 0x53, 113 => 0x1e, 184 => 0x1006, 213 => 0x16, 227 => 0xa013, 229 => [0xc,0x35], 249 => 'ExposureBiasValue' },
	'exposurecompensationmode' => { 114 => 0x47 },
	'exposurecompensationsetting' => { 114 => 0x1 },
	'exposurecompstepsize' => { 174 => '6.3' },
	'exposurecontrolstepsize' => { 174 => '6.2', 178 => '7.1' },
	'exposuredelaymode' => { 174 => '10.1', 176 => '9.1', 177 => '6.4', 178 => '11.2' },
	'exposuredifference' => { 139 => 0xe },
	'exposureindex' => { 70 => 0xa215, 249 => 'ExposureIndex' },
	'exposureindicator' => { 114 => 0x50 },
	'exposurelevelincrements' => { 45 => 0x6, 46 => 0x6, 47 => 0x101, 48 => 0x5, 49 => 0x6, 50 => 0x5, 51 => 0x5, 52 => 0x6, 53 => 0x4, 230 => 0x58 },
	'exposuremode' => { 70 => 0xa402, 97 => 'ExposureMode', 111 => 0x1, 112 => 0xa, 113 => 0x0, 114 => 0x0, 179 => 0x200, 196 => 0x40d, 229 => 0x8, 232 => 0xb041, 249 => 'ExposureMode' },
	'exposuremodeinmanual' => { 47 => 0x10b },
	'exposureprogram' => { 70 => 0x8822, 230 => 0x3c, 231 => 0x3c, 249 => 'ExposureProgram' },
	'exposureshift' => { 179 => 0x203 },
	'exposuretime' => { 2 => 0x4, 3 => 0x4, 4 => 0x4, 5 => 0x4, 6 => 0x4, 7 => 0x4, 8 => 0x4, 9 => 0x4, 10 => 0x4, 11 => 0x4, 12 => 0x4, 13 => 0x4, 14 => 0x4, 15 => 0x4, 17 => 0x6, 18 => 0x7, 42 => 0x16, 70 => 0x829a, 80 => 0xfd05, 83 => 0x20, 85 => 0xfa24, 87 => 0xf104, 90 => 0x12, 92 => 0x38, 95 => 0x10, 97 => 'ExposureTime', 111 => 0x9, 112 => 0x35, 113 => 0x48, 114 => 0x8, 213 => 0x12, 227 => 0xa018, 229 => 0x32, 249 => 'ExposureTime' },
	'exposuretime2' => { 229 => 0x33 },
	'exposuretuning' => { 139 => 0x1c },
	'exposurevalue' => { 81 => 0x3 },
	'exposurewarning' => { 74 => 0x1302 },
	'exrauto' => { 74 => 0x1033 },
	'exrmode' => { 74 => 0x1034 },
	'extendedwbdetect' => { 179 => 0x902 },
	'extender' => { 180 => 0x301 },
	'extenderfirmwareversion' => { 180 => 0x304 },
	'extendermagnification' => { 99 => 'Magnification' },
	'extendermake' => { 99 => 'Make' },
	'extendermodel' => { 99 => 'Model', 180 => 0x303 },
	'extenderserialnumber' => { 99 => 'SerialNumber', 180 => 0x302 },
	'externalflash' => { 182 => 0x1201 },
	'externalflashae1' => { 184 => 0x101f },
	'externalflashae1_0' => { 184 => 0x101b },
	'externalflashae2' => { 184 => 0x1020 },
	'externalflashae2_0' => { 184 => 0x101c },
	'externalflashbounce' => { 182 => 0x1204, 184 => 0x1026, 209 => 0x1a },
	'externalflashexposurecomp' => { 139 => 0x17, 209 => 0x19 },
	'externalflashfirmware' => { 131 => 0x6, 132 => 0x6, 133 => 0x6 },
	'externalflashflags' => { 131 => 0x8, 132 => 0x8, 133 => 0x8 },
	'externalflashguidenumber' => { 182 => 0x1203, 209 => '24.1' },
	'externalflashgvalue' => { 184 => 0x1025 },
	'externalflashmode' => { 184 => 0x1028, 209 => 0x2 },
	'externalflashzoom' => { 182 => 0x1205, 184 => 0x1027 },
	'externalsensorbrightnessvalue' => { 194 => 0x311, 200 => 0x3408 },
	'eyestartaf' => { 114 => 0x40 },
	'face0position' => { 28 => 0x8 },
	'face1position' => { 28 => 0xa, 192 => 0x1 },
	'face2position' => { 28 => 0xc, 192 => 0x5 },
	'face3position' => { 28 => 0xe, 192 => 0x9 },
	'face4position' => { 28 => 0x10, 192 => 0xd },
	'face5position' => { 28 => 0x12, 192 => 0x11 },
	'face6position' => { 28 => 0x14 },
	'face7position' => { 28 => 0x16 },
	'face8position' => { 28 => 0x18 },
	'facedetect' => { 183 => 0x1200 },
	'facedetectarea' => { 183 => 0x1201 },
	'facedetectframeheight' => { 28 => 0x4 },
	'facedetectframewidth' => { 28 => 0x3 },
	'facepositions' => { 74 => 0x4103 },
	'facesdetected' => { 28 => 0x2, 29 => 0x2, 74 => 0x4100, 199 => 0x3f },
	'facesrecognized' => { 193 => 0x0 },
	'faithfuloutputhighlightpoint' => { 65 => 0x38 },
	'faithfuloutputshadowpoint' => { 65 => 0x39 },
	'faithfulrawcolortone' => { 65 => 0x31 },
	'faithfulrawcontrast' => { 65 => 0x33 },
	'faithfulrawhighlight' => { 65 => 0x79 },
	'faithfulrawhighlightpoint' => { 65 => 0x36 },
	'faithfulrawlinear' => { 65 => 0x34 },
	'faithfulrawsaturation' => { 65 => 0x32 },
	'faithfulrawshadow' => { 65 => 0x82 },
	'faithfulrawshadowpoint' => { 65 => 0x37 },
	'faithfulrawsharpness' => { 65 => 0x35 },
	'femicroadjustment' => { 47 => 0x110 },
	'ffid' => { 247 => 'ffid' },
	'fieldcount' => { 184 => 0x103f },
	'filedatarate' => { 264 => 'fileDataRate' },
	'fileformat' => { 58 => 0x0, 77 => 0x14, 229 => 0x22, 232 => 0xb000 },
	'fileindex' => { 2 => 0x143, 5 => 0x172, 8 => 0x133, 9 => 0x13f, 10 => 0x1d3, 11 => [0x197,0x19b], 12 => 0x1e4, 14 => [0x197,0x1bb], 16 => 0x1c7 },
	'filemodifydate' => { 71 => 'FileModifyDate' },
	'filename' => { 71 => 'FileName' },
	'filenameasdelivered' => { 254 => 'FileNameAsDelivered' },
	'filenumber' => { 30 => 0x1, 34 => 0x8, 60 => 0x1817, 68 => 'FileNumber', 130 => 0x8 },
	'filenumbermemory' => { 111 => 0x1a },
	'filenumbersequence' => { 174 => '12.2', 176 => '3.1', 178 => '5.2' },
	'filesource' => { 70 => 0xa300, 74 => 0x8000, 249 => 'FileSource' },
	'fileversion' => { 77 => 0x16 },
	'fillflashautoreduction' => { 45 => 0xe, 46 => 0xe, 53 => 0xa },
	'filllight' => { 245 => 'FillLight' },
	'fillorder' => { 70 => 0x10a },
	'filmmode' => { 74 => 0x1401, 196 => 0x412, 199 => 0x42 },
	'filmtype' => { 144 => 0x2 },
	'filtereffect' => { 30 => 0xe, 141 => 0x37 },
	'filtereffectmonochrome' => { 13 => 0xff },
	'finderdisplayduringexposure' => { 46 => 0x1 },
	'finetuneoptcenterweighted' => { 174 => '7.2', 178 => '9.1' },
	'finetuneoptmatrixmetering' => { 174 => '8.1', 178 => '8.2' },
	'finetuneoptspotmetering' => { 174 => '8.2', 178 => '9.2' },
	'firmware' => { 184 => 0x405, 229 => [0x17,0x3b], 243 => 'Firmware' },
	'firmwaredate' => { 66 => 0x15, 67 => 0x2001 },
	'firmwareid' => { 117 => 0x0 },
	'firmwarename' => { 227 => 0xa001 },
	'firmwarerevision' => { 13 => 0xa4, 34 => 0x1e },
	'firmwareversion' => { 2 => 0x10b, 5 => 0x136, 8 => 0xff, 9 => 0x107, 81 => 0xce5, 95 => 0x57, 97 => 'FirmwareVersion', 199 => 0x2, 200 => 0x3109, 213 => 0x230, 223 => 0x2 },
	'firstpublicationdate' => { 254 => 'FirstPublicationDate' },
	'fixtureidentifier' => { 76 => 0x16 },
	'flash' => { 70 => 0x9209, 112 => 0x1f, 113 => 0x15 },
	'flashactivity' => { 20 => 0x1c },
	'flashbatterylevel' => { 24 => 0x249 },
	'flashbias' => { 199 => 0x24 },
	'flashbits' => { 20 => 0x1d },
	'flashchargelevel' => { 184 => 0x1010 },
	'flashcolorfilter' => { 133 => 0x10 },
	'flashcommandermode' => { 131 => '9.1', 132 => '9.1', 133 => '9.1' },
	'flashcompensation' => { 131 => 0xa, 132 => 0xa, 133 => 0xa, 243 => 'FlashCompensation' },
	'flashcontrolmode' => { 131 => '9.2', 132 => '9.2', 133 => '9.2', 179 => 0x404 },
	'flashdefault' => { 114 => 0x42 },
	'flashdevice' => { 184 => 0x1005 },
	'flashdistance' => { 67 => 0x2034 },
	'flashenergy' => { 70 => 0xa20b, 249 => 'FlashEnergy' },
	'flashexposurebracketvalue' => { 139 => 0x18 },
	'flashexposurecomp' => { 42 => 0xf, 74 => 0x1011, 100 => 'ExposureComp', 111 => 0x23, 115 => 0x104, 139 => 0x12, 179 => 0x401, 184 => 0x1023, 213 => 0x4d, 229 => 0x3a, 232 => 0x104 },
	'flashexposurecompset' => { 202 => 0xe },
	'flashexposurecompsetting' => { 114 => 0x10 },
	'flashexposureindicator' => { 114 => 0x54 },
	'flashexposureindicatorlast' => { 114 => 0x56 },
	'flashexposureindicatornext' => { 114 => 0x55 },
	'flashexposurelock' => { 30 => 0x19 },
	'flashfired' => { 83 => 0x5d, 100 => 'Fired', 111 => 0x14, 155 => '590.3', 199 => 0x8007, 249 => 'FlashFired' },
	'flashfiring' => { 47 => 0x306, 48 => 0x6, 49 => 0x7, 52 => 0x7 },
	'flashfirmwareversion' => { 180 => 0x1002 },
	'flashfocallength' => { 131 => 0xb, 132 => 0xc, 133 => 0xc },
	'flashfunction' => { 249 => 'FlashFunction' },
	'flashgndistance' => { 131 => 0xe, 132 => 0xf, 133 => 0xf },
	'flashgroupacompensation' => { 131 => 0x11, 132 => 0x12, 133 => 0x13 },
	'flashgroupacontrolmode' => { 131 => 0xf, 132 => '16.1', 133 => '17.1' },
	'flashgroupaoutput' => { 131 => 0x11, 132 => 0x12, 133 => 0x13 },
	'flashgroupbcompensation' => { 131 => 0x12, 132 => 0x13, 133 => 0x14 },
	'flashgroupbcontrolmode' => { 131 => 0x10, 132 => '17.1', 133 => '18.1' },
	'flashgroupboutput' => { 131 => 0x12, 132 => 0x13, 133 => 0x14 },
	'flashgroupccompensation' => { 132 => 0x14, 133 => 0x15 },
	'flashgroupccontrolmode' => { 132 => '17.2', 133 => '18.2' },
	'flashgroupcoutput' => { 132 => 0x14, 133 => 0x15 },
	'flashguidenumber' => { 42 => 0xd, 57 => 0x0, 100 => 'GuideNumber' },
	'flashintensity' => { 66 => [0x19,0x5], 179 => 0x405 },
	'flashlevel' => { 175 => 0x9, 232 => 0xb048 },
	'flashmake' => { 100 => 'Make' },
	'flashmanufacturer' => { 241 => 'FlashManufacturer' },
	'flashmetering' => { 111 => 0x3f, 114 => 0x1c },
	'flashmeteringmode' => { 2 => 0x15, 7 => 0x15, 8 => 0x15, 9 => 0x15, 10 => 0x15, 11 => 0x15, 12 => 0x15, 14 => 0x15, 15 => 0x15 },
	'flashmeteringsegments' => { 213 => 0x20a },
	'flashmode' => { 66 => 0x4, 83 => 0x5c, 100 => 'Mode', 111 => 0x2, 112 => 0x20, 113 => 0x16, 114 => 0xf, 139 => 0x87, 179 => 0x400, 184 => 0x1004, 213 => 0xc, 215 => 0x4, 222 => 0x20, 228 => 0x225, 230 => 0x23, 231 => 0x23, 249 => 'FlashMode' },
	'flashmodel' => { 100 => 'Model', 180 => 0x1001, 241 => 'FlashModel' },
	'flashoptions' => { 206 => 0x2 },
	'flashoptions2' => { 206 => 0x10 },
	'flashoutput' => { 24 => 0x248, 42 => 0x21, 131 => 0xa, 132 => 0xa, 133 => 0xa },
	'flashpixversion' => { 70 => 0xa000, 249 => 'FlashpixVersion' },
	'flashredeyemode' => { 249 => 'FlashRedEyeMode' },
	'flashremotecontrol' => { 179 => 0x403 },
	'flashreturn' => { 249 => 'FlashReturn' },
	'flashserialnumber' => { 100 => 'SerialNumber', 180 => 0x1003 },
	'flashsetting' => { 139 => 0x8 },
	'flashshutterspeed' => { 174 => '20.2', 177 => '7.2', 178 => '23.1' },
	'flashsource' => { 131 => 0x4, 132 => 0x4, 133 => 0x4 },
	'flashstatus' => { 209 => 0x0 },
	'flashsyncspeed' => { 174 => '20.1' },
	'flashsyncspeedav' => { 45 => 0x3, 47 => 0x10f, 48 => 0x2, 49 => 0x3, 50 => 0x2, 51 => 0x2, 52 => 0x3, 53 => 0x6 },
	'flashthreshold' => { 57 => 0x1 },
	'flashtype' => { 100 => 'Type', 114 => 0x59, 139 => 0x9, 180 => 0x1000 },
	'flashwarning' => { 177 => '7.1', 178 => '31.1', 199 => 0x62 },
	'flickerreduce' => { 228 => 0x218 },
	'fliphorizontal' => { 167 => 0x76a43206 },
	'fnumber' => { 2 => 0x3, 5 => 0x3, 7 => 0x3, 8 => 0x3, 9 => 0x3, 10 => 0x3, 11 => 0x3, 12 => 0x3, 13 => 0x3, 14 => 0x3, 15 => 0x3, 17 => 0x5, 18 => 0x6, 42 => 0x15, 70 => 0x829d, 80 => 0xfd04, 83 => 0x1e, 85 => 0xfa23, 87 => 0xf103, 90 => 0x13, 92 => 0x3c, 95 => 0xc, 104 => 'FNumber', 111 => 0xa, 112 => 0x36, 113 => 0x47, 114 => 0x9, 213 => 0x13, 227 => 0xa019, 229 => 0x31, 249 => 'FNumber' },
	'focallength' => { 2 => 0x1d, 3 => 0xa, 4 => 0x9, 5 => 0x1d, 6 => 0x9, 7 => 0x1e, 8 => 0x1d, 9 => 0x1d, 10 => 0x1e, 11 => 0x1e, 12 => 0x1e, 13 => 0x28, 14 => 0x1e, 15 => 0x1e, 32 => 0x1, 67 => 0x1d, 70 => 0x920a, 90 => 0x1d, 104 => 'FocalLength', 111 => 0x12, 137 => 0xa, 138 => 0xb, 210 => 0x9, 213 => 0x1d, 249 => 'FocalLength' },
	'focallengthin35mmformat' => { 70 => 0xa405, 227 => 0xa01a, 249 => 'FocalLengthIn35mmFilm' },
	'focalplanediagonal' => { 180 => 0x103, 184 => 0x205 },
	'focalplaneresolutionunit' => { 70 => 0xa210, 249 => 'FocalPlaneResolutionUnit' },
	'focalplanexresolution' => { 70 => 0xa20e, 249 => 'FocalPlaneXResolution' },
	'focalplanexsize' => { 32 => 0x2 },
	'focalplanexunknown' => { 32 => 0x2 },
	'focalplaneyresolution' => { 70 => 0xa20f, 249 => 'FocalPlaneYResolution' },
	'focalplaneysize' => { 32 => 0x3 },
	'focalplaneyunknown' => { 32 => 0x3 },
	'focaltype' => { 4 => 0x2d, 32 => 0x0 },
	'focalunits' => { 20 => 0x19 },
	'focus' => { 157 => 0x8 },
	'focusarea' => { 111 => 0x31 },
	'focusareaselection' => { 177 => '15.2' },
	'focuscontinuous' => { 20 => 0x20 },
	'focusdisplayaiservoandmf' => { 47 => 0x515 },
	'focusdistance' => { 104 => 'FocusDistance', 111 => 0x13, 137 => 0x9, 138 => 0xa, 182 => 0x305 },
	'focusdistancelower' => { 2 => 0x45, 5 => 0x45, 7 => 0x56, 8 => 0x45, 9 => 0x45, 10 => 0x52, 11 => 0x52, 12 => 0x56, 14 => 0x52, 16 => 0x32, 42 => 0x14 },
	'focusdistanceupper' => { 2 => 0x43, 5 => 0x43, 7 => 0x54, 8 => 0x43, 9 => 0x43, 10 => 0x50, 11 => 0x50, 12 => 0x54, 14 => 0x50, 16 => 0x30, 42 => 0x13 },
	'focusholdbutton' => { 114 => 0x44 },
	'focusinfoversion' => { 182 => 0x0 },
	'focusingscreen' => { 46 => 0x0, 47 => 0x80b, 52 => 0x0 },
	'focusmode' => { 20 => 0x7, 66 => 0x3, 67 => [0x3003,0xd], 74 => 0x1021, 83 => 0x38, 97 => 'FocusMode', 111 => 0x30, 113 => 0xe, 114 => 0xc, 139 => 0x7, 179 => 0x301, 184 => 0x100b, 199 => 0x7, 213 => 0xd, 215 => 0x3, 230 => 0x10, 231 => 0x10, 232 => 0xb042 },
	'focusmode2' => { 206 => '3.1' },
	'focusmodesetting' => { 175 => '10.1' },
	'focusmodeswitch' => { 114 => 0x58 },
	'focuspixel' => { 74 => 0x1023 },
	'focuspointwrap' => { 174 => '2.2', 178 => '2.5' },
	'focusposition' => { 137 => 0x8, 138 => 0x8, 213 => 0x10 },
	'focusprocess' => { 179 => 0x302 },
	'focusrange' => { 20 => 0x12, 184 => 0x100a },
	'focussetting' => { 229 => 0x6 },
	'focusstepcount' => { 182 => 0x301, 184 => 0x100e },
	'focusstepinfinity' => { 182 => 0x303 },
	'focusstepnear' => { 182 => 0x304 },
	'focustrackinglockon' => { 174 => '1.5' },
	'focuswarning' => { 74 => 0x1301 },
	'foldername' => { 111 => 0x27 },
	'fontcomposite' => { 269 => 'FontsComposite' },
	'fontface' => { 269 => 'FontsFontFace' },
	'fontfamily' => { 269 => 'FontsFontFamily' },
	'fontfilename' => { 269 => 'FontsFontFileName' },
	'fontname' => { 269 => 'FontsFontName' },
	'fonttype' => { 269 => 'FontsFontType' },
	'fontversion' => { 269 => 'FontsVersionString' },
	'for' => { 221 => 'For' },
	'format' => { 246 => 'format' },
	'forwardlock' => { 259 => 'forwardlock' },
	'forwardmatrix1' => { 70 => 0xc714 },
	'forwardmatrix2' => { 70 => 0xc715 },
	'framenum' => { 216 => 0xd7 },
	'framenumber' => { 74 => 0x8003, 213 => 0x29 },
	'frameselector' => { 198 => '0.1' },
	'freebytes' => { 60 => 0x1 },
	'freememorycardimages' => { 112 => [0x37,0x54], 113 => [0x2d,0x4a], 114 => 0x32 },
	'fujiflashmode' => { 74 => 0x1010 },
	'fullimagesize' => { 232 => 0xb02b },
	'fullsizeimage' => { 103 => 'data' },
	'fullsizeimagename' => { 103 => '1Name' },
	'fullsizeimagetype' => { 103 => '0Type' },
	'funcbutton' => { 174 => ['14.1','15.1'], 178 => '14.1' },
	'funcbuttonplusdials' => { 174 => ['14.2','15.2'] },
	'functionbutton' => { 177 => '5.2' },
	'gainbase' => { 183 => 0x610 },
	'gaincontrol' => { 70 => 0xa407, 249 => 'GainControl' },
	'gamma' => { 70 => 0xa500 },
	'gammacompensatedvalue' => { 78 => 0x91 },
	'genre' => { 255 => 'genre', 264 => 'genre' },
	'geography' => { 256 => 'geography' },
	'geosync' => { 71 => 'Geosync' },
	'geotag' => { 71 => 'Geotag' },
	'geotime' => { 71 => 'Geotime' },
	'globalaltitude' => { 219 => 0x419 },
	'globalangle' => { 219 => 0x40d },
	'good' => { 264 => 'good' },
	'gpsaltitude' => { 75 => 0x6, 101 => 'Altitude', 249 => 'GPSAltitude' },
	'gpsaltituderef' => { 75 => 0x5, 249 => 'GPSAltitudeRef' },
	'gpsareainformation' => { 75 => 0x1c, 249 => 'GPSAreaInformation' },
	'gpsdatestamp' => { 75 => 0x1d },
	'gpsdatetime' => { 101 => 'DateTime', 249 => 'GPSTimeStamp' },
	'gpsdestbearing' => { 75 => 0x18, 101 => 'Bearing', 249 => 'GPSDestBearing' },
	'gpsdestbearingref' => { 75 => 0x17, 249 => 'GPSDestBearingRef' },
	'gpsdestdistance' => { 75 => 0x1a, 101 => 'Distance', 249 => 'GPSDestDistance' },
	'gpsdestdistanceref' => { 75 => 0x19, 249 => 'GPSDestDistanceRef' },
	'gpsdestlatitude' => { 75 => 0x14, 249 => 'GPSDestLatitude' },
	'gpsdestlatituderef' => { 75 => 0x13 },
	'gpsdestlongitude' => { 75 => 0x16, 249 => 'GPSDestLongitude' },
	'gpsdestlongituderef' => { 75 => 0x15 },
	'gpsdifferential' => { 75 => 0x1e, 101 => 'Differential', 249 => 'GPSDifferential' },
	'gpsdop' => { 75 => 0xb, 249 => 'GPSDOP' },
	'gpshpositioningerror' => { 75 => 0x1f },
	'gpsimgdirection' => { 75 => 0x11, 249 => 'GPSImgDirection' },
	'gpsimgdirectionref' => { 75 => 0x10, 249 => 'GPSImgDirectionRef' },
	'gpslatitude' => { 75 => 0x2, 101 => 'Latitude', 249 => 'GPSLatitude' },
	'gpslatituderef' => { 75 => 0x1 },
	'gpslongitude' => { 75 => 0x4, 101 => 'Longitude', 249 => 'GPSLongitude' },
	'gpslongituderef' => { 75 => 0x3 },
	'gpsmapdatum' => { 75 => 0x12, 101 => 'Datum', 249 => 'GPSMapDatum' },
	'gpsmeasuremode' => { 75 => 0xa, 101 => 'MeasureMode', 249 => 'GPSMeasureMode' },
	'gpsprocessingmethod' => { 75 => 0x1b, 249 => 'GPSProcessingMethod' },
	'gpssatellites' => { 75 => 0x8, 101 => 'Satellites', 249 => 'GPSSatellites' },
	'gpsspeed' => { 75 => 0xd, 101 => 'Speed', 249 => 'GPSSpeed' },
	'gpsspeedref' => { 75 => 0xc, 249 => 'GPSSpeedRef' },
	'gpsstatus' => { 75 => 0x9, 249 => 'GPSStatus' },
	'gpstimestamp' => { 75 => 0x7 },
	'gpstrack' => { 75 => 0xf, 101 => 'Heading', 249 => 'GPSTrack' },
	'gpstrackref' => { 75 => 0xe, 249 => 'GPSTrackRef' },
	'gpsversionid' => { 75 => 0x0, 249 => 'GPSVersionID' },
	'gradation' => { 179 => 0x50f },
	'graymixeraqua' => { 245 => 'GrayMixerAqua' },
	'graymixerblue' => { 245 => 'GrayMixerBlue' },
	'graymixergreen' => { 245 => 'GrayMixerGreen' },
	'graymixermagenta' => { 245 => 'GrayMixerMagenta' },
	'graymixerorange' => { 245 => 'GrayMixerOrange' },
	'graymixerpurple' => { 245 => 'GrayMixerPurple' },
	'graymixerred' => { 245 => 'GrayMixerRed' },
	'graymixeryellow' => { 245 => 'GrayMixerYellow' },
	'graypoint' => { 235 => 0x8021 },
	'grayresponseunit' => { 70 => 0x122 },
	'greencurvelimits' => { 64 => 0x1c4 },
	'greencurvepoints' => { 64 => 0x19a },
	'greenhue' => { 245 => 'GreenHue' },
	'greensaturation' => { 245 => 'GreenSaturation' },
	'griddisplay' => { 174 => '13.3', 176 => '2.2', 177 => '6.1', 178 => '4.2' },
	'halftonehints' => { 70 => 0x141 },
	'hasalternative' => { 255 => 'hasAlternative' },
	'hascorrection' => { 255 => 'hasCorrection' },
	'hascrop' => { 245 => 'HasCrop' },
	'hasextendedxmp' => { 266 => 'HasExtendedXMP' },
	'haspreviousversion' => { 255 => 'hasPreviousVersion' },
	'hassettings' => { 245 => 'HasSettings' },
	'hastranslation' => { 255 => 'hasTranslation' },
	'hdr' => { 232 => 0x200a },
	'headline' => { 76 => 0x69, 253 => 'Headline' },
	'hierarchicalsubject' => { 238 => 'hierarchicalSubject' },
	'highisonoisereduction' => { 10 => 0xbc, 11 => 0xbd, 14 => 0xbd, 16 => 0xa5, 47 => 0x202, 139 => 0xb1, 213 => 0x71, 230 => 0x2c },
	'highlight' => { 229 => 0xf },
	'highlightcolordistortreduct' => { 235 => 0x8026 },
	'highlightprotection' => { 166 => 0x6 },
	'highlightrecovery' => { 245 => 'HighlightRecovery' },
	'highlighttonepriority' => { 7 => 0x7, 10 => 0x7, 11 => 0x7, 12 => 0x7, 14 => 0x7, 15 => 0x7, 47 => 0x203 },
	'highspeedsync' => { 114 => 0x5 },
	'history' => { 253 => 'History' },
	'historyaction' => { 265 => 'HistoryAction' },
	'historychanged' => { 265 => 'HistoryChanged' },
	'historyinstanceid' => { 265 => 'HistoryInstanceID' },
	'historyparameters' => { 265 => 'HistoryParameters' },
	'historysoftwareagent' => { 265 => 'HistorySoftwareAgent' },
	'historywhen' => { 265 => 'HistoryWhen' },
	'hometowncity' => { 67 => 0x3006, 213 => 0x23 },
	'hometowncitycode' => { 215 => 0x1000 },
	'hometowndst' => { 213 => 0x25 },
	'hostcomputer' => { 70 => 0x13c },
	'hue' => { 118 => 0x3b },
	'hueadj' => { 170 => 0x2f, 235 => 0x8019 },
	'hueadjustment' => { 112 => 0x4a, 113 => 0x40, 139 => 0x92, 141 => 0x36 },
	'hueadjustmentaqua' => { 245 => 'HueAdjustmentAqua' },
	'hueadjustmentblue' => { 245 => 'HueAdjustmentBlue' },
	'hueadjustmentgreen' => { 245 => 'HueAdjustmentGreen' },
	'hueadjustmentmagenta' => { 245 => 'HueAdjustmentMagenta' },
	'hueadjustmentorange' => { 245 => 'HueAdjustmentOrange' },
	'hueadjustmentpurple' => { 245 => 'HueAdjustmentPurple' },
	'hueadjustmentred' => { 245 => 'HueAdjustmentRed' },
	'hueadjustmentyellow' => { 245 => 'HueAdjustmentYellow' },
	'huesetting' => { 187 => 0x1011 },
	'icc_profile' => { 71 => 'ICC_Profile' },
	'iccprofilename' => { 253 => 'ICCProfile' },
	'idccreativestyle' => { 235 => 0x8000 },
	'idcpreviewlength' => { 235 => 0x202 },
	'idcpreviewstart' => { 235 => 0x201 },
	'identifier' => { 246 => 'identifier', 262 => 'Identifier' },
	'illumination' => { 177 => '0.5' },
	'imageadjustment' => { 139 => 0x80, 157 => 0x5 },
	'imagealterationconstraints' => { 254 => 'ImageAlterationConstraints' },
	'imagearea' => { 152 => 0x10 },
	'imageareaoffset' => { 213 => 0x38 },
	'imageauthentication' => { 139 => 0x20 },
	'imageboundary' => { 139 => 0x16 },
	'imagecount' => { 139 => 0xa5 },
	'imagecreatorid' => { 254 => 'ImageCreatorImageCreatorID' },
	'imagecreatorimageid' => { 254 => 'ImageCreatorImageID' },
	'imagecreatorname' => { 254 => 'ImageCreatorImageCreatorName' },
	'imagedatasize' => { 139 => 0xa2 },
	'imagedescription' => { 70 => 0x10e, 260 => 'ImageDescription' },
	'imageduplicationconstraints' => { 254 => 'ImageDuplicationConstraints' },
	'imagedustoff' => { 167 => 0xfe443a45 },
	'imagefileconstraints' => { 254 => 'ImageFileConstraints' },
	'imagefileformatasdelivered' => { 254 => 'ImageFileFormatAsDelivered' },
	'imagefilesizeasdelivered' => { 254 => 'ImageFileSizeAsDelivered' },
	'imageheight' => { 70 => 0x101, 117 => 0xc, 260 => 'ImageLength' },
	'imagehistory' => { 70 => 0x9213 },
	'imageidnumber' => { 194 => 0x340 },
	'imagenumber' => { 13 => 0xd0, 70 => 0x9211, 97 => 'ImageNumber', 112 => 0xae, 113 => 0x5e, 243 => 'ImageNumber' },
	'imagenumber2' => { 113 => 0x62 },
	'imageoptimization' => { 139 => 0xa9 },
	'imageorientation' => { 76 => 0x83 },
	'imageprocessing' => { 139 => 0x1a, 213 => 0x32 },
	'imageprocessingcount' => { 213 => 0x41 },
	'imageprocessingversion' => { 183 => 0x0 },
	'imagequality' => { 97 => 'ImageQuality', 151 => '723.2', 152 => '732.2', 155 => '708.1', 199 => 0x1 },
	'imagequality2' => { 179 => 0x603 },
	'imagereview' => { 175 => '0.4', 177 => '0.4' },
	'imagereviewtime' => { 175 => '2.1', 176 => '19.1', 178 => '21.2' },
	'imagesize' => { 103 => 'ImageSize' },
	'imagesizerestriction' => { 257 => 'imageSizeRestriction' },
	'imagesourcedata' => { 70 => 0x935c },
	'imagestabilization' => { 20 => 0x22, 67 => 0x3020, 97 => 'ImageStabilization', 112 => 0xbd, 113 => 0x71, 114 => 0x57, 115 => [0x18,0x107,0x113], 139 => 0xac, 179 => 0x604, 182 => 0x1600, 199 => 0x1a, 230 => 0x3d, 232 => 0xb026 },
	'imagestyle' => { 230 => 0x2d },
	'imagesupplierid' => { 254 => 'ImageSupplierImageSupplierID' },
	'imagesupplierimageid' => { 254 => 'ImageSupplierImageID' },
	'imagesuppliername' => { 254 => 'ImageSupplierImageSupplierName' },
	'imagetone' => { 213 => 0x4f },
	'imagetype' => { 76 => 0x82, 254 => 'ImageType' },
	'imageuniqueid' => { 34 => 0x28, 70 => 0xa420, 249 => 'ImageUniqueID' },
	'imagewidth' => { 70 => 0x100, 117 => 0xe, 260 => 'ImageWidth' },
	'incrementaltemperature' => { 245 => 'IncrementalTemperature' },
	'incrementaltint' => { 245 => 'IncrementalTint' },
	'industry' => { 255 => 'industry', 256 => 'industry' },
	'infinitylensstep' => { 184 => 0x103b },
	'infobuttonwhenshooting' => { 47 => 0x409 },
	'ingredientsalternatepaths' => { 265 => 'IngredientsAlternatePaths' },
	'ingredientsdocumentid' => { 265 => 'IngredientsDocumentID' },
	'ingredientsfilepath' => { 265 => 'IngredientsFilePath' },
	'ingredientsfrompart' => { 265 => 'IngredientsFromPart' },
	'ingredientsinstanceid' => { 265 => 'IngredientsInstanceID' },
	'ingredientslastmodifydate' => { 265 => 'IngredientsLastModifyDate' },
	'ingredientsmanager' => { 265 => 'IngredientsManager' },
	'ingredientsmanagervariant' => { 265 => 'IngredientsManagerVariant' },
	'ingredientsmanageto' => { 265 => 'IngredientsManageTo' },
	'ingredientsmanageui' => { 265 => 'IngredientsManageUI' },
	'ingredientsmaskmarkers' => { 265 => 'IngredientsMaskMarkers' },
	'ingredientsoriginaldocumentid' => { 265 => 'IngredientsOriginalDocumentID' },
	'ingredientspartmapping' => { 265 => 'IngredientsPartMapping' },
	'ingredientsrenditionclass' => { 265 => 'IngredientsRenditionClass' },
	'ingredientsrenditionparams' => { 265 => 'IngredientsRenditionParams' },
	'ingredientstopart' => { 265 => 'IngredientsToPart' },
	'ingredientsversionid' => { 265 => 'IngredientsVersionID' },
	'initialzoomsetting' => { 174 => '9.3' },
	'inkset' => { 70 => 0x14c },
	'instanceid' => { 265 => 'InstanceID' },
	'instantplaybacksetup' => { 114 => 0x3e },
	'instantplaybacktime' => { 114 => 0x3d },
	'instructions' => { 253 => 'Instructions' },
	'instrument' => { 264 => 'instrument' },
	'intellectualgenre' => { 250 => 'IntellectualGenre' },
	'intelligentauto' => { 232 => 0xb052 },
	'intelligentexposure' => { 199 => 0x5d },
	'intelligentresolution' => { 199 => 0x70 },
	'interchangecolorspace' => { 78 => 0x40 },
	'internalflash' => { 111 => 0x2b, 174 => '23.1', 175 => '8.1', 176 => '22.1', 177 => '8.1', 178 => '24.1', 182 => 0x1208 },
	'internalflashae1' => { 184 => 0x1021 },
	'internalflashae1_0' => { 184 => 0x101d },
	'internalflashae2' => { 184 => 0x1022 },
	'internalflashae2_0' => { 184 => 0x101e },
	'internalflashmode' => { 209 => 0x1 },
	'internalflashstrength' => { 209 => 0x3 },
	'internalflashtable' => { 184 => 0x1024 },
	'internalserialnumber' => { 34 => 0x96, 41 => 0x9, 74 => 0x10, 116 => 0x49dc, 180 => 0x102, 199 => 0x25, 205 => 0x4, 223 => 0x5 },
	'interopindex' => { 70 => 0x1 },
	'interopversion' => { 70 => 0x2 },
	'intervallength' => { 111 => 0x10 },
	'intervalmode' => { 111 => 0x26 },
	'intervalnumber' => { 111 => 0x11 },
	'introtimescale' => { 264 => 'introTimeScale' },
	'introtimevalue' => { 264 => 'introTimeValue' },
	'iptc-naa' => { 70 => 0x83bb, 201 => 0x83bb },
	'iptcbitspersample' => { 78 => 0x56 },
	'iptcdigest' => { 219 => 0x425 },
	'iptcimageheight' => { 78 => 0x1e },
	'iptcimagerotation' => { 78 => 0x66 },
	'iptcimagewidth' => { 78 => 0x14 },
	'iptclastedited' => { 251 => 'IptcLastEdited' },
	'iptcpicturenumber' => { 78 => 0xa },
	'iptcpixelheight' => { 78 => 0x32 },
	'iptcpixelwidth' => { 78 => 0x28 },
	'isbn' => { 255 => 'isbn' },
	'iscorrectionof' => { 255 => 'isCorrectionOf' },
	'iscustompicturestyle' => { 65 => 0x3 },
	'iso' => { 2 => 0x6, 4 => 0x75, 5 => 0x6, 6 => 0x79, 7 => 0x6, 8 => 0x6, 9 => 0x6, 10 => 0x6, 11 => 0x6, 12 => 0x6, 13 => 0x6, 14 => 0x6, 15 => 0x6, 17 => 0x0, 18 => 0x1, 66 => 0x14, 67 => [0x3014,0x14], 70 => 0x8827, 80 => 0xfd06, 81 => 0x1784, 83 => 0x60, 85 => [0xfa2e,0xfa46], 86 => [0x27,0x28], 87 => 0xf105, 90 => 0x14, 92 => 0x4e, 95 => 0x34, 97 => 'ISO', 111 => 0x8, 135 => 0x0, 139 => 0x2, 201 => 0x17, 213 => 0x14, 215 => 0x14, 227 => 0xa014, 249 => 'ISOSpeedRatings' },
	'iso2' => { 135 => 0x6, 146 => 0x265, 147 => 0x25c, 148 => 0x265, 149 => 0x221, 150 => 0x25d, 151 => 0x256, 152 => 0x25d, 154 => 0x2b5, 156 => 0x2b5 },
	'isodisplay' => { 176 => '2.3', 178 => '4.3' },
	'isoexpansion' => { 47 => 0x103, 48 => 0x7, 49 => 0x8, 52 => 0x8, 135 => 0x4 },
	'isoexpansion2' => { 135 => 0xa },
	'isofloor' => { 206 => 0x6 },
	'isoselection' => { 139 => 0xf },
	'isosetting' => { 83 => 0x5e, 97 => 'ISOSetting', 111 => 0x24, 112 => 0x26, 113 => 0x1c, 114 => 0x13, 118 => 0x6, 139 => 0x13, 206 => '17.3', 222 => 0x27, 230 => 0x16, 231 => 0x14 },
	'isospeed' => { 70 => 0x8833 },
	'isospeedexpansion' => { 46 => 0x3 },
	'isospeedincrements' => { 47 => 0x102 },
	'isospeedlatitudeyyy' => { 70 => 0x8834 },
	'isospeedlatitudezzz' => { 70 => 0x8835 },
	'isospeedrange' => { 47 => 0x103 },
	'isostepsize' => { 174 => '6.1' },
	'isovalue' => { 184 => 0x1001 },
	'issn' => { 255 => 'issn' },
	'issueidentifier' => { 255 => 'issueIdentifier' },
	'issuename' => { 255 => 'issueName' },
	'istranslationof' => { 255 => 'isTranslationOf' },
	'jobid' => { 76 => 0xb8 },
	'jobrefid' => { 263 => 'JobRefId' },
	'jobrefname' => { 263 => 'JobRefName' },
	'jobrefurl' => { 263 => 'JobRefUrl' },
	'jpegquality' => { 4 => 0x66, 200 => 0x3034 },
	'jpegsize' => { 200 => 0x303a },
	'jpgfromraw' => { 60 => 0x2007, 68 => 'JpgFromRaw', 201 => 0x2e },
	'jpgfromrawlength' => { 70 => [0x117,0x202] },
	'jpgfromrawstart' => { 70 => [0x111,0x201] },
	'jpgrecordedpixels' => { 206 => 0xe },
	'key' => { 264 => 'key' },
	'keyword' => { 255 => 'keyword' },
	'keywords' => { 76 => 0x19, 98 => 'Keywords', 188 => 'Keywords', 221 => 'Keywords', 242 => 'keywords', 252 => 'Keywords' },
	'killdate' => { 255 => 'killDate' },
	'kodakimageheight' => { 80 => 0xf908, 83 => 0xe, 85 => [0xfa1e,0xfa52], 91 => 0x70 },
	'kodakimagewidth' => { 80 => 0xf907, 83 => 0xc, 85 => [0xfa1d,0xfa51], 91 => 0x6c },
	'kodakinfotype' => { 80 => 0xfa00 },
	'kodakmaker' => { 91 => 0x8 },
	'kodakmodel' => { 83 => 0x0, 91 => 0x28 },
	'label' => { 190 => 'Label', 262 => 'Label' },
	'landmark' => { 199 => 0x6f },
	'landscapeoutputhighlightpoint' => { 65 => 0x26 },
	'landscapeoutputshadowpoint' => { 65 => 0x27 },
	'landscaperawcolortone' => { 65 => 0x1f },
	'landscaperawcontrast' => { 65 => 0x21 },
	'landscaperawhighlight' => { 65 => 0x77 },
	'landscaperawhighlightpoint' => { 65 => 0x24 },
	'landscaperawlinear' => { 65 => 0x22 },
	'landscaperawsaturation' => { 65 => 0x20 },
	'landscaperawshadow' => { 65 => 0x80 },
	'landscaperawshadowpoint' => { 65 => 0x25 },
	'landscaperawsharpness' => { 65 => 0x23 },
	'language' => { 246 => 'language' },
	'languageidentifier' => { 76 => 0x87 },
	'lastfilenumber' => { 111 => 0x1b },
	'lastkeywordiptc' => { 241 => 'LastKeywordIPTC' },
	'lastkeywordxmp' => { 241 => 'LastKeywordXMP' },
	'lasturl' => { 265 => 'LastURL' },
	'lc1' => { 210 => 0x2 },
	'lc10' => { 210 => 0xb },
	'lc11' => { 210 => 0xc },
	'lc12' => { 210 => 0xd },
	'lc14' => { 210 => 0xf },
	'lc15' => { 210 => 0x10 },
	'lc2' => { 210 => 0x3 },
	'lc3' => { 210 => 0x4 },
	'lc4' => { 210 => 0x5 },
	'lc5' => { 210 => 0x6 },
	'lc6' => { 210 => 0x7 },
	'lc7' => { 210 => 0x8 },
	'lcddisplayatpoweron' => { 47 => 0x811, 51 => 0xa },
	'lcddisplayreturntoshoot' => { 52 => 0x12 },
	'lcdillumination' => { 174 => '17.5', 178 => '5.4' },
	'lcdilluminationduringbulb' => { 47 => 0x408 },
	'lcdpanels' => { 46 => 0x8 },
	'lcheditor' => { 167 => 0x8ae85e },
	'legacyiptcdigest' => { 253 => 'LegacyIPTCDigest' },
	'lens' => { 70 => 0xfdea, 139 => 0x84, 243 => 'Lens' },
	'lensafstopbutton' => { 45 => 0x11, 46 => 0x13, 47 => 0x506, 48 => 0x10, 49 => 0x12, 52 => 0x13, 53 => 0x9 },
	'lensaperturerange' => { 229 => 0x30 },
	'lensdistortionparams' => { 184 => 0x206 },
	'lensdrivenoaf' => { 47 => 0x505 },
	'lensfirmware' => { 224 => 0x20 },
	'lensfirmwareversion' => { 180 => 0x204 },
	'lensfocalrange' => { 229 => 0xa },
	'lensfstops' => { 136 => 0x7, 137 => 0xc, 138 => 0xd, 139 => 0x8b, 210 => '0.3' },
	'lensid' => { 243 => 'LensID' },
	'lensidnumber' => { 136 => 0x6, 137 => 0xb, 138 => 0xc },
	'lensinfo' => { 70 => 0xa432, 243 => 'LensInfo' },
	'lenskind' => { 210 => 0x1 },
	'lensmake' => { 70 => 0xa433, 104 => 'Make' },
	'lensmanufacturer' => { 241 => 'LensManufacturer' },
	'lensmodel' => { 2 => 0x937, 8 => 0x92b, 9 => 0x933, 34 => 0x95, 70 => 0xa434, 104 => 'Model', 180 => 0x203, 241 => 'LensModel' },
	'lensproperties' => { 180 => 0x20b },
	'lensserialnumber' => { 70 => 0xa435, 104 => 'SerialNumber', 180 => 0x202, 199 => 0x52, 224 => 0x30 },
	'lensshutterlock' => { 114 => 0x4a },
	'lenstemperature' => { 184 => 0x1008 },
	'lenstype' => { 2 => 0xe2, 3 => 0xd, 4 => 0xc, 5 => 0x111, 6 => 0xc, 8 => 0xd6, 9 => 0xde, 10 => 0xf6, 11 => 0xea, 12 => 0xff, 13 => [0xc,0x97], 14 => 0xe6, 16 => 0xee, 20 => 0x16, 115 => 0x10c, 139 => 0x83, 180 => 0x201, 191 => 0x16, 197 => 0x303, 198 => 0x0, 199 => 0x51, 200 => 0x3405, 211 => 0x0, 212 => 0x0, 213 => 0x3f, 227 => 0xa003, 232 => 0xb027 },
	'levelgaugepitch' => { 179 => 0x904 },
	'levelgaugeroll' => { 179 => 0x903 },
	'license' => { 244 => 'license' },
	'licenseeid' => { 254 => 'LicenseeLicenseeID' },
	'licenseeimageid' => { 254 => 'LicenseeImageID' },
	'licenseeimagenotes' => { 254 => 'LicenseeImageNotes' },
	'licenseename' => { 254 => 'LicenseeLicenseeName' },
	'licenseenddate' => { 254 => 'LicenseEndDate' },
	'licenseeprojectreference' => { 254 => 'LicenseeProjectReference' },
	'licenseetransactionid' => { 254 => 'LicenseeTransactionID' },
	'licenseid' => { 254 => 'LicenseID' },
	'licensestartdate' => { 254 => 'LicenseStartDate' },
	'licensetransactiondate' => { 254 => 'LicenseTransactionDate' },
	'licensetype' => { 247 => 'licensetype' },
	'licensorcity' => { 254 => 'LicensorLicensorCity' },
	'licensorcountry' => { 254 => 'LicensorLicensorCountry' },
	'licensoremail' => { 254 => 'LicensorLicensorEmail' },
	'licensorextendedaddress' => { 254 => 'LicensorLicensorExtendedAddress' },
	'licensorid' => { 254 => 'LicensorLicensorID' },
	'licensorimageid' => { 254 => 'LicensorImageID' },
	'licensorname' => { 254 => 'LicensorLicensorName' },
	'licensornotes' => { 254 => 'LicensorNotes' },
	'licensorpostalcode' => { 254 => 'LicensorLicensorPostalCode' },
	'licensorregion' => { 254 => 'LicensorLicensorRegion' },
	'licensorstreetaddress' => { 254 => 'LicensorLicensorStreetAddress' },
	'licensortelephone1' => { 254 => 'LicensorLicensorTelephone1' },
	'licensortelephone2' => { 254 => 'LicensorLicensorTelephone2' },
	'licensortelephonetype1' => { 254 => 'LicensorLicensorTelephoneType1' },
	'licensortelephonetype2' => { 254 => 'LicensorLicensorTelephoneType2' },
	'licensortransactionid' => { 254 => 'LicensorTransactionID' },
	'licensorurl' => { 254 => 'LicensorLicensorURL' },
	'lightcondition' => { 184 => 0x1009 },
	'lightingmode' => { 67 => 0x302a },
	'lightreading' => { 213 => 0x15 },
	'lightsource' => { 70 => 0x9208, 139 => 0x90, 187 => 0x1000, 249 => 'LightSource' },
	'lightsourcespecial' => { 228 => 0x21d },
	'lightswitch' => { 178 => '0.1' },
	'lightvaluecenter' => { 184 => 0x103d },
	'lightvalueperiphery' => { 184 => 0x103e },
	'linearresponselimit' => { 70 => 0xc62e },
	'liveviewaf' => { 176 => '32.1', 178 => '34.1' },
	'liveviewexposuresimulation' => { 47 => 0x810 },
	'liveviewshooting' => { 30 => 0x13 },
	'localafareapoint' => { 114 => 0xd, 230 => 0x12, 231 => 0x12 },
	'localcaption' => { 76 => 0x79 },
	'localizedcameramodel' => { 70 => 0xc615 },
	'location' => { 240 => 'Location', 250 => 'Location', 255 => 'location' },
	'locationcreatedcity' => { 251 => 'LocationCreatedCity' },
	'locationcreatedcountrycode' => { 251 => 'LocationCreatedCountryCode' },
	'locationcreatedcountryname' => { 251 => 'LocationCreatedCountryName' },
	'locationcreatedprovincestate' => { 251 => 'LocationCreatedProvinceState' },
	'locationcreatedsublocation' => { 251 => 'LocationCreatedSublocation' },
	'locationcreatedworldregion' => { 251 => 'LocationCreatedWorldRegion' },
	'locationshowncity' => { 251 => 'LocationShownCity' },
	'locationshowncountrycode' => { 251 => 'LocationShownCountryCode' },
	'locationshowncountryname' => { 251 => 'LocationShownCountryName' },
	'locationshownprovincestate' => { 251 => 'LocationShownProvinceState' },
	'locationshownsublocation' => { 251 => 'LocationShownSublocation' },
	'locationshownworldregion' => { 251 => 'LocationShownWorldRegion' },
	'lockmicrophonebutton' => { 47 => 0x709 },
	'logcomment' => { 264 => 'logComment' },
	'longexposurenoisereduction' => { 47 => 0x201, 48 => 0x1, 49 => 0x2, 50 => 0x1, 51 => 0x1, 52 => 0x2, 53 => 0x1, 230 => 0x2b, 232 => 0xb04e },
	'longexposurenoisereduction2' => { 30 => 0x8 },
	'longfocal' => { 3 => 0x10, 4 => 0x13, 5 => 0x115, 6 => 0x13, 8 => 0xda, 10 => 0xfa, 11 => 0xee, 12 => 0x103, 13 => 0x95, 14 => 0xea, 16 => 0xf2, 20 => 0x17 },
	'loop' => { 264 => 'loop' },
	'luminanceadjustmentaqua' => { 245 => 'LuminanceAdjustmentAqua' },
	'luminanceadjustmentblue' => { 245 => 'LuminanceAdjustmentBlue' },
	'luminanceadjustmentgreen' => { 245 => 'LuminanceAdjustmentGreen' },
	'luminanceadjustmentmagenta' => { 245 => 'LuminanceAdjustmentMagenta' },
	'luminanceadjustmentorange' => { 245 => 'LuminanceAdjustmentOrange' },
	'luminanceadjustmentpurple' => { 245 => 'LuminanceAdjustmentPurple' },
	'luminanceadjustmentred' => { 245 => 'LuminanceAdjustmentRed' },
	'luminanceadjustmentyellow' => { 245 => 'LuminanceAdjustmentYellow' },
	'luminancecurvelimits' => { 64 => 0x150 },
	'luminancecurvepoints' => { 64 => 0x126 },
	'luminancenoisereduction' => { 65 => 0x5f },
	'luminancenr_tiff_jpeg' => { 65 => 0x6d },
	'luminancesmoothing' => { 245 => 'LuminanceSmoothing' },
	'm16cversion' => { 194 => 0x333 },
	'macro' => { 74 => 0x1020, 184 => 0x202, 222 => 0x21, 228 => 0x202, 232 => 0xb040 },
	'macromagnification' => { 2 => 0x1b, 5 => 0x1b, 8 => 0x1b, 9 => 0x1b, 13 => 0x1b, 14 => 0x1b, 30 => 0x10 },
	'macromode' => { 20 => 0x1, 111 => 0xb, 179 => 0x300, 199 => 0x1c },
	'magicfilter' => { 179 => 0x52c },
	'magnifiedview' => { 49 => 0x11, 51 => 0x9 },
	'maindialexposurecomp' => { 177 => '0.6' },
	'make' => { 61 => 0x0, 70 => 0x10f, 97 => 'Make', 190 => 'Make', 201 => 0x10f, 260 => 'Make' },
	'makernote' => { 249 => 'MakerNote' },
	'makernotecanon' => { 69 => 'MakN', 70 => 0x927c },
	'makernotecasio' => { 69 => 'MakN', 70 => 0x927c },
	'makernotecasio2' => { 69 => 'MakN', 70 => 0x927c },
	'makernotefujifilm' => { 69 => 'MakN', 70 => 0x927c },
	'makernotehp' => { 69 => 'MakN', 70 => 0x927c },
	'makernotehp2' => { 69 => 'MakN', 70 => 0x927c },
	'makernotehp4' => { 69 => 'MakN', 70 => 0x927c },
	'makernotehp6' => { 69 => 'MakN', 70 => 0x927c },
	'makernoteisl' => { 69 => 'MakN', 70 => 0x927c },
	'makernotejvc' => { 69 => 'MakN', 70 => 0x927c },
	'makernotejvctext' => { 69 => 'MakN', 70 => 0x927c },
	'makernotekodak10' => { 69 => 'MakN', 70 => 0x927c },
	'makernotekodak1a' => { 69 => 'MakN', 70 => 0x927c },
	'makernotekodak1b' => { 69 => 'MakN', 70 => 0x927c },
	'makernotekodak2' => { 69 => 'MakN', 70 => 0x927c },
	'makernotekodak3' => { 69 => 'MakN', 70 => 0x927c },
	'makernotekodak4' => { 69 => 'MakN', 70 => 0x927c },
	'makernotekodak5' => { 69 => 'MakN', 70 => 0x927c },
	'makernotekodak6a' => { 69 => 'MakN', 70 => 0x927c },
	'makernotekodak6b' => { 69 => 'MakN', 70 => 0x927c },
	'makernotekodak7' => { 69 => 'MakN', 70 => 0x927c },
	'makernotekodak8a' => { 69 => 'MakN', 70 => 0x927c },
	'makernotekodak8b' => { 69 => 'MakN', 70 => 0x927c },
	'makernotekodak9' => { 69 => 'MakN', 70 => 0x927c },
	'makernotekodakunknown' => { 69 => 'MakN', 70 => 0x927c },
	'makernotekyocera' => { 69 => 'MakN', 70 => 0x927c },
	'makernoteleica' => { 69 => 'MakN', 70 => 0x927c },
	'makernoteleica2' => { 69 => 'MakN', 70 => 0x927c },
	'makernoteleica3' => { 69 => 'MakN', 70 => 0x927c },
	'makernoteleica4' => { 69 => 'MakN', 70 => 0x927c },
	'makernoteleica5' => { 69 => 'MakN', 70 => 0x927c },
	'makernoteleica6' => { 69 => 'MakN', 70 => 0x927c },
	'makernoteminolta' => { 69 => 'MakN', 70 => 0x927c },
	'makernoteminolta2' => { 69 => 'MakN', 70 => 0x927c },
	'makernoteminolta3' => { 69 => 'MakN', 70 => 0x927c },
	'makernotenikon' => { 69 => 'MakN', 70 => 0x927c },
	'makernotenikon2' => { 69 => 'MakN', 70 => 0x927c },
	'makernotenikon3' => { 69 => 'MakN', 70 => 0x927c },
	'makernoteoffset' => { 228 => 0xff },
	'makernoteolympus' => { 69 => 'MakN', 70 => 0x927c },
	'makernoteolympus2' => { 69 => 'MakN', 70 => 0x927c },
	'makernotepanasonic' => { 69 => 'MakN', 70 => 0x927c },
	'makernotepanasonic2' => { 69 => 'MakN', 70 => 0x927c },
	'makernotepentax' => { 69 => 'MakN', 70 => 0x927c },
	'makernotepentax2' => { 69 => 'MakN', 70 => 0x927c },
	'makernotepentax3' => { 69 => 'MakN', 70 => 0x927c },
	'makernotepentax4' => { 69 => 'MakN', 70 => 0x927c },
	'makernotericoh' => { 69 => 'MakN', 70 => 0x927c },
	'makernotericohtext' => { 69 => 'MakN', 70 => 0x927c },
	'makernotesafety' => { 70 => 0xc635 },
	'makernotesamsung1a' => { 69 => 'MakN', 70 => 0x927c },
	'makernotesamsung1b' => { 69 => 'MakN', 70 => 0x927c },
	'makernotesamsung2' => { 69 => 'MakN', 70 => 0x927c },
	'makernotesanyo' => { 69 => 'MakN', 70 => 0x927c },
	'makernotesanyoc4' => { 69 => 'MakN', 70 => 0x927c },
	'makernotesanyopatch' => { 69 => 'MakN', 70 => 0x927c },
	'makernotesigma' => { 69 => 'MakN', 70 => 0x927c },
	'makernotesony' => { 69 => 'MakN', 70 => 0x927c },
	'makernotesony2' => { 69 => 'MakN', 70 => 0x927c },
	'makernotesony3' => { 69 => 'MakN', 70 => 0x927c },
	'makernotesony4' => { 69 => 'MakN', 70 => 0x927c },
	'makernotesonysrf' => { 69 => 'MakN', 70 => 0x927c },
	'makernotetype' => { 223 => 0x1 },
	'makernoteunknown' => { 69 => 'MakN', 70 => 0x927c },
	'makernoteversion' => { 115 => 0x0, 139 => 0x1, 184 => 0x0, 199 => 0x8000, 226 => 0x0, 227 => 0x1, 229 => 0x1d },
	'managedfromalternatepaths' => { 265 => 'ManagedFromAlternatePaths' },
	'managedfromdocumentid' => { 265 => 'ManagedFromDocumentID' },
	'managedfromfilepath' => { 265 => 'ManagedFromFilePath' },
	'managedfromfrompart' => { 265 => 'ManagedFromFromPart' },
	'managedfrominstanceid' => { 265 => 'ManagedFromInstanceID' },
	'managedfromlastmodifydate' => { 265 => 'ManagedFromLastModifyDate' },
	'managedfrommanager' => { 265 => 'ManagedFromManager' },
	'managedfrommanagervariant' => { 265 => 'ManagedFromManagerVariant' },
	'managedfrommanageto' => { 265 => 'ManagedFromManageTo' },
	'managedfrommanageui' => { 265 => 'ManagedFromManageUI' },
	'managedfrommaskmarkers' => { 265 => 'ManagedFromMaskMarkers' },
	'managedfromoriginaldocumentid' => { 265 => 'ManagedFromOriginalDocumentID' },
	'managedfrompartmapping' => { 265 => 'ManagedFromPartMapping' },
	'managedfromrenditionclass' => { 265 => 'ManagedFromRenditionClass' },
	'managedfromrenditionparams' => { 265 => 'ManagedFromRenditionParams' },
	'managedfromtopart' => { 265 => 'ManagedFromToPart' },
	'managedfromversionid' => { 265 => 'ManagedFromVersionID' },
	'manager' => { 265 => 'Manager' },
	'managervariant' => { 265 => 'ManagerVariant' },
	'manageto' => { 265 => 'ManageTo' },
	'manageui' => { 265 => 'ManageUI' },
	'manometerpressure' => { 179 => 0x900 },
	'manometerreading' => { 179 => 0x901 },
	'manualafpointselectpattern' => { 47 => 0x513 },
	'manualexposuretime' => { 114 => 0x6 },
	'manualflash' => { 182 => 0x1209 },
	'manualflashoutput' => { 20 => 0x29, 175 => '8.2', 176 => '22.2', 177 => '8.2', 178 => '24.2' },
	'manualflashstrength' => { 179 => 0x406 },
	'manualfnumber' => { 114 => 0x7 },
	'manualfocusdistance' => { 139 => 0x85, 184 => 0x100c, 228 => 0x223 },
	'manualtv' => { 46 => 0x5, 47 => 0x705 },
	'manufacturedate' => { 205 => 0x1 },
	'manufacturedate1' => { 225 => 0x4 },
	'manufacturedate2' => { 225 => 0x5 },
	'marked' => { 252 => 'Marked', 268 => 'Marked' },
	'markerscomment' => { 264 => 'markersComment' },
	'markerscuepointparamskey' => { 264 => 'markersCuePointParamsKey' },
	'markerscuepointparamsvalue' => { 264 => 'markersCuePointParamsValue' },
	'markerscuepointtype' => { 264 => 'markersCuePointType' },
	'markersduration' => { 264 => 'markersDuration' },
	'markerslocation' => { 264 => 'markersLocation' },
	'markersname' => { 264 => 'markersName' },
	'markersprobability' => { 264 => 'markersProbability' },
	'markersspeaker' => { 264 => 'markersSpeaker' },
	'markersstarttime' => { 264 => 'markersStartTime' },
	'markerstarget' => { 264 => 'markersTarget' },
	'markerstype' => { 264 => 'markersType' },
	'maskedareas' => { 70 => 0xc68e },
	'masterdocumentid' => { 76 => 0xb9 },
	'mastergain' => { 144 => 0x50 },
	'maxaperture' => { 20 => 0x1a, 87 => 0x6103, 104 => 'MaxAperture', 111 => 0x17, 210 => '14.1' },
	'maxapertureatcurrentfocal' => { 180 => 0x20a },
	'maxapertureatmaxfocal' => { 74 => 0x1407, 104 => 'MaxApertureAtMaxFocal', 136 => 0xb, 137 => 0x10, 138 => 0x11, 180 => 0x206 },
	'maxapertureatminfocal' => { 74 => 0x1406, 136 => 0xa, 137 => 0xf, 138 => 0x10, 180 => 0x205 },
	'maxaperturevalue' => { 70 => 0x9205, 249 => 'MaxApertureValue' },
	'maxavailheight' => { 251 => 'MaxAvailHeight' },
	'maxavailwidth' => { 251 => 'MaxAvailWidth' },
	'maxcontinuousrelease' => { 174 => 0xb },
	'maxfocallength' => { 74 => 0x1405, 104 => 'MaxFocalLength', 136 => 0x9, 137 => 0xe, 138 => 0xf, 180 => 0x208 },
	'maximumdensityrange' => { 78 => 0x8c },
	'maxpagesizeh' => { 269 => 'MaxPageSizeH' },
	'maxpagesizeunit' => { 269 => 'MaxPageSizeUnit' },
	'maxpagesizew' => { 269 => 'MaxPageSizeW' },
	'maxsamplevalue' => { 70 => 0x119 },
	'mb-d10batteries' => { 174 => '12.6' },
	'mb-d80batteries' => { 177 => '6.5' },
	'mb-d80batterytype' => { 178 => '3.2' },
	'mcuversion' => { 136 => 0xc, 137 => 0x11, 138 => 0x12 },
	'md5digest' => { 105 => 'zmd5' },
	'measuredev' => { 15 => 0x9, 42 => 0x3, 60 => 0x1814, 97 => 'MeasuredEV' },
	'measuredev2' => { 15 => 0x8, 42 => 0x17 },
	'measuredlv' => { 194 => 0x312, 200 => 0x3407 },
	'measuredrggb' => { 35 => 0x1 },
	'measuredrggbdata' => { 24 => 0x287 },
	'mediaconstraints' => { 254 => 'MediaConstraints' },
	'mediasummarycode' => { 254 => 'MediaSummaryCode' },
	'menubuttondisplayposition' => { 45 => 0xb, 48 => 0xa, 49 => 0xb, 52 => 0xb },
	'menubuttonreturn' => { 53 => 0xb },
	'menumonitorofftime' => { 178 => '22.1' },
	'metadatadate' => { 262 => 'MetadataDate' },
	'metadatamoddate' => { 264 => 'metadataModDate' },
	'metering' => { 175 => '6.1' },
	'meteringmode' => { 20 => 0x11, 70 => 0x9207, 83 => 0x1c, 111 => 0x7, 112 => 0x25, 114 => 0x12, 179 => 0x202, 213 => 0x17, 229 => 0x9, 230 => 0x15, 231 => 0x13, 249 => 'MeteringMode' },
	'meteringmode2' => { 206 => '2.1' },
	'meteringmode3' => { 206 => '16.1' },
	'meteringoffscaleindicator' => { 114 => 0x53 },
	'meteringtime' => { 174 => '22.2', 175 => '3.2', 176 => '17.1', 177 => '3.2', 178 => '19.1' },
	'mieversion' => { 105 => '0Vers' },
	'minaperture' => { 20 => 0x1b, 104 => 'MinAperture', 210 => '0.2' },
	'minfocallength' => { 74 => 0x1404, 104 => 'MinFocalLength', 136 => 0x8, 137 => 0xd, 138 => 0xe, 180 => 0x207 },
	'minoltadate' => { 111 => 0x15 },
	'minoltaimagesize' => { 111 => 0x4, 112 => 0xc, 113 => 0x2, 115 => 0x103 },
	'minoltamodelid' => { 111 => 0x25 },
	'minoltaquality' => { 111 => 0x5, 112 => 0xd, 113 => 0x3, 115 => [0x102,0x103] },
	'minoltatime' => { 111 => 0x16 },
	'minormodelagedisclosure' => { 254 => 'MinorModelAgeDisclosure' },
	'minsamplevalue' => { 70 => 0x118 },
	'mirrorlockup' => { 45 => 0xc, 46 => 0xc, 47 => 0x60f, 48 => 0xb, 49 => 0xc, 50 => 0x6, 51 => 0x6, 52 => 0xc, 53 => 0x3 },
	'moddate' => { 190 => 'modify-date', 252 => 'ModDate' },
	'model' => { 61 => 0x6, 70 => 0x110, 97 => 'Model', 190 => 'Model', 201 => 0x110, 260 => 'Model' },
	'modelage' => { 251 => 'ModelAge' },
	'modelingflash' => { 174 => '21.4', 177 => '7.4', 178 => '31.3' },
	'modelreleaseid' => { 254 => 'ModelReleaseID' },
	'modelreleasestatus' => { 254 => 'ModelReleaseStatus' },
	'modificationdate' => { 255 => 'modificationDate' },
	'modifiedcolortemp' => { 36 => 0x9 },
	'modifieddigitalgain' => { 36 => 0xb },
	'modifiedparamflag' => { 31 => 0x1 },
	'modifiedpicturestyle' => { 36 => 0xa },
	'modifiedsaturation' => { 179 => 0x504 },
	'modifiedsensorbluelevel' => { 36 => 0x5 },
	'modifiedsensorredlevel' => { 36 => 0x4 },
	'modifiedsharpness' => { 36 => 0x2 },
	'modifiedsharpnessfreq' => { 36 => 0x3 },
	'modifiedtonecurve' => { 36 => 0x1 },
	'modifiedwhitebalance' => { 36 => 0x8 },
	'modifiedwhitebalanceblue' => { 36 => 0x7 },
	'modifiedwhitebalancered' => { 36 => 0x6 },
	'modifydate' => { 70 => 0x132, 98 => 'ModifyDate', 188 => 'ModDate', 189 => 'tIME', 221 => 'ModDate', 262 => 'ModifyDate' },
	'moirefilter' => { 70 => 0xfe58, 245 => 'MoireFilter' },
	'monitordisplayoff' => { 114 => 0x4c },
	'monitorofftime' => { 174 => '18.2', 175 => '3.1', 177 => '3.1' },
	'monochromecontrast' => { 65 => 0x3c },
	'monochromefiltereffect' => { 65 => 0x3a },
	'monochromelinear' => { 65 => 0x3d },
	'monochromeoutputhighlightpoint' => { 65 => 0x41 },
	'monochromeoutputshadowpoint' => { 65 => 0x42 },
	'monochromerawhighlight' => { 65 => 0x7a },
	'monochromerawhighlightpoint' => { 65 => 0x3f },
	'monochromerawshadow' => { 65 => 0x83 },
	'monochromerawshadowpoint' => { 65 => 0x40 },
	'monochromesharpness' => { 65 => 0x3e },
	'monochrometoningeffect' => { 65 => 0x3b },
	'monthdaycreated' => { 83 => 0x12, 92 => 0xe },
	'morepermissions' => { 244 => 'morePermissions' },
	'multiburstimageheight' => { 232 => 0x1002 },
	'multiburstimagewidth' => { 232 => 0x1001 },
	'multiburstmode' => { 232 => 0x1000 },
	'multicontrollerwhilemetering' => { 47 => 0x517 },
	'multiexposureautogain' => { 140 => 0x3 },
	'multiexposuremode' => { 140 => 0x1 },
	'multiexposureshots' => { 140 => 0x2 },
	'multipleexposuremode' => { 183 => 0x101c },
	'multipleexposureset' => { 206 => '10.1' },
	'multisample' => { 144 => 0x40 },
	'multiselector' => { 174 => '9.4' },
	'multiselectorplaybackmode' => { 174 => '9.2' },
	'multiselectorshootmode' => { 174 => '9.1' },
	'mycolormode' => { 37 => 0x2 },
	'nativedigest' => { 249 => 'NativeDigest', 260 => 'NativeDigest' },
	'ncdfileinfo' => { 81 => 0x414 },
	'ndfilter' => { 42 => 0x1c },
	'nearlensstep' => { 184 => 0x103c },
	'nefbitdepth' => { 139 => 0xe22 },
	'nefcompression' => { 139 => 0x93 },
	'neutraloutputhighlightpoint' => { 65 => 0x2f },
	'neutraloutputshadowpoint' => { 65 => 0x30 },
	'neutralrawcolortone' => { 65 => 0x28 },
	'neutralrawcontrast' => { 65 => 0x2a },
	'neutralrawhighlight' => { 65 => 0x78 },
	'neutralrawhighlightpoint' => { 65 => 0x2d },
	'neutralrawlinear' => { 65 => 0x2b },
	'neutralrawsaturation' => { 65 => 0x29 },
	'neutralrawshadow' => { 65 => 0x81 },
	'neutralrawshadowpoint' => { 65 => 0x2e },
	'neutralrawsharpness' => { 65 => 0x2c },
	'newsphotoversion' => { 78 => 0x0 },
	'nickname' => { 262 => 'Nickname' },
	'nikoncaptureversion' => { 139 => 0xe09 },
	'nikoniccprofile' => { 139 => 0xe1d },
	'nikonimagesize' => { 151 => '723.1', 152 => '732.1', 155 => 0x2c4 },
	'noisefilter' => { 179 => 0x527 },
	'noisereduction' => { 74 => 0x100b, 112 => 0xb0, 113 => 0x60, 114 => 0x3f, 139 => 0x95, 167 => 0x753dcbc0, 168 => 0x17, 179 => 0x50a, 184 => 0x103a, 199 => 0x2d, 213 => 0x49 },
	'noisereduction2' => { 183 => 0x1010 },
	'noisereductionapplied' => { 70 => 0xc6f7 },
	'noisereductionintensity' => { 168 => 0x9 },
	'noisereductionmethod' => { 168 => 0x11 },
	'noisereductionmode' => { 235 => 0x801e },
	'noisereductionsharpness' => { 168 => 0xd },
	'noisereductionvalue' => { 235 => 0x8027 },
	'nomemorycard' => { 174 => '22.1', 175 => '0.3', 176 => '2.4', 177 => '0.3', 178 => '4.5' },
	'nominalmaxaperture' => { 210 => 0xa },
	'nominalminaperture' => { 210 => '10.1' },
	'notes' => { 236 => 'Notes', 242 => 'notes' },
	'npages' => { 269 => 'NPages' },
	'nullrecord' => { 60 => 0x0 },
	'number' => { 255 => 'number' },
	'numberofbeats' => { 264 => 'numberOfBeats' },
	'numfacepositions' => { 192 => 0x0 },
	'numindexentries' => { 78 => 0x54 },
	'object' => { 255 => 'object' },
	'objectattributereference' => { 76 => 0x4 },
	'objectcycle' => { 76 => 0x4b },
	'objectdistance' => { 66 => 0x6, 67 => 0x2022 },
	'objectname' => { 76 => 0x5 },
	'objectpreviewdata' => { 76 => 0xca },
	'objectpreviewfileformat' => { 76 => 0xc8 },
	'objectpreviewfileversion' => { 76 => 0xc9 },
	'objecttypereference' => { 76 => 0x3 },
	'oecfcolumns' => { 249 => 'OECFColumns' },
	'oecfnames' => { 249 => 'OECFNames' },
	'oecfrows' => { 249 => 'OECFRows' },
	'oecfvalues' => { 249 => 'OECFValues' },
	'offsetschema' => { 70 => 0xea1d },
	'okbutton' => { 178 => '16.1' },
	'oldsubfiletype' => { 70 => 0xff },
	'olympusimageheight' => { 184 => 0x102f },
	'olympusimagewidth' => { 184 => 0x102e },
	'onetouchwb' => { 184 => 0x302 },
	'opticalzoom' => { 85 => 0xfa3d, 87 => [0x6006,0xf006], 88 => 0x1000, 89 => 0xf, 92 => 0x1e, 104 => 'OpticalZoom' },
	'opticalzoomcode' => { 42 => 0xa },
	'opticalzoommode' => { 199 => 0x34 },
	'opticalzoomon' => { 228 => 0x219 },
	'optionenddate' => { 257 => 'optionEndDate' },
	'ordernumber' => { 74 => 0x8002 },
	'organisationinimagecode' => { 251 => 'OrganisationInImageCode' },
	'organisationinimagename' => { 251 => 'OrganisationInImageName' },
	'organization' => { 255 => 'organization' },
	'orientation' => { 70 => 0x112, 201 => 0x112, 260 => 'Orientation' },
	'orientationlinkedafpoint' => { 47 => 0x516 },
	'originaldecisiondata' => { 68 => 'OriginalDecisionData' },
	'originaldecisiondataoffset' => { 34 => 0x83 },
	'originaldirectory' => { 196 => 0x408 },
	'originaldocumentid' => { 265 => 'OriginalDocumentID' },
	'originalfilename' => { 60 => 0x816, 81 => 0x3e9, 93 => 0x20, 196 => 0x407 },
	'originalimageheight' => { 43 => 0xc, 73 => 0x1 },
	'originalimagewidth' => { 43 => 0xb, 73 => 0x0 },
	'originalrawfiledata' => { 70 => 0xc68c },
	'originalrawfiledigest' => { 70 => 0xc71d },
	'originalrawfilename' => { 70 => 0xc68b },
	'originaltransmissionreference' => { 76 => 0x67 },
	'originatingprogram' => { 76 => 0x41 },
	'originplatform' => { 255 => 'originPlatform' },
	'os' => { 247 => 'os' },
	'otherconditions' => { 254 => 'OtherConditions' },
	'otherconstraints' => { 254 => 'OtherConstraints' },
	'otherimageinfo' => { 254 => 'OtherImageInfo' },
	'otherlicensedocuments' => { 254 => 'OtherLicenseDocuments' },
	'otherlicenseinfo' => { 254 => 'OtherLicenseInfo' },
	'otherlicenserequirements' => { 254 => 'OtherLicenseRequirements' },
	'outcuescale' => { 264 => 'outCueScale' },
	'outcuevalue' => { 264 => 'outCueValue' },
	'outputimageheight' => { 123 => 0x3 },
	'outputimagewidth' => { 123 => 0x2 },
	'outputresolution' => { 123 => 0x4 },
	'owner' => { 268 => 'Owner' },
	'ownerid' => { 76 => 0xbc },
	'ownername' => { 34 => 0x9, 60 => 0x810, 70 => [0xa430,0xfde8], 97 => 'OwnerName', 243 => 'OwnerName' },
	'padding' => { 70 => 0xea1c },
	'pageimage' => { 262 => 'PageInfoImage' },
	'pageimageformat' => { 262 => 'PageInfoFormat' },
	'pageimageheight' => { 262 => 'PageInfoHeight' },
	'pageimagepagenumber' => { 262 => 'PageInfoPageNumber' },
	'pageimagewidth' => { 262 => 'PageInfoWidth' },
	'pagename' => { 70 => 0x11d },
	'pagenumber' => { 70 => 0x129 },
	'pagerange' => { 255 => 'pageRange' },
	'panasonicexifversion' => { 199 => 0x26 },
	'panasonicrawversion' => { 201 => 0x1 },
	'panasonictitle' => { 70 => 0xc6d2 },
	'panasonictitle2' => { 70 => 0xc6d3 },
	'panoramacropbottom' => { 233 => 0x7 },
	'panoramacropleft' => { 233 => 0x4 },
	'panoramacropright' => { 233 => 0x6 },
	'panoramacroptop' => { 233 => 0x5 },
	'panoramadirection' => { 38 => 0x5, 233 => 0x3 },
	'panoramaframeheight' => { 233 => 0x9 },
	'panoramaframenumber' => { 38 => 0x2 },
	'panoramaframewidth' => { 233 => 0x8 },
	'panoramafullheight' => { 233 => 0x2 },
	'panoramafullwidth' => { 233 => 0x1 },
	'panoramamode' => { 83 => 0x3c, 179 => 0x601 },
	'panoramasourceheight' => { 233 => 0xb },
	'panoramasourcewidth' => { 233 => 0xa },
	'parallax' => { 74 => 0xb211 },
	'parametricdarks' => { 245 => 'ParametricDarks' },
	'parametrichighlights' => { 245 => 'ParametricHighlights' },
	'parametrichighlightsplit' => { 245 => 'ParametricHighlightSplit' },
	'parametriclights' => { 245 => 'ParametricLights' },
	'parametricmidtonesplit' => { 245 => 'ParametricMidtoneSplit' },
	'parametricshadows' => { 245 => 'ParametricShadows' },
	'parametricshadowsplit' => { 245 => 'ParametricShadowSplit' },
	'patientbirthdate' => { 237 => 'PatientDOB' },
	'patientid' => { 237 => 'PatientID' },
	'patientname' => { 237 => 'PatientName' },
	'patientsex' => { 237 => 'PatientSex' },
	'pdfversion' => { 252 => 'PDFVersion' },
	'pentaximagesize' => { 213 => 0x9 },
	'pentaxmodelid' => { 205 => 0x0, 213 => 0x5 },
	'pentaxmodeltype' => { 213 => 0x1 },
	'pentaxversion' => { 213 => 0x0 },
	'people' => { 240 => 'People' },
	'peripheralillumcentralradius' => { 235 => 0x8030 },
	'peripheralillumcentralvalue' => { 235 => 0x8031 },
	'peripheralillumination' => { 65 => 0x68 },
	'peripheralilluminationon' => { 65 => 0x64 },
	'peripheralillumperiphvalue' => { 235 => 0x8032 },
	'peripherallighting' => { 43 => 0x2 },
	'peripherallightingsetting' => { 44 => 0x5 },
	'peripherallightingvalue' => { 43 => 0x6 },
	'permissions' => { 257 => 'permissions' },
	'person' => { 255 => 'person' },
	'personinimage' => { 251 => 'PersonInImage' },
	'pf0customfuncregistration' => { 55 => 0x1 },
	'pf10retainprogramshift' => { 55 => 0xb },
	'pf13drivepriority' => { 55 => 0xe },
	'pf14disablefocussearch' => { 55 => 0xf },
	'pf15disableafassistbeam' => { 55 => 0x10 },
	'pf16autofocuspointshoot' => { 55 => 0x11 },
	'pf17disableafpointsel' => { 55 => 0x12 },
	'pf18enableautoafpointsel' => { 55 => 0x13 },
	'pf19continuousshootspeed' => { 55 => 0x14 },
	'pf19shootingspeedhigh' => { 54 => 0xa },
	'pf19shootingspeedlow' => { 54 => 0x9 },
	'pf1disableshootingmodes' => { 55 => 0x2 },
	'pf1value' => { 54 => 0x1 },
	'pf20limitcontinousshots' => { 55 => 0x15 },
	'pf20maxcontinousshots' => { 54 => 0xb },
	'pf21enablequietoperation' => { 55 => 0x16 },
	'pf23felocktime' => { 54 => 0xd },
	'pf23postreleasetime' => { 54 => 0xe },
	'pf23settimerlengths' => { 55 => 0x18 },
	'pf23shutterbuttontime' => { 54 => 0xc },
	'pf24lightlcdduringbulb' => { 55 => 0x19 },
	'pf25aemode' => { 54 => 0xf },
	'pf25afmode' => { 54 => 0x12 },
	'pf25afpointsel' => { 54 => 0x13 },
	'pf25colormatrix' => { 54 => 0x17 },
	'pf25defaultclearsettings' => { 55 => 0x1a },
	'pf25drivemode' => { 54 => 0x11 },
	'pf25imagesize' => { 54 => 0x14 },
	'pf25meteringmode' => { 54 => 0x10 },
	'pf25parameters' => { 54 => 0x16 },
	'pf25wbmode' => { 54 => 0x15 },
	'pf26shortenreleaselag' => { 55 => 0x1b },
	'pf27reversedialrotation' => { 55 => 0x1c },
	'pf27value' => { 54 => 0x18 },
	'pf28noquickdialexpcomp' => { 55 => 0x1d },
	'pf29quickdialswitchoff' => { 55 => 0x1e },
	'pf2disablemeteringmodes' => { 55 => 0x3 },
	'pf2value' => { 54 => 0x2 },
	'pf30enlargementmode' => { 55 => 0x1f },
	'pf31originaldecisiondata' => { 55 => 0x20 },
	'pf3manualexposuremetering' => { 55 => 0x4 },
	'pf3value' => { 54 => 0x3 },
	'pf4exposuretimelimits' => { 55 => 0x5 },
	'pf4exposuretimemax' => { 54 => 0x5 },
	'pf4exposuretimemin' => { 54 => 0x4 },
	'pf5aperturelimits' => { 55 => 0x6 },
	'pf5aperturemax' => { 54 => 0x7 },
	'pf5aperturemin' => { 54 => 0x6 },
	'pf6presetshootingmodes' => { 55 => 0x7 },
	'pf7bracketcontinuousshoot' => { 55 => 0x8 },
	'pf8bracketshots' => { 54 => 0x8 },
	'pf8setbracketshots' => { 55 => 0x9 },
	'pf9changebracketsequence' => { 55 => 0xa },
	'phasedetectaf' => { 121 => 0x6 },
	'phonenumber' => { 98 => 'Phone' },
	'photoeffect' => { 20 => 0x28 },
	'photoeffects' => { 167 => 0xab5eca5e },
	'photoeffectsblue' => { 169 => 0x8 },
	'photoeffectsgreen' => { 169 => 0x6 },
	'photoeffectsred' => { 169 => 0x4 },
	'photoeffectstype' => { 169 => 0x0 },
	'photoinfoplayback' => { 174 => '17.6' },
	'photometricinterpretation' => { 70 => 0x106, 260 => 'PhotometricInterpretation' },
	'photoshopquality' => { 218 => 0x0 },
	'pictinfo' => { 228 => 0x208 },
	'picturecontrol' => { 167 => 0xe2173c47 },
	'picturecontrolactive' => { 170 => 0x0 },
	'picturecontroladjust' => { 141 => 0x30 },
	'picturecontrolbase' => { 141 => 0x18 },
	'picturecontrolmode' => { 170 => 0x13 },
	'picturecontrolname' => { 141 => 0x4 },
	'picturecontrolquickadjust' => { 141 => 0x31 },
	'picturefinish' => { 112 => 0x71 },
	'picturemode' => { 74 => 0x1031, 179 => 0x520, 213 => [0xb,0x33], 229 => 0x3d },
	'picturemode2' => { 206 => 0x0 },
	'picturemodebwfilter' => { 179 => 0x525 },
	'picturemodecontrast' => { 179 => 0x523 },
	'picturemodehue' => { 179 => 0x522 },
	'picturemodesaturation' => { 179 => 0x521 },
	'picturemodesharpness' => { 179 => 0x524 },
	'picturemodetone' => { 179 => 0x526 },
	'picturestyle' => { 3 => [0x4b,0x51], 4 => 0x6c, 5 => 0x86, 6 => 0x73, 10 => 0xab, 11 => 0xa7, 12 => 0xb0, 13 => 0x6c, 14 => 0xa7, 40 => 0xa, 65 => 0x2 },
	'picturewizard' => { 227 => 0x21 },
	'planarconfiguration' => { 70 => 0x11c, 260 => 'PlanarConfiguration' },
	'platenames' => { 269 => 'PlateNames' },
	'playbackmenustime' => { 176 => '20.1' },
	'playbackmonitorofftime' => { 178 => '21.1' },
	'playdisplay' => { 114 => 0x4e },
	'plusversion' => { 254 => 'Version' },
	'pngwarning' => { 190 => 'Warning' },
	'portraitoutputhighlightpoint' => { 65 => 0x1d },
	'portraitoutputshadowpoint' => { 65 => 0x1e },
	'portraitrawcolortone' => { 65 => 0x16 },
	'portraitrawcontrast' => { 65 => 0x18 },
	'portraitrawhighlight' => { 65 => 0x76 },
	'portraitrawhighlightpoint' => { 65 => 0x1b },
	'portraitrawlinear' => { 65 => 0x19 },
	'portraitrawsaturation' => { 65 => 0x17 },
	'portraitrawshadow' => { 65 => 0x7f },
	'portraitrawshadowpoint' => { 65 => 0x1c },
	'portraitrawsharpness' => { 65 => 0x1a },
	'portraitrefiner' => { 67 => 0x302b },
	'postalcode' => { 102 => 'PostalCode' },
	'postcropvignetteamount' => { 245 => 'PostCropVignetteAmount' },
	'postcropvignettefeather' => { 245 => 'PostCropVignetteFeather' },
	'postcropvignettemidpoint' => { 245 => 'PostCropVignetteMidpoint' },
	'postcropvignetteroundness' => { 245 => 'PostCropVignetteRoundness' },
	'powersource' => { 204 => 0x0 },
	'poweruptime' => { 139 => 0xb6 },
	'precaptureframes' => { 184 => 0x300 },
	'predictor' => { 70 => 0x13d },
	'preflashreturnstrength' => { 152 => 0x28a },
	'prefs' => { 76 => 0xdd, 217 => 'Prefs' },
	'preservedfilename' => { 265 => 'PreservedFileName' },
	'presetwhitebalance' => { 114 => 0x24, 235 => 0x8002 },
	'presetwhitebalanceadj' => { 235 => 0x8014 },
	'previewapplicationname' => { 70 => 0xc716 },
	'previewapplicationversion' => { 70 => 0xc717 },
	'previewbutton' => { 174 => ['14.1','15.1'] },
	'previewbuttonplusdials' => { 174 => ['14.2','15.2'] },
	'previewcolorspace' => { 70 => 0xc71a },
	'previewcropbottom' => { 216 => 0xef },
	'previewcropleft' => { 216 => 0xec },
	'previewcropright' => { 216 => 0xee },
	'previewcroptop' => { 216 => 0xed },
	'previewdatetime' => { 70 => 0xc71b },
	'previewheight' => { 85 => 0xfa58 },
	'previewimage' => { 67 => 0x2000, 68 => 'PreviewImage', 71 => 'PreviewImage', 72 => 0x4, 107 => 'data', 115 => 0x81, 184 => 0x280, 197 => 0x300, 232 => 0x2001 },
	'previewimageborders' => { 213 => 0x3e },
	'previewimageheight' => { 39 => 0x4 },
	'previewimagelength' => { 39 => 0x2, 67 => 0x3, 70 => [0x117,0x202], 115 => 0x89, 142 => 0x202, 179 => 0x102, 184 => 0x1037, 213 => 0x3, 222 => 0x1e, 226 => 0x3, 229 => 0x1b },
	'previewimagename' => { 107 => '1Name' },
	'previewimagesize' => { 67 => 0x2, 90 => 0x2, 107 => 'ImageSize', 213 => 0x2, 229 => 0x1c, 232 => 0xb02c },
	'previewimagestart' => { 39 => 0x5, 67 => 0x4, 70 => [0x111,0x201], 115 => 0x88, 142 => 0x201, 179 => 0x101, 184 => 0x1036, 213 => 0x4, 222 => 0x1c, 226 => 0x2, 229 => 0x1a },
	'previewimagetype' => { 107 => '0Type' },
	'previewimagevalid' => { 179 => 0x100, 184 => 0x1035 },
	'previewimagewidth' => { 39 => 0x3 },
	'previewquality' => { 39 => 0x1 },
	'previewsettingsdigest' => { 70 => 0xc719 },
	'previewsettingsname' => { 70 => 0xc718 },
	'previewwidth' => { 85 => 0xfa57 },
	'primaryafpoint' => { 121 => 0x7 },
	'primarychromaticities' => { 70 => 0x13f, 260 => 'PrimaryChromaticities' },
	'printim' => { 70 => 0xc4a5 },
	'prioritysetupshutterrelease' => { 114 => 0x1d, 230 => 0x28 },
	'privatertkinfo' => { 238 => 'privateRTKInfo' },
	'processingsoftware' => { 70 => 0xb },
	'producer' => { 188 => 'Producer', 252 => 'Producer' },
	'productid' => { 77 => 0x32 },
	'productioncode' => { 205 => 0x2 },
	'productorserviceconstraints' => { 254 => 'ProductOrServiceConstraints' },
	'profilecalibrationsig' => { 70 => 0xc6f4 },
	'profilecopyright' => { 70 => 0xc6fe },
	'profileembedpolicy' => { 70 => 0xc6fd },
	'profilehuesatmapdata1' => { 70 => 0xc6fa },
	'profilehuesatmapdata2' => { 70 => 0xc6fb },
	'profilehuesatmapdims' => { 70 => 0xc6f9 },
	'profilelooktabledata' => { 70 => 0xc726 },
	'profilelooktabledims' => { 70 => 0xc725 },
	'profilename' => { 70 => 0xc6f8 },
	'profiletonecurve' => { 70 => 0xc6fc },
	'programiso' => { 199 => 0x3c },
	'programline' => { 206 => '1.1' },
	'programmode' => { 118 => 0x5 },
	'programshift' => { 139 => 0xd },
	'programversion' => { 76 => 0x46 },
	'projectname' => { 264 => 'projectName' },
	'projectrefpath' => { 264 => 'projectRefPath' },
	'projectreftype' => { 264 => 'projectRefType' },
	'propertyreleaseid' => { 254 => 'PropertyReleaseID' },
	'propertyreleasestatus' => { 254 => 'PropertyReleaseStatus' },
	'province-state' => { 76 => 0x5f },
	'publicationdate' => { 255 => 'publicationDate' },
	'publicationname' => { 255 => 'publicationName' },
	'publisher' => { 246 => 'publisher' },
	'pulldown' => { 264 => 'pullDown' },
	'quality' => { 0 => 0x1, 20 => 0x3, 66 => 0x2, 67 => 0x3002, 74 => 0x1000, 83 => 0x9, 139 => 0x4, 157 => 0x3, 184 => 0x201, 194 => 0x300, 213 => 0x8, 215 => 0x2, 229 => 0x16, 230 => 0x56, 232 => [0x102,0xb047] },
	'qualitymode' => { 67 => 0x8 },
	'quantizationmethod' => { 78 => 0x78 },
	'quickadjust' => { 170 => 0x2a },
	'quickcontroldialinmeter' => { 47 => 0x703 },
	'quickshot' => { 228 => 0x213 },
	'rangefinder' => { 176 => '4.1' },
	'rasterizedcaption' => { 76 => 0x7d },
	'rating' => { 70 => 0x4746, 216 => 0xdf, 242 => 'rating', 247 => 'rating', 262 => 'Rating' },
	'ratingpercent' => { 70 => 0x4749, 241 => 'Rating' },
	'rawandjpgrecording' => { 45 => 0x8, 115 => 0x109, 206 => 0xd },
	'rawbrightnessadj' => { 64 => 0x38 },
	'rawcoloradj' => { 64 => 0x2e },
	'rawcropbottom' => { 216 => 0xd4 },
	'rawcropleft' => { 216 => 0xd1 },
	'rawcropright' => { 216 => 0xd3 },
	'rawcroptop' => { 216 => 0xd2 },
	'rawcustomsaturation' => { 64 => 0x30 },
	'rawcustomtone' => { 64 => 0x34 },
	'rawdatauniqueid' => { 70 => 0xc65d },
	'rawdepth' => { 117 => 0x10 },
	'rawdevautogradation' => { 186 => 0x119 },
	'rawdevcolorspace' => { 185 => 0x108, 186 => 0x109 },
	'rawdevcontrastvalue' => { 185 => 0x106, 186 => 0x105 },
	'rawdeveditstatus' => { 185 => 0x10b },
	'rawdevengine' => { 185 => 0x109, 186 => 0x10b },
	'rawdevexposurebiasvalue' => { 185 => 0x100, 186 => 0x100 },
	'rawdevgradation' => { 186 => 0x112 },
	'rawdevgraypoint' => { 185 => 0x103, 186 => 0x104 },
	'rawdevmemorycoloremphasis' => { 185 => 0x105, 186 => 0x108 },
	'rawdevnoisereduction' => { 185 => 0x10a, 186 => 0x10a },
	'rawdevpicturemode' => { 186 => 0x10c },
	'rawdevpm_bwfilter' => { 186 => 0x110 },
	'rawdevpmcontrast' => { 186 => 0x10e },
	'rawdevpmnoisefilter' => { 186 => 0x120 },
	'rawdevpmpicturetone' => { 186 => 0x111 },
	'rawdevpmsaturation' => { 186 => 0x10d },
	'rawdevpmsharpness' => { 186 => 0x10f },
	'rawdevsaturation3' => { 186 => 0x113 },
	'rawdevsaturationemphasis' => { 185 => 0x104, 186 => 0x107 },
	'rawdevsettings' => { 185 => 0x10c },
	'rawdevsharpnessvalue' => { 185 => 0x107, 186 => 0x106 },
	'rawdevversion' => { 185 => 0x0, 186 => 0x0 },
	'rawdevwbfineadjustment' => { 185 => 0x102, 186 => 0x103 },
	'rawdevwhitebalance' => { 186 => 0x101 },
	'rawdevwhitebalancevalue' => { 185 => 0x101, 186 => 0x102 },
	'rawfile' => { 70 => 0xfe4c },
	'rawfilename' => { 245 => 'RawFileName' },
	'rawimagecenter' => { 139 => 0x99 },
	'rawimagedigest' => { 70 => 0xc71c },
	'rawimagesize' => { 213 => 0x39 },
	'rawinfoversion' => { 187 => 0x0 },
	'rawjpgheight' => { 62 => 0x4 },
	'rawjpgquality' => { 30 => 0x6, 62 => 0x1 },
	'rawjpgsize' => { 30 => 0x7, 62 => 0x2 },
	'rawjpgwidth' => { 62 => 0x3 },
	'rawmeasuredrggb' => { 23 => 0x26a, 25 => 0x280 },
	'reardisplay' => { 174 => '12.3' },
	'recognizedface1age' => { 193 => 0x20 },
	'recognizedface1name' => { 193 => 0x4 },
	'recognizedface1position' => { 193 => 0x18 },
	'recognizedface2age' => { 193 => 0x50 },
	'recognizedface2name' => { 193 => 0x34 },
	'recognizedface2position' => { 193 => 0x48 },
	'recognizedface3age' => { 193 => 0x80 },
	'recognizedface3name' => { 193 => 0x64 },
	'recognizedface3position' => { 193 => 0x78 },
	'recognizedfaceflags' => { 199 => 0x63 },
	'recommendedexposureindex' => { 70 => 0x8832 },
	'recorddisplay' => { 114 => 0x4d },
	'recordid' => { 60 => 0x1804 },
	'recordingmode' => { 66 => 0x1, 215 => 0x1 },
	'recordmode' => { 20 => 0x9, 67 => 0x3000 },
	'recordshutterrelease' => { 228 => 0x217 },
	'redbalance' => { 128 => 0x270, 184 => 0x1017, 201 => 0x11, 213 => 0x1c },
	'redcurvelimits' => { 64 => 0x18a },
	'redcurvepoints' => { 64 => 0x160 },
	'redeyecorrection' => { 171 => 0x0 },
	'redeyeinfo' => { 245 => 'RedEyeInfo' },
	'redeyereduction' => { 114 => 0x41 },
	'redhue' => { 245 => 'RedHue' },
	'redsaturation' => { 245 => 'RedSaturation' },
	'reductionmatrix1' => { 70 => 0xc625 },
	'reductionmatrix2' => { 70 => 0xc626 },
	'referenceblackwhite' => { 70 => 0x214, 260 => 'ReferenceBlackWhite' },
	'referencedate' => { 76 => 0x2f },
	'referencenumber' => { 76 => 0x32 },
	'references' => { 98 => 'References' },
	'referenceservice' => { 76 => 0x2d },
	'regionconstraints' => { 254 => 'RegionConstraints' },
	'regionpersondisplayname' => { 239 => 'RegionInfoRegionsPersonDisplayName' },
	'regionrectangle' => { 239 => 'RegionInfoRegionsRectangle' },
	'registryitemid' => { 251 => 'RegistryIdRegItemId' },
	'registryorganisationid' => { 251 => 'RegistryIdRegOrgId' },
	'relatedaudiofile' => { 96 => 'data' },
	'relatedaudiofilename' => { 96 => '1Name' },
	'relatedaudiofiletype' => { 96 => '0Type' },
	'relatedimagefileformat' => { 70 => 0x1000 },
	'relatedimageheight' => { 70 => 0x1002 },
	'relatedimagewidth' => { 70 => 0x1001 },
	'relatedsoundfile' => { 70 => 0xa004, 249 => 'RelatedSoundFile' },
	'relatedvideofile' => { 110 => 'data' },
	'relatedvideofilename' => { 110 => '1Name' },
	'relatedvideofiletype' => { 110 => '0Type' },
	'relation' => { 246 => 'relation' },
	'relativepeakaudiofilepath' => { 264 => 'relativePeakAudioFilePath' },
	'relativetimestampscale' => { 264 => 'relativeTimestampScale' },
	'relativetimestampvalue' => { 264 => 'relativeTimestampValue' },
	'releasebuttontousedial' => { 174 => '17.8' },
	'releasedate' => { 76 => 0x1e, 264 => 'releaseDate' },
	'releasemode' => { 67 => 0x3001, 232 => 0xb049 },
	'releasesetting' => { 60 => 0x1016 },
	'releasetime' => { 76 => 0x23 },
	'remoteonduration' => { 175 => '3.4', 176 => '17.2', 177 => '4.3', 178 => '19.2' },
	'renditionclass' => { 265 => 'RenditionClass' },
	'renditionofalternatepaths' => { 265 => 'RenditionOfAlternatePaths' },
	'renditionofdocumentid' => { 265 => 'RenditionOfDocumentID' },
	'renditionoffilepath' => { 265 => 'RenditionOfFilePath' },
	'renditionoffrompart' => { 265 => 'RenditionOfFromPart' },
	'renditionofinstanceid' => { 265 => 'RenditionOfInstanceID' },
	'renditionoflastmodifydate' => { 265 => 'RenditionOfLastModifyDate' },
	'renditionofmanager' => { 265 => 'RenditionOfManager' },
	'renditionofmanagervariant' => { 265 => 'RenditionOfManagerVariant' },
	'renditionofmanageto' => { 265 => 'RenditionOfManageTo' },
	'renditionofmanageui' => { 265 => 'RenditionOfManageUI' },
	'renditionofmaskmarkers' => { 265 => 'RenditionOfMaskMarkers' },
	'renditionoforiginaldocumentid' => { 265 => 'RenditionOfOriginalDocumentID' },
	'renditionofpartmapping' => { 265 => 'RenditionOfPartMapping' },
	'renditionofrenditionclass' => { 265 => 'RenditionOfRenditionClass' },
	'renditionofrenditionparams' => { 265 => 'RenditionOfRenditionParams' },
	'renditionoftopart' => { 265 => 'RenditionOfToPart' },
	'renditionofversionid' => { 265 => 'RenditionOfVersionID' },
	'renditionparams' => { 265 => 'RenditionParams' },
	'repeatingflashcount' => { 131 => 0xd, 132 => 0xe, 133 => 0xe, 177 => '9.2', 178 => '25.2' },
	'repeatingflashoutput' => { 177 => '9.1', 178 => '25.1' },
	'repeatingflashrate' => { 131 => 0xc, 132 => 0xd, 133 => 0xd, 177 => '10.1', 178 => '26.1' },
	'resampleparamsquality' => { 264 => 'resampleParamsQuality' },
	'resaved' => { 228 => 0x21e },
	'resolution' => { 103 => 'Resolution' },
	'resolutionmode' => { 229 => 0x4 },
	'resolutionunit' => { 70 => 0x128, 79 => 0x2, 260 => 'ResolutionUnit' },
	'restrictions' => { 257 => 'restrictions' },
	'retouchhistory' => { 139 => 0x9e },
	'retouchinfo' => { 245 => 'RetouchInfo' },
	'reuse' => { 254 => 'Reuse' },
	'reuseallowed' => { 267 => 'ReuseAllowed' },
	'reuseprohibited' => { 257 => 'reuseProhibited' },
	'reverseindicators' => { 174 => '12.1', 176 => '4.3', 178 => '6.2' },
	'revision' => { 247 => 'revision' },
	'rgbcurvelimits' => { 64 => 0x238 },
	'rgbcurvepoints' => { 64 => 0x20e },
	'ricohdate' => { 222 => 0x6 },
	'ricohimageheight' => { 222 => 0x2 },
	'ricohimagewidth' => { 222 => 0x0 },
	'rightascension' => { 106 => 'RightAscension' },
	'rights' => { 246 => 'rights' },
	'rightsagent' => { 255 => 'rightsAgent', 257 => 'rightsAgent' },
	'rightsowner' => { 257 => 'rightsOwner' },
	'romoperationmode' => { 60 => 0x80d },
	'rotation' => { 17 => 0x17, 18 => 0x18, 59 => 0x3, 64 => 0x26e, 73 => 0x4, 106 => 'Rotation', 112 => [0x65,0x50], 113 => 0x46, 114 => 0x5a, 155 => '590.1', 167 => 0x76a43207, 199 => 0x30, 206 => '17.2', 216 => 0xd8, 230 => 0x3f, 231 => 0x3f },
	'routing' => { 221 => 'Routing' },
	'rowsperstrip' => { 70 => 0x116 },
	'rpp' => { 242 => 'rpp' },
	'safetyshift' => { 47 => 0x108 },
	'safetyshiftinavortv' => { 45 => 0x10, 46 => 0x10, 48 => 0xf, 49 => 0x10, 52 => 0x10 },
	'samplebits' => { 96 => 'SampleBits' },
	'samplerate' => { 96 => 'SampleRate' },
	'samplesperpixel' => { 70 => 0x115, 260 => 'SamplesPerPixel' },
	'samplestructure' => { 78 => 0x5a },
	'sanyoquality' => { 228 => 0x201 },
	'sanyothumbnail' => { 228 => 0x100 },
	'saturation' => { 4 => 0x6e, 6 => 0x76, 20 => 0xe, 27 => 0x1, 66 => 0xd, 67 => [0x3013,0x1f], 70 => [0xa409,0xfe55], 74 => 0x1003, 97 => 'Saturation', 111 => 0x1f, 112 => 0x32, 113 => 0x28, 114 => 0x1a, 118 => 0x1, 139 => [0x94,0xaa], 141 => 0x35, 199 => 0x40, 200 => 0x300d, 213 => 0x1f, 215 => 0xd, 222 => 0x28, 229 => 0x10, 230 => 0x1e, 231 => 0x1b, 232 => 0x2005, 245 => 'Saturation', 249 => 'Saturation' },
	'saturationadj' => { 64 => 0x116, 166 => 0x1, 170 => 0x2e, 235 => 0x8016 },
	'saturationadjustmentaqua' => { 245 => 'SaturationAdjustmentAqua' },
	'saturationadjustmentblue' => { 245 => 'SaturationAdjustmentBlue' },
	'saturationadjustmentgreen' => { 245 => 'SaturationAdjustmentGreen' },
	'saturationadjustmentmagenta' => { 245 => 'SaturationAdjustmentMagenta' },
	'saturationadjustmentorange' => { 245 => 'SaturationAdjustmentOrange' },
	'saturationadjustmentpurple' => { 245 => 'SaturationAdjustmentPurple' },
	'saturationadjustmentred' => { 245 => 'SaturationAdjustmentRed' },
	'saturationadjustmentyellow' => { 245 => 'SaturationAdjustmentYellow' },
	'saturationfaithful' => { 13 => 0xfe },
	'saturationlandscape' => { 13 => 0xfc },
	'saturationneutral' => { 13 => 0xfd },
	'saturationportrait' => { 13 => 0xfb },
	'saturationsetting' => { 187 => 0x1010 },
	'saturationstandard' => { 13 => 0xfa },
	'saturationuserdef1' => { 13 => 0x100 },
	'saturationuserdef2' => { 13 => 0x101 },
	'saturationuserdef3' => { 13 => 0x102 },
	'saveid' => { 265 => 'SaveID' },
	'scaletype' => { 264 => 'scaleType' },
	'scanimageenhancer' => { 144 => 0x60 },
	'scanningdirection' => { 78 => 0x64 },
	'scene' => { 250 => 'Scene', 264 => 'scene' },
	'scenearea' => { 182 => 0x211, 184 => 0x1031 },
	'sceneassist' => { 139 => 0x9c },
	'scenecapturetype' => { 70 => 0xa406, 249 => 'SceneCaptureType' },
	'scenedetect' => { 182 => 0x210, 184 => 0x1030 },
	'scenedetectdata' => { 182 => 0x212, 184 => 0x1033 },
	'scenemode' => { 85 => 0xfa02, 115 => 0x100, 139 => 0x8f, 179 => 0x509, 184 => 0x403, 199 => 0x8001, 232 => 0xb023 },
	'scenemodeused' => { 87 => [0x6002,0xf002] },
	'sceneselect' => { 228 => 0x21f },
	'scenetype' => { 70 => 0xa301, 249 => 'SceneType' },
	'screentips' => { 178 => '5.1' },
	'section' => { 255 => 'section' },
	'securityclassification' => { 70 => 0x9212 },
	'selectableafpoint' => { 47 => 0x509 },
	'selectafareaselectmode' => { 47 => 0x512 },
	'selftimer' => { 20 => 0x2, 199 => 0x2e, 228 => 0x214 },
	'selftimer2' => { 42 => 0x1d },
	'selftimermode' => { 70 => 0x882b },
	'selftimershotcount' => { 176 => '18.2', 178 => '20.2' },
	'selftimertime' => { 60 => 0x1806, 114 => 0x1f, 174 => '18.1', 175 => '3.3', 176 => '18.1', 177 => '3.3', 178 => '20.1' },
	'seminfo' => { 70 => 0x8546 },
	'sensingmethod' => { 70 => 0xa217, 249 => 'SensingMethod' },
	'sensitivityadjust' => { 213 => 0x40 },
	'sensitivitysteps' => { 206 => '17.4', 208 => 0x1 },
	'sensitivitytype' => { 70 => 0x8830 },
	'sensorareas' => { 227 => 0xa010 },
	'sensorbitdepth' => { 200 => 0x312d },
	'sensorbluelevel' => { 40 => 0x5 },
	'sensorcleaning' => { 53 => 0xd },
	'sensorfullheight' => { 80 => 0xf904 },
	'sensorfullwidth' => { 80 => 0xf903 },
	'sensorheight' => { 80 => 0xf901, 85 => 0xfa21, 117 => 0x8, 200 => 0x312c },
	'sensorpixelsize' => { 139 => 0x9a },
	'sensorredlevel' => { 40 => 0x4 },
	'sensorsize' => { 97 => 'SensorSize' },
	'sensortemperature' => { 182 => 0x1500, 184 => 0x1007, 229 => 0x39 },
	'sensorwidth' => { 80 => 0xf900, 85 => 0xfa20, 117 => 0xa, 200 => 0x312b },
	'sequencenumber' => { 42 => 0x9, 67 => 0x301c, 74 => 0x1101, 83 => 0x1d, 199 => 0x2b, 232 => 0xb04a },
	'sequenceshotinterval' => { 228 => 0x224 },
	'sequentialshot' => { 228 => 0x20e },
	'serialnumber' => { 34 => 0xc, 60 => 0x180b, 70 => [0xa431,0xfde9], 80 => 0xfa04, 82 => 0xfa00, 84 => 0xc354, 85 => 0xfa19, 94 => 0x0, 95 => 0xa8, 97 => 'SerialNumber', 139 => [0xa0,0x1d], 180 => 0x101, 184 => [0x404,0x101a], 194 => 0x303, 200 => 0x3103, 213 => 0x229, 223 => 0x5, 229 => 0x2, 243 => 'SerialNumber' },
	'serialnumberformat' => { 34 => 0x15, 60 => 0x183b },
	'seriesdatetime' => { 237 => 'SeriesDateTime' },
	'seriesdescription' => { 237 => 'SeriesDescription' },
	'seriesmodality' => { 237 => 'SeriesModality' },
	'seriesnumber' => { 237 => 'SeriesNumber' },
	'serviceidentifier' => { 77 => 0x1e },
	'setbuttoncrosskeysfunc' => { 50 => 0x0, 51 => 0x0 },
	'setbuttonwhenshooting' => { 45 => 0x1, 47 => 0x704, 53 => 0xc },
	'setfunctionwhenshooting' => { 48 => 0x0, 49 => 0x1, 52 => 0x1 },
	'shadingcompensation' => { 179 => 0x50c },
	'shadingcompensation2' => { 183 => 0x1012 },
	'shadow' => { 229 => 0xe },
	'shadowcompensation' => { 213 => 0x79 },
	'shadowprotection' => { 166 => 0x0 },
	'shadows' => { 70 => 0xfe52, 245 => 'Shadows' },
	'shadowscale' => { 70 => 0xc633 },
	'shadowtint' => { 245 => 'ShadowTint' },
	'shakereduction' => { 214 => 0x1 },
	'sharpendetail' => { 245 => 'SharpenDetail' },
	'sharpenedgemasking' => { 245 => 'SharpenEdgeMasking' },
	'sharpening' => { 200 => 0x300b },
	'sharpeningadj' => { 170 => 0x2b },
	'sharpenradius' => { 245 => 'SharpenRadius' },
	'sharpness' => { 3 => [0x42,0x48], 4 => 0x72, 6 => 0x74, 20 => 0xf, 40 => 0x2, 66 => 0xb, 67 => [0x3011,0x21], 70 => [0xa40a,0xfe56], 74 => 0x1001, 83 => 0x6b, 92 => 0x37, 97 => 'Sharpness', 111 => 0x21, 112 => 0x30, 113 => 0x26, 114 => 0x18, 118 => 0x3, 139 => 0x6, 141 => 0x32, 184 => 0x100f, 199 => 0x41, 213 => 0x21, 215 => 0xb, 222 => 0x22, 223 => 0x1003, 229 => 0x11, 230 => 0x1c, 231 => 0x19, 245 => 'Sharpness', 249 => 'Sharpness' },
	'sharpnessadj' => { 64 => 0x25a, 235 => 0x801a },
	'sharpnessfactor' => { 184 => 0x102a },
	'sharpnessfaithful' => { 13 => 0xf5 },
	'sharpnessfrequency' => { 3 => [0x41,0x47], 40 => 0x3 },
	'sharpnesslandscape' => { 13 => 0xf3 },
	'sharpnessmonochrome' => { 13 => 0xf6 },
	'sharpnessneutral' => { 13 => 0xf4 },
	'sharpnessovershoot' => { 235 => 0x801b },
	'sharpnessportrait' => { 13 => 0xf2 },
	'sharpnesssetting' => { 179 => 0x506, 187 => 0x1013 },
	'sharpnessstandard' => { 13 => 0xf1 },
	'sharpnessthreshold' => { 235 => 0x801d },
	'sharpnessundershoot' => { 235 => 0x801c },
	'sharpnessuserdef1' => { 13 => 0xf7 },
	'sharpnessuserdef2' => { 13 => 0xf8 },
	'sharpnessuserdef3' => { 13 => 0xf9 },
	'shootinginfodisplay' => { 174 => '13.2', 178 => '5.3' },
	'shootinginfomonitorofftime' => { 178 => '22.2' },
	'shootingmode' => { 97 => 'ShootingMode', 139 => 0x89, 199 => 0x1f },
	'shootingmodesetting' => { 175 => '5.1' },
	'shortdescription' => { 247 => 'shortdescription' },
	'shortdocumentid' => { 76 => 0xba },
	'shortfocal' => { 3 => 0xe, 4 => 0x11, 5 => 0x113, 6 => 0x11, 8 => 0xd8, 10 => 0xf8, 11 => 0xec, 12 => 0x101, 13 => 0x93, 14 => 0xe8, 16 => 0xf0, 20 => 0x18 },
	'shortownername' => { 13 => 0xac },
	'shortreleasetimelag' => { 47 => 0x80d },
	'shotdate' => { 264 => 'shotDate' },
	'shotday' => { 264 => 'shotDay' },
	'shotlocation' => { 264 => 'shotLocation' },
	'shotname' => { 264 => 'shotName' },
	'shotnumber' => { 264 => 'shotNumber' },
	'shotsize' => { 264 => 'shotSize' },
	'shutter-aelock' => { 45 => 0x4, 47 => 0x701, 48 => 0x3, 49 => 0x4, 50 => 0x3, 51 => 0x3, 52 => 0x4, 53 => 0x2 },
	'shutteraelbutton' => { 46 => 0x4 },
	'shutterbuttonafonbutton' => { 47 => 0x701 },
	'shuttercount' => { 5 => 0x176, 30 => 0x1, 139 => 0xa7, 145 => [0x6a,0x157,0x24d], 146 => 0x286, 147 => 0x279, 148 => 0x284, 149 => 0x242, 150 => 0x280, 151 => 0x276, 152 => [0x27d,0x27f], 153 => 0x246, 154 => 0x2d6, 155 => 0x24a, 156 => 0x2d5, 213 => 0x5d },
	'shuttercurtainsync' => { 45 => 0xf, 46 => 0xf, 47 => 0x305, 48 => 0xe, 49 => 0xf, 50 => 0x8, 51 => 0x8, 52 => 0xf, 53 => 0x8 },
	'shuttermode' => { 83 => 0x1b },
	'shutterreleasebuttonae-l' => { 174 => '17.7', 176 => '16.1', 178 => '18.2' },
	'shutterreleasemethod' => { 60 => 0x1010 },
	'shutterreleasenocfcard' => { 45 => 0x2, 46 => 0x2, 53 => 0xf },
	'shutterreleasetiming' => { 60 => 0x1011 },
	'shutterspeedrange' => { 47 => 0x10c },
	'shutterspeedvalue' => { 56 => 0x1, 70 => 0x9201, 184 => 0x1000, 249 => 'ShutterSpeedValue' },
	'sidecarforextension' => { 253 => 'SidecarForExtension' },
	'similarityindex' => { 76 => 0xe4 },
	'singleframebracketing' => { 114 => 0x21 },
	'slaveflashmeteringsegments' => { 213 => 0x20b },
	'slowshutter' => { 42 => 0x8 },
	'slowsync' => { 74 => 0x1030 },
	'smoothness' => { 70 => 0xfe57, 245 => 'Smoothness' },
	'software' => { 70 => 0x131, 98 => 'Software', 190 => 'Software', 229 => 0x18, 260 => 'Software' },
	'softwareversion' => { 228 => 0x207 },
	'sonydatetime' => { 234 => 0x6 },
	'sonyimagesize' => { 114 => 0x3b, 230 => 0x54, 231 => 0x54 },
	'sonymodelid' => { 232 => 0xb001 },
	'sonyquality' => { 114 => 0x3c },
	'source' => { 76 => 0x73, 190 => 'Source', 246 => 'source', 247 => 'source', 253 => 'Source' },
	'spatialfrequencyresponsecolumns' => { 249 => 'SpatialFrequencyResponseColumns' },
	'spatialfrequencyresponsenames' => { 249 => 'SpatialFrequencyResponseNames' },
	'spatialfrequencyresponserows' => { 249 => 'SpatialFrequencyResponseRows' },
	'spatialfrequencyresponsevalues' => { 249 => 'SpatialFrequencyResponseValues' },
	'speakerplacement' => { 264 => 'speakerPlacement' },
	'specialeffectlevel' => { 67 => 0x3030 },
	'specialeffectmode' => { 67 => 0x2076 },
	'specialeffectsetting' => { 67 => 0x3031 },
	'specialinstructions' => { 76 => 0x28 },
	'specialmode' => { 184 => 0x200, 228 => 0x200 },
	'spectralsensitivity' => { 70 => 0x8824, 249 => 'SpectralSensitivity' },
	'splittoningbalance' => { 245 => 'SplitToningBalance' },
	'splittoninghighlighthue' => { 245 => 'SplitToningHighlightHue' },
	'splittoninghighlightsaturation' => { 245 => 'SplitToningHighlightSaturation' },
	'splittoningshadowhue' => { 245 => 'SplitToningShadowHue' },
	'splittoningshadowsaturation' => { 245 => 'SplitToningShadowSaturation' },
	'spotfocuspointx' => { 111 => 0x2d },
	'spotfocuspointy' => { 111 => 0x2e },
	'spotmeteringmode' => { 20 => 0x27 },
	'spotmeterlinktoafpoint' => { 47 => 0x107 },
	'sractive' => { 206 => '17.1' },
	'srawquality' => { 20 => 0x2e },
	'srfocallength' => { 214 => 0x3 },
	'srhalfpresstime' => { 214 => 0x2 },
	'srresult' => { 214 => 0x0 },
	'standardoutputhighlightpoint' => { 65 => 0x14 },
	'standardoutputsensitivity' => { 70 => 0x8831 },
	'standardoutputshadowpoint' => { 65 => 0x15 },
	'standardrawcolortone' => { 65 => 0xd },
	'standardrawcontrast' => { 65 => 0xf },
	'standardrawhighlight' => { 65 => 0x75 },
	'standardrawhighlightpoint' => { 65 => 0x12 },
	'standardrawlinear' => { 65 => 0x10 },
	'standardrawsaturation' => { 65 => 0xe },
	'standardrawshadow' => { 65 => 0x7e },
	'standardrawshadowpoint' => { 65 => 0x13 },
	'standardrawsharpness' => { 65 => 0x11 },
	'startingpage' => { 255 => 'startingPage' },
	'startmovieshooting' => { 47 => 0x70d },
	'starttimecodetimeformat' => { 264 => 'startTimecodeTimeFormat' },
	'starttimecodetimevalue' => { 264 => 'startTimecodeTimeValue' },
	'starttimecodevalue' => { 264 => 'startTimecodeValue' },
	'state' => { 102 => 'State', 199 => 0x6b, 253 => 'State' },
	'status' => { 240 => 'Status' },
	'storagemethod' => { 117 => 0x12 },
	'straightenangle' => { 167 => 0x2fc08431 },
	'stretchmode' => { 264 => 'stretchMode' },
	'studydatetime' => { 237 => 'StudyDateTime' },
	'studydescription' => { 237 => 'StudyDescription' },
	'studyid' => { 237 => 'StudyID' },
	'studyphysician' => { 237 => 'StudyPhysician' },
	'sub-location' => { 76 => 0x5c },
	'subfiledata' => { 105 => 'data' },
	'subfiledirectory' => { 105 => '1Directory' },
	'subfilemimetype' => { 105 => '2MIME' },
	'subfilename' => { 105 => '1Name' },
	'subfileresource' => { 105 => 'rsrc' },
	'subfiletype' => { 70 => 0xfe, 105 => '0Type' },
	'subject' => { 188 => 'Subject', 221 => 'Subject', 246 => 'subject', 252 => 'Subject' },
	'subjectarea' => { 70 => 0x9214, 249 => 'SubjectArea' },
	'subjectcode' => { 250 => 'SubjectCode' },
	'subjectdistance' => { 70 => 0x9206, 83 => 0x3e, 249 => 'SubjectDistance' },
	'subjectdistancerange' => { 70 => 0xa40c, 249 => 'SubjectDistanceRange' },
	'subjectlocation' => { 70 => 0xa214, 249 => 'SubjectLocation' },
	'subjectprogram' => { 111 => 0x22 },
	'subjectreference' => { 76 => 0xc },
	'subsectime' => { 70 => 0x9290 },
	'subsectimedigitized' => { 70 => 0x9292 },
	'subsectimeoriginal' => { 70 => 0x9291 },
	'subsection1' => { 255 => 'subsection1' },
	'subsection2' => { 255 => 'subsection2' },
	'subsection3' => { 255 => 'subsection3' },
	'subsection4' => { 255 => 'subsection4' },
	'superimposeddisplay' => { 45 => 0xa, 47 => 0x510, 48 => 0x9, 49 => 0xa, 52 => 0xa, 53 => 0xe },
	'supermacro' => { 34 => 0x1a },
	'supplementalcategories' => { 76 => 0x14, 253 => 'SupplementalCategories' },
	'supplementaltype' => { 78 => 0x37 },
	'svisosetting' => { 206 => 0x14 },
	'switchtoregisteredafpoint' => { 46 => 0x12, 47 => 0x50a },
	'tagged' => { 216 => 0xdd, 242 => 'tagged' },
	'tagslist' => { 248 => 'TagsList' },
	'takenumber' => { 264 => 'takeNumber' },
	'tapename' => { 264 => 'tapeName' },
	'targetaperture' => { 42 => 0x4 },
	'targetcompressionratio' => { 58 => 0x1 },
	'targetdistancesetting' => { 60 => 0x1807 },
	'targetexposuretime' => { 42 => 0x5 },
	'targetimagetype' => { 60 => 0x100a },
	'teaser' => { 255 => 'teaser' },
	'teleconverter' => { 115 => 0x105, 232 => 0x105 },
	'temperature' => { 245 => 'Temperature' },
	'tempo' => { 264 => 'tempo' },
	'termsandconditionstext' => { 254 => 'TermsAndConditionsText' },
	'termsandconditionsurl' => { 254 => 'TermsAndConditionsURL' },
	'textlayername' => { 253 => 'TextLayersLayerName' },
	'textlayertext' => { 253 => 'TextLayersLayerText' },
	'textstamp' => { 199 => [0x8008,0x8009,0x3b,0x3e] },
	'thresholding' => { 70 => 0x107 },
	'thumbnailfilename' => { 60 => 0x817 },
	'thumbnailformat' => { 262 => 'ThumbnailsFormat' },
	'thumbnailheight' => { 85 => 0xfa55, 262 => 'ThumbnailsHeight' },
	'thumbnailimage' => { 60 => 0x2008, 68 => 'ThumbnailImage', 72 => 0x3, 108 => 'data', 184 => 0x100, 262 => 'ThumbnailsImage' },
	'thumbnailimagename' => { 108 => '1Name' },
	'thumbnailimagesize' => { 108 => 'ImageSize' },
	'thumbnailimagetype' => { 108 => '0Type' },
	'thumbnailimagevalidarea' => { 34 => 0x13 },
	'thumbnaillength' => { 70 => 0x202 },
	'thumbnailoffset' => { 70 => 0x201 },
	'thumbnailwidth' => { 85 => 0xfa54, 262 => 'ThumbnailsWidth' },
	'ticker' => { 255 => 'ticker' },
	'tilelength' => { 70 => 0x143 },
	'tilewidth' => { 70 => 0x142 },
	'time' => { 81 => 0x401, 213 => 0x7 },
	'timecreated' => { 76 => 0x3c, 83 => 0x14, 92 => 0x10, 217 => 'TimeCreated' },
	'timeperiod' => { 255 => 'timePeriod' },
	'timerfunctionbutton' => { 175 => '5.2', 176 => '12.1' },
	'timerlength' => { 47 => 0x80c },
	'timescaleparamsframeoverlappingpercentage' => { 264 => 'timeScaleParamsFrameOverlappingPercentage' },
	'timescaleparamsframesize' => { 264 => 'timeScaleParamsFrameSize' },
	'timescaleparamsquality' => { 264 => 'timeScaleParamsQuality' },
	'timesent' => { 77 => 0x50 },
	'timesignature' => { 264 => 'timeSignature' },
	'timesincepoweron' => { 199 => 0x29 },
	'timestamp' => { 5 => 0x45e, 13 => 0x11c, 190 => 'TimeStamp' },
	'timestamp1' => { 5 => 0x45a },
	'timezone' => { 159 => 0x0 },
	'timezonecode' => { 63 => 0x1 },
	'timezoneinfo' => { 63 => 0x2 },
	'timezoneoffset' => { 70 => 0x882a },
	'tint' => { 245 => 'Tint' },
	'title' => { 98 => 'Title', 188 => 'Title', 190 => 'Title', 221 => 'Title', 246 => 'title', 252 => 'Title' },
	'tonecomp' => { 139 => 0x81 },
	'tonecurve' => { 40 => 0x1, 213 => 0x402, 245 => 'ToneCurve' },
	'tonecurveactive' => { 64 => 0x110 },
	'tonecurvebluex' => { 235 => 0x9003 },
	'tonecurvebluey' => { 235 => 0x9007 },
	'tonecurvebrightnessx' => { 235 => 0x9000 },
	'tonecurvebrightnessy' => { 235 => 0x9004 },
	'tonecurvefilename' => { 81 => 0x1391 },
	'tonecurvegreenx' => { 235 => 0x9002 },
	'tonecurvegreeny' => { 235 => 0x9006 },
	'tonecurveinterpolation' => { 64 => 0x159 },
	'tonecurvemode' => { 64 => 0x113 },
	'tonecurvename' => { 245 => 'ToneCurveName' },
	'tonecurveproperty' => { 64 => 0x3c },
	'tonecurveredx' => { 235 => 0x9001 },
	'tonecurveredy' => { 235 => 0x9005 },
	'tonecurves' => { 213 => 0x403 },
	'toningeffect' => { 30 => 0xf, 139 => 0xb3, 141 => 0x38 },
	'toningeffectmonochrome' => { 13 => 0x108 },
	'toningsaturation' => { 141 => 0x39 },
	'totalzoom' => { 83 => 0x62 },
	'tracknumber' => { 264 => 'trackNumber' },
	'tracksframerate' => { 264 => 'TracksFrameRate' },
	'tracksmarkerscomment' => { 264 => 'TracksMarkersComment' },
	'tracksmarkerscuepointparamskey' => { 264 => 'TracksMarkersCuePointParamsKey' },
	'tracksmarkerscuepointparamsvalue' => { 264 => 'TracksMarkersCuePointParamsValue' },
	'tracksmarkerscuepointtype' => { 264 => 'TracksMarkersCuePointType' },
	'tracksmarkersduration' => { 264 => 'TracksMarkersDuration' },
	'tracksmarkerslocation' => { 264 => 'TracksMarkersLocation' },
	'tracksmarkersname' => { 264 => 'TracksMarkersName' },
	'tracksmarkersprobability' => { 264 => 'TracksMarkersProbability' },
	'tracksmarkersspeaker' => { 264 => 'TracksMarkersSpeaker' },
	'tracksmarkersstarttime' => { 264 => 'TracksMarkersStartTime' },
	'tracksmarkerstarget' => { 264 => 'TracksMarkersTarget' },
	'tracksmarkerstype' => { 264 => 'TracksMarkersType' },
	'trackstrackname' => { 264 => 'TracksTrackName' },
	'trackstracktype' => { 264 => 'TracksTrackType' },
	'trailersignature' => { 105 => 'zmie' },
	'transferfunction' => { 70 => 0x12d, 260 => 'TransferFunction' },
	'transform' => { 199 => [0x8012,0x59] },
	'transmissionreference' => { 253 => 'TransmissionReference' },
	'trapped' => { 188 => 'Trapped', 252 => 'Trapped' },
	'travelday' => { 199 => 0x36 },
	'ttl_da_adown' => { 209 => 0x5 },
	'ttl_da_aup' => { 209 => 0x4 },
	'ttl_da_bdown' => { 209 => 0x7 },
	'ttl_da_bup' => { 209 => 0x6 },
	'tvexposuretimesetting' => { 206 => 0x12 },
	'type' => { 246 => 'type', 259 => 'type' },
	'uniquecameramodel' => { 70 => 0xc614 },
	'uniquedocumentid' => { 76 => 0xbb },
	'uniqueobjectname' => { 77 => 0x64 },
	'unknownblock' => { 183 => 0x1103 },
	'unknowncontrast' => { 65 => 0x45 },
	'unknownev' => { 81 => 0x1 },
	'unknownlinear' => { 65 => 0x46 },
	'unknownmode' => { 67 => 0x301b },
	'unknownnumber' => { 60 => 0x180b },
	'unknownoutputhighlightpoint' => { 65 => 0x4a },
	'unknownoutputshadowpoint' => { 65 => 0x4b },
	'unknownrawhighlight' => { 65 => 0x7b },
	'unknownrawhighlightpoint' => { 65 => 0x48 },
	'unknownrawshadow' => { 65 => 0x84 },
	'unknownrawshadowpoint' => { 65 => 0x49 },
	'unknownsharpness' => { 65 => 0x47 },
	'unsharp1color' => { 172 => 0x13 },
	'unsharp1halowidth' => { 172 => 0x19 },
	'unsharp1intensity' => { 172 => 0x17 },
	'unsharp1threshold' => { 172 => 0x1b },
	'unsharp2color' => { 172 => 0x2e },
	'unsharp2halowidth' => { 172 => 0x34 },
	'unsharp2intensity' => { 172 => 0x32 },
	'unsharp2threshold' => { 172 => 0x36 },
	'unsharp3color' => { 172 => 0x49 },
	'unsharp3halowidth' => { 172 => 0x4f },
	'unsharp3intensity' => { 172 => 0x4d },
	'unsharp3threshold' => { 172 => 0x51 },
	'unsharp4color' => { 172 => 0x64 },
	'unsharp4halowidth' => { 172 => 0x6a },
	'unsharp4intensity' => { 172 => 0x68 },
	'unsharp4threshold' => { 172 => 0x6c },
	'unsharpcount' => { 172 => 0x0 },
	'unsharpmask' => { 167 => 0x76a43200 },
	'urgency' => { 76 => 0xa, 253 => 'Urgency' },
	'url' => { 98 => 'URL', 190 => 'URL', 219 => 0x40b, 255 => 'url' },
	'usablemeteringmodes' => { 47 => 0x10a },
	'usableshootingmodes' => { 47 => 0x109 },
	'usage' => { 256 => 'usage' },
	'usagefee' => { 257 => 'usageFee' },
	'usageterms' => { 268 => 'UsageTerms' },
	'usercomment' => { 60 => 0x805, 70 => 0x9286, 249 => 'UserComment' },
	'userdef1picturestyle' => { 13 => 0x10c },
	'userdef2picturestyle' => { 13 => 0x10e },
	'userdef3picturestyle' => { 13 => 0x110 },
	'userfields' => { 240 => 'UserFields' },
	'userprofile' => { 194 => 0x302, 200 => 0x3038 },
	'usmlenselectronicmf' => { 46 => 0x7, 47 => 0x501 },
	'utmeasting' => { 109 => 'Easting' },
	'utmmapdatum' => { 109 => 'Datum' },
	'utmnorthing' => { 109 => 'Northing' },
	'utmzone' => { 109 => 'Zone' },
	'uv-irfiltercorrection' => { 194 => 0x325 },
	'validbits' => { 183 => 0x611, 184 => 0x102c },
	'validpixeldepth' => { 187 => 0x611 },
	'variousmodes' => { 83 => 0x26 },
	'variousmodes2' => { 83 => 0x3a },
	'variprogram' => { 139 => 0xab },
	'version' => { 74 => 0x0, 221 => 'Version', 245 => 'Version' },
	'versioncreatedate' => { 235 => 0xd100 },
	'versionid' => { 265 => 'VersionID' },
	'versionidentifier' => { 255 => 'versionIdentifier' },
	'versionmodifydate' => { 235 => 0xd101 },
	'versionscomments' => { 265 => 'VersionsComments' },
	'versionseventaction' => { 265 => 'VersionsEventAction' },
	'versionseventchanged' => { 265 => 'VersionsEventChanged' },
	'versionseventinstanceid' => { 265 => 'VersionsEventInstanceID' },
	'versionseventparameters' => { 265 => 'VersionsEventParameters' },
	'versionseventsoftwareagent' => { 265 => 'VersionsEventSoftwareAgent' },
	'versionseventwhen' => { 265 => 'VersionsEventWhen' },
	'versionsmodifier' => { 265 => 'VersionsModifier' },
	'versionsmodifydate' => { 265 => 'VersionsModifyDate' },
	'versionsversion' => { 265 => 'VersionsVersion' },
	'verticalafonbutton' => { 174 => '3.2' },
	'vfdisplayillumination' => { 47 => 0x510 },
	'vibrance' => { 245 => 'Vibrance' },
	'vibrationreduction' => { 145 => [0x75,0x82,0x1ae], 153 => '586.1', 155 => '590.2', 158 => 0x4 },
	'videoalphamode' => { 264 => 'videoAlphaMode' },
	'videoalphapremultiplecolora' => { 264 => 'videoAlphaPremultipleColorA' },
	'videoalphapremultiplecolorb' => { 264 => 'videoAlphaPremultipleColorB' },
	'videoalphapremultiplecolorblack' => { 264 => 'videoAlphaPremultipleColorBlack' },
	'videoalphapremultiplecolorblue' => { 264 => 'videoAlphaPremultipleColorBlue' },
	'videoalphapremultiplecolorcyan' => { 264 => 'videoAlphaPremultipleColorCyan' },
	'videoalphapremultiplecolorgreen' => { 264 => 'videoAlphaPremultipleColorGreen' },
	'videoalphapremultiplecolorl' => { 264 => 'videoAlphaPremultipleColorL' },
	'videoalphapremultiplecolormagenta' => { 264 => 'videoAlphaPremultipleColorMagenta' },
	'videoalphapremultiplecolormode' => { 264 => 'videoAlphaPremultipleColorMode' },
	'videoalphapremultiplecolorred' => { 264 => 'videoAlphaPremultipleColorRed' },
	'videoalphapremultiplecolorswatchname' => { 264 => 'videoAlphaPremultipleColorSwatchName' },
	'videoalphapremultiplecolortype' => { 264 => 'videoAlphaPremultipleColorType' },
	'videoalphapremultiplecoloryellow' => { 264 => 'videoAlphaPremultipleColorYellow' },
	'videoalphaunityistransparent' => { 264 => 'videoAlphaUnityIsTransparent' },
	'videocolorspace' => { 264 => 'videoColorSpace' },
	'videocompressor' => { 264 => 'videoCompressor' },
	'videofieldorder' => { 264 => 'videoFieldOrder' },
	'videoframerate' => { 264 => 'videoFrameRate' },
	'videoframesizeh' => { 264 => 'videoFrameSizeH' },
	'videoframesizeunit' => { 264 => 'videoFrameSizeUnit' },
	'videoframesizew' => { 264 => 'videoFrameSizeW' },
	'videomoddate' => { 264 => 'videoModDate' },
	'videopixelaspectratio' => { 264 => 'videoPixelAspectRatio' },
	'videopixeldepth' => { 264 => 'videoPixelDepth' },
	'videoquality' => { 67 => 0x4003 },
	'viewfinderdisplay' => { 174 => '12.4' },
	'viewfinderwarning' => { 174 => '13.4', 177 => '6.2', 178 => '4.4' },
	'viewinfoduringexposure' => { 47 => 0x407 },
	'vignetteamount' => { 245 => 'VignetteAmount' },
	'vignettecontrol' => { 139 => 0x2a, 167 => 0x76a43205 },
	'vignettecontrolintensity' => { 167 => 0xac6bd5c0 },
	'vignettemidpoint' => { 245 => 'VignetteMidpoint' },
	'voicememo' => { 228 => 0x216 },
	'volume' => { 255 => 'volume' },
	'vr_0x66' => { 145 => 0x66 },
	'vrdoffset' => { 34 => 0xd0 },
	'wb_bluepresetsfluorescent' => { 116 => 0x40a },
	'wb_gbrglevels' => { 116 => 0xae, 119 => 0x4 },
	'wb_glevel' => { 183 => 0x11f },
	'wb_glevel3000k' => { 183 => 0x113 },
	'wb_glevel3300k' => { 183 => 0x114 },
	'wb_glevel3600k' => { 183 => 0x115 },
	'wb_glevel3900k' => { 183 => 0x116 },
	'wb_glevel4000k' => { 183 => 0x117 },
	'wb_glevel4300k' => { 183 => 0x118 },
	'wb_glevel4500k' => { 183 => 0x119 },
	'wb_glevel4800k' => { 183 => 0x11a },
	'wb_glevel5300k' => { 183 => 0x11b },
	'wb_glevel6000k' => { 183 => 0x11c },
	'wb_glevel6600k' => { 183 => 0x11d },
	'wb_glevel7500k' => { 183 => 0x11e },
	'wb_grbglevels' => { 127 => 0x0 },
	'wb_rbgglevels' => { 124 => 0x0 },
	'wb_rblevels' => { 139 => 0xc, 183 => 0x100 },
	'wb_rblevels3000k' => { 183 => 0x102 },
	'wb_rblevels3300k' => { 183 => 0x103 },
	'wb_rblevels3600k' => { 183 => 0x104 },
	'wb_rblevels3900k' => { 183 => 0x105 },
	'wb_rblevels4000k' => { 183 => 0x106 },
	'wb_rblevels4300k' => { 183 => 0x107 },
	'wb_rblevels4500k' => { 183 => 0x108 },
	'wb_rblevels4800k' => { 183 => 0x109 },
	'wb_rblevels5300k' => { 183 => 0x10a },
	'wb_rblevels6000k' => { 183 => 0x10b },
	'wb_rblevels6600k' => { 183 => 0x10c },
	'wb_rblevels7500k' => { 183 => 0x10d },
	'wb_rblevelsauto' => { 187 => 0x110 },
	'wb_rblevelscloudy' => { 118 => 0x10, 187 => 0x121 },
	'wb_rblevelscoolwhitef' => { 118 => 0x14 },
	'wb_rblevelscoolwhitefluor' => { 187 => 0x132 },
	'wb_rblevelscwb1' => { 183 => 0x10e },
	'wb_rblevelscwb2' => { 183 => 0x10f },
	'wb_rblevelscwb3' => { 183 => 0x110 },
	'wb_rblevelscwb4' => { 183 => 0x111 },
	'wb_rblevelsdaylight' => { 118 => 0xc },
	'wb_rblevelsdaylightf' => { 118 => 0x24 },
	'wb_rblevelsdaylightfluor' => { 187 => 0x130 },
	'wb_rblevelsdaywhitef' => { 118 => 0x28 },
	'wb_rblevelsdaywhitefluor' => { 187 => 0x131 },
	'wb_rblevelseveningsunlight' => { 187 => 0x124 },
	'wb_rblevelsfineweather' => { 187 => 0x122 },
	'wb_rblevelsflash' => { 118 => 0x18 },
	'wb_rblevelsshade' => { 118 => 0x20, 187 => 0x120 },
	'wb_rblevelstungsten' => { 118 => 0x8, 187 => 0x123 },
	'wb_rblevelsunknown' => { 118 => 0x1c },
	'wb_rblevelsused' => { 187 => 0x100 },
	'wb_rblevelswhitef' => { 118 => 0x2c },
	'wb_rblevelswhitefluorescent' => { 187 => 0x133 },
	'wb_rbpresetcloudy' => { 116 => 0x3f0 },
	'wb_rbpresetcoolwhitef' => { 116 => 0x308 },
	'wb_rbpresetcustom' => { 116 => 0x424 },
	'wb_rbpresetdaylight' => { 116 => 0x3ec },
	'wb_rbpresetflash' => { 116 => [0x3f4,0x304] },
	'wb_rbpresetshade' => { 116 => 0x418 },
	'wb_rbpresettungsten' => { 116 => 0x3e8 },
	'wb_redpresetsfluorescent' => { 116 => 0x3fc },
	'wb_rgbglevels' => { 126 => 0x0 },
	'wb_rgblevels' => { 116 => 0x96, 195 => 0xd, 196 => 0x413, 200 => 0x3036 },
	'wb_rggblevels' => { 119 => 0x4, 125 => 0x0, 227 => 0xa021 },
	'wb_rggblevelsasshot' => { 22 => 0x19, 23 => 0x22, 24 => 0x3f, 25 => 0x3f, 26 => 0x47 },
	'wb_rggblevelsauto' => { 21 => 0x0, 22 => 0x1e, 23 => 0x18, 24 => 0x44, 25 => 0x44, 26 => 0x4c },
	'wb_rggblevelscloudy' => { 21 => 0xc, 22 => 0x2d, 23 => 0x31, 24 => 0x58, 25 => 0x5d, 26 => 0x65, 213 => 0x20f },
	'wb_rggblevelscustom' => { 21 => 0x1c, 24 => 0x80 },
	'wb_rggblevelscustom1' => { 22 => 0x41 },
	'wb_rggblevelscustom2' => { 22 => 0x46 },
	'wb_rggblevelsdaylight' => { 21 => 0x4, 22 => 0x23, 23 => 0x27, 24 => 0x4e, 25 => 0x53, 26 => 0x5b, 213 => 0x20d },
	'wb_rggblevelsflash' => { 21 => 0x18, 22 => 0x3c, 23 => 0x45, 24 => 0x6c, 25 => 0x71, 26 => 0x79, 213 => 0x214 },
	'wb_rggblevelsfluorescent' => { 21 => 0x14, 22 => 0x37, 23 => 0x3b, 24 => 0x62, 25 => 0x67, 26 => 0x6f },
	'wb_rggblevelsfluorescentd' => { 213 => 0x211 },
	'wb_rggblevelsfluorescentn' => { 213 => 0x212 },
	'wb_rggblevelsfluorescentw' => { 213 => 0x213 },
	'wb_rggblevelskelvin' => { 21 => 0x20, 23 => 0x40, 24 => 0x67, 25 => 0x6c, 26 => 0x74 },
	'wb_rggblevelsmeasured' => { 24 => 0x49, 25 => 0x49, 26 => 0x51 },
	'wb_rggblevelspc1' => { 23 => 0x90, 24 => 0x71 },
	'wb_rggblevelspc2' => { 23 => 0x95, 24 => 0x76 },
	'wb_rggblevelspc3' => { 23 => 0x9a, 24 => 0x7b },
	'wb_rggblevelsshade' => { 21 => 0x8, 22 => 0x28, 23 => 0x2c, 24 => 0x53, 25 => 0x58, 26 => 0x60, 213 => 0x20e },
	'wb_rggblevelstungsten' => { 21 => 0x10, 22 => 0x32, 23 => 0x36, 24 => 0x5d, 25 => 0x62, 26 => 0x6a, 213 => 0x210 },
	'wb_rggblevelsunknown' => { 23 => 0x1d, 25 => 0x4e, 26 => 0x56 },
	'wb_rggblevelsunknown10' => { 23 => 0x72, 25 => 0x9e, 26 => 0xa6 },
	'wb_rggblevelsunknown11' => { 23 => 0x77, 25 => 0xa3, 26 => 0xab },
	'wb_rggblevelsunknown12' => { 23 => 0x7c, 26 => 0xb0 },
	'wb_rggblevelsunknown13' => { 23 => 0x81, 26 => 0xb5 },
	'wb_rggblevelsunknown14' => { 23 => 0x86 },
	'wb_rggblevelsunknown15' => { 23 => 0x8b },
	'wb_rggblevelsunknown16' => { 23 => 0x9f },
	'wb_rggblevelsunknown2' => { 23 => 0x4a, 25 => 0x76, 26 => 0x7e },
	'wb_rggblevelsunknown3' => { 23 => 0x4f, 25 => 0x7b, 26 => 0x83 },
	'wb_rggblevelsunknown4' => { 23 => 0x54, 25 => 0x80, 26 => 0x88 },
	'wb_rggblevelsunknown5' => { 23 => 0x59, 25 => 0x85, 26 => 0x8d },
	'wb_rggblevelsunknown6' => { 23 => 0x5e, 25 => 0x8a, 26 => 0x92 },
	'wb_rggblevelsunknown7' => { 23 => 0x63, 25 => 0x8f, 26 => 0x97 },
	'wb_rggblevelsunknown8' => { 23 => 0x68, 25 => 0x94, 26 => 0x9c },
	'wb_rggblevelsunknown9' => { 23 => 0x6d, 25 => 0x99, 26 => 0xa1 },
	'wbadjbluebalance' => { 173 => 0x8 },
	'wbadjcolortemp' => { 64 => 0x1a },
	'wbadjlighting' => { 173 => 0x15 },
	'wbadjlightingsubtype' => { 173 => 0x14 },
	'wbadjmode' => { 173 => 0x10 },
	'wbadjredbalance' => { 173 => 0x0 },
	'wbadjrgblevels' => { 64 => 0x8 },
	'wbadjtemperature' => { 173 => 0x18 },
	'wbadjtint' => { 173 => 0x25 },
	'wbadjustab' => { 199 => 0x46 },
	'wbadjustgm' => { 199 => 0x47 },
	'wbbluelevel' => { 194 => 0x324, 199 => 0x8006, 201 => 0x26 },
	'wbbracketmode' => { 30 => 0x9 },
	'wbbracketvalueab' => { 30 => 0xc },
	'wbbracketvaluegm' => { 30 => 0xd },
	'wbfinetuneactive' => { 64 => 0x24 },
	'wbfinetunesaturation' => { 64 => 0x28 },
	'wbfinetunetone' => { 64 => 0x2c },
	'wbgreenlevel' => { 194 => 0x323, 199 => 0x8005, 201 => 0x25 },
	'wbmediaimagesizesetting' => { 47 => 0x708 },
	'wbmode' => { 118 => 0x4, 184 => 0x1015 },
	'wbredlevel' => { 194 => 0x322, 199 => 0x8004, 201 => 0x24 },
	'wbscale' => { 119 => 0x0 },
	'wbshiftab' => { 40 => 0xc, 207 => 0x10 },
	'wbshiftgm' => { 40 => 0xd },
	'wbshiftmg' => { 207 => 0x11 },
	'webstatement' => { 268 => 'WebStatement' },
	'whitebalance' => { 2 => 0x6f, 3 => [0x44,0x4a], 4 => 0x36, 5 => 0x5e, 6 => 0x36, 8 => 0x6f, 9 => 0x6f, 10 => 0x73, 11 => 0x6f, 12 => 0x78, 13 => 0x54, 14 => 0x6f, 16 => 0x53, 40 => 0x8, 42 => 0x7, 66 => 0x7, 67 => [0x19,0x2012], 70 => [0xa403,0xfe4e], 74 => 0x1002, 81 => 0x3fc, 82 => 0xfa0d, 83 => 0x40, 111 => 0x3, 112 => 0xe, 113 => 0x4, 114 => 0xb, 115 => 0x115, 139 => 0x5, 157 => 0x7, 194 => 0x304, 199 => 0x3, 200 => 0x3033, 213 => 0x19, 215 => 0x7, 222 => 0x26, 229 => [0x3c,0x7], 232 => [0x115,0xb054], 245 => 'WhiteBalance', 249 => 'WhiteBalance' },
	'whitebalance2' => { 179 => 0x500 },
	'whitebalanceadj' => { 64 => 0x18, 167 => 0x76a43204 },
	'whitebalancebias' => { 67 => 0x2011, 184 => 0x304, 199 => 0x23 },
	'whitebalanceblue' => { 40 => 0x7 },
	'whitebalancebracket' => { 179 => 0x502, 184 => 0x303 },
	'whitebalancebracketing' => { 114 => 0x22 },
	'whitebalancecomp' => { 187 => 0x1001 },
	'whitebalancefinetune' => { 74 => 0x100a, 114 => 0x38, 115 => 0x112, 139 => 0xb, 230 => 0x6, 232 => 0x112 },
	'whitebalancemode' => { 213 => 0x1a },
	'whitebalancered' => { 40 => 0x6 },
	'whitebalanceset' => { 206 => 0xa },
	'whitebalancesetting' => { 114 => 0x23 },
	'whitebalancetemperature' => { 179 => 0x501 },
	'whiteboard' => { 184 => 0x301 },
	'whitelevel' => { 70 => 0xc61d },
	'whitepoint' => { 70 => 0x13e, 213 => 0x201, 260 => 'WhitePoint' },
	'widefocuszone' => { 111 => 0x2f },
	'widerange' => { 228 => 0x20f },
	'wordcount' => { 255 => 'wordCount' },
	'workcolorspace' => { 64 => 0x270 },
	'worldtimelocation' => { 199 => 0x3a, 213 => 0x22 },
	'writer-editor' => { 76 => 0x7a },
	'x3filllight' => { 229 => 0x12 },
	'xmp' => { 71 => 'XMP' },
	'xmptoolkit' => { 261 => 'xmptk' },
	'xpauthor' => { 70 => 0x9c9d },
	'xpcomment' => { 70 => 0x9c9c },
	'xpkeywords' => { 70 => 0x9c9e },
	'xposition' => { 70 => 0x11e },
	'xpsubject' => { 70 => 0x9c9f },
	'xptitle' => { 70 => 0x9c9b },
	'xresolution' => { 70 => 0x11a, 79 => 0x3, 220 => 0x0, 260 => 'XResolution' },
	'xyresolution' => { 73 => 0x3 },
	'ycbcrcoefficients' => { 70 => 0x211, 260 => 'YCbCrCoefficients' },
	'ycbcrpositioning' => { 70 => 0x213, 260 => 'YCbCrPositioning' },
	'ycbcrsubsampling' => { 70 => 0x212, 260 => 'YCbCrSubSampling' },
	'yearcreated' => { 83 => 0x10, 92 => 0xc },
	'yposition' => { 70 => 0x11f },
	'yresolution' => { 70 => 0x11b, 79 => 0x5, 220 => 0x4, 260 => 'YResolution' },
	'zonematching' => { 115 => 0x10a, 118 => [0x3a,0x4a], 232 => 0xb024 },
	'zonematchingmode' => { 114 => 0x14 },
	'zonematchingon' => { 113 => 0x75 },
	'zonematchingvalue' => { 230 => 0x1f },
	'zoomsourcewidth' => { 20 => 0x24 },
	'zoomstepcount' => { 182 => 0x300, 184 => 0x100d },
	'zoomtargetwidth' => { 20 => 0x25 },
);

# lookup for non-writable tags to check if the name exists
my %tagExists = (
	'_ac3' => 1,
	'_h264' => 1,
	'_stream' => 1,
	'a100dataoffset' => 1,
	'abstract' => 1,
	'accessdate' => 1,
	'acdsee' => 1,
	'actualcompensation' => 1,
	'adobe' => 1,
	'adobe_cm' => 1,
	'adobecmtype' => 1,
	'adobecrw' => 1,
	'adobekoda' => 1,
	'adobeleaf' => 1,
	'adobemrw' => 1,
	'adobepano' => 1,
	'adobephotoshop' => 1,
	'adoberaf' => 1,
	'adobesr2' => 1,
	'advancedcontentencryption' => 1,
	'advancedmutualexcl' => 1,
	'adventrevision' => 1,
	'adventscale' => 1,
	'aeinfo' => 1,
	'afarea' => 1,
	'afareaheights' => 1,
	'afareawidths' => 1,
	'afareaxpositions' => 1,
	'afareaypositions' => 1,
	'afcp' => 1,
	'afcp_iptc' => 1,
	'afinfo' => 1,
	'afinfo2' => 1,
	'afinfo2version' => 1,
	'afinfocus' => 1,
	'afinfosize' => 1,
	'afm' => 1,
	'afmicroadj' => 1,
	'afpointsinfocus1d' => 1,
	'afpointsselected' => 1,
	'aftune' => 1,
	'aimetadata' => 1,
	'aiprivatedata' => 1,
	'album2' => 1,
	'albumartist' => 1,
	'albumcoverurl' => 1,
	'albumname' => 1,
	'albumsortorder' => 1,
	'albumtitle' => 1,
	'albumtitleid' => 1,
	'aliaslayermetadata' => 1,
	'alphabitdepth' => 1,
	'alphabytecount' => 1,
	'alphachannelsnames' => 1,
	'alphacompression' => 1,
	'alphadatadiscard' => 1,
	'alphafilter' => 1,
	'alphaidentifiers' => 1,
	'alphainterlace' => 1,
	'alphaoffset' => 1,
	'alphasample' => 1,
	'alternateduotonecolors' => 1,
	'alternatespotcolors' => 1,
	'animationextension' => 1,
	'animationiterations' => 1,
	'annotation' => 1,
	'annotations' => 1,
	'anta' => 1,
	'aperture' => 1,
	'aperturedisplayed' => 1,
	'aperturesetting' => 1,
	'apeversion' => 1,
	'app14flags0' => 1,
	'app14flags1' => 1,
	'app1_profile' => 1,
	'applestoreaccount' => 1,
	'applestoreaccounttype' => 1,
	'applestorecatalogid' => 1,
	'applestorecountry' => 1,
	'application' => 1,
	'applicationdata' => 1,
	'applicationmissingmsg' => 1,
	'applicationversion' => 1,
	'appversion' => 1,
	'archivallocation' => 1,
	'archivedfilename' => 1,
	'artist2' => 1,
	'artistlen' => 1,
	'artisturl' => 1,
	'ascender' => 1,
	'ascent' => 1,
	'asfleakybucketpairs' => 1,
	'asfpacketcount' => 1,
	'asfsecurityobjectssize' => 1,
	'aspectratiotype' => 1,
	'aspectratiox' => 1,
	'aspectratioy' => 1,
	'association' => 1,
	'assumeddisplaysize' => 1,
	'assumeddistanceview' => 1,
	'atob0' => 1,
	'atob1' => 1,
	'atob2' => 1,
	'attachedfile' => 1,
	'attachedfiledata' => 1,
	'attachedfiledescription' => 1,
	'attachedfilemimetype' => 1,
	'attachedfilename' => 1,
	'attachedfilereferral' => 1,
	'attachedfileuid' => 1,
	'attachments' => 1,
	'audiences' => 1,
	'audioattributes' => 1,
	'audioavgbitrate' => 1,
	'audiobitrate' => 1,
	'audiobitspersample' => 1,
	'audiobytes' => 1,
	'audiochannels' => 1,
	'audiocodec' => 1,
	'audiocodecdescription' => 1,
	'audiocodecid' => 1,
	'audiocodecinfo' => 1,
	'audiocodecname' => 1,
	'audiodelay' => 1,
	'audioencoding' => 1,
	'audiofilesize' => 1,
	'audiofileurl' => 1,
	'audioformat' => 1,
	'audioframesize' => 1,
	'audiogain' => 1,
	'audioheader' => 1,
	'audioinfo' => 1,
	'audiolayer' => 1,
	'audiomaxbitrate' => 1,
	'audiomode' => 1,
	'audioprofile' => 1,
	'audioprofileversion' => 1,
	'audiosamplebits' => 1,
	'audiosamplecount' => 1,
	'audiosampledesc' => 1,
	'audiosamplesize' => 1,
	'audiosize' => 1,
	'audiosourceurl' => 1,
	'audiostream' => 1,
	'audiostreamtype' => 1,
	'audiotrackid' => 1,
	'audiovendorid' => 1,
	'authorlen' => 1,
	'authorship' => 1,
	'authorurl' => 1,
	'aux' => 1,
	'averagelevel' => 1,
	'avgbitrate' => 1,
	'avgbytespersec' => 1,
	'avgpacketsize' => 1,
	'avgpdusize' => 1,
	'avgwidth' => 1,
	'avi1' => 1,
	'avif' => 1,
	'aviheader' => 1,
	'axisdistancex' => 1,
	'axisdistancey' => 1,
	'axisdistancez' => 1,
	'background' => 1,
	'backgroundcolor' => 1,
	'backgroundcolorindicator' => 1,
	'backgroundcolorvalue' => 1,
	'backgroundimageid' => 1,
	'backgroundtiling' => 1,
	'backlight' => 1,
	'backserial' => 1,
	'backuptime' => 1,
	'badfaxlines' => 1,
	'balance' => 1,
	'band' => 1,
	'bandwidthsharing' => 1,
	'bannerimage' => 1,
	'bannerimagedata' => 1,
	'bannerimagetype' => 1,
	'bannerimageurl' => 1,
	'baselinelength' => 1,
	'baseviewpointnum' => 1,
	'basisobject' => 1,
	'bass' => 1,
	'batteryinfo' => 1,
	'beatsperminute' => 1,
	'binaryfilter' => 1,
	'binaryxml' => 1,
	'bitrate' => 1,
	'bitratemutualexclusion' => 1,
	'bitsperextendedrunlength' => 1,
	'bitsperpixel' => 1,
	'bitsperrunlength' => 1,
	'blackleveldeltah' => 1,
	'blackleveldeltav' => 1,
	'blackmaskbottomborder' => 1,
	'blackmaskleftborder' => 1,
	'blackmaskrightborder' => 1,
	'blackmasktopborder' => 1,
	'block' => 1,
	'blockaddid' => 1,
	'blockadditional' => 1,
	'blockadditionalid' => 1,
	'blockadditions' => 1,
	'blockduration' => 1,
	'blockgroup' => 1,
	'blocklocation' => 1,
	'blockmore' => 1,
	'blocksize' => 1,
	'blocksizemax' => 1,
	'blocksizemin' => 1,
	'blockspercolumn' => 1,
	'blocksperframe' => 1,
	'blocksperrow' => 1,
	'blockvirtual' => 1,
	'blueadjust' => 1,
	'bluegain' => 1,
	'bluematrixcolumn' => 1,
	'blueprimary' => 1,
	'bluesample' => 1,
	'bluetrc' => 1,
	'bluex' => 1,
	'bluey' => 1,
	'booktitle' => 1,
	'bordercolor' => 1,
	'borderid' => 1,
	'borderinformation' => 1,
	'borderlocation' => 1,
	'bordername' => 1,
	'bordersversion' => 1,
	'bordertype' => 1,
	'bottommag' => 1,
	'boundaryorigin' => 1,
	'boundingbox' => 1,
	'bracketshot' => 1,
	'breakchar' => 1,
	'brightnessdata' => 1,
	'broadcast' => 1,
	'btoa0' => 1,
	'btoa1' => 1,
	'btoa2' => 1,
	'bufferaverage' => 1,
	'builddate' => 1,
	'buildversion' => 1,
	'bw_halftoninginfo' => 1,
	'bw_transferfunc' => 1,
	'bytes' => 1,
	'bytesperminute' => 1,
	'cachecontrol' => 1,
	'cachedimageheight' => 1,
	'cachedimagewidth' => 1,
	'calibrationdatetime' => 1,
	'camera' => 1,
	'camera1' => 1,
	'camera2' => 1,
	'cameraarrangementinterval' => 1,
	'camerabacktype' => 1,
	'camerabody' => 1,
	'camerabyteorder' => 1,
	'cameradatetime' => 1,
	'camerainfo' => 1,
	'camerainfo7d_2a' => 1,
	'camerainfo7d_2b' => 1,
	'cameraname' => 1,
	'cameraobjbacktype' => 1,
	'cameraobject' => 1,
	'cameraobjname' => 1,
	'cameraobjtype' => 1,
	'cameraobjversion' => 1,
	'cameraprofileversion' => 1,
	'camerasettings' => 1,
	'camerasettings2' => 1,
	'camerasettingsa100' => 1,
	'camerasettingsifd' => 1,
	'camerasettingsunknown' => 1,
	'camerasetup' => 1,
	'cameraspecification' => 1,
	'can_skip_backward' => 1,
	'can_skip_forward' => 1,
	'canon' => 1,
	'canon_afinfo2_0x000d' => 1,
	'canon_afinfo_0x000b' => 1,
	'canonafinfo' => 1,
	'canonafinfo2' => 1,
	'canoncamerainfo1000d' => 1,
	'canoncamerainfo1d' => 1,
	'canoncamerainfo1dmkii' => 1,
	'canoncamerainfo1dmkiii' => 1,
	'canoncamerainfo1dmkiin' => 1,
	'canoncamerainfo1dmkiv' => 1,
	'canoncamerainfo40d' => 1,
	'canoncamerainfo450d' => 1,
	'canoncamerainfo500d' => 1,
	'canoncamerainfo50d' => 1,
	'canoncamerainfo550d' => 1,
	'canoncamerainfo5d' => 1,
	'canoncamerainfo5dmkii' => 1,
	'canoncamerainfo7d' => 1,
	'canoncamerainfopowershot' => 1,
	'canoncamerainfopowershot2' => 1,
	'canoncamerainfounknown' => 1,
	'canoncamerainfounknown16' => 1,
	'canoncamerainfounknown32' => 1,
	'canoncamerasettings' => 1,
	'canoncolorinfo1' => 1,
	'canoncolorinfo2' => 1,
	'canonfileinfo' => 1,
	'canonflags' => 1,
	'canonfocallength' => 1,
	'canonimageheight' => 1,
	'canonimagewidth' => 1,
	'canonpanorama' => 1,
	'canonrawmakemodel' => 1,
	'canonshotinfo' => 1,
	'canseektoend' => 1,
	'capheight' => 1,
	'captiontext' => 1,
	'captprofbacktype' => 1,
	'captprofname' => 1,
	'captproftype' => 1,
	'captprofversion' => 1,
	'captureconditionspar' => 1,
	'capturedevicefid' => 1,
	'captureobjbacktype' => 1,
	'captureobjname' => 1,
	'captureobjtype' => 1,
	'captureobjversion' => 1,
	'captureprofile' => 1,
	'captureresolution' => 1,
	'captureserial' => 1,
	'capturesetup' => 1,
	'capturexresolution' => 1,
	'capturexresolutionunit' => 1,
	'captureyresolution' => 1,
	'captureyresolutionunit' => 1,
	'casio' => 1,
	'casiodata' => 1,
	'casiojunk' => 1,
	'casioquality' => 1,
	'casioqvmi' => 1,
	'cc' => 1,
	'ccdrect' => 1,
	'ccdvalidrect' => 1,
	'ccdvideorect' => 1,
	'centerdarkrect' => 1,
	'cfalayout' => 1,
	'cfapattern2' => 1,
	'cfaplanecolor' => 1,
	'cfarepeatpatterndim' => 1,
	'channelmode' => 1,
	'channelpositions' => 1,
	'chapter' => 1,
	'chapteratom' => 1,
	'chaptercountry' => 1,
	'chapterdisplay' => 1,
	'chapterflagenabled' => 1,
	'chapterflaghidden' => 1,
	'chapterlanguage' => 1,
	'chapterlist' => 1,
	'chapterphysicalequivalent' => 1,
	'chapterprocess' => 1,
	'chapterprocesscodecid' => 1,
	'chapterprocesscommand' => 1,
	'chapterprocessdata' => 1,
	'chapterprocessprivate' => 1,
	'chapterprocesstime' => 1,
	'chapters' => 1,
	'chaptersegmenteditionuid' => 1,
	'chaptersegmentuid' => 1,
	'chapterstring' => 1,
	'chaptertimeend' => 1,
	'chaptertimestart' => 1,
	'chaptertrack' => 1,
	'chaptertracknumber' => 1,
	'chaptertranslate' => 1,
	'chaptertranslatecodec' => 1,
	'chaptertranslateeditionuid' => 1,
	'chaptertranslateid' => 1,
	'chapteruid' => 1,
	'characters' => 1,
	'characterset' => 1,
	'characterswithspaces' => 1,
	'charcountwithspaces' => 1,
	'chartarget' => 1,
	'checkedby' => 1,
	'chromaticadaptation' => 1,
	'chromaticity' => 1,
	'chromaticitychannel1' => 1,
	'chromaticitychannel2' => 1,
	'chromaticitychannel3' => 1,
	'chromaticitychannel4' => 1,
	'chromaticitychannels' => 1,
	'chromaticitycolorant' => 1,
	'chunkoffset' => 1,
	'chunkoffset64' => 1,
	'ciff' => 1,
	'cip3datafile' => 1,
	'cip3sheet' => 1,
	'cip3side' => 1,
	'circleofconfusion' => 1,
	'class' => 1,
	'classification' => 1,
	'cleanfaxdata' => 1,
	'clipboundary' => 1,
	'clipobjects' => 1,
	'clippath' => 1,
	'clippingboundary' => 1,
	'clippingpathname' => 1,
	'cloneid' => 1,
	'cloneobject' => 1,
	'clonetype' => 1,
	'cluster' => 1,
	'clusterduration' => 1,
	'cmmflags' => 1,
	'cmykequivalent' => 1,
	'codecdecodeall' => 1,
	'codecdownloadurl' => 1,
	'codecflavorid' => 1,
	'codecid' => 1,
	'codecinfourl' => 1,
	'codeclist' => 1,
	'codecname' => 1,
	'codecprivate' => 1,
	'codecsettings' => 1,
	'codecstate' => 1,
	'codedframesize' => 1,
	'codepage' => 1,
	'codesize' => 1,
	'codestreamheader' => 1,
	'codestreamregistration' => 1,
	'codingmethods' => 1,
	'color' => 1,
	'colorant1coordinates' => 1,
	'colorant1name' => 1,
	'colorant2coordinates' => 1,
	'colorant2name' => 1,
	'colorant3coordinates' => 1,
	'colorant3name' => 1,
	'colorantcount' => 1,
	'colorantorder' => 1,
	'coloranttable' => 1,
	'coloranttableout' => 1,
	'coloraverages' => 1,
	'colorbalance0100' => 1,
	'colorbalance0102' => 1,
	'colorbalance0103' => 1,
	'colorbalance02' => 1,
	'colorbalance0205' => 1,
	'colorbalance0209' => 1,
	'colorbalancea' => 1,
	'colorbalanceunknown' => 1,
	'colorbitdepth' => 1,
	'colorboostdata' => 1,
	'colorbw' => 1,
	'colorcalibrationmatrix' => 1,
	'colorcasts' => 1,
	'colorcharacterization' => 1,
	'colorcomponents' => 1,
	'colordata1' => 1,
	'colordata2' => 1,
	'colordata3' => 1,
	'colordata4' => 1,
	'colordata5' => 1,
	'colordataunknown' => 1,
	'colorgroup' => 1,
	'colorhalftoninginfo' => 1,
	'colorinfo' => 1,
	'colormap' => 1,
	'colorobjbacktype' => 1,
	'colorobjname' => 1,
	'colorobjtype' => 1,
	'colorobjversion' => 1,
	'colorpalette' => 1,
	'colorresolutiondepth' => 1,
	'colorresponseunit' => 1,
	'colors' => 1,
	'colorsamplersresource' => 1,
	'colorsetup' => 1,
	'colorspacedata' => 1,
	'colorspecification' => 1,
	'colortable' => 1,
	'colortransferfuncs' => 1,
	'colortransform' => 1,
	'colortwistmatrix' => 1,
	'colortype' => 1,
	'commandlinearguments' => 1,
	'commentlen' => 1,
	'comments' => 1,
	'commenttime' => 1,
	'commercialurl' => 1,
	'commissioned' => 1,
	'common' => 1,
	'commonnetworkrellink' => 1,
	'commonpathsuffix' => 1,
	'compactsamplesizes' => 1,
	'company' => 1,
	'companyname' => 1,
	'compatibility' => 1,
	'compatiblebrands' => 1,
	'compatiblefontname' => 1,
	'compilation' => 1,
	'compobj' => 1,
	'compobjusertype' => 1,
	'compobjusertypelen' => 1,
	'componentbitdepth' => 1,
	'componentdefinition' => 1,
	'componentmapping' => 1,
	'compositinglayerheader' => 1,
	'composition' => 1,
	'compositionmode' => 1,
	'compositionoptions' => 1,
	'compositiontimetosample' => 1,
	'compositiontodecodetimelinemapping' => 1,
	'compressed' => 1,
	'compressedannotation' => 1,
	'compresseddatalength' => 1,
	'compresseddataoffset' => 1,
	'compressedtext' => 1,
	'compressionlevel' => 1,
	'compressiontype' => 1,
	'compressorid' => 1,
	'compressorname' => 1,
	'compressorversion' => 1,
	'concreteflag' => 1,
	'condition' => 1,
	'conditionalfec' => 1,
	'conductor' => 1,
	'confirmedobjectsize' => 1,
	'connectionspaceilluminant' => 1,
	'consecutivebadfaxlines' => 1,
	'consoledata' => 1,
	'consolefedata' => 1,
	'cont' => 1,
	'containerformat' => 1,
	'containerversion' => 1,
	'contake' => 1,
	'contentbranding' => 1,
	'contentcompression' => 1,
	'contentcompressionalgorithm' => 1,
	'contentcompressionsettings' => 1,
	'contentdescription' => 1,
	'contentdescriptionnotes' => 1,
	'contentdisposition' => 1,
	'contentdistributor' => 1,
	'contentencoding' => 1,
	'contentencodingorder' => 1,
	'contentencodings' => 1,
	'contentencodingscope' => 1,
	'contentencodingtype' => 1,
	'contentencryption' => 1,
	'contentencryptionalgorithm' => 1,
	'contentencryptionkeyid' => 1,
	'contentgroupdescription' => 1,
	'contentlanguage' => 1,
	'contentrating' => 1,
	'contents' => 1,
	'contentscripttype' => 1,
	'contentsignature' => 1,
	'contentsignaturealgorithm' => 1,
	'contentsignaturehashalgorithm' => 1,
	'contentsignaturekeyid' => 1,
	'contentstyletype' => 1,
	'contenttype' => 1,
	'contiguouscodestream' => 1,
	'contrastadjustment' => 1,
	'contrastcurve' => 1,
	'convergenceangle' => 1,
	'convergencebaseimage' => 1,
	'convergencedistance' => 1,
	'copyrightlen' => 1,
	'copyrighturl' => 1,
	'coverart' => 1,
	'coverartmimetype' => 1,
	'cpuarchitecture' => 1,
	'cpubyteorder' => 1,
	'cpucount' => 1,
	'cpusubtype' => 1,
	'cputype' => 1,
	'cpuversions' => 1,
	'crc-32' => 1,
	'crdinfo' => 1,
	'creatingapplication' => 1,
	'creatingtransform' => 1,
	'creationpathvector' => 1,
	'creatorappid' => 1,
	'creatorapplication' => 1,
	'creatorappversion' => 1,
	'creatorinfo' => 1,
	'creatorversion' => 1,
	'cropdata' => 1,
	'cropped' => 1,
	'cropx' => 1,
	'cropxcommonoffset' => 1,
	'cropxoffset' => 1,
	'cropxoffset2' => 1,
	'cropxsize' => 1,
	'cropxviewpointnumber' => 1,
	'cropxviewpointnumber2' => 1,
	'cropy' => 1,
	'cropycommonoffset' => 1,
	'cropyoffset' => 1,
	'cropyoffset2' => 1,
	'cropysize' => 1,
	'cropyviewpointnumber' => 1,
	'cropyviewpointnumber2' => 1,
	'cross-reference' => 1,
	'crossref' => 1,
	'crs' => 1,
	'cueblocknumber' => 1,
	'cueclusterposition' => 1,
	'cuecodecstate' => 1,
	'cuepoint' => 1,
	'cuerefcluster' => 1,
	'cuerefcodecstate' => 1,
	'cuereference' => 1,
	'cuerefnumber' => 1,
	'cuereftime' => 1,
	'cues' => 1,
	'cuetime' => 1,
	'cuetrack' => 1,
	'cuetrackpositions' => 1,
	'currentbitrate' => 1,
	'currentiptcdigest' => 1,
	'currenttime' => 1,
	'currentuser' => 1,
	'cursorsize' => 1,
	'customfunctions10d' => 1,
	'customfunctions1d' => 1,
	'customfunctions2' => 1,
	'customfunctions20d' => 1,
	'customfunctions30d' => 1,
	'customfunctions350d' => 1,
	'customfunctions400d' => 1,
	'customfunctions5d' => 1,
	'customfunctionsd30' => 1,
	'customfunctionsd60' => 1,
	'customfunctionsunknown' => 1,
	'custompicturestyledata' => 1,
	'customsettingsd3' => 1,
	'customsettingsd300' => 1,
	'customsettingsd300s' => 1,
	'customsettingsd3s' => 1,
	'customsettingsd3x' => 1,
	'customsettingsd40' => 1,
	'customsettingsd5000' => 1,
	'customsettingsd80' => 1,
	'customsettingsd90' => 1,
	'd-lightinghqdata' => 1,
	'd-lightinghsdata' => 1,
	'darkcorrectiontype' => 1,
	'darwindata' => 1,
	'data' => 1,
	'data1' => 1,
	'data2' => 1,
	'datacreatedate' => 1,
	'datadump' => 1,
	'datadump2' => 1,
	'datainfo' => 1,
	'datainformation' => 1,
	'datakey' => 1,
	'datalen' => 1,
	'datalength' => 1,
	'datalocation' => 1,
	'datamodifydate' => 1,
	'dataobject' => 1,
	'dataobjectid' => 1,
	'dataobjectstatus' => 1,
	'dataobjecttitle' => 1,
	'dataoffset' => 1,
	'dataoffsets' => 1,
	'datapackets' => 1,
	'dataref' => 1,
	'datareference' => 1,
	'datasize' => 1,
	'datatype' => 1,
	'datecompleted' => 1,
	'datetime1' => 1,
	'datetime2' => 1,
	'datetimecreated' => 1,
	'dc' => 1,
	'dcmd' => 1,
	'dcme' => 1,
	'dctencodeversion' => 1,
	'dealeridnumber' => 1,
	'decimationmethod' => 1,
	'decimationprefilterwidth' => 1,
	'decode' => 1,
	'decodertable' => 1,
	'decodertablenumber' => 1,
	'defaultchar' => 1,
	'defaultdisplayheight' => 1,
	'defaultdisplaywidth' => 1,
	'defaultduration' => 1,
	'defaultimagecolor' => 1,
	'defaultrgb' => 1,
	'defaultstyle' => 1,
	'defineobject' => 1,
	'definequantizationtable' => 1,
	'delay' => 1,
	'deltapngheader' => 1,
	'deltatype' => 1,
	'deltaxy' => 1,
	'department' => 1,
	'dependentimage1entrynumber' => 1,
	'dependentimage2entrynumber' => 1,
	'depth' => 1,
	'descender' => 1,
	'designer' => 1,
	'designerurl' => 1,
	'desiredreproductions' => 1,
	'destinationid' => 1,
	'deviceattributes' => 1,
	'devicemanufacturer' => 1,
	'devicemfgdesc' => 1,
	'devicemodel' => 1,
	'devicemodeldesc' => 1,
	'devicename' => 1,
	'devicesettingdescription' => 1,
	'devicesettings' => 1,
	'dex' => 1,
	'dicom' => 1,
	'dictionary' => 1,
	'digikam' => 1,
	'digitalcreationdatetime' => 1,
	'digitaleffectsname' => 1,
	'digitaleffectstype' => 1,
	'digitaleffectsversion' => 1,
	'digitalimagebroker' => 1,
	'digitalsignature' => 1,
	'dimensions' => 1,
	'discardobjects' => 1,
	'disknumber' => 1,
	'displayheight' => 1,
	'displayinfo' => 1,
	'displayresolution' => 1,
	'displaysize' => 1,
	'displayunit' => 1,
	'displayunits' => 1,
	'displaywidth' => 1,
	'displayxresolution' => 1,
	'displayxresolutionunit' => 1,
	'displayyresolution' => 1,
	'displayyresolutionunit' => 1,
	'dispose' => 1,
	'disposition' => 1,
	'distortinfo' => 1,
	'distortionversion' => 1,
	'distribution' => 1,
	'division' => 1,
	'djvuversion' => 1,
	'dngadobedata' => 1,
	'dngprivatedata' => 1,
	'docclass' => 1,
	'docrights' => 1,
	'docsecurity' => 1,
	'doctype' => 1,
	'doctypereadversion' => 1,
	'doctypeversion' => 1,
	'documentinfo' => 1,
	'documentnumber' => 1,
	'dof' => 1,
	'donotshow' => 1,
	'dotsperinch' => 1,
	'driveserialnumber' => 1,
	'drivetype' => 1,
	'drm' => 1,
	'drm_contentid' => 1,
	'drm_drmheader' => 1,
	'drm_drmheader_contentdistributor' => 1,
	'drm_drmheader_contentid' => 1,
	'drm_drmheader_individualizedversion' => 1,
	'drm_drmheader_keyid' => 1,
	'drm_drmheader_licenseacqurl' => 1,
	'drm_drmheader_subscriptioncontentid' => 1,
	'drm_individualizedversion' => 1,
	'drm_keyid' => 1,
	'drm_lasignaturecert' => 1,
	'drm_lasignaturelicsrvcert' => 1,
	'drm_lasignatureprivkey' => 1,
	'drm_lasignaturerootcert' => 1,
	'drm_licenseacqurl' => 1,
	'drm_v1licenseacqurl' => 1,
	'dropbykeyword' => 1,
	'dropchunks' => 1,
	'ducky' => 1,
	'duotonehalftoninginfo' => 1,
	'duotoneimageinfo' => 1,
	'duotonetransferfuncs' => 1,
	'dvdid' => 1,
	'ebmlheader' => 1,
	'ebmlmaxidlength' => 1,
	'ebmlmaxsizelength' => 1,
	'ebmlreadversion' => 1,
	'ebmlversion' => 1,
	'edit1' => 1,
	'edit2' => 1,
	'edit3' => 1,
	'edit4' => 1,
	'edit5' => 1,
	'edit6' => 1,
	'edit7' => 1,
	'edit8' => 1,
	'edit9' => 1,
	'editionentry' => 1,
	'editionflagdefault' => 1,
	'editionflaghidden' => 1,
	'editionflagordered' => 1,
	'editionuid' => 1,
	'editor' => 1,
	'edittagarray' => 1,
	'effect' => 1,
	'effectivebw' => 1,
	'effectsvisible' => 1,
	'embeddedfile' => 1,
	'embeddedfilename' => 1,
	'emphasis' => 1,
	'encodedby' => 1,
	'encodedusing' => 1,
	'encoder' => 1,
	'encodersettings' => 1,
	'encoderversion' => 1,
	'encoding' => 1,
	'encodingprocess' => 1,
	'encodingscheme' => 1,
	'encodingsettings' => 1,
	'encodingtime' => 1,
	'encryptedblock' => 1,
	'encryption' => 1,
	'endpoints' => 1,
	'endtime' => 1,
	'endtimecode' => 1,
	'entrypoint' => 1,
	'envvardata' => 1,
	'episodeglobaluniqueid' => 1,
	'eppim' => 1,
	'eprint' => 1,
	'epsoptions' => 1,
	'equipment' => 1,
	'equipmentifd' => 1,
	'error' => 1,
	'errorcorrection' => 1,
	'errorcorrectiontype' => 1,
	'escchar' => 1,
	'evalstate' => 1,
	'events' => 1,
	'evstepinfo' => 1,
	'exif_profile' => 1,
	'exifinfo' => 1,
	'exifinfo2' => 1,
	'exifinformation' => 1,
	'exifoffset' => 1,
	'exiftoolversion' => 1,
	'expandfilm' => 1,
	'expandfilterlens' => 1,
	'expandflashlamp' => 1,
	'expandlens' => 1,
	'expandscanner' => 1,
	'expandsoftware' => 1,
	'expires' => 1,
	'exportimage' => 1,
	'exposurebias' => 1,
	'exposureinfo' => 1,
	'exposureunknown' => 1,
	'extcache' => 1,
	'extendedaviheader' => 1,
	'extendedcontentdescr' => 1,
	'extendedcontentencryption' => 1,
	'extendedinfo' => 1,
	'extendedstreamprops' => 1,
	'extendedxmp' => 1,
	'extenderstatus' => 1,
	'extensionclassid' => 1,
	'extensioncreatedate' => 1,
	'extensiondescription' => 1,
	'extensionmodifydate' => 1,
	'extensionname' => 1,
	'extensionpersistence' => 1,
	'extensions' => 1,
	'externalleading' => 1,
	'extraflags' => 1,
	'extrasamples' => 1,
	'facedetect1' => 1,
	'facedetect2' => 1,
	'facedetinfo' => 1,
	'facerecinfo' => 1,
	'fastseek' => 1,
	'faxprofile' => 1,
	'faxrecvparams' => 1,
	'faxrecvtime' => 1,
	'faxsubaddress' => 1,
	'fileattributes' => 1,
	'filedescription' => 1,
	'fileflags' => 1,
	'fileflagsmask' => 1,
	'filefunctionflags' => 1,
	'fileglobalprofile' => 1,
	'fileid' => 1,
	'fileinfo' => 1,
	'fileinfolen' => 1,
	'fileinfolen2' => 1,
	'fileinfoproperties' => 1,
	'fileinfoversion' => 1,
	'fileos' => 1,
	'fileowner' => 1,
	'filepermissions' => 1,
	'fileprofileversion' => 1,
	'fileproperties' => 1,
	'files' => 1,
	'filesize' => 1,
	'filesizebytes' => 1,
	'filesubtype' => 1,
	'filetype' => 1,
	'fileurl' => 1,
	'fileversionnumber' => 1,
	'fillattributes' => 1,
	'fillmethod' => 1,
	'filmbrand' => 1,
	'filmcategory' => 1,
	'filmframenumber' => 1,
	'filmgencode' => 1,
	'filmproductcode' => 1,
	'filmrollnumber' => 1,
	'filmsize' => 1,
	'filter' => 1,
	'filtering' => 1,
	'finalframeblocks' => 1,
	'firstchar' => 1,
	'firstobject' => 1,
	'firstobjectid' => 1,
	'flags' => 1,
	'flashexpcomp' => 1,
	'flashinfo' => 1,
	'flashinfo0100' => 1,
	'flashinfo0102' => 1,
	'flashinfo0103' => 1,
	'flashinfounknown' => 1,
	'flashinfoversion' => 1,
	'flashpixstreamfieldoffset' => 1,
	'flashpixstreampathname' => 1,
	'flashpower' => 1,
	'flashsyncmode' => 1,
	'flashttlmode' => 1,
	'flashversion' => 1,
	'focallength35efl' => 1,
	'focalrange' => 1,
	'focusinfo' => 1,
	'focusinfoifd' => 1,
	'focuspos' => 1,
	'font' => 1,
	'fontsize' => 1,
	'fontsubfamily' => 1,
	'fontsubfamilyid' => 1,
	'fontweight' => 1,
	'footnotes' => 1,
	'form' => 1,
	'formatter' => 1,
	'formatversion' => 1,
	'formatversiontime' => 1,
	'forwardto' => 1,
	'fotostation' => 1,
	'fourcc1' => 1,
	'fourcc2' => 1,
	'fourcc2len' => 1,
	'fourcc3' => 1,
	'fourcc3len' => 1,
	'fov' => 1,
	'fpxr' => 1,
	'fractalparameters' => 1,
	'fragmentlist' => 1,
	'fragmenttable' => 1,
	'frame' => 1,
	'framecount' => 1,
	'frameheight' => 1,
	'framepriority' => 1,
	'framerate' => 1,
	'framesize' => 1,
	'framesizemax' => 1,
	'framesizemin' => 1,
	'framewidth' => 1,
	'free' => 1,
	'freebytecounts' => 1,
	'freeoffsets' => 1,
	'fstype' => 1,
	'fujifilm' => 1,
	'fujilayout' => 1,
	'fullname' => 1,
	'fullscreen' => 1,
	'gain' => 1,
	'gamut' => 1,
	'gapless' => 1,
	'gdalmetadata' => 1,
	'gdalnodata' => 1,
	'geminfo' => 1,
	'genbalance' => 1,
	'generator' => 1,
	'genflags' => 1,
	'gengraphicsmode' => 1,
	'genmediaheader' => 1,
	'genmediainfo' => 1,
	'genmediaversion' => 1,
	'genopcolor' => 1,
	'genr' => 1,
	'genreid' => 1,
	'geo' => 1,
	'geogangularunits' => 1,
	'geogangularunitsize' => 1,
	'geogazimuthunits' => 1,
	'geogcitation' => 1,
	'geogellipsoid' => 1,
	'geoggeodeticdatum' => 1,
	'geoginvflattening' => 1,
	'geoglinearunits' => 1,
	'geoglinearunitsize' => 1,
	'geogprimemeridian' => 1,
	'geogprimemeridianlong' => 1,
	'geographictype' => 1,
	'geogsemimajoraxis' => 1,
	'geogsemiminoraxis' => 1,
	'geotiffasciiparams' => 1,
	'geotiffdirectory' => 1,
	'geotiffdoubleparams' => 1,
	'geotiffversion' => 1,
	'gifapplicationextension' => 1,
	'gifgraphiccontrolextension' => 1,
	'gifplaintextextension' => 1,
	'gifversion' => 1,
	'globalinfo' => 1,
	'globalparametersifd' => 1,
	'globalpixelsize' => 1,
	'googlebot' => 1,
	'gps' => 1,
	'gpsinfo' => 1,
	'gpsposition' => 1,
	'gradientbasedcorractive' => 1,
	'gradientbasedcorramount' => 1,
	'gradientbasedcorrbrightness' => 1,
	'gradientbasedcorrclarity' => 1,
	'gradientbasedcorrcontrast' => 1,
	'gradientbasedcorrexposure' => 1,
	'gradientbasedcorrhue' => 1,
	'gradientbasedcorrmaskcenterweight' => 1,
	'gradientbasedcorrmaskdabs' => 1,
	'gradientbasedcorrmaskflow' => 1,
	'gradientbasedcorrmaskfullx' => 1,
	'gradientbasedcorrmaskfully' => 1,
	'gradientbasedcorrmaskradius' => 1,
	'gradientbasedcorrmaskvalue' => 1,
	'gradientbasedcorrmaskwhat' => 1,
	'gradientbasedcorrmaskzerox' => 1,
	'gradientbasedcorrmaskzeroy' => 1,
	'gradientbasedcorrsaturation' => 1,
	'gradientbasedcorrsharpness' => 1,
	'gradientbasedcorrwhat' => 1,
	'graphicconverter' => 1,
	'graphicsmode' => 1,
	'graphicstechnologystandardoutput' => 1,
	'grayresponsecurve' => 1,
	'graytrc' => 1,
	'greenadjust' => 1,
	'greengain' => 1,
	'greenmatrixcolumn' => 1,
	'greenprimary' => 1,
	'greensample' => 1,
	'greentrc' => 1,
	'greenx' => 1,
	'greeny' => 1,
	'gridguidesinfo' => 1,
	'group' => 1,
	'groupcaption' => 1,
	'grouping' => 1,
	'groupmutualexclusion' => 1,
	'gtcitation' => 1,
	'gtmodeltype' => 1,
	'gtrastertype' => 1,
	'handler' => 1,
	'handlerclass' => 1,
	'handlerdescription' => 1,
	'handlertype' => 1,
	'handlervendorid' => 1,
	'hasarbitrarydatastream' => 1,
	'hasattachedimages' => 1,
	'hasaudio' => 1,
	'hascolormap' => 1,
	'hascuepoints' => 1,
	'hasfiletransferstream' => 1,
	'hasicc' => 1,
	'hasimage' => 1,
	'haskeyframes' => 1,
	'hasmetadata' => 1,
	'hasscript' => 1,
	'hasvideo' => 1,
	'hcusage' => 1,
	'hdrl' => 1,
	'hdvideo' => 1,
	'header' => 1,
	'headerext' => 1,
	'headerextension' => 1,
	'headersize' => 1,
	'headingpairs' => 1,
	'heightresolution' => 1,
	'hiddenslides' => 1,
	'highlightdata' => 1,
	'highlightendpoints' => 1,
	'hintformat' => 1,
	'hintheader' => 1,
	'hintinfo' => 1,
	'hintsampledesc' => 1,
	'hinttrackinfo' => 1,
	'historybuffersize' => 1,
	'hotkey' => 1,
	'howpublished' => 1,
	'hp_tdhd' => 1,
	'http-equiv' => 1,
	'huffmantable' => 1,
	'hyperfocaldistance' => 1,
	'hyperlinkbase' => 1,
	'hyperlinks' => 1,
	'hyperlinkschanged' => 1,
	'icc_untagged' => 1,
	'iccbased' => 1,
	'iconenvdata' => 1,
	'iconfilename' => 1,
	'iconindex' => 1,
	'id' => 1,
	'id3' => 1,
	'id3size' => 1,
	'id3v1' => 1,
	'id3v1_enh' => 1,
	'id3v2_2' => 1,
	'id3v2_3' => 1,
	'id3v2_4' => 1,
	'idc2_ifd' => 1,
	'idc_ifd' => 1,
	'idcpreviewimage' => 1,
	'identification' => 1,
	'idependentanddisposablesamples' => 1,
	'idsbasevalue' => 1,
	'ifd0_offset' => 1,
	'illustrator' => 1,
	'image' => 1,
	'imagearrangement' => 1,
	'imageboardid' => 1,
	'imagebounds' => 1,
	'imagebytecount' => 1,
	'imageclass' => 1,
	'imagecolor' => 1,
	'imagecolorindicator' => 1,
	'imagecolorvalue' => 1,
	'imagedata' => 1,
	'imagedatadiscard' => 1,
	'imagedepth' => 1,
	'imagefields' => 1,
	'imageformat' => 1,
	'imageheader' => 1,
	'imageid' => 1,
	'imageinfo' => 1,
	'imagelayer' => 1,
	'imagelength' => 1,
	'imageoffset' => 1,
	'imageprintstatus' => 1,
	'imageprocessingifd' => 1,
	'imageprofile' => 1,
	'imageprops' => 1,
	'imagerboardid' => 1,
	'imageresolution' => 1,
	'imageresources' => 1,
	'imagerotated' => 1,
	'imagerotation' => 1,
	'imagerotationstatus' => 1,
	'imagesourceek' => 1,
	'imagestatus' => 1,
	'imagetoolbar' => 1,
	'imageuidlist' => 1,
	'imageversion' => 1,
	'imgprofbacktype' => 1,
	'imgprofname' => 1,
	'imgproftype' => 1,
	'imgprofversion' => 1,
	'immediatedatabytes' => 1,
	'includedfileid' => 1,
	'index' => 1,
	'indexable' => 1,
	'indexed' => 1,
	'indexedcolourtablecount' => 1,
	'indexoffset' => 1,
	'indexparameters' => 1,
	'info' => 1,
	'infolist' => 1,
	'information' => 1,
	'ingrreserved' => 1,
	'initialdisplayeffect' => 1,
	'initializeddatasize' => 1,
	'initialkey' => 1,
	'initialobjectdescriptor' => 1,
	'inknames' => 1,
	'inputdataobjectlist' => 1,
	'inputprofile' => 1,
	'insertmode' => 1,
	'institution' => 1,
	'instructionset' => 1,
	'integrationtime' => 1,
	'intellectualproperty' => 1,
	'intellectualpropertynotes' => 1,
	'intensitystereo' => 1,
	'intergraphflagregisters' => 1,
	'intergraphmatrix' => 1,
	'intergraphpacketdata' => 1,
	'interlace' => 1,
	'interleavedfield' => 1,
	'internalidnumber' => 1,
	'internalleading' => 1,
	'internalname' => 1,
	'internalversionnumber' => 1,
	'internationaltext' => 1,
	'internetradiostationname' => 1,
	'internetradiostationowner' => 1,
	'internetradiostationurl' => 1,
	'interopoffset' => 1,
	'interpretedby' => 1,
	'involvedpeople' => 1,
	'ipmpcontrol' => 1,
	'iptc' => 1,
	'iptc_profile' => 1,
	'iptcapplication' => 1,
	'iptccore' => 1,
	'iptcdata' => 1,
	'iptcenvelope' => 1,
	'iptcext' => 1,
	'iptcnewsphoto' => 1,
	'iptcobjectdata' => 1,
	'iptcpostobjectdata' => 1,
	'iptcpreobjectdata' => 1,
	'is_protected' => 1,
	'is_trusted' => 1,
	'isbasefont' => 1,
	'isfixedpitch' => 1,
	'isfixedv' => 1,
	'isoinfo' => 1,
	'isrc' => 1,
	'isrcnumber' => 1,
	'isvbr' => 1,
	'it8header' => 1,
	'italic' => 1,
	'italicangle' => 1,
	'itch' => 1,
	'item' => 1,
	'item0032' => 1,
	'itemid' => 1,
	'iteminformation' => 1,
	'itemlocation' => 1,
	'itemprotection' => 1,
	'iterationcount' => 1,
	'iterationendaction' => 1,
	'iterationmax' => 1,
	'iterationminmax' => 1,
	'iterations' => 1,
	'itunesinfo' => 1,
	'jfif' => 1,
	'jfifversion' => 1,
	'jfxx' => 1,
	'jngheader' => 1,
	'journal' => 1,
	'jp2header' => 1,
	'jp2signature' => 1,
	'jpeg_quality' => 1,
	'jpegactables' => 1,
	'jpegdctables' => 1,
	'jpegdigest' => 1,
	'jpeglosslesspredictors' => 1,
	'jpegpointtransforms' => 1,
	'jpegproc' => 1,
	'jpegprocess' => 1,
	'jpegqtables' => 1,
	'jpegrestartinterval' => 1,
	'jpegtables' => 1,
	'jumptoxpep' => 1,
	'junk' => 1,
	'kbytesize' => 1,
	'kdc_ifd' => 1,
	'keyframepositions' => 1,
	'keyframestimes' => 1,
	'keys' => 1,
	'kids' => 1,
	'knownfolderdata' => 1,
	'kodak' => 1,
	'kodakbordersifd' => 1,
	'kodakeffectsifd' => 1,
	'kodakifd' => 1,
	'kodaktags' => 1,
	'konicaminolta' => 1,
	'konicaminoltatags' => 1,
	'lacenumber' => 1,
	'lamebitrate' => 1,
	'lameheader' => 1,
	'lamelowpassfilter' => 1,
	'lamemethod' => 1,
	'lamequality' => 1,
	'lamestereomode' => 1,
	'lamevbrquality' => 1,
	'languagecode' => 1,
	'languagelist' => 1,
	'largestpacketduration' => 1,
	'largestpacketsize' => 1,
	'lastauthor' => 1,
	'lastchar' => 1,
	'lastkeyframetime' => 1,
	'lastmodifiedby' => 1,
	'lastmodifier' => 1,
	'lastobject' => 1,
	'lastobjectid' => 1,
	'lastprinted' => 1,
	'lasttimestamp' => 1,
	'layercomps' => 1,
	'layersgroupinfo' => 1,
	'layerstateinfo' => 1,
	'leafautoactive' => 1,
	'leafautobasename' => 1,
	'leafdata' => 1,
	'leafhotfolder' => 1,
	'leafopenprochdr' => 1,
	'leafoutputfiletype' => 1,
	'leafsaveselection' => 1,
	'leafsubifd' => 1,
	'leftdarkrect' => 1,
	'leftmag' => 1,
	'legalcopyright' => 1,
	'legaltrademarks' => 1,
	'length' => 1,
	'lens35efl' => 1,
	'lensdata' => 1,
	'lensdata0100' => 1,
	'lensdata0101' => 1,
	'lensdata0201' => 1,
	'lensdata0204' => 1,
	'lensdataunknown' => 1,
	'lensdataversion' => 1,
	'lensshading' => 1,
	'lensspec' => 1,
	'libraryid' => 1,
	'licenseinfourl' => 1,
	'lightingopt' => 1,
	'lightness' => 1,
	'lights' => 1,
	'lightvalue' => 1,
	'linearizationtable' => 1,
	'lines' => 1,
	'linkerversion' => 1,
	'linkinfo' => 1,
	'linksuptodate' => 1,
	'lit' => 1,
	'localbasepath' => 1,
	'localdeltatype' => 1,
	'localeindicator' => 1,
	'lockedpropertylist' => 1,
	'locks' => 1,
	'longdescription' => 1,
	'lookheadbacktype' => 1,
	'lookheader' => 1,
	'lookheadname' => 1,
	'lookheadtype' => 1,
	'lookheadversion' => 1,
	'lookuptable' => 1,
	'loopstyle' => 1,
	'lotus' => 1,
	'lr' => 1,
	'lslv' => 1,
	'luminance' => 1,
	'luminanceconsts' => 1,
	'lyricist' => 1,
	'lyrics' => 1,
	'lyrics_synchronised' => 1,
	'machineid' => 1,
	'machinetype' => 1,
	'macintoshprintinfo' => 1,
	'magnification' => 1,
	'magnifyobject' => 1,
	'mailstop' => 1,
	'maininfo' => 1,
	'maininfoifd' => 1,
	'majorbrand' => 1,
	'makeandmodel' => 1,
	'makemodel' => 1,
	'makernotes' => 1,
	'mandatorybackground' => 1,
	'manufacturecode' => 1,
	'manufactureindex' => 1,
	'manufacturer' => 1,
	'mappingscheme' => 1,
	'markbits' => 1,
	'marker' => 1,
	'markerid' => 1,
	'matrixstructure' => 1,
	'mattcolor' => 1,
	'matte' => 1,
	'matteing' => 1,
	'matter' => 1,
	'maxband' => 1,
	'maxbitrate' => 1,
	'maxblockadditionid' => 1,
	'maxcache' => 1,
	'maxdatarate' => 1,
	'maximumbitrate' => 1,
	'maximumimageindex' => 1,
	'maximumobjectsize' => 1,
	'maximumoperationindex' => 1,
	'maximumtransformindex' => 1,
	'maxjpegtableindex' => 1,
	'maxpacketsize' => 1,
	'maxpagenormal' => 1,
	'maxpdusize' => 1,
	'maxsubfilesize' => 1,
	'maxtransmissiontime' => 1,
	'maxval' => 1,
	'maxwidth' => 1,
	'mcdi' => 1,
	'mdat' => 1,
	'mdcolortable' => 1,
	'mdfiletag' => 1,
	'mdfileunits' => 1,
	'mdlabname' => 1,
	'mdpm' => 1,
	'mdpr' => 1,
	'mdprepdate' => 1,
	'mdpreptime' => 1,
	'mdsampleinfo' => 1,
	'mdscalepixel' => 1,
	'mean' => 1,
	'measuredcolor' => 1,
	'measuredinfo' => 1,
	'measurement' => 1,
	'measurementbacking' => 1,
	'measurementflare' => 1,
	'measurementgeometry' => 1,
	'measurementilluminant' => 1,
	'measurementobserver' => 1,
	'media' => 1,
	'mediablackpoint' => 1,
	'mediaclassprimaryid' => 1,
	'mediaclasssecondaryid' => 1,
	'mediacreatedate' => 1,
	'mediacredits' => 1,
	'mediadata' => 1,
	'mediaduration' => 1,
	'mediaheader' => 1,
	'mediaheaderversion' => 1,
	'mediaindex' => 1,
	'mediainfo' => 1,
	'mediaisdelay' => 1,
	'mediaisfinale' => 1,
	'mediaislive' => 1,
	'mediaispremiere' => 1,
	'mediaisrepeat' => 1,
	'mediaissap' => 1,
	'mediaisstereo' => 1,
	'mediaissubtitled' => 1,
	'mediaistape' => 1,
	'medialanguagecode' => 1,
	'mediamodifydate' => 1,
	'medianetworkaffiliation' => 1,
	'mediaoriginalbroadcastdatetime' => 1,
	'mediaoriginalchannel' => 1,
	'mediapro' => 1,
	'mediastationcallsign' => 1,
	'mediastationname' => 1,
	'mediatimescale' => 1,
	'mediatrackbytes' => 1,
	'mediatype' => 1,
	'mediawhitepoint' => 1,
	'medium' => 1,
	'meta' => 1,
	'metadata' => 1,
	'metadatacreator' => 1,
	'metadataid' => 1,
	'metadatalibrary' => 1,
	'metadatanumber' => 1,
	'metermode' => 1,
	'microsoft' => 1,
	'mie' => 1,
	'mimetype' => 1,
	'mincache' => 1,
	'minimumbitrate' => 1,
	'minoltacamerasettings' => 1,
	'minoltacamerasettings2' => 1,
	'minoltacamerasettings5d' => 1,
	'minoltacamerasettings7d' => 1,
	'minoltacamerasettingsold' => 1,
	'minoltamakernote' => 1,
	'minoltamma0' => 1,
	'minoltamma1' => 1,
	'minoltaprd' => 1,
	'minoltarif' => 1,
	'minoltatags' => 1,
	'minoltattw' => 1,
	'minoltawbg' => 1,
	'minorversion' => 1,
	'minpacketsize' => 1,
	'mintransmissiontime' => 1,
	'mmclips' => 1,
	'mngheader' => 1,
	'modeextension' => 1,
	'model2' => 1,
	'modelandversion' => 1,
	'modeltiepoint' => 1,
	'modeltransform' => 1,
	'modeltype' => 1,
	'modenumber' => 1,
	'modifiedby' => 1,
	'modifiedinfo' => 1,
	'montage' => 1,
	'month' => 1,
	'mood' => 1,
	'mosaicpattern' => 1,
	'moveobjects' => 1,
	'movie' => 1,
	'movieheader' => 1,
	'mp' => 1,
	'mpeg7binary' => 1,
	'mpegaudioversion' => 1,
	'mpf' => 1,
	'mpfversion' => 1,
	'mpimage' => 1,
	'mpimageflags' => 1,
	'mpimageformat' => 1,
	'mpimagelength' => 1,
	'mpimagelist' => 1,
	'mpimagestart' => 1,
	'mpimagetype' => 1,
	'mpindividualnum' => 1,
	'mrwinfo' => 1,
	'msdocumenttext' => 1,
	'msdocumenttextposition' => 1,
	'mspropertysetstorage' => 1,
	'msstereo' => 1,
	'multiexposure' => 1,
	'multiexposureversion' => 1,
	'multimediatype' => 1,
	'multiprofiles' => 1,
	'multiquality' => 1,
	'musiccdidentifier' => 1,
	'musiciancredits' => 1,
	'mute' => 1,
	'muxingapp' => 1,
	'mycolors' => 1,
	'name' => 1,
	'namedcolor' => 1,
	'namedcolor2' => 1,
	'nametableversion' => 1,
	'narrator' => 1,
	'nativedisplayinfo' => 1,
	'nativeresolutionunit' => 1,
	'nativexresolution' => 1,
	'nativeyresolution' => 1,
	'ncc' => 1,
	'nestlevel' => 1,
	'netexposurecompensation' => 1,
	'netname' => 1,
	'netprovidertype' => 1,
	'neutals' => 1,
	'neutobjbacktype' => 1,
	'neutobjname' => 1,
	'neutobjtype' => 1,
	'neutobjversion' => 1,
	'neutrals' => 1,
	'newbitdepth' => 1,
	'newcolortype' => 1,
	'nextfilename' => 1,
	'nexttrackid' => 1,
	'nextuid' => 1,
	'nikon' => 1,
	'nikoncapturedata' => 1,
	'nikoncaptureoffsets' => 1,
	'nikoncaptureoutput' => 1,
	'nikondata' => 1,
	'nikonncdt' => 1,
	'nikonscanifd' => 1,
	'nikontags' => 1,
	'nikonvers' => 1,
	'nitf' => 1,
	'nitfversion' => 1,
	'noise' => 1,
	'noiseprofile' => 1,
	'noisereductiondata' => 1,
	'nominalbitrate' => 1,
	'nominalframecount' => 1,
	'nominallayercount' => 1,
	'nominalplaytime' => 1,
	'nomssmarttags' => 1,
	'note' => 1,
	'notice' => 1,
	'now' => 1,
	'npts' => 1,
	'nsc_address' => 1,
	'nsc_description' => 1,
	'nsc_email' => 1,
	'nsc_name' => 1,
	'nsc_phone' => 1,
	'nullmediaheader' => 1,
	'numafpoints' => 1,
	'numberlist' => 1,
	'numberofcomponents' => 1,
	'numberofframes' => 1,
	'numberofimages' => 1,
	'numberofinks' => 1,
	'numberofplanes' => 1,
	'numberofresolutions' => 1,
	'numchannels' => 1,
	'numcolors' => 1,
	'numfonts' => 1,
	'numhistorybuffers' => 1,
	'numimportantcolors' => 1,
	'numpackets' => 1,
	'numproperties' => 1,
	'numrules' => 1,
	'numsampleframes' => 1,
	'numstreams' => 1,
	'objectfiletype' => 1,
	'objectid' => 1,
	'objectsizeannounced' => 1,
	'objecttype' => 1,
	'obsoletephotoshoptag1' => 1,
	'obsoletephotoshoptag2' => 1,
	'obsoletephotoshoptag3' => 1,
	'oceapplicationselector' => 1,
	'oceidnumber' => 1,
	'oceimagelogic' => 1,
	'ocescanjobdesc' => 1,
	'office' => 1,
	'offsetorigin' => 1,
	'offsetxy' => 1,
	'oldxmp' => 1,
	'olympus' => 1,
	'olympus2100' => 1,
	'olympus2100ifd' => 1,
	'olympus2200' => 1,
	'olympus2200ifd' => 1,
	'olympus2300' => 1,
	'olympus2300ifd' => 1,
	'olympus2400' => 1,
	'olympus2400ifd' => 1,
	'olympus2500' => 1,
	'olympus2500ifd' => 1,
	'olympus2600' => 1,
	'olympus2600ifd' => 1,
	'olympus2700' => 1,
	'olympus2700ifd' => 1,
	'olympus2800' => 1,
	'olympus2800ifd' => 1,
	'olympus2900' => 1,
	'olympus2900ifd' => 1,
	'olympusjunk' => 1,
	'olympustags1' => 1,
	'olympustags2' => 1,
	'olympustags3' => 1,
	'opacity' => 1,
	'opcodelist1' => 1,
	'opcodelist2' => 1,
	'opcodelist3' => 1,
	'opcolor' => 1,
	'opendml' => 1,
	'openwithapplication' => 1,
	'operatingsystem' => 1,
	'operation' => 1,
	'operationclassid' => 1,
	'operationid' => 1,
	'operationnumber' => 1,
	'opiproxy' => 1,
	'optimalbitrate' => 1,
	'opto-electricconvfactor' => 1,
	'orderingrestrictions' => 1,
	'originalalbum' => 1,
	'originalalbumtitle' => 1,
	'originalartist' => 1,
	'originaldocumentsize' => 1,
	'originalfilesize' => 1,
	'originalfiletype' => 1,
	'originalimagebroker' => 1,
	'originallyricist' => 1,
	'originalmedia' => 1,
	'originalmedium' => 1,
	'originalrawcreator' => 1,
	'originalrawfiletype' => 1,
	'originalrawimage' => 1,
	'originalrawresource' => 1,
	'originalreleasetime' => 1,
	'originalreleaseyear' => 1,
	'originalscannedimagesize' => 1,
	'originalthmcreator' => 1,
	'originalthmfiletype' => 1,
	'originalthmimage' => 1,
	'originalthmresource' => 1,
	'originator' => 1,
	'osversion' => 1,
	'othercodecdescription' => 1,
	'othercodecname' => 1,
	'otherformat' => 1,
	'otherimage' => 1,
	'otherimagelength' => 1,
	'otherimagestart' => 1,
	'otherinfo' => 1,
	'othersampledesc' => 1,
	'outputaudiosamplerate' => 1,
	'outputdataobjectlist' => 1,
	'outputprofile' => 1,
	'outputresponse' => 1,
	'packets' => 1,
	'page' => 1,
	'pagecount' => 1,
	'pageenter' => 1,
	'pageexit' => 1,
	'pagefront' => 1,
	'pagenormal' => 1,
	'pages' => 1,
	'pagespecial' => 1,
	'paintcorrectionactive' => 1,
	'paintcorrectionamount' => 1,
	'paintcorrectionbrightness' => 1,
	'paintcorrectionclarity' => 1,
	'paintcorrectioncontrast' => 1,
	'paintcorrectionexposure' => 1,
	'paintcorrectionhue' => 1,
	'paintcorrectionmaskcenterweight' => 1,
	'paintcorrectionmaskdabs' => 1,
	'paintcorrectionmaskflow' => 1,
	'paintcorrectionmaskfullx' => 1,
	'paintcorrectionmaskfully' => 1,
	'paintcorrectionmaskradius' => 1,
	'paintcorrectionmaskvalue' => 1,
	'paintcorrectionmaskwhat' => 1,
	'paintcorrectionmaskzerox' => 1,
	'paintcorrectionmaskzeroy' => 1,
	'paintcorrectionsaturation' => 1,
	'paintcorrectionsharpness' => 1,
	'paintcorrectionwhat' => 1,
	'palette' => 1,
	'palettehistogram' => 1,
	'panasonic' => 1,
	'panorama' => 1,
	'panorientation' => 1,
	'panoverlaph' => 1,
	'panoverlapv' => 1,
	'paragraphs' => 1,
	'parameter' => 1,
	'parentalrating' => 1,
	'parentalratingreason' => 1,
	'partialpalette' => 1,
	'partofset' => 1,
	'pastclippingboundary' => 1,
	'pasteimage' => 1,
	'patternangle' => 1,
	'payloadtype' => 1,
	'paymenturl' => 1,
	'pcscitation' => 1,
	'pdahistogram' => 1,
	'pdf' => 1,
	'pdfx' => 1,
	'peakbitrate' => 1,
	'peakvalue' => 1,
	'pefversion' => 1,
	'pentax' => 1,
	'pentaxdata' => 1,
	'pentaxtags' => 1,
	'performer' => 1,
	'performers' => 1,
	'performersortorder' => 1,
	'period' => 1,
	'perpicturenotes' => 1,
	'personalfunctions' => 1,
	'personalfunctionvalues' => 1,
	'petype' => 1,
	'pfmheader' => 1,
	'pfmversion' => 1,
	'photoeffectsdata' => 1,
	'photomech' => 1,
	'photomechanic' => 1,
	'photoshop' => 1,
	'photoshop2colortable' => 1,
	'photoshop2info' => 1,
	'photoshopbgrthumbnail' => 1,
	'photoshopdata' => 1,
	'photoshopformat' => 1,
	'photoshopinfo' => 1,
	'photoshopsettings' => 1,
	'photoshopthumbnail' => 1,
	'physicalpixel' => 1,
	'physicalstreamnumbermap' => 1,
	'physicalstreamnumbers' => 1,
	'physicalstreams' => 1,
	'picslabel' => 1,
	'picture' => 1,
	'picturebitsperpixel' => 1,
	'picturecontrolversion' => 1,
	'picturectrl' => 1,
	'picturedescription' => 1,
	'pictureformat' => 1,
	'pictureheight' => 1,
	'pictureindexedcolors' => 1,
	'pictureinfo' => 1,
	'picturelength' => 1,
	'picturemimetype' => 1,
	'picturetype' => 1,
	'picturewidth' => 1,
	'pieceinfo' => 1,
	'pitchandfamily' => 1,
	'pitchangle' => 1,
	'pitchshift' => 1,
	'pixelaspectratio' => 1,
	'pixelcalibration' => 1,
	'pixelformat' => 1,
	'pixelintensityrange' => 1,
	'pixellive' => 1,
	'pixelmagicjbigoptions' => 1,
	'pixelscale' => 1,
	'pixelspermeterx' => 1,
	'pixelspermetery' => 1,
	'pixelsperunitx' => 1,
	'pixelsperunity' => 1,
	'pixelunits' => 1,
	'pixheight' => 1,
	'pixwidth' => 1,
	'places' => 1,
	'planes' => 1,
	'playallframes' => 1,
	'playcounter' => 1,
	'playduration' => 1,
	'playerversion' => 1,
	'playgap' => 1,
	'playlistdelay' => 1,
	'playlistid' => 1,
	'playselection' => 1,
	'plus' => 1,
	'podcast' => 1,
	'podcasturl' => 1,
	'pointsize' => 1,
	'popupfillattributes' => 1,
	'popupflash' => 1,
	'position' => 1,
	'postertime' => 1,
	'postscript2crd0' => 1,
	'postscript2crd1' => 1,
	'postscript2crd2' => 1,
	'postscript2csa' => 1,
	'postscriptfontname' => 1,
	'pragma' => 1,
	'preferredfamily' => 1,
	'preferredrate' => 1,
	'preferredsubfamily' => 1,
	'preferredvolume' => 1,
	'preroll' => 1,
	'presentationformat' => 1,
	'presentationtarget' => 1,
	'prevfilename' => 1,
	'preview' => 1,
	'preview0' => 1,
	'preview1' => 1,
	'preview2' => 1,
	'previewatomindex' => 1,
	'previewatomtype' => 1,
	'previewdate' => 1,
	'previewduration' => 1,
	'previewifd' => 1,
	'previewifd_offset' => 1,
	'previewimagedata' => 1,
	'previewimageinfo' => 1,
	'previewinfo' => 1,
	'previewpict' => 1,
	'previewpng' => 1,
	'previewtime' => 1,
	'previewversion' => 1,
	'prevsize' => 1,
	'prevuid' => 1,
	'primaryitemreference' => 1,
	'primaryplatform' => 1,
	'printflags' => 1,
	'printflagsinfo' => 1,
	'printimversion' => 1,
	'printquality' => 1,
	'printscale' => 1,
	'printtovideo' => 1,
	'priority' => 1,
	'prism' => 1,
	'private' => 1,
	'privatebuild' => 1,
	'prl' => 1,
	'processing' => 1,
	'processinginfo' => 1,
	'prod' => 1,
	'prodnotes' => 1,
	'produceddate' => 1,
	'producednotice' => 1,
	'product' => 1,
	'productiondate' => 1,
	'productname' => 1,
	'productversion' => 1,
	'productversionnumber' => 1,
	'profile' => 1,
	'profileclass' => 1,
	'profilecmmtype' => 1,
	'profileconnectionspace' => 1,
	'profilecreator' => 1,
	'profiledatetime' => 1,
	'profiledescription' => 1,
	'profiledescriptionml' => 1,
	'profilefilesignature' => 1,
	'profileheader' => 1,
	'profileid' => 1,
	'profileifd' => 1,
	'profilesequencedesc' => 1,
	'profiletype' => 1,
	'profileversion' => 1,
	'progid' => 1,
	'progressivescans' => 1,
	'projazimuthangle' => 1,
	'projcentereasting' => 1,
	'projcenterlat' => 1,
	'projcenterlong' => 1,
	'projcenternorthing' => 1,
	'projcoordtrans' => 1,
	'project' => 1,
	'projectedcstype' => 1,
	'projection' => 1,
	'projects' => 1,
	'projfalseeasting' => 1,
	'projfalsenorthing' => 1,
	'projfalseorigineasting' => 1,
	'projfalseoriginlat' => 1,
	'projfalseoriginlong' => 1,
	'projfalseoriginnorthing' => 1,
	'projlinearunits' => 1,
	'projlinearunitsize' => 1,
	'projnatoriginlat' => 1,
	'projnatoriginlong' => 1,
	'projrectifiedgridangle' => 1,
	'projscaleatcenter' => 1,
	'projscaleatnatorigin' => 1,
	'projstdparallel1' => 1,
	'projstdparallel2' => 1,
	'projstraightvertpolelong' => 1,
	'promoteparent' => 1,
	'promotionurl' => 1,
	'prop' => 1,
	'properties' => 1,
	'propertysetidcodes' => 1,
	'propertysetpathname' => 1,
	'propertystoredata' => 1,
	'propertyvectorelements' => 1,
	'protect' => 1,
	'protectiontype' => 1,
	'provider' => 1,
	'providercopyright' => 1,
	'providerrating' => 1,
	'providerstyle' => 1,
	'ps2crdvmsize' => 1,
	'ps2renteringintent' => 1,
	'psfontinfo' => 1,
	'pstringcaption' => 1,
	'publisherurl' => 1,
	'pur' => 1,
	'purchasedate' => 1,
	'purpose' => 1,
	'quickedit' => 1,
	'quickmaskinfo' => 1,
	'qvci' => 1,
	'ra3' => 1,
	'ra4' => 1,
	'ra5' => 1,
	'radiostationname' => 1,
	'radiostationowner' => 1,
	'rafversion' => 1,
	'rasterpadding' => 1,
	'rate' => 1,
	'rawdata' => 1,
	'rawdatalength' => 1,
	'rawdataoffset' => 1,
	'rawdatarotation' => 1,
	'rawdev2' => 1,
	'rawdev2ifd' => 1,
	'rawdevelopment' => 1,
	'rawdevelopmentifd' => 1,
	'rawimagefullsize' => 1,
	'rawimagemode' => 1,
	'rawimagesegmentation' => 1,
	'rawinfo' => 1,
	'rawinfoifd' => 1,
	'rawjpginfo' => 1,
	'rawzorcreatorversion' => 1,
	'rawzorrequiredversion' => 1,
	'rdf' => 1,
	'readerrequirements' => 1,
	'realtimestreamingprotocol' => 1,
	'receivedfrom' => 1,
	'recengineer' => 1,
	'reclocation' => 1,
	'reconstructiontype' => 1,
	'recordedby' => 1,
	'recordeddate' => 1,
	'recordingdates' => 1,
	'recordingtime' => 1,
	'rect' => 1,
	'rectangleofinterest' => 1,
	'redadjust' => 1,
	'redeyedata' => 1,
	'redgain' => 1,
	'redmatrixcolumn' => 1,
	'redprimary' => 1,
	'redsample' => 1,
	'redtrc' => 1,
	'redx' => 1,
	'redy' => 1,
	'reference' => 1,
	'referenceblock' => 1,
	'referencepriority' => 1,
	'referencevirtual' => 1,
	'refresh' => 1,
	'relatedimagefile' => 1,
	'relativepath' => 1,
	'removehistoryduplicates' => 1,
	'renderingintent' => 1,
	'repeateddatabytes' => 1,
	'replaygainalbumgain' => 1,
	'replaygainalbumpeak' => 1,
	'replaygaintrackgain' => 1,
	'replaygaintrackpeak' => 1,
	'replyto' => 1,
	'representativedisparityfar' => 1,
	'representativedisparitynear' => 1,
	'representativeimage' => 1,
	'requirements' => 1,
	'reserved1' => 1,
	'resolutioninfo' => 1,
	'resourceforksize' => 1,
	'resources' => 1,
	'resourcesneeded' => 1,
	'resourcetype' => 1,
	'resultaspectratio' => 1,
	'revisiondate' => 1,
	'revisionnumber' => 1,
	'revisitafter' => 1,
	'rgb_profile' => 1,
	'ricoh' => 1,
	'ricohjunk' => 1,
	'ricohrdc2' => 1,
	'ricohrr1subdir' => 1,
	'ricohsubdir' => 1,
	'rightdarkrect' => 1,
	'rightmag' => 1,
	'rjmd' => 1,
	'rmeta' => 1,
	'robots' => 1,
	'rocinfo' => 1,
	'roidescription' => 1,
	'rollangle' => 1,
	'rollguidelements' => 1,
	'root' => 1,
	'rotationangle' => 1,
	'roundtripversion' => 1,
	'rowinterleavefactor' => 1,
	'runwindow' => 1,
	'sampledegradationpriority' => 1,
	'sampleformat' => 1,
	'samplegroupdescription' => 1,
	'samplepaddingbits' => 1,
	'samplerate2' => 1,
	'samplesize' => 1,
	'samplesizes' => 1,
	'sampletable' => 1,
	'sampletext' => 1,
	'sampletochunk' => 1,
	'sampletogroup' => 1,
	'samsunginfo' => 1,
	'sanyomov' => 1,
	'sanyomp4' => 1,
	'saturationinfo' => 1,
	'saveobjbacktype' => 1,
	'saveobjects' => 1,
	'saveobjname' => 1,
	'saveobjtype' => 1,
	'saveobjversion' => 1,
	'savesetup' => 1,
	'sba_rgbshifts' => 1,
	'sbaexposurerecord' => 1,
	'sbainputimagebitdepth' => 1,
	'sbainputimagecolorspace' => 1,
	'scalado' => 1,
	'scale' => 1,
	'scalecrop' => 1,
	'scalefactor35efl' => 1,
	'scalingfactor' => 1,
	'scandate' => 1,
	'scannermake' => 1,
	'scannermodel' => 1,
	'scannerpixelsize' => 1,
	'scannerserialnumber' => 1,
	'scanoperatorid' => 1,
	'scansoftware' => 1,
	'scansoftwarerevisiondate' => 1,
	'school' => 1,
	'screenbuffersize' => 1,
	'screendescriptor' => 1,
	'screening' => 1,
	'screeningdesc' => 1,
	'screennail' => 1,
	'scriptcommand' => 1,
	'security' => 1,
	'seek' => 1,
	'seekable' => 1,
	'seekhead' => 1,
	'seekid' => 1,
	'seekpoint' => 1,
	'seekposition' => 1,
	'segmentfamily' => 1,
	'segmentfilename' => 1,
	'segmentheader' => 1,
	'segmentuid' => 1,
	'selection' => 1,
	'selectionduration' => 1,
	'selectiontime' => 1,
	'selobjbacktype' => 1,
	'selobjname' => 1,
	'selobjtype' => 1,
	'selobjversion' => 1,
	'sendduration' => 1,
	'sensorbottomborder' => 1,
	'sensorid' => 1,
	'sensorimageheight' => 1,
	'sensorimagewidth' => 1,
	'sensorinfo' => 1,
	'sensorleftborder' => 1,
	'sensorrightborder' => 1,
	'sensortopborder' => 1,
	'serialinfo' => 1,
	'series' => 1,
	'serviceorganizationname' => 1,
	'setcookie' => 1,
	'setinfo' => 1,
	'setsubtitle' => 1,
	'shadowendpoints' => 1,
	'shadowsyncsampletable' => 1,
	'shakereductioninfo' => 1,
	'shareddata' => 1,
	'shareddoc' => 1,
	'shareduserrating' => 1,
	'sharpinfo' => 1,
	'sharpmethod' => 1,
	'sharpnessapproximation' => 1,
	'sharpnessfreqtable' => 1,
	'sharpnesstable' => 1,
	'sharpobjbacktype' => 1,
	'sharpobjname' => 1,
	'sharpobjtype' => 1,
	'sharpobjversion' => 1,
	'shimdata' => 1,
	'shootingcount' => 1,
	'shootingrecord' => 1,
	'shootobjbacktype' => 1,
	'shootobjname' => 1,
	'shootobjtype' => 1,
	'shootobjversion' => 1,
	'shootsetup' => 1,
	'shotinfo' => 1,
	'shotinfo02xx' => 1,
	'shotinfod300a' => 1,
	'shotinfod300b' => 1,
	'shotinfod300s' => 1,
	'shotinfod3a' => 1,
	'shotinfod3b' => 1,
	'shotinfod3s' => 1,
	'shotinfod3x' => 1,
	'shotinfod40' => 1,
	'shotinfod5000' => 1,
	'shotinfod80' => 1,
	'shotinfod90' => 1,
	'shotinfounknown' => 1,
	'shotinfoversion' => 1,
	'showmode' => 1,
	'showobjects' => 1,
	'shutter' => 1,
	'shuttercurtainhack' => 1,
	'shutterspeed' => 1,
	'shutterspeeddisplayed' => 1,
	'sidebars' => 1,
	'sigma' => 1,
	'signalnumber' => 1,
	'signature' => 1,
	'signature_name' => 1,
	'signaturealgo' => 1,
	'signatureelementlist' => 1,
	'signatureelements' => 1,
	'signaturehash' => 1,
	'signaturepublickey' => 1,
	'signatureslot' => 1,
	'signedelement' => 1,
	'significantbits' => 1,
	'signtype' => 1,
	'silenttracknumber' => 1,
	'silenttracks' => 1,
	'simpleblock' => 1,
	'simpleindex' => 1,
	'simpletag' => 1,
	'simplicityprofile' => 1,
	'singlequality' => 1,
	'site' => 1,
	'siteenter' => 1,
	'siteexit' => 1,
	'size' => 1,
	'sizemode' => 1,
	'skip' => 1,
	'slices' => 1,
	'slides' => 1,
	'slideshow' => 1,
	'smaxsamplevalue' => 1,
	'sminsamplevalue' => 1,
	'snapshotid' => 1,
	'snapshotname' => 1,
	'softedit' => 1,
	'softwarerelease' => 1,
	'sony' => 1,
	'sonyimageheight' => 1,
	'sonyimagewidth' => 1,
	'sortalbum' => 1,
	'sortalbumartist' => 1,
	'sortartist' => 1,
	'sortcomposer' => 1,
	'sortname' => 1,
	'sortshow' => 1,
	'sourcedate' => 1,
	'sourceedition' => 1,
	'sourceform' => 1,
	'sourceid' => 1,
	'sourceimagedirectory' => 1,
	'sourceimagefilename' => 1,
	'sourceimageheight' => 1,
	'sourceimagevolumename' => 1,
	'sourceimagewidth' => 1,
	'sourcepublisher' => 1,
	'sourcerights' => 1,
	'sourcetitle' => 1,
	'sourceurl' => 1,
	'spatialfrequencyresponse' => 1,
	'spatialorientation' => 1,
	'spatialresolution' => 1,
	'specialbuild' => 1,
	'specialeffectsopticalfilter' => 1,
	'specialfolderdata' => 1,
	'speed' => 1,
	'spiff' => 1,
	'spiffversion' => 1,
	'spothalftone' => 1,
	'sr2dataifd' => 1,
	'sr2private' => 1,
	'sr2subifdkey' => 1,
	'sr2subifdlength' => 1,
	'sr2subifdoffset' => 1,
	'srf2key' => 1,
	'srf6offset' => 1,
	'srfdataoffset' => 1,
	'srgbrendering' => 1,
	'stamptoolcount' => 1,
	'startofframe' => 1,
	'starttime' => 1,
	'starttimecode' => 1,
	'statistics' => 1,
	'stdautoactive' => 1,
	'stdbasename' => 1,
	'stdhotfolder' => 1,
	'stdopeninphotoshop' => 1,
	'stdoutputbitdepth' => 1,
	'stdoutputcolormode' => 1,
	'stdoutputfiletype' => 1,
	'stdoxygen' => 1,
	'stdsaveselection' => 1,
	'stdscaledoutput' => 1,
	'stdsharpenoutput' => 1,
	'stereo' => 1,
	'stereo3dmode' => 1,
	'stereoimage' => 1,
	'stereomode' => 1,
	'stim' => 1,
	'stimversion' => 1,
	'stonits' => 1,
	'storage-streampathname' => 1,
	'stream' => 1,
	'streamavgbitrate' => 1,
	'streamavgpacketsize' => 1,
	'streambitdepth' => 1,
	'streambitrateprops' => 1,
	'streamcolor' => 1,
	'streamcount' => 1,
	'streamdata' => 1,
	'streamduration' => 1,
	'streamheader' => 1,
	'streaminfo' => 1,
	'streamingdataprotocol' => 1,
	'streammaxbitrate' => 1,
	'streammaxpacketsize' => 1,
	'streammimelen' => 1,
	'streammimetype' => 1,
	'streamname' => 1,
	'streamnamelen' => 1,
	'streamnumber' => 1,
	'streampreroll' => 1,
	'streamprioritization' => 1,
	'streamproperties' => 1,
	'streamsamplecount' => 1,
	'streamsamplerate' => 1,
	'streamstarttime' => 1,
	'streamtype' => 1,
	'streamtypeinfo' => 1,
	'stridable' => 1,
	'strikeout' => 1,
	'stripbytecounts' => 1,
	'stripoffsets' => 1,
	'striprowcounts' => 1,
	'strobe' => 1,
	'strobetime' => 1,
	'sub-sampleinformation' => 1,
	'subdir3000' => 1,
	'subdir3100' => 1,
	'subdir3400' => 1,
	'subdir3900' => 1,
	'subfile' => 1,
	'subifd' => 1,
	'subifd0' => 1,
	'subifd1' => 1,
	'subifd2' => 1,
	'subifd255' => 1,
	'subifd3' => 1,
	'subifd4' => 1,
	'subifd5' => 1,
	'subifd6' => 1,
	'subifd_offset' => 1,
	'subimagecolor' => 1,
	'subimagehdr' => 1,
	'subimageheight' => 1,
	'subimageicc_profile' => 1,
	'subimagenumericalformat' => 1,
	'subimageresolutions' => 1,
	'subimagetilecount' => 1,
	'subimagetileheight' => 1,
	'subimagetilewidth' => 1,
	'subimagewidth' => 1,
	'subjectpixelheight' => 1,
	'subjectpixelwidth' => 1,
	'subjectscale' => 1,
	'subjectunits' => 1,
	'subpacketh' => 1,
	'subpacketsize' => 1,
	'subscriptioncontentid' => 1,
	'subseccreatedate' => 1,
	'subsecdatetimeoriginal' => 1,
	'subsecmodifydate' => 1,
	'subsystem' => 1,
	'subsystemversion' => 1,
	'subtileblocksize' => 1,
	'subtitle' => 1,
	'subtitledescription' => 1,
	'suggestedpalette' => 1,
	'summaryinfo' => 1,
	'surroundmode' => 1,
	'svgversion' => 1,
	'swf' => 1,
	'synchronizedlyrictext' => 1,
	'syncsampletable' => 1,
	't4options' => 1,
	't6options' => 1,
	't82options' => 1,
	't88options' => 1,
	'tag' => 1,
	'tagattachmentuid' => 1,
	'tagbinary' => 1,
	'tagchapteruid' => 1,
	'tagdefault' => 1,
	'tageditionuid' => 1,
	'taggingtime' => 1,
	'taglanguage' => 1,
	'tagname' => 1,
	'tags' => 1,
	'tagstring' => 1,
	'tagtrackuid' => 1,
	'targetaudiences' => 1,
	'targetdeltatype' => 1,
	'targetfiledosname' => 1,
	'targetfilesize' => 1,
	'targetprinter' => 1,
	'targets' => 1,
	'targettype' => 1,
	'targettypevalue' => 1,
	'targetxy' => 1,
	'tdat' => 1,
	'tdhd' => 1,
	'technician' => 1,
	'technology' => 1,
	'telephonenumber' => 1,
	'template' => 1,
	'terminationaction' => 1,
	'terminationcondition' => 1,
	'termsofuse' => 1,
	'testtarget' => 1,
	'text' => 1,
	'textinfo' => 1,
	'textualdata' => 1,
	'textualinfo' => 1,
	'things' => 1,
	'thumbnail' => 1,
	'thumbnailclip' => 1,
	'tickspersecond' => 1,
	'tiff' => 1,
	'tiff-epstandardid' => 1,
	'tiff_fxextensions' => 1,
	'tiffpreview' => 1,
	'tilebytecounts' => 1,
	'tiledepth' => 1,
	'tileoffsets' => 1,
	'timecode' => 1,
	'timecodeindex' => 1,
	'timecodeindexparms' => 1,
	'timecodescale' => 1,
	'timeoffset' => 1,
	'timescale' => 1,
	'timeslice' => 1,
	'timetosampletable' => 1,
	'title2' => 1,
	'titlelen' => 1,
	'titleofparts' => 1,
	'titlesofparts' => 1,
	'titlesortorder' => 1,
	'tocitems' => 1,
	'tonecurvematching' => 1,
	'tonecurvetable' => 1,
	'tonematrix' => 1,
	'toneobjbacktype' => 1,
	'toneobjname' => 1,
	'toneobjtype' => 1,
	'toneobjversion' => 1,
	'tones' => 1,
	'tonespaceflow' => 1,
	'toolname' => 1,
	'toolversion' => 1,
	'topmag' => 1,
	'totalbytes' => 1,
	'totalbytesnortpheaders' => 1,
	'totaledittime' => 1,
	'totalframes' => 1,
	'totalsamples' => 1,
	'track' => 1,
	'trackattachmentuid' => 1,
	'trackcategory' => 1,
	'trackcomments' => 1,
	'trackcreatedate' => 1,
	'trackdefault' => 1,
	'trackduration' => 1,
	'trackentry' => 1,
	'trackerdata' => 1,
	'trackforced' => 1,
	'trackheader' => 1,
	'trackid' => 1,
	'tracklacing' => 1,
	'tracklanguage' => 1,
	'tracklayer' => 1,
	'tracklyrics' => 1,
	'trackmodifydate' => 1,
	'trackname' => 1,
	'trackoffset' => 1,
	'trackoverlay' => 1,
	'trackproperty' => 1,
	'trackref' => 1,
	'tracks' => 1,
	'tracktimecodescale' => 1,
	'tracktranslate' => 1,
	'tracktranslatecodec' => 1,
	'tracktranslateeditionuid' => 1,
	'tracktranslatetrackid' => 1,
	'tracktype' => 1,
	'trackuid' => 1,
	'trackused' => 1,
	'trackversion' => 1,
	'trackvolume' => 1,
	'trademark' => 1,
	'transferrange' => 1,
	'transformation' => 1,
	'transformcreatedate' => 1,
	'transformedimagetitle' => 1,
	'transformmodifydate' => 1,
	'transformnodeid' => 1,
	'transformtitle' => 1,
	'transparency' => 1,
	'transparencyindicator' => 1,
	'transparentindex' => 1,
	'trapindicator' => 1,
	'trebel' => 1,
	'tvepisode' => 1,
	'tvepisodeid' => 1,
	'tvnetworkname' => 1,
	'tvseason' => 1,
	'tvshow' => 1,
	'typeoforiginal' => 1,
	'typist' => 1,
	'ucrbg' => 1,
	'uic1tag' => 1,
	'uic2tag' => 1,
	'uic3tag' => 1,
	'uic4tag' => 1,
	'uncompressed' => 1,
	'underline' => 1,
	'underlineposition' => 1,
	'underlinethickness' => 1,
	'unicodealphanames' => 1,
	'uninitializeddatasize' => 1,
	'uniquefileidentifier' => 1,
	'units' => 1,
	'unknown' => 1,
	'unknownblock1' => 1,
	'unknownblock2' => 1,
	'unknownd30' => 1,
	'unknowndata' => 1,
	'unknowninfo' => 1,
	'unknowninfoifd' => 1,
	'unknownjunk' => 1,
	'unknowntags' => 1,
	'unsharpdata' => 1,
	'unused' => 1,
	'url_list' => 1,
	'urn' => 1,
	'usedextensionnumbers' => 1,
	'useradjsba_rgbshifts' => 1,
	'userdata' => 1,
	'userdefinedid' => 1,
	'userdefinedtext' => 1,
	'userdefinedurl' => 1,
	'userselectgrouptitle' => 1,
	'userweburl' => 1,
	'usingtransforms' => 1,
	'usptomiscellaneous' => 1,
	'usptooriginalcontenttype' => 1,
	'utm' => 1,
	'uuid-exif' => 1,
	'uuid-geojp2' => 1,
	'uuid-iptc' => 1,
	'uuid-prof' => 1,
	'uuid-unknown' => 1,
	'uuid-usmt' => 1,
	'uuid-xmp' => 1,
	'uuidinfo' => 1,
	'uuidlist' => 1,
	'validafpoints' => 1,
	'vary' => 1,
	'vbrbytes' => 1,
	'vbrframes' => 1,
	'vbrpeak' => 1,
	'vbrscale' => 1,
	'vegasversionmajor' => 1,
	'vegasversionminor' => 1,
	'vendor' => 1,
	'vendorid' => 1,
	'vendorurl' => 1,
	'version2' => 1,
	'versionbf' => 1,
	'versionifd' => 1,
	'versioninfo' => 1,
	'versionyear' => 1,
	'verticalcitation' => 1,
	'verticalcstype' => 1,
	'verticaldatum' => 1,
	'verticaldivergence' => 1,
	'verticalunits' => 1,
	'video' => 1,
	'videoattributes' => 1,
	'videoavgbitrate' => 1,
	'videoavgframerate' => 1,
	'videobitrate' => 1,
	'videocardgamma' => 1,
	'videoclosedcaptioning' => 1,
	'videocodec' => 1,
	'videocodecdescription' => 1,
	'videocodecid' => 1,
	'videocodecinfo' => 1,
	'videocodecname' => 1,
	'videoencoding' => 1,
	'videoformat' => 1,
	'videoframecount' => 1,
	'videoheader' => 1,
	'videoheight' => 1,
	'videomaxbitrate' => 1,
	'videomaxframerate' => 1,
	'videomode' => 1,
	'videoprofile' => 1,
	'videoprofileversion' => 1,
	'videosampledesc' => 1,
	'videoscantype' => 1,
	'videosize' => 1,
	'videostreamtype' => 1,
	'videotrackid' => 1,
	'videowidth' => 1,
	'viewable' => 1,
	'viewingconddesc' => 1,
	'viewingcondilluminant' => 1,
	'viewingcondilluminanttype' => 1,
	'viewingconditions' => 1,
	'viewingcondsurround' => 1,
	'viewtype' => 1,
	'vignettingcorr' => 1,
	'vignettingcorr2' => 1,
	'virtualimageheight' => 1,
	'virtualimagewidth' => 1,
	'virtualpage' => 1,
	'virtualpageunits' => 1,
	'visibleoutputs' => 1,
	'vistaidlistdata' => 1,
	'void' => 1,
	'volumeid' => 1,
	'volumelabel' => 1,
	'vorbiscomment' => 1,
	'vorbisversion' => 1,
	'vrd1' => 1,
	'vrd2' => 1,
	'vrdstamptool' => 1,
	'vrdversion' => 1,
	'vrinfo' => 1,
	'vrinfoversion' => 1,
	'vw96' => 1,
	'wangannotation' => 1,
	'wangtag1' => 1,
	'wangtag3' => 1,
	'wangtag4' => 1,
	'warning' => 1,
	'watermark' => 1,
	'watermarktype' => 1,
	'wb_grgblevels' => 1,
	'wb_rgbcoeffs0' => 1,
	'wb_rgbcoeffs1' => 1,
	'wb_rgbcoeffs2' => 1,
	'wb_rgbcoeffs3' => 1,
	'wb_rgblevelsauto' => 1,
	'wb_rgblevelscloudy' => 1,
	'wb_rgblevelsdaylight' => 1,
	'wb_rgblevelsflash' => 1,
	'wb_rgblevelsfluorescent' => 1,
	'wb_rgblevelsshade' => 1,
	'wb_rgblevelstungsten' => 1,
	'wb_rgbmul0' => 1,
	'wb_rgbmul1' => 1,
	'wb_rgbmul2' => 1,
	'wb_rgbmul3' => 1,
	'wbadjdata' => 1,
	'wbinfoa100' => 1,
	'wcsprofiles' => 1,
	'weight' => 1,
	'whitebalancematching' => 1,
	'whitebalancetable' => 1,
	'whitepointx' => 1,
	'whitepointy' => 1,
	'whitesample' => 1,
	'whitesamplebits' => 1,
	'whitesampleheight' => 1,
	'whitesampleleftborder' => 1,
	'whitesampletopborder' => 1,
	'whitesamplewidth' => 1,
	'wide' => 1,
	'widthbytes' => 1,
	'widthresolution' => 1,
	'windowlocation' => 1,
	'windoworigin' => 1,
	'windoworiginauto' => 1,
	'windowsize' => 1,
	'windowtarget' => 1,
	'wmadrcaveragereference' => 1,
	'wmadrcaveragetarget' => 1,
	'wmadrcpeakreference' => 1,
	'wmadrcpeaktarget' => 1,
	'wmcollectiongroupid' => 1,
	'wmcollectionid' => 1,
	'wmcontentid' => 1,
	'words' => 1,
	'workflowurl' => 1,
	'workingdirectory' => 1,
	'workingpath' => 1,
	'worldtime' => 1,
	'writer' => 1,
	'writingapp' => 1,
	'wwsfamilyname' => 1,
	'wwssubfamilyname' => 1,
	'x' => 1,
	'xclippathunits' => 1,
	'xheight' => 1,
	'xmag' => 1,
	'xmethod' => 1,
	'xml' => 1,
	'xmldata' => 1,
	'xmp_profile' => 1,
	'xmpbj' => 1,
	'xmpdm' => 1,
	'xmpextension' => 1,
	'xmpmm' => 1,
	'xmpnote' => 1,
	'xmpplus' => 1,
	'xmprights' => 1,
	'xmptpg' => 1,
	'xylocation' => 1,
	'xyoffsetinfo' => 1,
	'yawangle' => 1,
	'yclippathunits' => 1,
	'year' => 1,
	'ylevel' => 1,
	'ymag' => 1,
	'ymethod' => 1,
	'ytarget' => 1,
	'zipbitflag' => 1,
	'zipcompressedsize' => 1,
	'zipcompression' => 1,
	'zipcrc' => 1,
	'zipfilename' => 1,
	'zipmodifydate' => 1,
	'ziprequiredversion' => 1,
	'zipuncompressedsize' => 1,
	'zoom' => 1,
	'zoompos' => 1,
);

# module names for writable Composite tags
my %compositeModules = (
	'filenumber' => 'Image::ExifTool::Canon',
	'jpgfromraw' => 'Image::ExifTool::Exif',
	'originaldecisiondata' => 'Image::ExifTool::Canon',
	'previewimage' => 'Image::ExifTool::Exif',
	'thumbnailimage' => 'Image::ExifTool::Exif',
);

#++++ End automatically generated code ++++

# insert any user-defined tags into our tag lookup
if (%Image::ExifTool::UserDefined) {
    my @userTables = sort keys %Image::ExifTool::UserDefined;
    while (@userTables) {
        my $table = shift @userTables;
        AddTags($Image::ExifTool::UserDefined{$table}, $table);
    }
}

# insert any other queued tags from plug-in modules
if (@Image::ExifTool::pluginTags) {
    my $args;
    foreach $args (@Image::ExifTool::pluginTags) {
        AddTags($$args[0], $$args[1]);
    }
    undef @Image::ExifTool::pluginTags;
}


#------------------------------------------------------------------------------
# Add tags to the lookup (for user-defined tags, etc)
# Inputs: 0) source hash of tag definitions, 1) destination table name
my %tableNumHash;
sub AddTags($$)
{
    my ($tagsHash, $table) = @_;

    # generate lookup for table numbers if not done already
    unless (%tableNumHash) {
        my $tnum = 0;
        my $tbl;
        foreach $tbl (@tableList) {
            $tableNumHash{$tbl} = $tnum++;
        }
    }
    my (@moreTables, %moreTableRefs);
    for (;;) {
        my $tnum = $tableNumHash{$table};
        unless (defined $tnum) {
            # add new table to list
            $tnum = scalar @tableList;
            push @tableList, $table;
        }
        my $tagID;
        foreach $tagID (Image::ExifTool::TagTableKeys($tagsHash)) {
            my $newInfo = $$tagsHash{$tagID};
            if (ref $newInfo eq 'HASH') {
                $$newInfo{Name} or $$newInfo{Name} = ucfirst($tagID);
                # use new ID of tag in Composite table in case it changed
                $tagID = $$newInfo{NewTagID} if defined $$newInfo{NewTagID};
            } else {
                $newInfo = $$tagsHash{$tagID} = { Name => $newInfo };
            }
            my $lcTag = lc($$newInfo{Name});
            # add to lookup even though we don't know it is writable
            # (to save speed by not having to load the module)
            my $lookup = $tagLookup{$lcTag};
            $lookup or $lookup = $tagLookup{$lcTag} = { };
            if ($$lookup{$tnum}) {
                my $le = $$lookup{$tnum};
                my @ids = (ref $le eq 'ARRAY') ? @{$le} : ( $le );
                # only add new tag ID if it didn't already exist
                next if grep /^$tagID$/, @ids;
                push @ids, $tagID;
                $$lookup{$tnum} = \@ids;
            } else {
                $$lookup{$tnum} = $tagID;
            }
            # add any new subdirectory tables
            next unless $$newInfo{SubDirectory};
            my $subTable = $$newInfo{SubDirectory}{TagTable};
            next unless $subTable and not defined $tableNumHash{$subTable};
            next if $moreTableRefs{$subTable};
            no strict 'refs';
            next unless %$subTable;
            # save new table to process after this one
            push @moreTables, $subTable;
            $moreTableRefs{$subTable} = \%$subTable;
            # save source table name so we can load it when necessary
            $$subTable{SRC_TABLE} = $table;
        }
        $table = shift @moreTables or last;
        $tagsHash = $moreTableRefs{$table};
    }
}

#------------------------------------------------------------------------------
# Return true if the tag exists
# Inputs: 0) tag name (case insensitive)
# Returns: true if tag exists
sub TagExists($)
{
    my $tag = lc($_[0]);
    return 1 if $tagExists{$tag} or $tagLookup{$tag};
    return 0;
}

#------------------------------------------------------------------------------
# Find information for writable tags (case insensitive)
# Inputs: 0) tag name (case insensitive)
# Returns: Scalar context: tag info or false if none found
#          List context: list of all matching tagInfo hashes
sub FindTagInfo($)
{
    local $_;
    my $tag = shift;
    my $lcTag = lc($tag);
    my ($tableNum, @tagInfoList);
    my $lookup = $tagLookup{$lcTag};
    if ($lookup) {
        foreach $tableNum (keys %$lookup) {
            my $table = GetTagTable($tableList[$tableNum]);
            my $tagID = $$lookup{$tableNum};
            my @tagIDs;
            if (ref $tagID eq 'ARRAY') {
                @tagIDs = @$tagID;
            } else {
                push @tagIDs, $tagID;
            }
            foreach $tagID (@tagIDs) {
                my @infoList = GetTagInfoList($table,$tagID);
                unless (@infoList) {
                    my $reload;
                    # call write proc if it exists in case it adds tags to the table
                    my $writeProc = $table->{WRITE_PROC};
                    $reload = 1 if $writeProc and &$writeProc();
                    # load module with composite tag if necessary
                    my $compMod = $compositeModules{$lcTag};
                    $reload = 1 if $compMod and eval "require $compMod";
                    @infoList = GetTagInfoList($table,$tagID) if $reload;
                }
                if (@infoList == 1) {
                    push @tagInfoList, @infoList;
                } elsif (@infoList > 1) {
                    my $tagInfo;
                    # must check tag list in case tags have different names
                    foreach $tagInfo (@infoList) {
                        next unless $lcTag eq lc($$tagInfo{Name});
                        push @tagInfoList, $tagInfo;
                    }
                }
            }
        }
    }
    if (wantarray) {
        return @tagInfoList;
    } else {
        return $tagInfoList[0];
    }
}


1;  # end

__END__

=head1 NAME

Image::ExifTool::TagLookup - Fast lookup for ExifTool tags

=head1 SYNOPSIS

This module is required by Image::ExifTool for writing tags.

=head1 DESCRIPTION

Provides a fast, case insensitive lookup for tag names.

=head1 AUTHOR

Copyright 2003-2010, Phil Harvey (phil at owl.phy.queensu.ca)

This library is free software; you can redistribute it and/or modify it
under the same terms as Perl itself.

=head1 SEE ALSO

L<Image::ExifTool(3pm)|Image::ExifTool>,
L<Image::ExifTool::BuildTagLookup(3pm)|Image::ExifTool::BuildTagLookup>,
L<Image::ExifTool::TagNames(3pm)|Image::ExifTool::TagNames>

=cut
