######################################################################
# Lock.pm - This is PyukiWiki, yet another Wiki clone.
# $Id: Lock.pm,v 1.549 2012/08/16 01:24:28 papu Exp $
# Build on 2012-08-16 02:01:51
#
# "Nana::Lock" ver 0.2 $$
# Author: Nanami
# http://nanakochi.daiba.cx/
# Copyright (C) 2004-2007 Nekyo
# Copyright (C) 2005-2012 PyukiWiki Developers Team
# http://pyukiwiki.info/
# Based on YukiWiki http://www.hyuki.com/yukiwiki/
# Powerd by PukiWiki http://pukiwiki.sfjp.jp/
# License: GPL3 and/or Artistic or each later version
#
# This program is free software; you can redistribute it and/or
# modify it under the same terms as Perl itself.
# Return:CRLF Code=Shift-JIS 1TAB=4Spaces
######################################################################
#
# 莁renamet@CbNɑ΂āAȉ̉Ǔ_܂B
# EfBNggȂ
#   S̃bNł͂ȂAet@CŃbN
#
# YukiWikiDBAȉ̉Ǔ_܂B
# Elock֌Wʉł悤ɁAt@Cǂݏ̃t@C
#
# from http://www.din.or.jp/~ohzaki/perl.htm#File_Lock
#
######################################################################
package	Nana::Lock;
use 5.005;
use strict;
use vars qw($VERSION);
$VERSION = '0.2';
$Nana::Lock::DEBUG=0;
# PɂƃbN֌W̃bZ[Wł܂
# error
sub die {
	$::debug.="Nana::Lock:Error:$_[0]\n";
	return undef;
}
# message
sub msg {
	$::debug.="Nana:Lock:$_[0]\n"
		if($Nana::Lock::DEBUG eq 1);
}
$Nana::Lock::LOCK_SH=1;
$Nana::Lock::LOCK_EX=2;
$Nana::Lock::LOCK_NB=4;
$Nana::Lock::LOCK_DELETE=128;
# rename lock idea
# http://www.din.or.jp/~ohzaki/perl.htm#File_Lock
# bNt@Č`
# (t@Cŕsv).(method).(pid).(time).lk
#       0 : bNȂBȗ̃ftHg
#       1 : (LOCK_SH) LbNCgC
#       2 : (LOCK_EX) rbNCgC
#       5 : (LOCK_SH|LOCK_NB) LbNCgCȂ
#       6 : (LOCK_EX|LOCK_NB) rbNCgCȂ
#       8 : (LOCK_UN) gȂƁB
#     128 : (LOCK_DELETE) bNt@C̍폜
sub lock {
	my $timeout=5;
	my $trytime=2;
	my($fname,$method)=@_;
	# fBNgAt@CAgq𕪗
	my($d,$f,$e)=$fname=~/(.*)\/(.+)\.(.+)$/;
	# t@CL炵̂(Z邽)
	$f=~s/[.%()[]:*,_]//g;
	# nh̍쐬
	my %lfh=(
		dir=>$d,
		basename=>$f,
		timeout=>$timeout,
		trytime=>($method & $Nana::Lock::LOCK_NB ? 0 : $trytime),
		fname=>$fname,
		method=>$method & 3,
		path=>"$d/$f.lk"
	);
	# bNt@C̍폜
	if($method eq $Nana::Lock::LOCK_DELETE) {
		return &lock_del(%lfh);
	}
	# methodꍇreturn
	if($lfh{method} eq 0) {
		&msg("lock error:$fname $lfh{method} - $method");
		return;
	}
	return if($lfh{method} eq 0);
	for(my $i=0; $i < $lfh{trytime}*10; $i++) {
		# bN\bhAvZXIDAݎ
		$lfh{current}=sprintf("%s/%s.%x.%x.%x.%d.lk"
			,$lfh{dir},$lfh{basename},$lfh{method},$$,time);
		# bNA͐I
		if(rename($lfh{path},$lfh{current})) {
			&msg(sprintf("%s:%s->%s"
				,($lfh{method} eq 1 ? 'LOCK_SH' : 'LOCK_EX'), $lfh{path},$lfh{current}));
			return \%lfh;
		}
		return \%lfh if(rename($lfh{path},$lfh{current}));
		# ߋ̃bNt@C
		my @filelist=&lock_getdir(%lfh);
		my @locklist=();
		my $fcount=0;
		my $excount=0;
		my $shcount=0;
		foreach (@filelist) {
			if (/^$lfh{basename}\.(\d)\.(.+)\.(.+)\.lk$/) {
				push(@locklist,"$1\t$2\t$3");
				$fcount++;
				$shcount++ if($1 eq 1);
				$excount++ if($1 eq 2);
				&msg(sprintf("Found:%s.%s.%s.%s.lk(method=%d,all=%d,ex=%d,sh=%d)"
					,$lfh{basename},$1,$2,$3,$lfh{method},$fcount,$excount,$shcount));
			}
		}
		# bNt@C݂ȂΐVK쐬
		if($fcount eq 0) {
			&msg("Create $lfh{path}");
			open(LFHF,">$lfh{path}");# or return undef;
			close(LFHF);
			next;
		# LbN̏ꍇ
		} elsif($lfh{method} eq 1) {
			# r݂Ȃꍇ
			&msg("SH Lock Check $lfh{basename}");
			if($shcount > 0 && $excount eq 0) {
				# P`CXāAl[
				foreach(@locklist) {
					my($method,$pid,$time)=split(/\t/,$_);
					my $orgf=sprintf("%s/%s.%x.%s.%s.lk"
						,$lfh{dir},$lfh{basename},$method,$pid,$time);
					&msg("new fn=$orgf");
					# ăbN
					if(rename($orgf,$lfh{current})) {
						&msg(sprintf("%s:%s->%s"
							,"LOCK_SH",$orgf,$lfh{current}));
						return \%lfh;
					}
					return \%lfh if(rename($orgf,$lfh{current}));
				}
			}
		}
		# rłorُ펞
		# 0.1bsleepAgȂ1b
		eval("select undef, undef, undef, 0.1;");
		if($@) {
			sleep 1;
			$i+=9;
			&msg("waiting 1sec count $i");
		} else {
			&msg("waiting 0.1sec count $i");
		}
	}
	# ĎsI
	# ߋ̃bNt@C
	my @filelist=&lock_getdir(%lfh);
	foreach (@filelist) {
		if (/^$lfh{basename}\.(\d)\.(.+)\.(.+)\.lk$/) {
			# ^CAEgĂ݂̂
			if (time - hex($3) > $lfh{timeout}) {
				my $orgf=sprintf("%s/%s.%s.%s.%s.lk"
					,$lfh{dir},$lfh{basename},$1,$2,$3);
				if(rename($orgf,$lfh{current})) {
					&msg(sprintf("%s:%s->%s"
						,"FORCE_LOCK",$orgf,$lfh{current}));
					return \%lfh;
				}
				return \%lfh if(rename($orgf,$lfh{current}));
			}
		}
	}
	&msg("lock:can't lock");
	return undef;
}
sub unlock {
	if(rename($_[0]->{current}, $_[0]->{path})) {
		&msg("LOCK_UN" . $_[0]->{current} . "->" . $_[0]->{path});
	}
	rename($_[0]->{current}, $_[0]->{path});
}
sub lock_del {
	my(%lfh)=@_;
	unlink($lfh{path});
	&msg("LOCK_DELETE: $lfh{path}");
	my @filelist=&lock_getdir(%lfh);
	foreach (@filelist) {
		if (/^$lfh{basename}\.(\d)\.(.+)\.(.+)\.lk$/) {
			unlink($_);
			&msg("LOCK_DELETE: $_");
		}
	}
}
sub lock_getdir {
	my(%lfh)=@_;
	opendir(LOCKDIR, $lfh{dir});
	my @filelist = readdir(LOCKDIR);
	closedir(LOCKDIR);
	return @filelist;
}
1;
__END__
