######################################################################
# captcha.inc.pl - This is PyukiWiki, yet another Wiki clone.
# $Id: captcha.inc.pl,v 1.51 2012/08/16 01:24:35 papu Exp $
# Build on 2012-08-16 02:07:12
#
# "PyukiWiki" ver 0.2.1-beta1 $$
# Author: Nanami http://nanakochi.daiba.cx/
# Copyright (C) 2004-2007 Nekyo
# Copyright (C) 2005-2012 PyukiWiki Developers Team
# http://pyukiwiki.info/
# Based on YukiWiki http://www.hyuki.com/yukiwiki/
# Powerd by PukiWiki http://pukiwiki.sfjp.jp/
# License: GPL3 and/or Artistic or each later version
#
# This program is free software; you can redistribute it and/or
# modify it under the same terms as Perl itself.
# Return:CRLF Code=UTF-8 1TAB=4Spaces
######################################################################
# This is sub plugin of captcha.inc.cgi
######################################################################
use Encode qw(from_to);
use encoding "utf8";
use strict;
use warnings;
use GD;
use File::Spec;
sub getvalue {
	my ($v)=@_;
	if(ref($v) eq "ARRAY") {
		my @v=@{$v};
		return $v[int(rand($#v+1))];
	} else {
		return $v;
	}
}
sub getcolor {
	my($obj, $color)=@_;
	my $tmpcolor=&getvalue($color);
	if($tmpcolor=~/^#([0-9A-Fa-f][0-9A-Fa-f])([0-9A-Fa-f][0-9A-Fa-f])([0-9A-Fa-f][0-9A-Fa-f])$/) {
		return $obj->colorAllocate(hex($1),hex($2),hex($3));
	}
	return undef;
}
sub plugin_captcha_action {
	return if($::form{mode} ne "image");
	srand();
	my $chk=1;
	for(my $i=1; $i<100; $i++) {
		$chk=$i if(defined($captcha::parm{$i}->{fontcolor}));
	}
	return if($::form{teststring} eq "");
	my($captcha_lang, $rand, $tmpstr)=&plugin_captcha_random($::form{teststring});
	my $str=$tmpstr;
	my $width=$captcha::parm{$captcha_lang}->{width};
	my $height=$captcha::parm{$captcha_lang}->{height};
	my $im = new GD::Image($width, $height);
	$im->trueColor(1);
	# 背景色として塗りつぶし四角を描く				# comment
	$im->filledRectangle(0, 0, $width-1, $height-1, &getcolor($im, $captcha::parm{$rand}->{bgcolor}));
	# 外枠を描画									# comment
	$im->rectangle(0, 0, $width-1, $height-1, &getcolor($im, $captcha::parm{$rand}->{backlinecolor}));
	# 文字の前に線と丸を書く						# comment
	for(my $i=0; $i<$captcha::parm{$rand}->{rndlines}; $i++) {
		$im->line(
			rand($width-1), rand($height-1)
		  , rand($width-1), rand($height-1)
		  , &getcolor($im, $captcha::parm{$rand}->{rndcolors})
		);
	}
	for(my $i=0; $i<$captcha::parm{$rand}->{rndcircles}; $i++) {
		$im->arc(
			rand($width-1), rand($height-1)
		  , rand($width-1), rand($height-1)
		  , 0, 360
		  , &getcolor($im, $captcha::parm{$rand}->{rndcolors})
		);
	}
	my $PI=3.141592;
	my $str_x=10;
	my $str_y=40;
	for(my $i=0; $i<length($str); $i++) {
		my $char=substr($str, $i, 1);
		my $fontcolor=&getcolor($im, $captcha::parm{$rand}->{fontcolor});
     	# 文字を描画								# comment
		my $size=&getvalue($captcha::parm{$captcha_lang}->{size});
     	$im->stringFT($fontcolor,
				File::Spec->rel2abs(&getvalue($captcha::parm{$captcha_lang}->{font})),
				$size,
				&getvalue($captcha::parm{$captcha_lang}->{angle}) * ($PI/180),
				$str_x + $size*$i * &getvalue($captcha::parm{$captcha_lang}->{space}), $str_y,
				$char);
	}
	# 文字の後に線と丸を書く					# comment
	for(my $i=0; $i<$captcha::parm{$rand}->{lastrndlines}; $i++) {
		$im->line(
			rand($width-1), rand($height-1)
		  , rand($width-1), rand($height-1)
		  , &getcolor($im, $captcha::parm{$rand}->{rndcolors})
		);
	}
	for(my $i=0; $i<$captcha::parm{$rand}->{lastrndcircles}; $i++) {
		$im->arc(
			rand($width-1), rand($height-1)
		  , rand($width-1), rand($height-1)
		  , 0, 360
		  , &getcolor($im, $captcha::parm{$rand}->{rndcolors})
		);
	}
	print &http_header("Content-type: image/png");
	binmode STDOUT;
	print $im->png;
	exit;
}
1;
__END__
