-- シミュレーションの設定ファイル
-- Satofumi KAMIMURA
-- $Id: simulation_settings.lua 1240 2009-08-22 08:55:11Z satofumi $


-- 利用デバイスの初期化
DeviceManager():createDevice("/dev/usb/ttyUSB0", "DifferentialDrive", "run")
DeviceManager():createDevice("/dev/ttyACM0", "UrgDevice", "urg")


-- デバイスを作成
DeviceManager():device("run"):activate()
DeviceManager():device("urg"):activate()


-- デバイス位置を設定
local run = DeviceManager():model("run")
run:setPosition(Position(0, 0, deg(0)), nil, false)

local urg = DeviceManager():model("urg")
urg:setPosition(Position(70, 0, deg(0)), run, true)


-- カメラ視点を設定
CameraViewManager():setInitialView(0.0, 0.0, 4.0, deg(-45), deg(0), deg(20))


-- 障害物を配置
local box = Box(300, 400, 500, 1.0)
box:setPosition(Position(1500, 0, deg(30)), nil, false)

local cylinder = Cylinder(100, 300, 1.0)
cylinder:setPosition(Position(0, 1000, deg(0)), nil, false)
