/*!
  \file
  \brief Wn

  \author Satofumi KAMIMURA

  $Id: Coordinate.cpp 1219 2009-08-14 02:59:46Z satofumi $
*/

#include "Coordinate.h"
#include "MathUtils.h"
#include <map>

using namespace qrk;
using namespace std;


namespace
{
  class Child
  {
  public:
    Coordinate* pointer_;
    Position<long> offset_;


    Child(void) : pointer_(NULL)
    {
    }


    Child(Coordinate* pointer, const Position<long>& offset)
      : pointer_(pointer), offset_(offset)
    {
    }
  };
  typedef map<Coordinate*, Child> Children;


  // Rotate.h ̊֐g悤ɂ
  Position<long> rotate(const Position<long>& point, const double radian)
  {
    long x = static_cast<long>
      (lrint((point.x * cos(radian)) - (point.y * sin(radian))));
    long y = static_cast<long>
      (lrint((point.x * sin(radian)) + (point.y * cos(radian))));

    return Position<long>(x, y, point.angle);
  }
}


struct Coordinate::pImpl
{
  Coordinate* parent_;
  Children children_;


  pImpl(Coordinate* parent)
    : parent_(parent)
  {
  }


  void eraseFromParent(Coordinate* coordinate)
  {
    parent_->pimpl->children_.erase(coordinate);
  }


  Position<long> positionOnChild(const Coordinate* child,
                                 const Position<long>& position)
  {
    Coordinate* parent = child->parent();
    Position<long> offset = parent->offset(child);

    // q̍Wnł̈ʒu x, y Aq offset ̊px t ɉ]
    // vZ x, y  t  q offset  x, y, t ꂼZ
    Position<long> converted_position = rotate(position, offset.rad());
    converted_position += offset;

    return converted_position;
  }


  Position<long> positionOnParent(const Coordinate* child,
                                  const Position<long>& position)
  {
    Coordinate* parent = child->parent();
    Position<long> offset = parent->offset(child);

    // e̍Wnł̈ʒu x, y  offset  x, y, t 
    // vZ x, y  offset ̊px -t ɉ]
    Position<long> converted_position = position - offset;
    return rotate(converted_position, -offset.rad());
  }


  Position<long> positionOnGlobal(const Coordinate* coordinate,
                                  const Position<long>& position)
  {
    if (coordinate == global()) {
      return position;
    }

    return positionOnParent(coordinate,
                            positionOnGlobal(coordinate->parent(), position));
  }
};


// global() p̃RXgN^
Coordinate::Coordinate(Coordinate* parent) : pimpl(new pImpl(parent))
{
}


Coordinate::Coordinate(void) : pimpl(new pImpl(global()))
{
  // global ̎q̍WnƂēo^
  setOriginTo(Position<long>(0, 0, deg(0)), global());
}


Coordinate::~Coordinate(void)
{
  if (! pimpl->parent_) {
    return;
  }

  // q̍WneWnɊU
  // !!!

  // eo^폜
  pimpl->eraseFromParent(this);
}


Coordinate* Coordinate::global(void)
{
  static Coordinate global_coordinate(NULL);
  return &global_coordinate;
}


void Coordinate::setOriginTo(const Position<long>& position,
                             Coordinate* parent)
{
  pimpl->eraseFromParent(this);

  parent->pimpl->children_[this] = Child(this, position);
  pimpl->parent_ = parent;
}


Coordinate* Coordinate::parent(void) const
{
  return pimpl->parent_;
}


set<Coordinate*> Coordinate::children(void) const
{
  set<Coordinate*> children;
  for (Children::iterator it = pimpl->children_.begin();
       it != pimpl->children_.end(); ++it) {
    children.insert(it->first);
  }
  return children;
}


Position<long> Coordinate::offset(const Coordinate* child) const
{
  Children::iterator it = pimpl->children_.find(const_cast<Coordinate*>(child));
  if (it != pimpl->children_.end()) {
    return it->second.offset_;
  }

  // O𓊂邱Ƃ
  // !!!
  fprintf(stderr, "Coordinte::offset(): no child.\n");

  Position<long> dummy;
  return dummy;
}


Position<long> Coordinate::pointPosition(const Position<long>& position,
                                         const Coordinate* coordinate) const
{
  // WnɓLȏs
  const_cast<Coordinate*>(this)->beforeEvaluate();
  if (coordinate) {
    const_cast<Coordinate*>(coordinate)->beforeEvaluate();
  }

  // coordinate ̃O[oWnł̈ʒu߂
  Position<long> global_position = position;
  Coordinate* global_coordinate = global();
  for (const Coordinate* p = coordinate;
       p != global_coordinate; p = p->parent()) {
    global_position = pimpl->positionOnChild(p, global_position);
  }

  // ̍Wnł̈ʒu߂ĕԂ
  return pimpl->positionOnGlobal(this, global_position);
}
