#ifndef QRK_CYCLE_TIMER_H
#define QRK_CYCLE_TIMER_H

/*!
  \file
  \brief ^C}[

  \author Satofumi KAMIMURA

  $Id: CycleTimer.h 772 2009-05-05 06:57:57Z satofumi $
*/

#include <memory>


namespace qrk
{
  /*!
    \brief ^C}[
  */
  class CycleTimer
  {
    CycleTimer(const CycleTimer& rhs);
    CycleTimer& operator = (const CycleTimer& rhs);

    struct pImpl;
    std::auto_ptr<pImpl> pimpl;

  public:
    enum {
      DefaultFps = 60,          //!<  FPS
    };

    CycleTimer(void);
    ~CycleTimer(void);


    /*!
      \brief ҋ@

      wҋ@ԂԂ

      \retval ҂ׂ [msec]

      gp
\dontinclude libs/gui/samples/CycleTimerSample.cpp
\skip CycleTimer cycle_timer;
\until ++total_count;
\line }
    */
    size_t waitMsec(void);


    /*!
      \brief ^C}[̃Zbg

      ̓JEgZbg
    */
    void reset(void);


    /*!
      \brief KJԂA̎w

      \param[in] on ɍsKvꍇ true
    */
    void setStrictCycle(bool on);


    /*!
      \brief FPS ɂw

      \param[in] fps 

      \see setCycleMsec()
    */
    void setCycleFps(size_t fps);


    /*!
      \brief ̎擾

      \retval  [fps]
    */
    size_t cycleFps(void) const;


    /*!
      \brief msec ɂw

      \param[in] delay_msec ̊Ԋu

      \see setCycleFps()
    */
    void setCycleMsec(size_t delay_msec);


    /*!
      \brief ̎擾

      \retval  [msec]
    */
    size_t cycleMsec(void) const;


    /*!
      \brief ̎܂ł̎ԂԂ

      \retval ̎܂ł̎ [msec]
    */
    int toNextCycleMsec(void);
  };
}

#endif /* !QRK_CYCLE_TIMER_H */
