#ifndef QRK_RANGE_FINDER_PARAMETER_H
#define QRK_RANGE_FINDER_PARAMETER_H

/*!
  \file
  \brief WZT̃p[^Ǘ

  \author Satofumi KAMIMURA

  $Id: RangeFinderParameter.h 1003 2009-06-14 07:24:58Z satofumi $
*/

#include <string>


namespace qrk
{
  /*!
    \brief ZTp[^ǗNX
  */
  class RangeFinderParameter
  {
  public:
    enum {
      MODL = 0,                 //!< ZT^
      DMIN,                     //!< ŏv\ [mm]
      DMAX,                     //!< őv\ [mm]
      ARES,                     //!< px\(360x̕)
      AMIN,                     //!< ŏv\l
      AMAX,                     //!< őv\l
      AFRT,                     //!< ʕl
      SCAN,                     //!< Wpx
    };

    std::string model;          //!< MODL 
    long distance_min;          //!< DMIN 
    long distance_max;          //!< DMAX 
    int area_total;             //!< ARES 
    int area_min;               //!< AMIN 
    int area_max;               //!< AMAX 
    int area_front;             //!< AFRT 
    int scan_rpm;               //!< SCAN 

    RangeFinderParameter(void)
      : model(""), distance_min(0), distance_max(0), area_total(0),
        area_min(0), area_max(0), area_front(0), scan_rpm(600)
    {
    }
  };
}

#endif /* !QRK_RANGE_FINDER_PARAMETER_H */
