#ifndef QRK_ROTATION_H
#define QRK_ROTATION_H

/*!
  \file
  \brief ]

  \author Satofumi KAMIMURA

  $Id: Rotate.h 1150 2009-07-17 11:02:10Z satofumi $
*/

#include "Angle.h"


namespace qrk
{
  template<class T>
  Position<T> rotate(const Position<T>& position, const Angle& angle)
  {
    double radian = angle.to_rad();
    T x =
      static_cast<T>((position.x * cos(radian)) - (position.y * sin(radian)));
    T y =
      static_cast<T>((position.x * sin(radian)) + (position.y * cos(radian)));

    return Position<T>(x, y, rad(position.angle.to_rad() + radian));
  }
}

#endif /* !QRK_ROTATION_H */
