#ifndef QRC_URG_DEVICE_H
#define QRC_URG_DEVICE_H

/*!
  \file
  \brief URG ̐

  \author Satofumi KAMIMURA

  $Id: UrgDevice.h 1230 2009-08-19 02:15:55Z satofumi $
*/

#include "Coordinate.h"
#include "RangeFinder.h"


namespace qrk
{
  //! URG ̐
  class UrgDevice : public Coordinate, public RangeFinder
  {
    UrgDevice(const UrgDevice& rhs);
    UrgDevice& operator = (const UrgDevice& rhs);

    struct pImpl;
    std::auto_ptr<pImpl> pimpl;

  public:
    enum {
      DefaultBaudrate = 115200, // [bps]
    };

    typedef enum {
      GD_Capture,
      MD_Capture,
    } CaptureMode;

    UrgDevice(void);
    ~UrgDevice(void);

    const char* what(void) const;
    bool connect(const char* device, long baudrate = DefaultBaudrate);
    void disconnect(void);
    bool isConnected(void) const;
    void setConnection(Connection* connection);
    Connection* connection(void);
    size_t scanMsec(void) const;
    size_t minDistance(void) const;
    size_t maxDistance(void) const;
    size_t maxRange(void) const;
    void setTimestamp(long timestamp);
    void setCaptureTimes(size_t times);
    void setCaptureRange(size_t begin_index, size_t end_index);


    /*!
      \brief f[^̎擾Jn

      \param[in] mode f[^̎擾[h
    */
    void setRequestMode(CaptureMode mode);


    void requestData(void);
    bool receiveData(std::vector<long>& data, long* timestamp = NULL);
    size_t rad2index(double radian) const;
    double index2rad(size_t index) const;


    //! [U_
    void laserOn(void);


    /*!
      \brief [U

      [UAf[^̎擾͒f
    */
    void laserOff(void);
  };
}

#endif /* !QRC_URG_DEVICE_H */
