#ifndef QRK_URG_DISTANCE_H
#define QRK_URG_DISTANCE_H

/*!
  \file
  \brief UrgDevice ɑ苗ێNX

  \author Satofumi KAMIMURA

  $Id: UrgDistance.h 1148 2009-07-17 00:21:48Z satofumi $
*/

#include "UrgDevice.h"


namespace qrk
{
  class UrgDistance : public Coordinate, public RangeFinder
  {
  public:
    UrgDistance(const UrgDistance& rhs);
    UrgDistance& operator = (const UrgDistance& rhs);

    struct pImpl;
    std::auto_ptr<pImpl> pimpl;

  public:
    UrgDistance(void);
    ~UrgDistance(void);

    const char* what(void) const;
    bool connect(const char* device,
                 long baudrate = UrgDevice::DefaultBaudrate);
    void disconnect(void);
    bool isConnected(void) const;
    void setConnection(Connection* connection);
    Connection* connection(void);
    size_t scanMsec(void) const;
    size_t minDistance(void) const;
    size_t maxDistance(void) const;
    size_t maxRange(void) const;
    void setTimestamp(long timestamp);
    void setCaptureTimes(size_t times);
    void setCaptureRange(size_t begin_index, size_t end_index);

    void setRequestMode(UrgDevice::CaptureMode mode);
    void requestData(void);
    bool receiveData(std::vector<long>& data, long* timestamp);
    bool receiveData(void);
    long at(size_t index) const;

    size_t rad2index(double radian) const;
    double index2rad(size_t index) const;

    void laserOn(void);
    void laserOff(void);
  };
}

#endif /* !QRK_URG_DISTANCE_H */
