/*!
  \file
  \brief ŐL^֐

  \author Satofumi KAMIMURA

  $Id: log_printf.cpp 772 2009-05-05 06:57:57Z satofumi $
*/

#include "log_printf.h"
#include "DetectOS.h"
#include <string>
#include <cstdio>
#include <cstdarg>

using namespace std;


namespace
{
  string log_file_ = "error_log.txt";
}


int qrk::log_printf(const char *format, ...)
{
  static FILE* fd = NULL;
  if (fd == NULL) {
    fd = fopen(log_file_.c_str(), "w");
    if (fd == NULL) {
      return -1;
    }
  }

  va_list ap;

  // WG[o
  va_start(ap, format);
  vfprintf(stderr, format, ap);
  va_end(ap);

  // t@Co
  va_start(ap, format);
  int ret = vfprintf(fd, format, ap);
  va_end(ap);

  // fclose() @Ȃ̂ŁAeoĂ
  fflush(fd);

  return ret;
}


void qrk::log_setName(const char* file_name)
{
  log_file_ = file_name;
}
