#ifndef QRK_CYLINDER_H
#define QRK_CYLINDER_H

/*!
  \file
  \brief V~[Vp̏Q(Cylinder)

  \author Satofumi KAMIMURA

  $Id: Cylinder.h 1182 2009-07-25 08:30:12Z satofumi $
*/

#include "OdeModel.h"


namespace qrk
{
  class Color;


  class Cylinder : public OdeModel
  {
    Cylinder(void);
    Cylinder(const Cylinder& rhs);
    Cylinder& operator = (const Cylinder& rhs);

    struct pImpl;
    std::auto_ptr<pImpl> pimpl;

  public:
    Cylinder(long radius, long length, dReal mass = 1.0);
    ~Cylinder(void);

    void setPosition(const Position<long>& position,
                     OdeModel* model = NULL, bool fixed = false);
    Position<long> position(void) const;

    void setColor(const Color& color);

    dBodyID objectId(void) const;
  };
}

#endif /* !QRK_CYLINDER_H */
