#ifndef QRK_EXECUTION_TYPE_H
#define QRK_EXECUTION_TYPE_H

/*!
  \file
  \brief s̃^CvǗ

  \author Satofumi KAMIMURA

  $Id: ExecutionType.h 1198 2009-08-01 23:41:55Z satofumi $
*/

#include <memory>


namespace qrk
{
  class ExecutionType
  {
    ExecutionType(void);
    ExecutionType(const ExecutionType& rhs);
    ExecutionType& operator = (const ExecutionType& rhs);

    struct pImpl;
    std::auto_ptr<pImpl> pimpl;

  public:
    typedef enum {
      RealDevice,               //!< @s
      Recording,                //!< f[^L^Ď@s
      Simulation,               //!< V~[Vs
      Playback,                 //!< L^ꂽf[^pĎs
    } Type;

    static ExecutionType* object(void);
    ~ExecutionType(void);

    void setType(Type type);
    Type type(void) const;
  };
}

#endif /* !QRK_EXECUTION_TYPE_H */
