/*!
  \file
  \brief TCP/IP ʐM

  \author Satofumi KAMIMURA

  $Id: TcpipSocket.cpp 1140 2009-07-13 21:41:41Z satofumi $

  \todo eXgēmFs
*/

#include "TcpipSocket.h"
#include <QTcpSocket>

using namespace qrk;


struct TcpipSocket::pImpl
{
  QTcpSocket* socket_;
  long baudrate_;


  pImpl(QTcpSocket* socket) : socket_(socket), baudrate_(0)
  {
  }


  ~pImpl(void)
  {
    delete socket_;
  }
};


TcpipSocket::TcpipSocket(void) : pimpl(new pImpl(new QTcpSocket))
{
}


TcpipSocket::TcpipSocket(void* socket)
  : pimpl(new pImpl(static_cast<QTcpSocket*>(socket)))
{
}



TcpipSocket::~TcpipSocket(void)
{
}


const char* TcpipSocket::what(void)
{
  return pimpl->socket_->errorString().toStdString().c_str();
}


bool TcpipSocket::connect(const char* host, long port)
{
  pimpl->socket_->connectToHost(host, port);

  enum { ConnectionTimeout = 3000 };
  bool ret = pimpl->socket_->waitForConnected(ConnectionTimeout);

  return ret;
}


void TcpipSocket::disconnect(void)
{
  pimpl->socket_->disconnectFromHost();
}


bool TcpipSocket::setBaudrate(long baudrate)
{
  // Ȃ
  pimpl->baudrate_ = baudrate;
  return true;
}


long TcpipSocket::baudrate(void)
{
  // Ȃ
  return pimpl->baudrate_;
}


bool TcpipSocket::isConnected(void)
{
  return pimpl->socket_->isValid();
}


int TcpipSocket::send(const char* data, size_t count)
{
  return pimpl->socket_->write(data, count);
}


int TcpipSocket::receive(char* data, size_t count, int timeout)
{
  if (count == 0) {
    return 0;
  }

  size_t filled = 0;
  do {
    int n = pimpl->socket_->read(&data[filled], count - filled);
    if (n < 0) {
      return n;
    }
    if (n > 0) {
      filled += n;
    }

    if ((filled < count) && (! pimpl->socket_->waitForReadyRead(timeout))) {
      break;
    }
  } while (filled < count);

  return filled;
}


size_t TcpipSocket::size(void)
{
  return pimpl->socket_->bytesAvailable();
}


void TcpipSocket::flush(void)
{
  pimpl->socket_->flush();
}


void TcpipSocket::clear(void)
{
  // Mobt@̓eǂݎ̂Ă
  enum { BufferSize = 256 };
  char buffer[BufferSize];

  while (receive(buffer, BufferSize, 0) == BufferSize) {
    ;
  }
}


void TcpipSocket::ungetc(const char ch)
{
  pimpl->socket_->ungetChar(ch);
}
