/*!
  \file
  \brief Ԃ̊ǗpEBWbg

  \author Satofumi KAMIMURA

  $Id: TicksControlWidget.cpp 1113 2009-07-06 21:58:15Z satofumi $
*/

#include "TicksControlWidget.h"
#include <QShortcut>

using namespace qrk;


struct TicksControlWidget::pImpl
{
  TicksControlWidget* widget_;


  pImpl(TicksControlWidget* widget) : widget_(widget)
  {
  }


  void initializeForm(void)
  {
    connect(widget_->play_button_, SIGNAL(clicked()),
            widget_, SIGNAL(play()));
    connect(widget_->pause_button_, SIGNAL(clicked()),
            widget_, SIGNAL(pause()));
    connect(widget_->speed_up_button_, SIGNAL(clicked()),
            widget_, SIGNAL(moreFaster()));
    connect(widget_->speed_down_button_, SIGNAL(clicked()),
            widget_, SIGNAL(moreSlower()));
  }
};


TicksControlWidget::TicksControlWidget(QWidget* parent)
  : QWidget(parent), pimpl(new pImpl(this))
{
  setupUi(this);
  pimpl->initializeForm();

  (void) new QShortcut(Qt::CTRL + Qt::Key_W, this, SLOT(close()));
  (void) new QShortcut(Qt::CTRL + Qt::Key_Q, this, SIGNAL(quit()));
}


TicksControlWidget::~TicksControlWidget(void)
{
}


void TicksControlWidget::closeEvent(QCloseEvent* event)
{
  static_cast<void>(event);
  emit closed();
}
