/*!
  \file
  \brief ➑̐

  \author Satofumi KAMIMURA

  $Id: body_control.c 1209 2009-08-05 13:11:59Z satofumi $
*/

#include "body_control.h"
#include "robot_macro.h"


void body_initialize(body_t *body)
{
  body->reset = 0;
  body->rotate_coeffecient = BODY_T_ROTATE_COEFFECIENT;
}


void body_reset(body_t *body)
{
  // eȂ
  (void)body;
}


void body_calculateWheelVelocity(long wheel_velocity[],
                                 long mm_per_sec, long dir16,
                                 const body_t *body)
{
  // ]̈ړ = gbh * ]x
  long difference =
    (dir16 * body->rotate_coeffecient) >> (BODY_T_TREAD_R_SHIFT + 1 + 16);

  // E̎ԗ֑ = ix + (]x * gbh / 2)
  wheel_velocity[RightId] = mm_per_sec + difference;

  // ̎ԗ֑ = ix - (]x * gbh / 2)
  wheel_velocity[LeftId] = mm_per_sec - difference;
}
