#ifndef QRK_M_URG_DISTANCE_H
#define QRK_M_URG_DISTANCE_H

/*!
  \file
  \brief j^Ή UrgDistance NX

  \author Satofumi KAMIMURA

  $Id: mUrgDistance.h 1224 2009-08-15 12:01:06Z satofumi $
*/

#include "UrgDistance.h"


namespace qrk
{
  //! j^Ή UrgDistance NX
  class mUrgDistance : public Coordinate, public RangeFinder
  {
    mUrgDistance(const mUrgDistance& rhs);
    mUrgDistance& operator = (const mUrgDistance& rhs);

    struct pImpl;
    std::auto_ptr<pImpl> pimpl;

  public:
    mUrgDistance(void);
    ~mUrgDistance(void);

    const char* what(void) const;
    bool connect(const char* distance,
                 long baudrate = UrgDevice::DefaultBaudrate);
    void disconnect(void);
    bool isConnected(void) const;
    void setConnection(Connection* connection);
    Connection* connection(void);
    size_t scanMsec(void) const;
    size_t minDistance(void) const;
    size_t maxDistance(void) const;
    size_t maxRange(void) const;
    void setTimestamp(long timestamp);
    void setCaptureTimes(size_t times);
    void setCaptureRange(size_t begin_index, size_t end_index);
    void setRequestMode(UrgDevice::CaptureMode mode);
    void requestData(void);
    bool receiveData(std::vector<long>& data, long* timestamp);
    bool receiveData(void);
    long at(size_t index) const;
    size_t rad2index(double radian) const;
    double index2rad(size_t index) const;
    void laserOn(void);
    void laserOff(void);
  };
}

#endif /* !QRK_M_URG_DISTANCE_H */
