/*!
  \example gdCaptureSample.cpp

  \brief GD コマンドによるデータ取得サンプル

  \author Satofumi KAMIMURA

  $Id: gdCaptureSample.cpp 1474 2009-11-01 05:33:08Z satofumi $
*/

#include "UrgCtrl.h"
#include <cstdlib>
#include <cstdio>

using namespace qrk;
using namespace std;


//! main
int main(int argc, char *argv[])
{
  const char device[] = "COM3";
  //const char device[] = "/dev/ttyACM0";

  UrgCtrl urg;
  if (! urg.connect(device)) {
    printf("UrgCtrl::connect: %s\n", urg.what());
    exit(1);
  }

  // GD コマンドで指定された回数だけスキャンを行い、出力する
  enum { CaptureTimes = 1 };
  for (int i = 0; i < CaptureTimes; ++i) {
    long timestamp = 0;
    vector<long> data;

    // 取得
    int n = urg.capture(data, &timestamp);

    // 出力
    printf("timestamp: %ld\n", timestamp);
    for (int j = 0; j < n; ++j) {
      // urg_minDistance() 以下の距離データは、無効値を表す
      printf("%d:%ld, ", j, data[j]);
    }
    printf("\n");
  }

#ifdef MSC
  getchar();
#endif

  return 0;
}
