/*!
  \example mdCaptureSample.cpp

  \brief MD R}hɂf[^擾Tv

  \author Satofumi KAMIMURA

  $Id: mdCaptureSample.cpp 1474 2009-11-01 05:33:08Z satofumi $
*/

#include "UrgCtrl.h"
#include "delay.h"
#include "ticks.h"
#include <cstdlib>
#include <cstdio>

using namespace qrk;
using namespace std;


//! main
int main(int argc, char *argv[])
{
  const char device[] = "COM3";
  //const char device[] = "/dev/ttyACM0";

  UrgCtrl urg;
  if (! urg.connect(device)) {
    printf("UrgCtrl::connect: %s\n", urg.what());
    exit(1);
  }

#if 1
  // 擾[h MD ɐݒ
  urg.setCaptureMode(AutoCapture);

#else
  // xf[^t̃f[^擾[h
  urg.setCaptureMode(IntensityCapture);
  urg.setCaptureSkipLines(2);
#endif
  int scan_msec = urg.scanMsec();

#if 0
  // 擾͈͂ 獶E 90x(v180x)ɐݒ
  const double rad90 = 90.0 * M_PI / 180.0;
  urg.setCaptureRange(urg.rad2index(-rad90), urg.rad2index(rad90));
#endif

  int pre_timestamp = ticks();

  // MD R}hŘAf[^擾sAw񐔂o͂
  enum { CaptureTimes = 10};
  urg.setCaptureTimes(CaptureTimes);
  for (int i = 0; i < CaptureTimes;) {
    long timestamp = 0;
    vector<long> data;

    // f[^擾
    int n = urg.capture(data, &timestamp);
    if (n <= 0) {
      delay(scan_msec);
      continue;
    }

    // \
    printf("timestamp: %ld, (%d), %ld\n",
           timestamp, ticks(), timestamp - pre_timestamp);
    pre_timestamp = timestamp;
#if 0
    for (int j = 0; j < n; ++j) {
      // urg_minDistance() ȉ̋f[^́Al\
      printf("%d:%ld, ", j, data[j]);
    }
    printf("\n");
#endif
    ++i;
  }

#ifdef MSC
  getchar();
#endif

  return 0;
}
