<?php
/**
 *	Project:	Quicty: Quick application build environment depends on PEAR and Smarty
 *	File:		DataView.class.php
 *
 *	@copyright	Tomoyuki Negishi and ZubaPitaTech, Inc.
 *	@author		Tomoyuki Negishi <tomoyu-n@zubapita.jp>
 *	@license	http://www.opensource.org/licenses/bsd-license.php The BSD License
 *	@package	Quicty
 *	@version	$Id:$
 */


// {{{ DataView
/**
 *	DataView Create, validate and process HTML forms with easy settings class.
 *
 *	@author		Tomoyuki Negishi <tomoyu-n@zubapita.jp>
 *	@access		public
 *	@package	Quicty
 */
class DataView extends HTML_QuickForm {
public $data_view;
public $id_column;
public $validation_place = 'server';
public $error;
public $__page_obj;
public $escape_string_func = 'addslashes';
public $__force_escape_filter = false;
//  constructor
function DataView($formName='', $method='post', $action='', $target='', $attributes=null, $trackSubmit=false) {
	HTML_QuickForm::HTML_QuickForm($formName, $method, $action, $target, $attributes, $trackSubmit);
	$this->data_view_config_dir = '/etc/data_view';
	$this-> regist_custom_rules();
}

function read_conf_to_array($dir,$file,$type='IniFile') {
	$config = new Config();
	if(is_file($dir.'/'.$file)) {
		$parsed_data = $config->parseConfig($dir.'/'.$file,$type);
	} elseif(is_file($file)) {
		$parsed_data = $config->parseConfig($file,$type);
	} else {
		die('error:'.$file.''.$dir.'¸ߤޤ');
	}
	$data_array = $parsed_data->toArray();
	return $data_array;
}

function bind_data_view($data_view_file) {
	global $html_quickform_datatype,$html_quickform_datatype_default,$quicksmart_datatype,$validiate_rule;
	if(function_exists(apc_fetch)) {
		$columns = unserialize(apc_fetch('CONFIG_SET_'.$data_view_file));
	}
	if(!$columns) {
		$config_dir = $this->__page_obj->home_dir.$this->data_view_config_dir;
		$data_view_array = $this->read_conf_to_array($config_dir,$data_view_file);
		$columns = $data_view_array['root'];
		if(function_exists(apc_store)) {
			$result = apc_store('CONFIG_SET_'.$data_view_file,serialize($columns));
		}
	}
	foreach($columns as $column=>$attributes) {
		$method_pram = array();
		if(array_key_exists($attributes['type'],$quicksmart_datatype)===false) {
			die('Quicty error:'.$column.':'.$attributes['type'].'is unkown data type.');
		}
		if($attributes['type']=='id') $this->id_column = $column;
		$hqf_type = $quicksmart_datatype[$attributes['type']]['hqf_type'];
		$method_pram['type'] = $hqf_type;
		$method_pram['qs_type'] = $attributes['type'];
		$columns_pram = $html_quickform_datatype[$hqf_type];
		$columns_default = $html_quickform_datatype_default[$hqf_type];
		foreach($columns_pram as $property=>$value) {
			if($value=='property_array') {
				$tmp_array = $this->get_array_from_list($attributes,$property);
				if(count($tmp_array)==0) {
					$method_pram[$property] = $columns_default[$property];
				} else {
					$method_pram[$property] = $tmp_array;
				}
			} elseif($property=='name') {
				$method_pram['name'] = $column;
			} else {
				$method_pram[$property] = $attributes[$property] ? $attributes[$property]:$columns_default[$property];
			}
		}
		$current_logic = array($this,$hqf_type.'_element');
		$this->form_element[$column] = call_user_func($current_logic,$method_pram);
		$this->data_view[$column] = $method_pram;
		if(isset($attributes['default'])) {
			$this->setDefaults(array($column=>$attributes['default']));
		}
		if($attributes['default_list']=='start') {
			$default_param = $this->get_array_from_list($attributes,'default_list');
			$this->setDefaults(array($column=>$default_param));
		}
		if($attributes['force_value_list']=='start') {
			$force_value = $this->get_force_values($attributes,'force_value_list',$column);
			if(isset($force_value[$column])) {
				$this->form_element[$column]->setValue($force_value[$column]);
				$this->__force_values[$column] = $force_value;
			}
			$this->form_element[$column]->freeze();
		}
		if($attributes['reference']=='start') {
			$this->data_view[$column]['reference'] = $this->get_array_from_list($attributes,'reference');
		}
		$tmp_array = $this->get_array_from_list($attributes,'rule');
		if(count($tmp_array)) {
			foreach($tmp_array as $rule_name=>$value) {
				if(is_callable(array($this,'add_'.$rule_name.'_rule'))) {
					$result = call_user_func(array($this,'add_'.$rule_name.'_rule'),$column,$rule_name,$value,$this->validation_place);
				} elseif(is_callable(array($this->__page_obj,'add_'.$rule_name.'_rule'))) {
					$result = call_user_func(array($this->__page_obj,'add_'.$rule_name.'_rule'),$column,$rule_name,$value,$this->validation_place,$this);
				} else {
					echo 'Quity error!:"add_'.$rule_name.'_rule" is not able to call.';
				}
			}
		}
	}
} // end of function bind_data_view


function get_array_from_list($attributes,$property_name) {
	$tmp_flag = false;$tmp_array=array();
	foreach($attributes as $t_property=>$t_value) {
		if($t_property===$property_name and $t_value=='start') {
			$tmp_flag = true;
		} elseif($t_property==='end_'.$property_name) {
			$tmp_flag = false;
		} elseif($tmp_flag) {
			if(substr($t_value,0,12)=='_THIS_VALUE.') {
				$var_name = substr($t_value,12);
				if(strpos($var_name,'.')!==false) {
					list($array_name,$var_name) = explode('.',$var_name);
					$t_array = $this->__page_obj->$array_name;
					$t_value = $t_array[$var_name];
				} else {
					$t_value = $this->__page_obj->$var_name;
				}
			}
			$tmp_array[$t_property] = $t_value;
		}
	}
	if($tmp_array['_TABLE'] and $property_name!='reference') {
		$tmp_array = $this->get_list_from_table($tmp_array);
	}
	if($property_name=='default_list') {
		if($tmp_array['date']=='now') $tmp_array = $this->get_now_date();
	}
	return $tmp_array;
}

function get_list_from_table($tmp_array) {
	if($data_set = $tmp_array['_TABLE']) {
		$_FORM = $this->__page_obj->new_data_set($data_set);

		if($tmp_array['_WHERE_COLUMN']) {
			$where = 'where '.$tmp_array['_WHERE_COLUMN'].'=';
			list($var_name,$var_operator) = explode('.',$tmp_array['_WHERE_THIS_VALUE']);
			$where .= "'".$this->__page_obj->{$var_name}[$var_operator]."'";
		}
		if($tmp_array['_ORDER_BY']) $order_by = 'order by '.$tmp_array['_ORDER_BY'];
		$table = $_FORM->select_table("$where $order_by");
		
		if($tmp_array['_START']=='no_value') {
			$result_array[0] = 'ʤ';
		}
		$key_column = $tmp_array['_VALUE'];
		$label_column = $tmp_array['_LABEL'];
		if(is_array($table) and count($table)>0) {
			foreach($table as $key=>$value) {
				$key = $value[$key_column];
				$result_array[$key] = $value[$label_column];
			}
		}
	}
	return $result_array;
}

function get_force_values($attributes,$property_name,$column) {
	$tmp_array = $this->get_array_from_list($attributes,$property_name);
	if($tmp_array['date']=='now') {
		$result[$column] =  $this->get_now_date();
	}
	if($tmp_array['auto_only_1st']) {
		$result['auto_only_1st'] = 'yes';
	}
	if($tag = $tmp_array['_SERVER']) {
		$result[$column] = $_SERVER[$tag];
	} elseif($tag = $tmp_array['_THIS_VALUE']) {
		list($var_name,$var_operator) = explode('.',$tag);
		$result[$column] = $this->__page_obj->{$var_name}[$var_operator];
	}

	if($function = $tmp_array['_USER_FUNCTION']) {
		if($tmp_array['_AT_TIME']=='last') {
			$result['call_function_last'] = 'yes';
		} else {
			$result['call_function'] = 'yes';
		}
		if($source = $tmp_array['_PARAM']) {
			$result[$column] = '$eval_result = call_user_func(array($this->__page_obj,"'.$function.'"),$this->getSubmitValue("'.$source.'"));';
		} else {
			$result[$column] = '$eval_result = call_user_func(array($this->__page_obj,"'.$function.'"));';
		}
	}
	return $result;
}


function get_now_date() {
	$now = time();
	$tmp_array['Y'] = date('Y',$now);
	$tmp_array['m'] = date('m',$now);
	$tmp_array['d'] = date('d',$now);
	$tmp_array['H'] = date('H',$now);
	$tmp_array['i'] = date('i',$now);
	$tmp_array['s'] = date('i',$now);
	return $tmp_array;
}

public $can_skip_confirm = true;
public $use_confirm = true;
public $use_redo = true;
public $use_restart = true;

function set_button_status($button_kind,$status) {
	if($status) {
		$this->$button_kind = true;
	} else {
		$this->$button_kind = false;
	}
}

function set_button_label($button_name,$label) {
	$button_label = $button_name.'_button_label';
	if($button_name and $label) {
		$this->$button_label = $label;
	}
	return $this->$button_label;
}

function set_base_link_addr($addr='') {
	return $this->base_link_addr = $addr;
}

function set_restart_link_addr($addr='/') {
	return $this->restart_link_addr = $addr;
}

public $send_button_label = '';
public $insert_confirm_button_label = 'ǧ';
public $insert_button_label = 'Ͽ';
public $update_confirm_button_label = 'ǧ';
public $update_button_label = '';
public $browse_button_label = 'ɽ';
public $edit_button_label = 'Խ';
public $delete_confirm_button_label = '';
public $delete_button_label = '¹';
public $redo_button_label = '';
public $reset_button_label = 'ꥻå';
public $restart_button_label = '';
//
public $base_link_addr = '';
public $restart_link_addr = '/';
//
public $send_button;
public $insert_confirm_button;
public $insert_button;
public $update_confirm_button;
public $update_button;
public $browse_button;
public $edit_button;
public $delete_confirm_button;
public $delete_button;
public $redo_button;
public $reset_button;
public $restart_button;
//
public $START_set;
public $EDIT_set;
public $INSERT_CONFIRM_set;
public $INSERT_set;
public $UPDATE_CONFIRM_set;
public $UPDATE_set;
public $BROWSE_set;
public $DELETE_CONFIRM_set;
public $DELETE_SET;
public $REDO_set;

function bind_button_control ($control='submit') {
	if(substr($this->base_link_addr,-1)=='/') {
		$base_link_addr = substr($this->base_link_addr,0,-1);
	} else {
		$base_link_addr = $this->base_link_addr;
	}
	$this->send_button = $this->createElement('submit', 'SEND',$this->send_button_label);
	$this->insert_confirm_button = $this->createElement('submit', 'INSERT_CONFIRM',$this->insert_confirm_button_label);
	$this->insert_button = $this->createElement('submit', 'INSERT',$this->insert_button_label);
	$this->update_confirm_button = $this->createElement('submit', 'UPDATE_CONFIRM',$this->update_confirm_button_label);
	$this->update_button = $this->createElement('submit', 'UPDATE',$this->update_button_label);
	$id_column = $this->id_column;
	if($_REQUEST[$id_column]) {
		$id_query = "?$id_column=".$_REQUEST[$id_column];
	}
	$this->browse_button = $this->createElement('link', 'BROWSE',$this->browse_button_label,$base_link_addr."/info$id_query",$this->browse_button_label,NULL);
	$this->edit_button = $this->createElement('link', 'EDIT',$this->edit_button_label,$base_link_addr."/edit$id_query",$this->edit_button_label,NULL);
	$this->delete_confirm_button = $this->createElement('link', 'DELETE_CONFIRM',$this->delete_confirm_button_label,$base_link_addr."/delete$id_query",$this->delete_confirm_button_label,NULL);
	$this->delete_button = $this->createElement('submit', 'DELETE',$this->delete_button_label);
	$this->redo_button = $this->createElement('button', 'REDO',$this->redo_button_label,array('onClick'=>'javascript:history.back()'));
	$this->reset_button = $this->createElement('reset', 'RESET',$this->reset_button_label);
	$this->restart_button = $this->createElement('link', 'RESTART',$this->restart_button_label,"$this->restart_link_addr",$this->restart_button_label,NULL);

	// set of buttons
	$this->SEND_set[] = $this->send_button;
	if($this->use_confirm) $this->START_set[] = $this->insert_confirm_button;
	if($this->can_skip_confirm) $this->START_set[] = $this->insert_button;
	$this->EDIT_set[] = $this->redo_button;
	if($this->use_confirm) $this->EDIT_set[] = $this->update_confirm_button;
	if($this->can_skip_confirm) $this->EDIT_set[] = $this->update_button;
	$this->EDIT_set[] = $this->delete_confirm_button;
	if($this->use_redo) $this->INSERT_CONFIRM_set[] = $this->redo_button;
	$this->INSERT_CONFIRM_set[] = $this->insert_button;
	$this->INSERT_set[] = $this->restart_button;
	if($this->use_redo) $this->UPDATE_CONFIRM_set[] = $this->redo_button;
	$this->UPDATE_CONFIRM_set[] = $this->update_button;
	$this->UPDATE_set[] = $this->restart_button;
	if($this->use_restart) $this->BROWSE_set[] = $this->restart_button;
	$this->BROWSE_set[] = $this->edit_button;
	$this->DELETE_CONFIRM_set[] = $this->redo_button;
	$this->DELETE_CONFIRM_set[] = $this->delete_button;
	$this->DELETE_set[] = $this->restart_button;
	if($this->use_redo) $this->REDO_set[] = $this->redo_button;
	$this->REDO_set[] = $this->save_button;

	//
	$status = $this->__page_obj->QuictyStatus;
	$result = $this->addGroup($this->{$status.'_set'},$control,NULL,'&nbsp;');
	return $result;
}

function validate_and_freeze() {
	$result = NULL;
	switch($this->__page_obj->QuictyStatus) {
		case Quicty::BROWSE :
		case Quicty::DELETE_CONFIRM :
		case Quicty::DELETE :
			$this->freeze();
			break;
		case Quicty::INSERT_CONFIRM :
		case Quicty::INSERT :
			if($result = $this->validate()) {
				$this->freeze();
			} else {
				$this->__page_obj->QuictyStatus = Quicty::START;
			}
			break;
		case Quicty::UPDATE_CONFIRM :
		case Quicty::UPDATE :
			if($result = $this->validate()) {
				$this->freeze();
			} else {
				$this->__page_obj->QuictyStatus = Quicty::EDIT;
			}
			break;
	}
	return $result;
}

function advcheckbox_element($p) {
	return $this->addElement($p['type'],$p['name'],$p['label'],$p['text'],$p['attr'],$p['values']);
}

function checkbox_element($p) {
	return $this->addElement($p['type'],$p['name'],$p['label'],$p['text'],$p['attr']);
}

function date_element($p) {
	$element = $this->addElement($p['type'],$p['name'],$p['label'],$p['opt'],$p['attr']);
	return $element;
}

function file_element($p) {
	return $this->addElement($p['type'],$p['name'],$p['label'],$p['attr']);
}

function header_element($p) {
	return $this->addElement($p['type'],$p['name'],$p['label'],$p['opt'],$p['attr']);
}

function hidden_element($p) {
	return $this->addElement($p['type'],$p['name'],$p['value'],$p['attr']);
}

function hireselect_element($p) {
	return $this->addElement($p['type'],$p['name'],$p['label'],$p['attr']);
}

function html_element($p) {
	return $this->addElement($p['type'],$p['html']);
}

function image_element($p) {
	return $this->addElement($p['type'],$p['name'],$p['src'],$p['attr']);
}

function link_element($p) {
	return $this->addElement($p['type'],$p['name'],$p['label'],$p['href'],$p['value'],$p['attr']);
}

function password_element($p) {
	$element = $this->addElement($p['type'],$p['name'],$p['label'],$p['attr']);
	//$element->unfreeze();
	//$password = $element->getValue();
	//$md5pass = md5($password);
	//echo "md5pass=$md5pass<br>\n";
	//$element->setValue($md5pass);
	$element->setPersistantFreeze(true);
	return $element;
}

function radio_element($p) {
	$radios = array();
	foreach ($p['list'] as $key=>$value) {
		$radios[] = $this->createElement($p['type'],$p['name'],NULL,$value,$key);
	}
	return $this->addGroup($radios,$p['name'],$p['label']);
}

function select_element($p) {
	return $this->addElement($p['type'],$p['name'],$p['label'],$p['value'],$p['attr']);
}

function static_element($p) {
	return $this->addElement($p['type'],$p['label'],$p['text']);

}

function text_element($p) {
	$element = $this->addElement($p['type'],$p['name'],$p['label'],$p['attr']);
	$this->applyFilter($p['name'],'unify_newline');
	$this->applyFilter($p['name'],'trim');
	if(!get_magic_quotes_gpc) 
		$this->applyFilter($p['name'],$this->escape_string_func);
	return $element;
}

function textarea_element($p) {
	$element = $this->addElement($p['type'],$p['name'],$p['label'],$p['attr']);
	$this->applyFilter($p['name'],'unify_newline');
	$this->applyFilter($p['name'],'trim');
	if(!get_magic_quotes_gpc) 
		$this->applyFilter($p['name'],$this->escape_string_func);
	return $element;
}

//-----------------------------------
// add rule functions
//-----------------------------------

function add_required_rule($column,$rule_name,$value,$validation_place) {
	if($value=='only_1st' and substr($this->__page_obj->QuictyStatus,0,6)!='INSERT') {
		return NULL;
	} else {
		$message = $this->data_view[$column]['label'].'ɬϤƤ';
		return $this->addRule($column,$message,$rule_name,NULL,$validation_place);
	}
}

function add_maxlength_rule($column,$rule_name,$value,$validation_place) {
	$message = $this->data_view[$column]['label'].''.$value.'ʸʲϤƤ';
	return $this->addRule($column,$message,$rule_name,$value,$validation_place);
}

function add_minlength_rule($column,$rule_name,$value,$validation_place) {
	$message = $this->data_view[$column]['label'].''.$value.'ʸʾϤƤ';
	return $this->addRule($column,$message,$rule_name,$value,$validation_place);
}

function add_email_rule($column,$rule_name,$value,$validation_place) {
	$message = $this->data_view[$column]['label'].'emailɥ쥹ǤϤޤ';
	return $this->addRule($column,$message,$rule_name,NULL,$validation_place);
}

function add_lettersonly_rule($column,$rule_name,$value,$validation_place) {
	$message = $this->data_view[$column]['label'].'Ⱦѥե٥åȤΤϤǤޤ';
	return $this->addRule($column,$message,$rule_name,NULL,$validation_place);
}

function add_alphanumeric_rule($column,$rule_name,$value,$validation_place) {
	$message = $this->data_view[$column]['label'].'ȾѱѿΤϤǤޤ';
	return $this->addRule($column,$message,$rule_name,NULL,$validation_place);
}

function add_numeric_rule($column,$rule_name,$value,$validation_place) {
	$message = $this->data_view[$column]['label'].'ȾѿΤϤǤޤ';
	return $this->addRule($column,$message,$rule_name,NULL,$validation_place);
}

function add_nonzero_rule($column,$rule_name,$value,$validation_place) {
	$message = $this->data_view[$column]['label'].'ϥ(0)ϤǤޤ';
	return $this->addRule($column,$message,$rule_name,NULL,$validation_place);
}

function add_uploadedfile_rule($column,$rule_name,$value,$validation_place) {
	$message = $this->data_view[$column]['label'].'ɬե򤷤Ƥ';
	return $this->addRule($column,$message,$rule_name,NULL,$validation_place);
}

function add_maxfilesize_rule($column,$rule_name,$value,$validation_place) {
	$message = $this->data_view[$column]['label'].'ϥե뤬礭ޤ'.$value.'ХȰʲˤƤ';
	return $this->addRule($column,$message,$rule_name,$value,$validation_place);
}

function add_compare_rule($column,$rule_name,$value,$validation_place) {
	$message = $this->data_view[$column]['label'].''. $this->data_view[$value]['label'].'פޤ';
	return $this->addRule(array($column,$value),$message,$rule_name,NULL,$validation_place);
}

function add_zipcode_rule($column,$rule_name,$value,$validation_place) {
	$message = $this->data_view[$column]['label'].'͹ֹǤϤޤ';
	return $this->addRule($column,$message,'regex','/^[0-9]{3}\-[0-9]{4}$/',$validation_place);
}

function add_alphanumsymbol_rule($column,$rule_name,$value,$validation_place) {
	$message = $this->data_view[$column]['label'].'ȾѱѿȰεΤϤǤޤ';
	return $this->addRule($column,$message,'regex','/^[0-9A-Za-z._=|+\-]+$/',$validation_place);
}


//------------------------------------------------------------------------------------------------
// add validate rules
//

function regist_custom_rules() {
	$this->registerRule('checksame','callback','checksame',$this);
	$this->registerRule('checkmd5pass','callback','checkmd5pass',$this);
	$this->registerRule('checkmd5key','callback','checkmd5key',$this);
	$this->registerRule('checkuniq','callback','checkuniq',$this);
	$this->registerRule('checkemaildomain','callback','checkemaildomain',$this);
}

function add_checksame_rule($column,$rule_name,$value,$validation_place) {
	$message = $this->data_view[$column]['label'].'ޤ';
	return $this->addRule($column,$message,'checksame',$value);
}

function checksame($data,$column) {
	$id = $_REQUEST[$this->id_column];
	$row = $this->select("where $this->id_column=$id and $column='$data'");
	if(count($row)==1) {
		return true;
	} else {
		return false;
	}
}


function add_checkmd5pass_rule($column,$rule_name,$value,$validation_place) {
	$message = $this->data_view[$column]['label'].'ޤ';
	return $this->addRule($column,$message,'checkmd5pass',$value);
}

function checkmd5pass($data,$column) {
	$md5pass = md5($data);
	$id = $_REQUEST[$this->id_column];
	if($id) {
		$row = $this->select("where $this->id_column=$id and $column='$md5pass'");
		if(count($row)==1) {
			$result = true;
		} else {
			$result = false;
		}
	} else {
		$result = true;
	}
	return $result;
}

function add_checkmd5key_rule($column,$rule_name,$value,$validation_place) {
	$message = $this->data_view[$value]['label'].'ޤ';
	return $this->addRule(array($column,$value),$message,'checkmd5key',$column);
}

function checkmd5key($data_array,$column) {
	list($mydata,$keydata) = $data_array;
	$md5pass = md5($keydata);
	$id = $_REQUEST[$this->id_column];
	if($id) {
		$row = $this->select("where $this->id_column=$id and $column='$md5pass'");
		if(count($row)==1) {
			$result = true;
		} else {
			$result = false;
		}
	} else {
		$result = true;
	}
	return $result;
}

function add_checkuniq_rule($column,$rule_name,$value,$validation_place) {
	$message = $this->data_view[$column]['label'].'ϤǤϿƤޤ';
	return $this->addRule($column,$message,'checkuniq',$column);
}

function checkuniq($data,$column) {
	$id = $_REQUEST[$this->id_column];
	if($id) {
		$condition = "where $this->id_column=$id and $column='$data'";
		$num = $this->count_rows($condition);
		if($num==1 or $num==0) {
			$result = true;
		} else {
			$result = false;
		}
	} else {
		$condition = "where $column='$data'";
		$num = $this->count_rows($condition);
		if($num==0) {
			$result = true;
		} else {
			$result = false;
		}
	}
	return $result;
}

function add_entry_only_1st_rule($column,$rule_name,$value,$validation_place) {
	if($this->__page_obj->QuictyStatus=='EDIT') {
		$this->form_element[$column]->freeze();
	}
	return NULL;
}


function add_checkemaildomain_rule($column,$rule_name,$value,$validation_place) {
	$message = 'ɥᥤǧǤޤϤ˴ְ㤤ʤʤԤ䤤碌Ƥ';
	return $this->addRule($column,$message,'checkemaildomain',$column);
}

function checkemaildomain($data,$column) {
	$p = strpos($data,"@");
	$dn = substr($data,$p+1);
	$chkMx = checkdnsrr($dn, "MX");
	$chkA = checkdnsrr($dn, "A");
	$chkCn = checkdnsrr($dn, "CNAME");
	if(!$chkMx and !$chkA and !$chkCn) {
		$result = false;
	} else {
		$result = true;
	}
	return $result;
}


// Accsesor Method

function get_form_element($column) {
	return $this->form_element[$column];
}

} // end of DataView class
// }}}
?>
