/*
QVanaClock -- Vana'diel Clock for Zaurus SL-C Series.
Copyright (C) 2004 Gussan(http://sourceforge.jp/users/gsn/)

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

#include <qpe/qpeapplication.h>
#include <qrect.h>
#include <qthread.h>

#include "qvsbase.h"

#include <stdio.h>

QVSMainWindow::QVSMainWindow() : QMainWindow()
{
    setCaption("VanaClock 1.05");

    QWidget* cw = new QWidget(this, "cw");
    setCentralWidget(cw);
//    QVBoxLayout* mainbox = new QVBoxLayout(cw);

    // ׻(OBJ̥ޡȥꥬ)
    m_pTimer = new QTimer(cw);

    // Clock
    m_pClock = new QVSClock(cw);
    //  ClockľTimerˤĤʤ
    connect(m_pTimer, SIGNAL(timeout()), m_pClock, SLOT(handleRefresh()));
    
    // TAB⹽
    m_pTab = new QTabWidget(cw, "tab");
    m_pTab->setTabShape(QTabWidget::Triangular);

    // 	¬
    m_pTimerWin = new QVSTimerWindow(cw);
    m_pTab->addTab(m_pTimerWin, tr("¬"));

    // 	
    m_pShipTableFromJ = new QVSShipTimeTableFromJ(cw);
    m_pTab->addTab(m_pShipTableFromJ, tr(""));

    // 	
    m_pShipTableToJ = new QVSShipTimeTableToJ(cw);
    m_pTab->addTab(m_pShipTableToJ, tr("ƹ"));

    //  
    m_pGuild = new QVSGuild(cw);
    m_pTab->addTab(m_pGuild, tr(""));

    //TabϤΥ饹(QVSMainWindow)ΥåȤƤӽФ
    connect(m_pTimer, SIGNAL(timeout()), this, SLOT(handleRefresh()));
    m_pTimer->start(200, FALSE);

    // ScreenSaver
    m_pSaverTimer = new QTimer(cw);
    m_pSaverCtl = new QVSScreenSaverCtl(cw);
    m_pSaverCtl->setRunningObj(m_pTimerWin);
    connect(m_pSaverTimer, SIGNAL(timeout()), m_pSaverCtl, SLOT(handleSetSaver()));
    connect(m_pTimerWin, SIGNAL(statusChanged()), m_pSaverCtl, SLOT(handleSetSaver()));
    m_pSaverTimer->start(60000, FALSE);

    // 
    setFocusPolicy(QWidget::NoFocus);
    m_pTab->showPage(m_pTimerWin);
    //m_pTimerWin->setFocus();
    // ڡڤؤΥեå
    m_focusFlg = 0;
    connect(m_pTab, SIGNAL(currentChanged(QWidget *)), this, SLOT(handleTabChanged(QWidget *)));

}


// γǧФ
void QVSMainWindow::closeEvent(QCloseEvent *e)
{
  QFont font("Lcfont", 16, QFont::Bold);
  QMessageBox msgbox;
  msgbox.setFont(font);

  if(m_pTimerWin->isRunning()){
    switch(msgbox.warning( this, "Caution",
                               tr("ַ¬Ǥ\nλޤ?"),
                               "OK", "Cancel", 0,
                               1, 1 ) ){
      case 0: // Try again or Enter
        // OK(Exit)
        break;
      case 1: // Quit or Escape
        // Cancel
        e->ignore();
        return;
        break;
    }
  }

  // λ
  e->accept();
  // saver
  m_pSaverTimer->stop();
  m_pSaverCtl->setScreenSaverMode(3);
  delete m_pSaverTimer;
  m_pSaverTimer = NULL;

}

void QVSMainWindow::resizeEvent(QResizeEvent *e)
{
  //printf("Width:%d, Height:%d\n",QApplication::desktop()->width(),QApplication::desktop()->height());

//  e->accept();

  if(QApplication::desktop()->width() == 480){  // view style = 1
    m_pClock->resizeLayout(1);

    m_pClock->setGeometry(0,0,480,200);

    m_pTab->setGeometry(0,200,480,387);

    m_pShipTableFromJ->resizeLayout(1);
    m_pShipTableToJ->resizeLayout(1);

    m_pGuild->resizeLayout(1);

  }else{
    m_pClock->resizeLayout(0);                  // input style = 0

    m_pClock->setGeometry(0,0,640,125);

    m_pTab->setGeometry(0,125,640,291);

    m_pShipTableFromJ->resizeLayout(0);
    m_pShipTableToJ->resizeLayout(0);

    m_pGuild->resizeLayout(0);

  }
}

void QVSMainWindow::handleRefresh()
{
    switch(m_pTab->currentPageIndex()){
      case 0:
        m_pTimerWin->refresh();
        break;
      case 1:
        m_pShipTableFromJ->refresh();
        break;
      case 2:
        m_pShipTableToJ->refresh();
        break;
      case 3:
        m_pGuild->refresh();
        break;
    }
}

void QVSMainWindow::handleTabChanged(QWidget *widget)
{
    // ưˤ줬ưȤʤ󤫤ޤեܤʤΤǡ
    // ޻
    if(m_focusFlg){
      widget->setFocus();
    }else{
      m_focusFlg = 1;
    }
}
