/*
QVanaClock -- Vana'diel Clock for Zaurus SL-C Series.
Copyright (C) 2004 Gussan(http://sourceforge.jp/users/gsn/)

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

#include <qstring.h>
#include <qcstring.h>
#include <qlayout.h>
#include <qgrid.h>
#include <qhbox.h>
#include <qlabel.h>
#include <qfont.h>
#include <qpalette.h>
#include <qcolor.h>
#include <qrect.h>
#include <qcombobox.h>

#ifndef QVSCLOCK_H
#define QVSCLOCK_H

#include "qvsdatetime.h"

class QVSLabelWithSub : public QHBox
{
  private:
    QLabel* m_pMainStr;
    QLabel* m_pSubLStr;
    QLabel* m_pSubRStr;
  public:
    QVSLabelWithSub(QString text, QWidget* parent);
    void setPalette(QPalette palette);
    void setMainText(QString);
    void setSubLText(QString);
    void setSubRText(QString);
    void setWidth(long width);

};

class QVSClock : public QWidget
{
    Q_OBJECT

  public:
    QString TimeZoneName[10];
    long    TimeZoneOffset[10];
    int     TimeZoneDST[10];

  private:
    QLabel* m_pEarthCaption;
    QLabel* m_pEarthClockText;

    QComboBox* m_pUSTimeZone;
    QLabel* m_pEarthClockTextUS;

    QLabel* m_pVanaCaption;
    QLabel* m_pVanaClockText;
    QLabel* m_pVanaMoonText;

    QVSLabelWithSub* m_pWeekLabel[8];
    QPalette m_weekColor[8];
    QPalette m_weekColorInact;

    QLabel* m_pMoonLabel[12];
    QPalette m_moonColorAct;
    QPalette m_moonColorInact;

    QVSDateTime m_currentDT;
    long m_currentVanaDate;

    int m_resizeAccept;

    long m_curYear;//DST再計算flg
    QDateTime m_DstStartDT;
    QDateTime m_DstEndDT;

  private:
    QDateTime getDstStart(long year);
    QDateTime getDstEnd(long year);
    QString getUSDateTimeStr();

  public:
    QVSClock(QWidget* parent);
    void resizeLayout(int mode);
  public slots:
    void handleRefresh();
    void handleTZChanged(int index);

};

#endif //QVSCLOCK_H
