/*
QVanaClock -- Vana'diel Clock for Zaurus SL-C Series.
Copyright (C) 2004 Gussan(http://sourceforge.jp/users/gsn/)

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

// ܸʸɡܸEUC
#include <qwidget.h>
#include <qstring.h>
#include <qlabel.h>
#include <qpalette.h>
#include <qrect.h>
#include <qfont.h>
#include <qhbox.h>
#include <qvbox.h>
#include <qgroupbox.h>
#include <qdatetime.h>
#include "qvsdatetime.h"

#ifndef QVSGUILD_H
#define QVSGUILD_H

class QVSGuildCalc
{
  private:
    QString m_strOpenTime;
    QString m_strCloseTime;
    long m_closeDayofWeek;

    QDateTime m_currentDT;
    QDateTime m_nextStatusDT;//Statڤؤ
    QDateTime m_prevStatusDT;//Statڤؤ
    QDateTime m_RemainDT;//Open/CloseĻֻѡƱ
    int  m_status;
    long m_remainSec;

  public:
    QVSGuildCalc(QString& open_time, QString& close_time, int close_week);
    int setCurrentDateTime(QDateTime& curDT);
    long getRemainSec(){return m_remainSec;};
    int getStatus(){return m_status;};

};

class QVSGuildItem:public QWidget
{
  public:
    static QPalette weekColor[8];
    static QString weekName[8];

  private:
    QVSGuildCalc* m_pCalc;
    QVBox*  m_pNameBox;
    QLabel* m_pName;
    QLabel* m_pStatus;
    QLabel* m_pLocation;
    QHBox*  m_pOpenTimeBox;
    QLabel* m_pOpenTimeCaption;
    QLabel* m_pOpenTime;
    QHBox*  m_pCloseWeekBox;
    QLabel* m_pCloseWeekCaption;
    QLabel* m_pCloseWeek;
    QHBox*  m_pStatusBox;
    QLabel* m_pRemainCaption;
    QLabel* m_pRemainTime;

  public:
    QVSGuildItem(QString guild_name,
                 QString location,
                 QString start_time,
                 QString end_time,
                 int      close_dayofweek,
                 QWidget* parent);
    void refresh(QDateTime& curDT);
    void resizeLayout(int mode);

};

class QVSGuild:public QWidget
{
  private:
    QVSGuildItem* m_pGuildItem[10];

  public:
    QVSGuild(QWidget* parent);
    void refresh();
    void resizeLayout(int mode);

};

#endif //QVSGUILD_H

