/*
 * Decompiled with CFR 0.152.
 */
package com.rapide_act;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.sql.Clob;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import org.apache.commons.codec.binary.Base64;

public class CmnUtils {
    public static char[] hexArray = "0123456789ABCDEF".toCharArray();

    public static void writeCsv(String string, int n, ArrayList<String> arrayList) throws Exception {
        PrintWriter printWriter = null;
        CmnUtils.debugPrint("Start write csv,columnCount=" + n);
        printWriter = new PrintWriter(new BufferedWriter(new FileWriter(new File(string))));
        for (int i = 0; i < arrayList.size(); ++i) {
            printWriter.print(arrayList.get(i).replaceAll("\n", "\r\n"));
            if (n == 1) {
                printWriter.println("");
                continue;
            }
            if ((i + 1) % n == 0 && i > 0) {
                printWriter.println("");
                continue;
            }
            printWriter.print(",");
        }
        printWriter.close();
        CmnUtils.debugPrint("End write csv");
    }

    public static void printConsole(int n, ArrayList<String> arrayList) throws Exception {
        CmnUtils.debugPrint("Start console print");
        for (int i = 0; i < arrayList.size(); ++i) {
            System.out.print(arrayList.get(i).replaceAll("\n", "\r\n"));
            if (n == 1) {
                System.out.println("");
                continue;
            }
            if ((i + 1) % n == 0 && i > 0) {
                System.out.println("");
                continue;
            }
            System.out.print(",");
        }
        CmnUtils.debugPrint("End console print");
    }

    public static void debugPrint(String string) throws Exception {
        if (System.getProperty("debug") != null) {
            System.out.println(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS").format(new Date()) + " [DEBUG] " + string);
        }
    }

    public static void debugPrinting(String string) throws Exception {
        if (System.getProperty("debug") != null) {
            System.out.print(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS").format(new Date()) + " [DEBUG] " + string);
        }
    }

    public static void infoPrint(String string) throws Exception {
        System.out.println(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS").format(new Date()) + " [INFO] " + string);
    }

    public static void infoPrinting(String string) throws Exception {
        System.out.print(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS").format(new Date()) + " [INFO] " + string);
    }

    public static void errorPrint(String string) throws Exception {
        System.out.println(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS").format(new Date()) + " [ERROR] " + string);
    }

    public static String getTimestamp() throws Exception {
        return new SimpleDateFormat("yyyyMMddHHmmssSSS").format(new Date());
    }

    public static String getYmdhm() throws Exception {
        return new SimpleDateFormat("yyyyMMddHHmm").format(new Date());
    }

    public static int getArrayRowNo(ArrayList<String> arrayList, int n, int n2, String string) throws Exception {
        int n3 = -1;
        for (int i = 0; i < arrayList.size() / n; ++i) {
            if (!arrayList.get(i * n + n2).equals(string)) continue;
            n3 = i;
            break;
        }
        return n3;
    }

    public static String[] getArrayRowData(ArrayList<String> arrayList, int n, int n2) throws Exception {
        String[] stringArray = new String[n];
        int n3 = 0;
        for (int i = n2 * n; i < n2 * n + n; ++i) {
            stringArray[n3] = arrayList.get(i);
            ++n3;
        }
        return stringArray;
    }

    public static String[] splitCsv(String string) throws Exception {
        return CmnUtils.split(string, ",");
    }

    public static String[] splitSpace(String string) throws Exception {
        return CmnUtils.split(string, " ");
    }

    public static String[] splitDot(String string) throws Exception {
        return CmnUtils.split(string, "\\.");
    }

    public static String[] splitCrLf(String string) throws Exception {
        return CmnUtils.split(string, "\r\n");
    }

    public static String[] splitSlash(String string) throws Exception {
        return CmnUtils.split(string, "/");
    }

    public static String[] splitTab(String string) throws Exception {
        return CmnUtils.split(string, "\t");
    }

    public static String[] split(String string, String string2) throws Exception {
        String[] stringArray = string.split(string2, -1);
        return stringArray;
    }

    public static boolean isLastCrLf(String string) throws Exception {
        boolean bl = false;
        char[] cArray = string.toCharArray();
        if (string.length() > 1 && cArray[string.length() - 2] != '\r' && cArray[string.length() - 1] != '\n') {
            bl = true;
        }
        return bl;
    }

    public static String bytesToHex(byte[] byArray) {
        char[] cArray = new char[byArray.length * 2];
        for (int i = 0; i < byArray.length; ++i) {
            int n = byArray[i] & 0xFF;
            cArray[i * 2] = hexArray[n >>> 4];
            cArray[i * 2 + 1] = hexArray[n & 0xF];
        }
        return new String(cArray);
    }

    public static byte[] hexToBytes(String string) {
        byte[] byArray = new byte[string.length() / 2];
        for (int i = 0; i < string.length() / 2; ++i) {
            byArray[i] = (byte)Integer.parseInt(string.substring(i * 2, (i + 1) * 2), 16);
        }
        return byArray;
    }

    public static String bytesToBase64(byte[] byArray) {
        return new String(Base64.encodeBase64((byte[])byArray));
    }

    public static byte[] base64ToBytes(String string) {
        return Base64.decodeBase64((byte[])string.getBytes());
    }

    public static String clobToString(Clob clob) throws Exception {
        return clob.getSubString(1L, (int)clob.length());
    }

    public static String getLineSeparator() {
        return System.getProperty("line.separator");
    }

    public static boolean isMatch(String[] stringArray, String string) throws Exception {
        boolean bl = false;
        Object var3_3 = null;
        Object var4_4 = null;
        if (stringArray != null && stringArray.length > 0) {
            for (int i = 0; i < stringArray.length; ++i) {
                String string2 = stringArray[i].replace("*", ".*");
                if (!string.matches(string2)) continue;
                bl = true;
                break;
            }
        }
        return bl;
    }

    public static String getYesNo(boolean bl) {
        String string = bl ? "Yes" : "No";
        return string;
    }

    public static boolean isMatch(String[] stringArray, String string, String string2) throws Exception {
        boolean bl = false;
        Object var4_4 = null;
        Object var5_5 = null;
        if (stringArray != null && stringArray.length > 0) {
            for (int i = 0; i < stringArray.length; ++i) {
                String string3 = null;
                String[] stringArray2 = CmnUtils.splitDot(stringArray[i]);
                if (stringArray2.length == 1) {
                    string3 = stringArray[i].replace("*", ".*");
                    if (!string2.matches(string3)) continue;
                    bl = true;
                    break;
                }
                if (stringArray2.length != 2 || !string.matches(stringArray2[0].replace("*", ".*")) || !string2.matches(stringArray2[1].replace("*", ".*"))) continue;
                bl = true;
                break;
            }
        }
        return bl;
    }

    public static boolean isJapanese(String string) throws Exception {
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            Character.UnicodeBlock unicodeBlock = Character.UnicodeBlock.of(c);
            if (Character.UnicodeBlock.HIRAGANA.equals(unicodeBlock)) {
                return true;
            }
            if (Character.UnicodeBlock.KATAKANA.equals(unicodeBlock)) {
                return true;
            }
            if (Character.UnicodeBlock.HALFWIDTH_AND_FULLWIDTH_FORMS.equals(unicodeBlock)) {
                return true;
            }
            if (Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS.equals(unicodeBlock)) {
                return true;
            }
            if (!Character.UnicodeBlock.CJK_SYMBOLS_AND_PUNCTUATION.equals(unicodeBlock)) continue;
            return true;
        }
        return false;
    }

    public static boolean isHankaku(char c) throws Exception {
        return c <= '~' || c == '\u00a5' || c == '\u203e' || c >= '\uff61' && c <= '\uff9f';
    }

    public static boolean isColString(String string) throws Exception {
        return string.toUpperCase().equals("XML") || string.toUpperCase().equals("UNIQUEIDENTIFIER") || string.toUpperCase().equals("TEXT") || string.toUpperCase().equals("NTEXT") || string.toUpperCase().equals("CHAR") || string.toUpperCase().equals("NCHAR") || string.toUpperCase().equals("VARCHAR") || string.toUpperCase().equals("VARCHAR2") || string.toUpperCase().equals("NVARCHAR") || string.toUpperCase().equals("NVARCHAR2") || string.toUpperCase().equals("MVARCHAR") || string.toUpperCase().equals("BIGINT") || string.toUpperCase().equals("LONG");
    }

    public static boolean isColDate(String string) throws Exception {
        return string.toUpperCase().equals("DATE");
    }

    public static boolean isColTime(String string) throws Exception {
        return string.toUpperCase().equals("TIME");
    }

    public static boolean isColTimestamp(String string) throws Exception {
        return string.toUpperCase().equals("TIMESTAMP") || string.toUpperCase().equals("SMALLDATETIME") || string.toUpperCase().equals("DATETIME") || string.toUpperCase().equals("DATETIME2");
    }

    public static boolean isColBigDecimal(String string) throws Exception {
        return string.toUpperCase().equals("NUMERIC") || string.toUpperCase().equals("NUMBER") || string.toUpperCase().equals("MONEY") || string.toUpperCase().equals("SMALLMONEY") || string.toUpperCase().equals("DECIMAL");
    }

    public static boolean isColShort(String string) throws Exception {
        return string.toUpperCase().equals("TINYINT") || string.toUpperCase().equals("SMALLINT");
    }

    public static boolean isColInt(String string) throws Exception {
        return string.toUpperCase().equals("INTEGER") || string.toUpperCase().equals("INT");
    }

    public static boolean isColFloat(String string) throws Exception {
        return string.toUpperCase().equals("REAL") || string.toUpperCase().equals("SMALLFLT");
    }

    public static boolean isColDouble(String string) throws Exception {
        return string.toUpperCase().equals("FLOAT") || string.toUpperCase().equals("DOUBLE PRECISION");
    }

    public static boolean isColBytes(String string) throws Exception {
        return string.toUpperCase().equals("RAW") || string.toUpperCase().equals("BINARY");
    }

    public static boolean isColBlob(String string) throws Exception {
        return string.toUpperCase().equals("BLOB") || string.toUpperCase().equals("VARBINARY") || string.toUpperCase().equals("UDT") || string.toUpperCase().equals("IMAGE");
    }

    public static boolean isColClob(String string) throws Exception {
        return string.toUpperCase().equals("CLOB") || string.toUpperCase().equals("NCLOB");
    }

    public static boolean isLob(String string) throws Exception {
        return CmnUtils.isColClob(string) || CmnUtils.isColBlob(string);
    }

    public static boolean isEmpty(String string) throws Exception {
        return string == null || string.equals("");
    }

    public static boolean isNumeric(String string) {
        boolean bl = true;
        try {
            int n = Integer.parseInt(string);
        }
        catch (Exception exception) {
            bl = false;
        }
        return bl;
    }

    public static String[] getSystemProperty(String string) throws Exception {
        String[] stringArray = null;
        if (System.getProperty(string) != null) {
            stringArray = CmnUtils.splitCsv(System.getProperty(string).toUpperCase());
        }
        return stringArray;
    }

    public static String getSystemProperty(String string, String string2) throws Exception {
        String string3 = string2;
        if (System.getProperty(string) != null) {
            string3 = System.getProperty(string).toUpperCase();
        }
        return string3;
    }

    public static char getSystemProperty(String string, char c) throws Exception {
        char c2 = c;
        if (System.getProperty(string) != null) {
            c2 = System.getProperty(string).toUpperCase().charAt(0);
        }
        return c2;
    }

    public static boolean getSystemProperty(String string, boolean bl) throws Exception {
        boolean bl2 = bl;
        if (System.getProperty(string) != null) {
            bl2 = System.getProperty(string).toUpperCase().equals("Y") ? true : !System.getProperty(string).toUpperCase().equals("N");
        }
        return bl2;
    }

    public static String getSeparator(String string, String string2) throws Exception {
        String string3 = string2;
        if (System.getProperty(string) != null) {
            String string4 = System.getProperty(string);
            char[] cArray = new char[string4.length()];
            int n = 0;
            for (int i = 0; i < string4.length(); ++i) {
                if (i < string4.length() - 1) {
                    if (string4.charAt(i) == '\\') {
                        switch (string4.charAt(i + 1)) {
                            case 't': {
                                cArray[n] = 9;
                                ++i;
                                ++n;
                                break;
                            }
                            default: {
                                cArray[n] = string4.charAt(i);
                                ++n;
                                break;
                            }
                        }
                        continue;
                    }
                    cArray[n] = string4.charAt(i);
                    ++n;
                    continue;
                }
                cArray[n] = string4.charAt(i);
                ++n;
            }
            char[] cArray2 = new char[n];
            for (int i = 0; i < n; ++i) {
                cArray2[i] = cArray[i];
            }
            string3 = String.valueOf(cArray2);
        }
        return string3;
    }

    public static String getDelimiter(String string) throws Exception {
        String string2 = string;
        if (string != null) {
            char[] cArray = new char[string.length()];
            int n = 0;
            for (int i = 0; i < string.length(); ++i) {
                if (i < string.length() - 1) {
                    if (string.charAt(i) == '\\') {
                        switch (string.charAt(i + 1)) {
                            case 't': {
                                cArray[n] = 9;
                                ++i;
                                ++n;
                                break;
                            }
                            default: {
                                cArray[n] = string.charAt(i);
                                ++n;
                                break;
                            }
                        }
                        continue;
                    }
                    cArray[n] = string.charAt(i);
                    ++n;
                    continue;
                }
                cArray[n] = string.charAt(i);
                ++n;
            }
            char[] cArray2 = new char[n];
            for (int i = 0; i < n; ++i) {
                cArray2[i] = cArray[i];
            }
            string2 = String.valueOf(cArray2);
        }
        return string2;
    }

    public static String getLineSeparator(String string, String string2) throws Exception {
        String string3 = string2;
        if (System.getProperty(string) != null) {
            String string4 = System.getProperty(string);
            char[] cArray = new char[string4.length()];
            int n = 0;
            block4: for (int i = 0; i < string4.length(); ++i) {
                if (i >= string4.length() - 1 || string4.charAt(i) != '\\') continue;
                switch (string4.charAt(i + 1)) {
                    case 'r': {
                        cArray[n] = 13;
                        ++i;
                        ++n;
                        continue block4;
                    }
                    case 'n': {
                        cArray[n] = 10;
                        ++i;
                        ++n;
                    }
                }
            }
            char[] cArray2 = new char[n];
            for (int i = 0; i < n; ++i) {
                cArray2[i] = cArray[i];
            }
            string3 = String.valueOf(cArray2);
        }
        return string3;
    }

    public static String getLineSeparator(String string) throws Exception {
        String string2 = string;
        if (string != null) {
            char[] cArray = new char[string.length()];
            int n = 0;
            block4: for (int i = 0; i < string.length(); ++i) {
                if (i >= string.length() - 1 || string.charAt(i) != '\\') continue;
                switch (string.charAt(i + 1)) {
                    case 'r': {
                        cArray[n] = 13;
                        ++i;
                        ++n;
                        continue block4;
                    }
                    case 'n': {
                        cArray[n] = 10;
                        ++i;
                        ++n;
                    }
                }
            }
            char[] cArray2 = new char[n];
            for (int i = 0; i < n; ++i) {
                cArray2[i] = cArray[i];
            }
            string2 = String.valueOf(cArray2);
        }
        return string2;
    }
}

