package com.rapide_act;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.IOException;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.io.PrintWriter;
import java.util.Date;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Properties;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.math.BigDecimal;

public class CmnProps{
	protected String database = null;
	protected static final int DB_TYPE_ORACLE = 0;
	protected static final int DB_TYPE_SQLSERVER = 1;
	protected static final int DB_TYPE_MYSQL = 2;
	protected static final int DB_TYPE_DB2 = 3;
	protected static final int DB_TYPE_POSTGRESQL = 4;
	protected static final int DB_TYPE_HIRDB = 5;
	protected static final int DB_TYPE_UNKNOWN = -1;
	protected static final String [] DB_TYPE_NAME = {"ORACLE", "SQLSERVER", "MYSQL", "DB2", "POSTGRESQL", "HIRDB"};
	protected static final String [] DB_SQL_QUOTEDS = {"\"", "[", "`", "\"", "\"", "\""};
	protected static final String [] DB_SQL_QUOTEDE = {"\"", "]", "`", "\"", "\"", "\""};
	protected static final String [] SQL_TERMINATOR = {";",  System.getProperty("line.separator") + "GO", ";", ";", ";", ";"};
	protected static final String [] SQL_PREFIX = {"@", ":r ", "", "", "", ""};
	protected static final int MASK_PTN_ALL = 0;
	protected static final int MASK_PTN_ALT = 1;
	protected static final int MASK_PTN_EDGE = 2;
	protected static final int D_USER = 0;
	protected static final int D_PASS = 1;
	protected static final int D_URL = 2;
	protected static final int D_DRIVER = 3;
	protected static final int D_OUTPUT = 4;
	protected static final int D_INPUT = 5;
	protected static final int D_LINESEP = 6;
	protected static final int D_INLINESEP = 7;
	protected static final int D_FILENCODE = 8;
	protected static final int D_NULLMARK = 9;
	protected static final int D_DELIMITER = 10;
	protected static final int D_TBLSQL = 11;
	protected static final int D_TBLKEYSQL = 12;
	protected static final int D_ORDER = 13;
	protected static final int D_QUOTATION = 14;
	protected static final int D_BATCOUNT = 15;
	protected static final int D_INCLTAB = 16;
	protected static final int D_EXCLTAB = 17;
	protected static final int D_INCLCOL = 18;
	protected static final int D_EXCLCOL = 19;
	protected static final int D_INCLCOLMASK = 20;
	protected static final int D_EXCLCOLMASK = 21;
	protected static final int D_SBYTEMASKCHR = 22;
	protected static final int D_DBYTEMASKCHR = 23;
	protected static final int D_MASKPTN = 24;
	protected static final int D_PROPFILE = 25;
	protected static final int D_SPCPADDING = 26;
	protected static final int D_FILEEXT = 27;
	protected static final int D_SQLQUOTEDS = 28;
	protected static final int D_SQLQUOTEDE = 29;
	protected static final int D_PHYSICAL = 30;
	protected static final int D_DROP = 31;
	protected static final int KEYS = 32;
	protected static final String [] PROP_KEY = { "us","pw","url","dr","out","in","ls","ils","fe","nm",
												  "dm","ts","tks","od","qt","bc","it","et","ic","ec",
												  "icm","ecm","smc","dmc","mp","pf","sp","ext","sqs","sqe",
												  "ph", "dp"};

	protected String [] prop_val = new String[KEYS];
	protected static final String [] MASK_PTN = {"ALL", "ALT", "EDGE"};
	protected static final String DEFAULT_IN_FOLDER = "input";
	protected static final String DEFAULT_OUT_FOLDER = "output";
	protected static final String DEFAULT_PROP_FILE = "RapideAct.properties";

	protected static final int CREATE_TABLE = 0;
	protected static final int DROP_TABLE = 1;
	protected static final int TRUNCATE_TABLE = 2;
	protected static final int CREATE_PKEY = 3;
	protected static final int DROP_PKEY = 4;
	protected static final int CREATE_UKEY = 5;
	protected static final int DROP_UKEY = 6;
	protected static final int CREATE_INDEX = 7;
	protected static final int DROP_INDEX = 8;
	protected static final int CREATE_VIEW = 9;
	protected static final int DROP_VIEW = 10;
	protected static final int CREATE_PROCEDURE = 11;
	protected static final int DROP_PROCEDURE = 12;
	protected static final int CREATE_SYNONYM = 13;
	protected static final int DROP_SYNONYM = 14;
	protected static final int CREATE_SEQUENCE = 15;
	protected static final int DROP_SEQUENCE = 16;
	protected static final int CREATE_FK = 17;
	protected static final int DROP_FK = 18;
	
	protected static final String [] SQL_FILE_NAME = {
		"createTable.sql",
		"dropTable.sql",
		"truncateTable.sql",
		"createPrimaryKey.sql",
		"dropPrimaryKey.sql",
		"createUniqueKey.sql",
		"dropUniqueKey.sql",
		"createIndex.sql",
		"dropIndex.sql",
		"createView.sql",
		"dropView.sql",
		"createProcedure.sql",
		"dropProcedure.sql",
		"createSynonym.sql",
		"dropSynonym.sql",
		"createSequence.sql",
		"dropSequence.sql",
		"createFk.sql",
		"dropFk.sql"
	};
	
	protected static final String [] T_SQL_ARRAY = {
		"select "
		+ " table_name "
		+ " from user_tables "
		+ " order by table_name",
		"select "
		+ " name as table_name "
		+ " from sys.tables "
		+ " order by name",
		"select "
		+ " table_name "
		+ " from information_schema.tables "
		+ " where table_type = 'BASE TABLE' and table_schema = database() "
		+ " order by table_name",
		"select "
		+ " tabname "
		+ " from syscat.tables "
		+ " where tabschema = current_schema and ownertype = 'U' and type = 'T' "
		+ " order by tabname",
		"select "
		+ " table_name "
		+ " from information_schema.tables "
		+ " where table_type = 'BASE TABLE' and table_schema = current_schema() "
		+ " order by table_name",
		"select "
		+ " table_name "
		+ " from master.sql_tables "
		+ " where table_type = 'BASE TABLE' and table_schema=current_user "
		+ " order by table_name"
	};
	protected static final String [] TK_SQL_ARRAY = {
		"select "
		+ "a.table_name,"
		+ "d.column_name "
		+ " from user_tables a,"
		+ " (select b.table_name, "
		+ "   c.column_name, "
		+ "   c.position "
		+ "  from user_constraints b, "
		+ "       user_cons_columns c "
		+ "  where b.constraint_type = 'P' and "
		+ "        b.table_name = c.table_name and "
		+ "        b.constraint_name = c.constraint_name "
		+ "  ) d "
		+ "where a.table_name = d.table_name(+) "
		+ "order by a.table_name, d.position",
		"select "
		+ " a.name as table_name, "
		+ " d.name as col_name "
		+ "from sys.tables as a "
		+ "left outer join sys.key_constraints as b "
		+ "on a.object_id = b.parent_object_id "
		+ " and b.type = 'PK' "
		+ "left outer join sys.index_columns as c "
		+ "on b.parent_object_id = c.object_id "
		+ " and b.unique_index_id = c.index_id "
		+ "left outer join sys.columns as d "
		+ "on c.object_id = d.object_id "
		+ " and c.column_id = d.column_id "
		+ "order by a.name,c.key_ordinal",
		"select "
		+ " a.table_name, "
		+ " b.column_name "
		+ " from "
		+ " ( "
		+ " select "
		+ " table_schema, "
		+ " table_name "
		+ " from "
		+ " information_schema.tables "
		+ " where table_type = 'BASE TABLE' and table_schema = database()"
		+ " ) a "
		+ " left outer join information_schema.key_column_usage b "
		+ " on a.table_schema = b.table_schema "
		+ "  and a.table_name = b.table_name "
		+ "  and b.constraint_name = 'PRIMARY' "
		+ " order by "
		+ "  a.table_name,b.ordinal_position",
		"select"
		+ " a.tabname,"
		+ " b.colname"
		+ " from"
		+ " ("
		+ "  select"
		+ "    tabschema,"
		+ "    tabname "
		+ "  from"
		+ "    syscat.tables"
		+ "  where"
		+ "    tabschema = current_schema"
		+ "    and ownertype = 'U'"
		+ "    and type = 'T'"
		+ "  ) a"
		+ "  left outer join "
		+ "  ("
		+ "  select"
		+ "    c.tabschema,"
		+ "    c.tabname,"
		+ "    c.colname,"
		+ "    c.colseq"
		+ "  from"
		+ "    syscat.keycoluse c,"
		+ "    syscat.tabconst d"
		+ "  where"
		+ "    c.tabschema = current_schema"
		+ "    and c.tabschema = d.tabschema"
		+ "    and c.constname = d.constname"
		+ "    and d.type = 'P'"
		+ "  group by c.tabschema,c.tabname,c.colname,c.colseq"
		+ "  ) b "
		+ " on a.tabschema = b.tabschema and a.tabname = b.tabname"
		+ " order by a.tabname,b.colseq",
		"select "
		+ " a.table_name, "
		+ " b.column_name "
		+ " from "
		+ " ( "
		+ " select "
		+ " table_schema, "
		+ " table_name "
		+ " from "
		+ " information_schema.tables a"
		+ " where table_type = 'BASE TABLE' and table_schema = current_schema()"
		+ " ) a "
		+ " left outer join "
		+ " ("
		+ "	select"
		+ "		b1.table_schema,"
		+ "		b1.table_name,"
		+ "		b2.column_name,"
		+ "		b2.ordinal_position"
		+ "	from"
		+ "		information_schema.table_constraints b1,"
		+ "		information_schema.key_column_usage b2"
		+ "	where"
		+ "	    b1.table_schema = current_schema() and"
		+ "		b1.table_catalog = current_database() and"
		+ "		b1.constraint_type = 'PRIMARY KEY' and"
		+ "		b1.table_catalog = b2.table_catalog and"
		+ "		b1.table_schema = b2.table_schema and"
		+ "		b1.table_name = b2.table_name and"
		+ "		b1.constraint_name = b2.constraint_name"
		+ " ) b"
		+ " on a.table_schema = b.table_schema "
		+ "  and a.table_name = b.table_name "
		+ " order by "
		+ "  a.table_name,b.ordinal_position",
		"select"
		+ " a.table_name, "
		+ " b.column_name "
		+ "from "
		+ "( "
		+ "select "
		+ " a1.table_name "
		+ "from "
		+ " master.sql_tables a1 "
		+ "where "
		+ " a1.table_schema=current_user and "
		+ " a1.table_type='BASE TABLE' "
		+ ") a "
		+ "left outer join "
		+ "( "
		+ "select "
		+ " c.table_name, "
		+ " d.column_name, "
		+ " d.column_id "
		+ "from "
		+ " master.sql_tables c, "
		+ " master.sql_columns d "
		+ "where "
		+ " c.table_schema=current_user and "
		+ " c.table_type='BASE TABLE' and "
		+ " c.table_schema=d.table_schema and "
		+ " c.table_name=d.table_name and "
		+ " d.cluster_key = 'Y' "
		+ "group by "
		+ " c.table_name, "
		+ " d.column_name, "
		+ " d.column_id "
		+ ") b "
		+ "on "
		+ " a.table_name=b.table_name "
		+ "order by "
		+ " a.table_name, "
		+ " b.column_id"
	};
	
	protected String user 					= null;
	protected String pass 					= null;
	protected String url 					= null;
	protected String driver 				= null;
	protected String outFolder 				= null;
	protected String inFolder 				= null;
	protected String lineSeparator 			= System.getProperty("line.separator");
	protected String inColLineSeparator 	= System.getProperty("line.separator");
	protected String fileEncoding 			= System.getProperty("file.encoding");
	protected String nullMark 				= "";
	protected String delimiter 				= "\t";
	protected String fileExtension			= "tsv";
	protected boolean isSpcPadding 			= false;
	protected String sqlQuotedS				= null;
	protected String sqlQuotedE				= null;
	protected String tSql 					= null;
	protected String tkSql 					= null;
	protected boolean isOrder 				= false;
	protected boolean isQuotation 			= true;
	protected boolean isPhysical 			= false;
	protected boolean isDrop 				= false;
	protected int batchCount 				= 1000;
	protected String inclTables 			= null;
	protected String exclTables 			= null;
	protected String inclCols 				= null;
	protected String exclCols 				= null;
	protected String inclColsMask 			= null;
	protected String exclColsMask 			= null;
	protected char singleByteMaskChar		= '*';
	protected char doubleByteMaskChar 		= '\u25A0';
	protected String maskPattern 			= "ALT";

	protected String [] inclTablesArray 	= null;
	protected String [] exclTablesArray 	= null;
	protected String [] inclColsArray 		= null;
	protected String [] exclColsArray 		= null;
	protected String [] inclColsMaskArray 	= null;
	protected String [] exclColsMaskArray 	= null;
	protected boolean isInclTables 			= false;
	protected boolean isExclTables 			= false;
	protected boolean isInclCols 			= false;
	protected boolean isExclCols 			= false;
	protected boolean isMask 				= false;
	protected boolean isInclColsMask 		= false;
	protected boolean isExclColsMask 		= false;
	protected int dbType 					= DB_TYPE_UNKNOWN;

	protected void getProperties(String _propFile) throws Exception{
		BufferedReader br = null;
		Properties prop = null;
		try {
			prop = new Properties();
			br = new BufferedReader(new InputStreamReader(CmnProps.class.getClassLoader().getResourceAsStream(_propFile), "UTF-8"));
			prop.load(br);
			for(int i=0;i<KEYS;i++){
				prop_val[i] = prop.getProperty(database + "." +PROP_KEY[i]);
			}
			br.close();
			br = null;
		} catch (NullPointerException e) {
				throw new Exception("vpeBt@C܂B[" + _propFile +"]");
		} catch (IOException e) {
				throw e;
		}
		finally{
			try {
				if (br != null) {
					br.close();
					br = null;
				}
			} 
			catch (IOException e) {
				throw e;
			}
		}		
	}


	CmnProps() {
		super();
	}

	protected void setProperty(String _database) throws Exception{
		database = _database;
		if(database != null){
			if(!CmnUtils.isEmpty(prop_val[D_PROPFILE])){
				getProperties(System.getProperty(prop_val[D_PROPFILE]));
			} else {
				getProperties(DEFAULT_PROP_FILE);
			}
		}
		
		for(int i=0;i<KEYS;i++){
			if(System.getProperty(PROP_KEY[i])!=null)prop_val[i] = System.getProperty(PROP_KEY[i]);
			CmnUtils.debugPrint(PROP_KEY[i] + "=" + prop_val[i]);
		}
		
		if(!CmnUtils.isEmpty(prop_val[D_USER]))user = prop_val[D_USER];
		if(!CmnUtils.isEmpty(prop_val[D_PASS]))pass = prop_val[D_PASS];
		if(!CmnUtils.isEmpty(prop_val[D_URL]))url = prop_val[D_URL];
		if(!CmnUtils.isEmpty(prop_val[D_DRIVER]))driver = prop_val[D_DRIVER];
		if(!CmnUtils.isEmpty(prop_val[D_OUTPUT]))outFolder = prop_val[D_OUTPUT];
		if(!CmnUtils.isEmpty(prop_val[D_INPUT]))inFolder = prop_val[D_INPUT];
		if(!CmnUtils.isEmpty(prop_val[D_LINESEP]))lineSeparator = CmnUtils.getLineSeparator(prop_val[D_LINESEP]);
		if(!CmnUtils.isEmpty(prop_val[D_INLINESEP]))inColLineSeparator = CmnUtils.getLineSeparator(prop_val[D_INLINESEP]);
		if(!CmnUtils.isEmpty(prop_val[D_FILENCODE]))fileEncoding = prop_val[D_FILENCODE];
		if(!CmnUtils.isEmpty(prop_val[D_NULLMARK]))nullMark = prop_val[D_NULLMARK];
		if(!CmnUtils.isEmpty(prop_val[D_DELIMITER]))delimiter = CmnUtils.getDelimiter(prop_val[D_DELIMITER]);
		if(!CmnUtils.isEmpty(prop_val[D_TBLSQL]))tSql = prop_val[D_TBLSQL];
		if(!CmnUtils.isEmpty(prop_val[D_TBLKEYSQL]))tkSql = prop_val[D_TBLKEYSQL];
		if(!CmnUtils.isEmpty(prop_val[D_ORDER]) && prop_val[D_ORDER].toUpperCase().equals("Y"))isOrder = true;
		if(!CmnUtils.isEmpty(prop_val[D_QUOTATION]) && prop_val[D_QUOTATION].toUpperCase().equals("N"))isQuotation = false;
		if(!CmnUtils.isEmpty(prop_val[D_PHYSICAL]) && prop_val[D_PHYSICAL].toUpperCase().equals("Y"))isPhysical = true;
		if(!CmnUtils.isEmpty(prop_val[D_DROP]) && prop_val[D_DROP].toUpperCase().equals("Y"))isDrop = true;
		if(!CmnUtils.isEmpty(prop_val[D_BATCOUNT]) && CmnUtils.isNumeric(prop_val[D_BATCOUNT]))batchCount = Integer.parseInt(prop_val[D_BATCOUNT]);
		if(!CmnUtils.isEmpty(prop_val[D_INCLTAB]))isInclTables = true;
		if(!CmnUtils.isEmpty(prop_val[D_EXCLTAB]))isExclTables = true;
		if(!CmnUtils.isEmpty(prop_val[D_INCLCOL]))isInclCols = true;
		if(!CmnUtils.isEmpty(prop_val[D_EXCLCOL]))isExclCols = true;
		if(!CmnUtils.isEmpty(prop_val[D_INCLCOLMASK]))isInclColsMask = true;
		if(!CmnUtils.isEmpty(prop_val[D_EXCLCOLMASK]))isExclColsMask = true;
		if(isInclColsMask || isExclColsMask)isMask = true;
		if(!CmnUtils.isEmpty(prop_val[D_INCLTAB]))inclTables = prop_val[D_INCLTAB].toUpperCase();
		if(!CmnUtils.isEmpty(prop_val[D_EXCLTAB]))exclTables = prop_val[D_EXCLTAB].toUpperCase();
		if(!CmnUtils.isEmpty(prop_val[D_INCLCOL]))inclCols = prop_val[D_INCLCOL].toUpperCase();
		if(!CmnUtils.isEmpty(prop_val[D_EXCLCOL]))exclCols = prop_val[D_EXCLCOL].toUpperCase();
		if(!CmnUtils.isEmpty(prop_val[D_INCLCOLMASK]))inclColsMask = prop_val[D_INCLCOLMASK].toUpperCase();
		if(!CmnUtils.isEmpty(prop_val[D_EXCLCOLMASK]))exclColsMask = prop_val[D_EXCLCOLMASK].toUpperCase();
		if(!CmnUtils.isEmpty(prop_val[D_INCLTAB]))inclTablesArray = CmnUtils.splitCsv(prop_val[D_INCLTAB].toUpperCase());
		if(!CmnUtils.isEmpty(prop_val[D_EXCLTAB]))exclTablesArray = CmnUtils.splitCsv(prop_val[D_EXCLTAB].toUpperCase());
		if(!CmnUtils.isEmpty(prop_val[D_INCLCOL]))inclColsArray = CmnUtils.splitCsv(prop_val[D_INCLCOL].toUpperCase());
		if(!CmnUtils.isEmpty(prop_val[D_EXCLCOL]))exclColsArray = CmnUtils.splitCsv(prop_val[D_EXCLCOL].toUpperCase());
		if(!CmnUtils.isEmpty(prop_val[D_INCLCOLMASK]))inclColsMaskArray = CmnUtils.splitCsv(prop_val[D_INCLCOLMASK].toUpperCase());
		if(!CmnUtils.isEmpty(prop_val[D_EXCLCOLMASK]))exclColsMaskArray = CmnUtils.splitCsv(prop_val[D_EXCLCOLMASK].toUpperCase());
		if(!CmnUtils.isEmpty(prop_val[D_SBYTEMASKCHR]))singleByteMaskChar = prop_val[D_SBYTEMASKCHR].charAt(0);
		if(!CmnUtils.isEmpty(prop_val[D_DBYTEMASKCHR]))doubleByteMaskChar = prop_val[D_DBYTEMASKCHR].charAt(0);
		if(!CmnUtils.isEmpty(prop_val[D_MASKPTN]))maskPattern = prop_val[D_MASKPTN];
		if(!CmnUtils.isEmpty(prop_val[D_SPCPADDING]) && prop_val[D_SPCPADDING].toUpperCase().equals("Y"))isSpcPadding = true;
		if(!CmnUtils.isEmpty(prop_val[D_FILEEXT]))fileExtension = prop_val[D_FILEEXT];

		if(CmnUtils.isEmpty(user)){
			throw new Exception("us([UID)włB");
		} else if (CmnUtils.isEmpty(pass)){
			throw new Exception("pw(pX[h)włB");
		} else if (CmnUtils.isEmpty(url)){
			throw new Exception("url(ڑ)włB");
		} else if (CmnUtils.isEmpty(driver)){
			throw new Exception("dr(hCo)włB");
		}
		
		for(int i = 0;i<DB_TYPE_NAME.length;i++){
			if (url.toUpperCase().contains(DB_TYPE_NAME[i])){
				dbType = i;
				break;
			}
		}
		
		if (dbType != DB_TYPE_UNKNOWN){
			if(!CmnUtils.isEmpty(prop_val[D_TBLSQL])){
				tSql = prop_val[D_TBLSQL];
			} else {
				tSql = T_SQL_ARRAY[dbType];
			}
			if(!CmnUtils.isEmpty(prop_val[D_TBLKEYSQL])){
				tkSql = prop_val[D_TBLKEYSQL];
			} else {
				tkSql = TK_SQL_ARRAY[dbType];
			}
			if(!CmnUtils.isEmpty(prop_val[D_SQLQUOTEDS])){
				sqlQuotedS = prop_val[D_SQLQUOTEDS];
			} else {
				sqlQuotedS = DB_SQL_QUOTEDS[dbType];
			}
			if(!CmnUtils.isEmpty(prop_val[D_SQLQUOTEDE])){
				sqlQuotedE = prop_val[D_SQLQUOTEDE];
			} else {
				sqlQuotedE = DB_SQL_QUOTEDE[dbType];
			}
		} else {
			throw new Exception("f[^x[Xiʂł܂B[" + url + "]");
		}

		if(database!=null)CmnUtils.infoPrint("-->Ώۃf[^x[X='" + database.toUpperCase() + "'");
		if(!CmnUtils.isEmpty(prop_val[D_FILEEXT]))CmnUtils.infoPrint("-->t@Cgq='" + prop_val[D_FILEEXT] + "'");
		if(!CmnUtils.isEmpty(prop_val[D_DELIMITER]))CmnUtils.infoPrint("-->؂蕶='" + prop_val[D_DELIMITER] + "'");
		if(!CmnUtils.isEmpty(prop_val[D_LINESEP]))CmnUtils.infoPrint("-->sR[h='" + prop_val[D_LINESEP] + "'");
		if(!CmnUtils.isEmpty(prop_val[D_INLINESEP]))CmnUtils.infoPrint("-->JsR[h='" + prop_val[D_INLINESEP] + "'");
		if(!CmnUtils.isEmpty(prop_val[D_FILENCODE]))CmnUtils.infoPrint("-->R[h='" + prop_val[D_FILENCODE] + "'");
		if(!CmnUtils.isEmpty(prop_val[D_QUOTATION]))CmnUtils.infoPrint("-->p=" + CmnUtils.getYesNo(isQuotation));
		if(!CmnUtils.isEmpty(prop_val[D_SQLQUOTEDS]) && !CmnUtils.isEmpty(prop_val[D_SQLQUOTEDE]))CmnUtils.infoPrint("-->SQLp=" + "'" + sqlQuotedS + "' '" + sqlQuotedE + "'");
		if(!CmnUtils.isEmpty(prop_val[D_ORDER]))CmnUtils.infoPrint("-->\[g=" + CmnUtils.getYesNo(isOrder));
		if(!CmnUtils.isEmpty(prop_val[D_BATCOUNT]))CmnUtils.infoPrint("-->ob`=" + batchCount);
		if(isSpcPadding)CmnUtils.infoPrint("-->󔒖=" + CmnUtils.getYesNo(isSpcPadding));
		if(isInclTables)CmnUtils.infoPrint("-->Ώۃe[u='" + inclTables.toUpperCase() + "'");
		if(isExclTables)CmnUtils.infoPrint("-->Oe[u='" + exclTables.toUpperCase() + "'");
		if(isInclCols)CmnUtils.infoPrint("-->ΏۃJ='" + inclCols.toUpperCase() + "'");
		if(isExclCols)CmnUtils.infoPrint("-->OJ='" + exclCols.toUpperCase() + "'");
		if(isMask){
			CmnUtils.infoPrint("-->}XLO=" +  CmnUtils.getYesNo(isMask));
			CmnUtils.infoPrint("-->}XNLOp^[=" + maskPattern.toUpperCase());
			CmnUtils.infoPrint("-->p}XN='" + singleByteMaskChar + "'");
			CmnUtils.infoPrint("-->Sp}XN='" + doubleByteMaskChar + "'");
			if(isInclColsMask)CmnUtils.infoPrint("-->}XNΏۃJ='" + inclColsMask.toUpperCase() + "'");
			if(isExclColsMask)CmnUtils.infoPrint("-->}XNOJ='" + exclColsMask.toUpperCase() + "'");
		}

	}
	

}

