/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.intro;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IPluginContribution;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.intro.IIntroDescriptor;
import org.eclipse.ui.intro.IIntroPart;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class IntroDescriptor
implements IIntroDescriptor,
IPluginContribution {
    private static final String ATT_ID = "id";
    private static final String ATT_CLASS = "class";
    private static final String ATT_ICON = "icon";
    private IConfigurationElement configElement;
    private String id;
    private String pluginId;
    private String iconName;
    private ImageDescriptor imageDescriptor;

    public IntroDescriptor(IConfigurationElement configElement) throws CoreException {
        this.configElement = configElement;
        this.loadFromExtension();
    }

    private void loadFromExtension() throws CoreException {
        this.id = this.configElement.getAttribute(ATT_ID);
        this.pluginId = this.configElement.getDeclaringExtension().getNamespace();
        String className = this.configElement.getAttribute(ATT_CLASS);
        this.iconName = this.configElement.getAttribute(ATT_ICON);
        if (className == null) {
            throw new CoreException((IStatus)new Status(4, this.configElement.getDeclaringExtension().getNamespace(), 0, "Invalid extension (Missing class name): " + this.id, null));
        }
    }

    public IIntroPart createIntro() throws CoreException {
        return (IIntroPart)WorkbenchPlugin.createExtension(this.configElement, ATT_CLASS);
    }

    public String getId() {
        return this.id;
    }

    public ImageDescriptor getImageDescriptor() {
        if (this.imageDescriptor != null) {
            return this.imageDescriptor;
        }
        if (this.iconName == null) {
            return null;
        }
        IExtension extension = this.configElement.getDeclaringExtension();
        String extendingPluginId = extension.getNamespace();
        this.imageDescriptor = AbstractUIPlugin.imageDescriptorFromPlugin(extendingPluginId, this.iconName);
        return this.imageDescriptor;
    }

    public String getLocalId() {
        return this.id;
    }

    public String getPluginId() {
        return this.pluginId;
    }
}

