/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.framework.launcher;

import java.lang.reflect.Constructor;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;
import org.eclipse.osgi.framework.adaptor.FrameworkAdaptor;
import org.eclipse.osgi.framework.internal.core.Msg;
import org.eclipse.osgi.framework.internal.core.OSGi;
import org.eclipse.osgi.framework.util.Tokenizer;

public class Launcher {
    protected String consolePort = "";
    protected boolean console = false;
    protected String adaptorClassName = "org.eclipse.osgi.framework.internal.defaultadaptor.DefaultAdaptor";
    protected final String osgiConsoleClazz = "org.eclipse.osgi.framework.internal.core.FrameworkConsole";
    protected String[] adaptorArgs = null;
    private static final String OSGI_CONSOLE_COMPONENT_NAME = "OSGi Console";
    private static final String OSGI_CONSOLE_COMPONENT = "console.jar";
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    public static void main(String[] args) {
        new Launcher().doIt(args);
    }

    protected void doIt(String[] args) {
        String[] consoleArgs = this.parseArgs(args);
        FrameworkAdaptor adaptor = null;
        try {
            adaptor = this.doAdaptor();
        }
        catch (Exception e) {
            System.out.println(Msg.formatter.getString("LAUNCHER_ADAPTOR_ERROR"));
            e.printStackTrace();
            return;
        }
        OSGi osgi = this.doOSGi(adaptor);
        if (osgi != null) {
            if (this.console) {
                this.doConsole(osgi, consoleArgs);
            } else {
                osgi.launch();
            }
        }
    }

    private String[] parseArgs(String[] args) {
        Vector<String> consoleArgsVector = new Vector<String>();
        int i = 0;
        while (i < args.length) {
            Tokenizer tok;
            boolean match = false;
            String fullarg = args[i];
            int quoteidx = fullarg.indexOf("\"");
            if (quoteidx > 0) {
                if (quoteidx == fullarg.lastIndexOf("\"")) {
                    boolean stillparsing = true;
                    ++i;
                    while (i < args.length && stillparsing) {
                        fullarg = String.valueOf(fullarg) + " " + args[i];
                        ++i;
                        if (quoteidx >= fullarg.lastIndexOf("\"")) continue;
                        stillparsing = false;
                    }
                }
            } else {
                quoteidx = fullarg.indexOf("'");
                if (quoteidx > 0) {
                    if (quoteidx == fullarg.lastIndexOf("'")) {
                        boolean stillparsing = true;
                        ++i;
                        while (i < args.length && stillparsing) {
                            fullarg = String.valueOf(fullarg) + " " + args[i];
                            ++i;
                            if (quoteidx >= fullarg.lastIndexOf("'")) continue;
                            stillparsing = false;
                        }
                    }
                    fullarg = fullarg.replace('\'', '\"');
                }
            }
            if ((tok = new Tokenizer(fullarg)).hasMoreTokens()) {
                String command = tok.getString(" ");
                StringTokenizer subtok = new StringTokenizer(command, ":");
                String subcommand = subtok.nextToken().toLowerCase();
                if (Launcher.matchCommand("-console", subcommand, 4)) {
                    this._console(command);
                    match = true;
                }
                if (Launcher.matchCommand("-adaptor", subcommand, 2)) {
                    this._adaptor(command);
                    match = true;
                }
                if (!match) {
                    consoleArgsVector.addElement(fullarg);
                }
            }
            ++i;
        }
        String[] consoleArgsArray = new String[consoleArgsVector.size()];
        Enumeration e = consoleArgsVector.elements();
        int i2 = 0;
        while (i2 < consoleArgsArray.length) {
            consoleArgsArray[i2] = (String)e.nextElement();
            ++i2;
        }
        return consoleArgsArray;
    }

    public static boolean matchCommand(String command, String input, int minLength) {
        int length;
        if (minLength <= 0) {
            minLength = command.length();
        }
        if (minLength > (length = input.length())) {
            length = minLength;
        }
        return command.regionMatches(0, input, 0, length);
    }

    protected void _console(String command) {
        this.console = true;
        StringTokenizer tok = new StringTokenizer(command, ":");
        tok.nextToken();
        if (tok.hasMoreTokens()) {
            this.consolePort = tok.nextToken();
        }
    }

    protected void _adaptor(String command) {
        Tokenizer tok = new Tokenizer(command);
        tok.getToken(":");
        tok.getChar();
        String adp = tok.getToken(":");
        if (adp.length() > 0) {
            this.adaptorClassName = adp;
        }
        Vector<String> v = new Vector<String>();
        while (true) {
            tok.getChar();
            String arg = tok.getString(":");
            if (arg == null) break;
            v.addElement(arg);
        }
        if (v != null) {
            int numArgs = v.size();
            this.adaptorArgs = new String[numArgs];
            Enumeration e = v.elements();
            int i = 0;
            while (i < numArgs) {
                this.adaptorArgs[i] = (String)e.nextElement();
                ++i;
            }
        }
    }

    protected FrameworkAdaptor doAdaptor() throws Exception {
        Class<?> adaptorClass = Class.forName(this.adaptorClassName);
        Class[] classArray = new Class[1];
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("[Ljava.lang.String;");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[0] = clazz;
        Class[] constructorArgs = classArray;
        Constructor<?> constructor = adaptorClass.getConstructor(constructorArgs);
        return (FrameworkAdaptor)constructor.newInstance(new Object[]{this.adaptorArgs});
    }

    protected OSGi doOSGi(FrameworkAdaptor adaptor) {
        return new OSGi(adaptor);
    }

    protected void doConsole(OSGi osgi, String[] consoleArgs) {
        try {
            Object[] parameters;
            Class[] parameterTypes;
            Class<?> osgiconsoleClass = Class.forName("org.eclipse.osgi.framework.internal.core.FrameworkConsole");
            if (this.consolePort.length() == 0) {
                Class[] classArray = new Class[2];
                Class<?> clazz = class$1;
                if (clazz == null) {
                    try {
                        clazz = class$1 = Class.forName("org.eclipse.osgi.framework.internal.core.OSGi");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                classArray[0] = clazz;
                Class<?> clazz2 = class$0;
                if (clazz2 == null) {
                    try {
                        clazz2 = class$0 = Class.forName("[Ljava.lang.String;");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                classArray[1] = clazz2;
                parameterTypes = classArray;
                parameters = new Object[]{osgi, consoleArgs};
            } else {
                Class[] classArray = new Class[3];
                Class<?> clazz = class$1;
                if (clazz == null) {
                    try {
                        clazz = class$1 = Class.forName("org.eclipse.osgi.framework.internal.core.OSGi");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                classArray[0] = clazz;
                classArray[1] = Integer.TYPE;
                Class<?> clazz3 = class$0;
                if (clazz3 == null) {
                    try {
                        clazz3 = class$0 = Class.forName("[Ljava.lang.String;");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                classArray[2] = clazz3;
                parameterTypes = classArray;
                parameters = new Object[]{osgi, new Integer(this.consolePort), consoleArgs};
            }
            Constructor<?> consoleConstructor = osgiconsoleClass.getConstructor(parameterTypes);
            Object osgiconsole = consoleConstructor.newInstance(parameters);
            Thread t = new Thread((Runnable)osgiconsole, OSGI_CONSOLE_COMPONENT_NAME);
            t.start();
        }
        catch (NumberFormatException numberFormatException) {
            System.err.println(Msg.formatter.getString("LAUNCHER_INVALID_PORT", this.consolePort));
        }
        catch (Exception exception) {
            this.informAboutMissingComponent(OSGI_CONSOLE_COMPONENT_NAME, OSGI_CONSOLE_COMPONENT);
        }
    }

    void informAboutMissingComponent(String component, String jar) {
        System.out.println();
        System.out.print(Msg.formatter.getString("LAUNCHER_COMPONENT_MISSING", component));
        System.out.println(Msg.formatter.getString("LAUNCHER_COMPONENT_JAR", jar));
        System.out.println();
    }
}

