/*
 * Created on 2005/02/20
 *
 * @author KAMO Masahiko (mkamo@users.sourceforge.jp)
 */
package razgriz.news.ui.browser;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.SWT;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.TitleEvent;
import org.eclipse.swt.browser.TitleListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.part.MultiPageEditorPart;

/**
 * 
 */
public class NewsBrowser extends MultiPageEditorPart {
    public static final String ID = NewsBrowser.class.getName();

    private int overviewPageIndex;
    private int browserPageIndex;

    private void createOverviewPage() {
        Composite composite = new Composite(getContainer(), SWT.NONE);
        GridLayout layout = new GridLayout();
        composite.setLayout(layout);
        layout.numColumns = 1;

        NewsBrowserInput input = (NewsBrowserInput) getEditorInput();

        Label titlelabel = new Label(composite, SWT.NONE);
        titlelabel.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
        titlelabel.setText("^Cg: " + input.getArticle().getTitle());

        Label linklabel = new Label(composite, SWT.NONE);
        linklabel.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
        linklabel.setText("N: " + input.getArticle().getLink());

        Label desclabel = new Label(composite, SWT.NONE);
        desclabel.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
        desclabel.setText(": " + input.getArticle().getDescription());

        overviewPageIndex = addPage(composite);
        setPageText(overviewPageIndex, "Tv");
    }

    private void createBrowserPage() {
        NewsBrowserInput input = (NewsBrowserInput) getEditorInput();

        Composite composite = new Composite(getContainer(), SWT.NONE);
        GridLayout layout = new GridLayout();
        composite.setLayout(layout);
        layout.numColumns = 1;

        Browser browser = new Browser(composite, SWT.NONE);
        browser.setLayoutData(new GridData(GridData.FILL_BOTH));
        browser.addTitleListener(new TitleListener(){
            public void changed(TitleEvent event) {
                setPartName(event.title);
            }
        });

        browser.setUrl(input.getArticle().getLink());

        browserPageIndex = addPage(composite);
        setPageText(browserPageIndex, "Rec");
    }

    protected void createPages() {
        createOverviewPage();
        createBrowserPage();
    }

    public void doSave(IProgressMonitor monitor) {
    }

    public void doSaveAs() {
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void activateOverviewPage() {
        setActivePage(overviewPageIndex);
    }
    public void activateBrowserPage() {
        setActivePage(browserPageIndex);
    }
}
