/**
 * <copyright>
 * </copyright>
 *
 * $Id: GroupImpl.java,v 1.2 2005/03/02 16:06:51 mkamo Exp $
 */
package razgriz.news.model.impl;

import java.util.Collection;
import java.util.List;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EObjectContainmentWithInverseEList;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.InternalEList;

import razgriz.news.model.Favorite;
import razgriz.news.model.FavoriteList;
import razgriz.news.model.Group;
import razgriz.news.model.NewsPackage;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Group</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link razgriz.news.model.impl.GroupImpl#getTitle <em>Title</em>}</li>
 *   <li>{@link razgriz.news.model.impl.GroupImpl#getDescription <em>Description</em>}</li>
 *   <li>{@link razgriz.news.model.impl.GroupImpl#getFavoriteList <em>Favorite List</em>}</li>
 *   <li>{@link razgriz.news.model.impl.GroupImpl#getGroup <em>Group</em>}</li>
 *   <li>{@link razgriz.news.model.impl.GroupImpl#getMembers <em>Members</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class GroupImpl extends ModelElementImpl implements Group {
    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public static final String copyright = "KAMO Masahiko";

    /**
     * The default value of the '{@link #getTitle() <em>Title</em>}' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #getTitle()
     * @generated
     * @ordered
     */
    protected static final String TITLE_EDEFAULT = null;

    /**
     * The cached value of the '{@link #getTitle() <em>Title</em>}' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #getTitle()
     * @generated
     * @ordered
     */
    protected String title = TITLE_EDEFAULT;

    /**
     * The default value of the '{@link #getDescription() <em>Description</em>}' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #getDescription()
     * @generated
     * @ordered
     */
    protected static final String DESCRIPTION_EDEFAULT = null;

    /**
     * The cached value of the '{@link #getDescription() <em>Description</em>}' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #getDescription()
     * @generated
     * @ordered
     */
    protected String description = DESCRIPTION_EDEFAULT;

    /**
     * The cached value of the '{@link #getMembers() <em>Members</em>}' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #getMembers()
     * @generated
     * @ordered
     */
    protected EList members = null;

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected GroupImpl() {
        super();
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected EClass eStaticClass() {
        return NewsPackage.eINSTANCE.getGroup();
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public String getTitle() {
        return title;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public void setTitle(String newTitle) {
        String oldTitle = title;
        title = newTitle;
        if (eNotificationRequired())
            eNotify(new ENotificationImpl(this, Notification.SET, NewsPackage.GROUP__TITLE, oldTitle, title));
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public String getDescription() {
        return description;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public void setDescription(String newDescription) {
        String oldDescription = description;
        description = newDescription;
        if (eNotificationRequired())
            eNotify(new ENotificationImpl(this, Notification.SET, NewsPackage.GROUP__DESCRIPTION, oldDescription, description));
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public FavoriteList getFavoriteList() {
        if (eContainerFeatureID != NewsPackage.GROUP__FAVORITE_LIST) return null;
        return (FavoriteList)eContainer;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public void setFavoriteList(FavoriteList newFavoriteList) {
        if (newFavoriteList != eContainer || (eContainerFeatureID != NewsPackage.GROUP__FAVORITE_LIST && newFavoriteList != null)) {
            if (EcoreUtil.isAncestor(this, (EObject)newFavoriteList))
                throw new IllegalArgumentException("Recursive containment not allowed for " + toString());
            NotificationChain msgs = null;
            if (eContainer != null)
                msgs = eBasicRemoveFromContainer(msgs);
            if (newFavoriteList != null)
                msgs = ((InternalEObject)newFavoriteList).eInverseAdd(this, NewsPackage.FAVORITE_LIST__FAVORITES, FavoriteList.class, msgs);
            msgs = eBasicSetContainer((InternalEObject)newFavoriteList, NewsPackage.GROUP__FAVORITE_LIST, msgs);
            if (msgs != null) msgs.dispatch();
        }
        else if (eNotificationRequired())
            eNotify(new ENotificationImpl(this, Notification.SET, NewsPackage.GROUP__FAVORITE_LIST, newFavoriteList, newFavoriteList));
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public Group getGroup() {
        if (eContainerFeatureID != NewsPackage.GROUP__GROUP) return null;
        return (Group)eContainer;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public void setGroup(Group newGroup) {
        if (newGroup != eContainer || (eContainerFeatureID != NewsPackage.GROUP__GROUP && newGroup != null)) {
            if (EcoreUtil.isAncestor(this, (EObject)newGroup))
                throw new IllegalArgumentException("Recursive containment not allowed for " + toString());
            NotificationChain msgs = null;
            if (eContainer != null)
                msgs = eBasicRemoveFromContainer(msgs);
            if (newGroup != null)
                msgs = ((InternalEObject)newGroup).eInverseAdd(this, NewsPackage.GROUP__MEMBERS, Group.class, msgs);
            msgs = eBasicSetContainer((InternalEObject)newGroup, NewsPackage.GROUP__GROUP, msgs);
            if (msgs != null) msgs.dispatch();
        }
        else if (eNotificationRequired())
            eNotify(new ENotificationImpl(this, Notification.SET, NewsPackage.GROUP__GROUP, newGroup, newGroup));
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public List getMembers() {
        if (members == null) {
            members = new EObjectContainmentWithInverseEList(Favorite.class, this, NewsPackage.GROUP__MEMBERS, NewsPackage.FAVORITE__GROUP);
        }
        return members;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs) {
        if (featureID >= 0) {
            switch (eDerivedStructuralFeatureID(featureID, baseClass)) {
                case NewsPackage.GROUP__FAVORITE_LIST:
                    if (eContainer != null)
                        msgs = eBasicRemoveFromContainer(msgs);
                    return eBasicSetContainer(otherEnd, NewsPackage.GROUP__FAVORITE_LIST, msgs);
                case NewsPackage.GROUP__GROUP:
                    if (eContainer != null)
                        msgs = eBasicRemoveFromContainer(msgs);
                    return eBasicSetContainer(otherEnd, NewsPackage.GROUP__GROUP, msgs);
                case NewsPackage.GROUP__MEMBERS:
                    return ((InternalEList)getMembers()).basicAdd(otherEnd, msgs);
                default:
                    return eDynamicInverseAdd(otherEnd, featureID, baseClass, msgs);
            }
        }
        if (eContainer != null)
            msgs = eBasicRemoveFromContainer(msgs);
        return eBasicSetContainer(otherEnd, featureID, msgs);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs) {
        if (featureID >= 0) {
            switch (eDerivedStructuralFeatureID(featureID, baseClass)) {
                case NewsPackage.GROUP__FAVORITE_LIST:
                    return eBasicSetContainer(null, NewsPackage.GROUP__FAVORITE_LIST, msgs);
                case NewsPackage.GROUP__GROUP:
                    return eBasicSetContainer(null, NewsPackage.GROUP__GROUP, msgs);
                case NewsPackage.GROUP__MEMBERS:
                    return ((InternalEList)getMembers()).basicRemove(otherEnd, msgs);
                default:
                    return eDynamicInverseRemove(otherEnd, featureID, baseClass, msgs);
            }
        }
        return eBasicSetContainer(null, featureID, msgs);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public NotificationChain eBasicRemoveFromContainer(NotificationChain msgs) {
        if (eContainerFeatureID >= 0) {
            switch (eContainerFeatureID) {
                case NewsPackage.GROUP__FAVORITE_LIST:
                    return ((InternalEObject)eContainer).eInverseRemove(this, NewsPackage.FAVORITE_LIST__FAVORITES, FavoriteList.class, msgs);
                case NewsPackage.GROUP__GROUP:
                    return ((InternalEObject)eContainer).eInverseRemove(this, NewsPackage.GROUP__MEMBERS, Group.class, msgs);
                default:
                    return eDynamicBasicRemoveFromContainer(msgs);
            }
        }
        return ((InternalEObject)eContainer).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - eContainerFeatureID, null, msgs);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public Object eGet(EStructuralFeature eFeature, boolean resolve) {
        switch (eDerivedStructuralFeatureID(eFeature)) {
            case NewsPackage.GROUP__TITLE:
                return getTitle();
            case NewsPackage.GROUP__DESCRIPTION:
                return getDescription();
            case NewsPackage.GROUP__FAVORITE_LIST:
                return getFavoriteList();
            case NewsPackage.GROUP__GROUP:
                return getGroup();
            case NewsPackage.GROUP__MEMBERS:
                return getMembers();
        }
        return eDynamicGet(eFeature, resolve);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public void eSet(EStructuralFeature eFeature, Object newValue) {
        switch (eDerivedStructuralFeatureID(eFeature)) {
            case NewsPackage.GROUP__TITLE:
                setTitle((String)newValue);
                return;
            case NewsPackage.GROUP__DESCRIPTION:
                setDescription((String)newValue);
                return;
            case NewsPackage.GROUP__FAVORITE_LIST:
                setFavoriteList((FavoriteList)newValue);
                return;
            case NewsPackage.GROUP__GROUP:
                setGroup((Group)newValue);
                return;
            case NewsPackage.GROUP__MEMBERS:
                getMembers().clear();
                getMembers().addAll((Collection)newValue);
                return;
        }
        eDynamicSet(eFeature, newValue);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public void eUnset(EStructuralFeature eFeature) {
        switch (eDerivedStructuralFeatureID(eFeature)) {
            case NewsPackage.GROUP__TITLE:
                setTitle(TITLE_EDEFAULT);
                return;
            case NewsPackage.GROUP__DESCRIPTION:
                setDescription(DESCRIPTION_EDEFAULT);
                return;
            case NewsPackage.GROUP__FAVORITE_LIST:
                setFavoriteList((FavoriteList)null);
                return;
            case NewsPackage.GROUP__GROUP:
                setGroup((Group)null);
                return;
            case NewsPackage.GROUP__MEMBERS:
                getMembers().clear();
                return;
        }
        eDynamicUnset(eFeature);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public boolean eIsSet(EStructuralFeature eFeature) {
        switch (eDerivedStructuralFeatureID(eFeature)) {
            case NewsPackage.GROUP__TITLE:
                return TITLE_EDEFAULT == null ? title != null : !TITLE_EDEFAULT.equals(title);
            case NewsPackage.GROUP__DESCRIPTION:
                return DESCRIPTION_EDEFAULT == null ? description != null : !DESCRIPTION_EDEFAULT.equals(description);
            case NewsPackage.GROUP__FAVORITE_LIST:
                return getFavoriteList() != null;
            case NewsPackage.GROUP__GROUP:
                return getGroup() != null;
            case NewsPackage.GROUP__MEMBERS:
                return members != null && !members.isEmpty();
        }
        return eDynamicIsSet(eFeature);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public String toString() {
        if (eIsProxy()) return super.toString();

        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (title: ");
        result.append(title);
        result.append(", description: ");
        result.append(description);
        result.append(')');
        return result.toString();
    }

} //GroupImpl
